/*
 * Decompiled with CFR 0.152.
 */
package com.sanrad.nms.server.logic.vswitch.fc;

import com.sanrad.nms.server.logic.ClientParameterCode;
import com.sanrad.nms.server.logic.IllegalValueException;
import com.sanrad.nms.server.logic.InvalidElementException;
import com.sanrad.nms.server.logic.cluster.ClusterImpl;
import com.sanrad.nms.server.logic.vswitch.SFPConnectedInterfaceImpl;
import com.sanrad.nms.server.logic.vswitch.fc.FCInterfaceTableRow;
import com.sanrad.nms.server.mgr.ConfigElementData;
import com.sanrad.nms.server.util.ClassID;
import com.sanrad.nms.server.util.ParameterCode;
import com.sanrad.nms.server.util.types.constants.FcAdminSpeedConstant;
import com.sanrad.nms.server.util.types.constants.FcConnectModeConstant;
import java.rmi.RemoteException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public class FCInterfaceTableRowImpl
extends SFPConnectedInterfaceImpl
implements FCInterfaceTableRow {
    private static Map<ParameterCode, ParameterCode.Flags> theParameterCodeFlagsMap;

    public FCInterfaceTableRowImpl(ClusterImpl cluster, ConfigElementData aCED) throws RemoteException, IllegalValueException, InvalidElementException {
        super(cluster, ClassID.FC_INTERFACE, aCED);
        this.validateAndInit(aCED, theParameterCodeFlagsMap);
    }

    @Override
    public String getConnectMode() throws RemoteException {
        return this.getSrValueOf(this.getParentVSwitch(), ParameterCode.FC_IF_CONNECT_MODE).toString();
    }

    @Override
    public String getAdminSpeed() throws RemoteException {
        return this.getSrValueOf(this.getParentVSwitch(), ParameterCode.FC_IF_PORT_ADMIN_SPEED).toString();
    }

    @Override
    public String getAdminType() throws RemoteException {
        return this.getSrValueOf(this.getParentVSwitch(), ParameterCode.FC_IF_PORT_ADMIN_TYPE).toString();
    }

    @Override
    public String getOperType() throws RemoteException {
        return this.getSrValueOf(this.getParentVSwitch(), ParameterCode.FC_IF_PORT_OPER_TYPE).toString();
    }

    @Override
    public String getWWPN() throws RemoteException {
        return this.getDisplayStringOf(this.getParentVSwitch(), ParameterCode.FC_IF_PORT_WWN).toString();
    }

    @Override
    protected String isValid(HashMap parameterList) {
        String valid = super.isValid(parameterList);
        if (valid == null) {
            String connectMode;
            String speed = (String)parameterList.get(ClientParameterCode.FC_IF_SPEED);
            if (speed != null) {
                parameterList.put(ClientParameterCode.FC_IF_SPEED, FcAdminSpeedConstant.getSpeed(speed));
            }
            if ((connectMode = (String)parameterList.get(ClientParameterCode.FC_IF_TOPOLOGY)) != null) {
                parameterList.put(ClientParameterCode.FC_IF_TOPOLOGY, FcConnectModeConstant.getMode(connectMode));
            }
        }
        return valid;
    }

    static {
        HashMap<ParameterCode, ParameterCode.Flags> parameterCodeFlagsMap = new HashMap<ParameterCode, ParameterCode.Flags>();
        parameterCodeFlagsMap.put(ParameterCode.FC_IF_CONNECT_MODE, new ParameterCode.Flags(true, false));
        parameterCodeFlagsMap.put(ParameterCode.FC_IF_PORT_ADMIN_SPEED, new ParameterCode.Flags(true, false));
        parameterCodeFlagsMap.put(ParameterCode.FC_IF_PORT_ADMIN_TYPE, new ParameterCode.Flags(true, false));
        parameterCodeFlagsMap.put(ParameterCode.FC_IF_PORT_OPER_TYPE, new ParameterCode.Flags(true, false));
        parameterCodeFlagsMap.put(ParameterCode.FC_IF_PORT_WWN, new ParameterCode.Flags(true, false));
        theParameterCodeFlagsMap = Collections.unmodifiableMap(parameterCodeFlagsMap);
    }
}

