/*
 * Decompiled with CFR 0.152.
 */
package com.sanrad.nms.server.logic.vswitch;

import com.sanrad.nms.server.logic.ErrorMessage;
import com.sanrad.nms.server.logic.LogicObjectValidator;
import com.sanrad.nms.server.logic.SystemRootImpl;
import com.sanrad.nms.server.logic.cluster.Cluster;
import com.sanrad.nms.server.logic.cluster.ClusterImpl;
import com.sanrad.nms.server.util.ClassID;
import com.sanrad.util.NetUtil;
import java.rmi.RemoteException;

public class VSwitchValidator
extends LogicObjectValidator {
    private String ip;
    private String mask;
    private ClusterImpl cluster;
    private String readCommunity;
    private String writeCommunity;

    public VSwitchValidator(ClusterImpl cluster, String ip, String mask, String readCommunity, String writeCommunity) {
        this.cluster = cluster;
        this.ip = ip;
        this.mask = mask;
        this.readCommunity = readCommunity;
        this.writeCommunity = writeCommunity;
    }

    public static String isCommunityValid(String inCommunity) {
        if (inCommunity == null || inCommunity.equals("")) {
            return "Community is empty";
        }
        int maxCommunityLength = 80;
        if (inCommunity.length() > maxCommunityLength) {
            return "Too long (max length: " + maxCommunityLength + ")";
        }
        if (inCommunity.indexOf(33) > -1 || inCommunity.indexOf(35) > -1 || inCommunity.indexOf(38) > -1 || inCommunity.indexOf(42) > -1 || inCommunity.indexOf(43) > -1) {
            return "Can't contain the following characters: ! # & * +";
        }
        return null;
    }

    @Override
    public boolean isValid() throws RemoteException {
        Cluster c = SystemRootImpl.getInstance().getClusterOfVSwitch(this.ip);
        if (c != null) {
            this.setErrorMsg(ClassID.VSWITCH + " " + this.ip + " is already managed by " + c.getAlias());
            return false;
        }
        try {
            if (!NetUtil.isNetworkIpValid(this.ip)) {
                this.setErrorMsg(ErrorMessage.IP_IS_NOT_VALID.getMessage(this.ip));
                return false;
            }
        }
        catch (IllegalArgumentException iae) {
            this.setErrorMsg(ErrorMessage.IP_IS_NOT_VALID.getMessage(this.ip));
            return false;
        }
        if (NetUtil.isReservedIP(this.ip)) {
            this.setErrorMsg(ErrorMessage.IP_IS_NOT_VALID.getMessage(this.ip));
            return false;
        }
        if (!NetUtil.isMaskValid(this.mask)) {
            this.setErrorMsg(ErrorMessage.MASK_IS_NOT_VALID.getMessage(this.mask));
            return false;
        }
        if (this.cluster != null && this.cluster.getVSwitchByIPAddress(this.ip) != null) {
            this.setErrorMsg(ClassID.VSWITCH + " with IP address " + this.ip + " is already in cluster");
            return false;
        }
        String errMsg = VSwitchValidator.isCommunityValid(this.readCommunity);
        if (errMsg != null) {
            this.setErrorMsg("Read Community '" + this.readCommunity + "' string is not valid: " + errMsg);
            return false;
        }
        errMsg = VSwitchValidator.isCommunityValid(this.writeCommunity);
        if (errMsg != null) {
            this.setErrorMsg("Write Community '" + this.writeCommunity + "' string is not valid: " + errMsg);
            return false;
        }
        return true;
    }
}

