/*
 * Decompiled with CFR 0.152.
 */
package com.sanrad.nms.server.logic.vswitch;

import com.sanrad.nms.server.logic.ErrorMessage;
import com.sanrad.nms.server.logic.LogicObjectValidator;
import com.sanrad.nms.server.logic.vswitch.VSwitchImpl;
import com.sanrad.nms.server.util.ClassID;
import com.sanrad.nms.server.util.types.constants.NetConfigActivityConstant;
import com.sanrad.util.NetUtil;

public class IPTableRowValidator
extends LogicObjectValidator {
    private String ip;
    private String mask;
    private VSwitchImpl vSwitch;
    private String interfaceName;
    private String activity;

    public IPTableRowValidator(VSwitchImpl vSwitch, String ip, String mask, String interfaceAlias, String activity) {
        this.vSwitch = vSwitch;
        this.ip = ip;
        this.mask = mask;
        this.interfaceName = interfaceAlias;
        this.activity = activity;
    }

    @Override
    public boolean isValid() {
        StringBuffer sb = new StringBuffer();
        sb.append("IP ");
        sb.append(this.ip);
        sb.append(" already exists ");
        if (this.vSwitch.getIPTableRow(this.ip) != null) {
            sb.append("as a local IP in ");
            sb.append(ClassID.VSWITCH);
            sb.append(" ");
            sb.append(this.vSwitch.getName());
            this.setErrorMsg(sb.toString());
            return false;
        }
        try {
            if (!NetUtil.isNetworkIpValid(this.ip)) {
                this.setErrorMsg(ErrorMessage.IP_IS_NOT_VALID.getMessage(this.ip));
                return false;
            }
        }
        catch (IllegalArgumentException iae) {
            this.setErrorMsg(ErrorMessage.IP_IS_NOT_VALID.getMessage(this.ip));
            return false;
        }
        if (this.vSwitch.getCluster().isIPExistedAsISNSServer(this.ip)) {
            sb.append("an ISNS server IP in ");
            sb.append(ClassID.CLUSTER);
            sb.append(" ");
            sb.append(this.vSwitch.getCluster().getAlias());
            this.setErrorMsg(sb.toString());
            return false;
        }
        if (this.vSwitch.getCluster().isIPExistedAsRadiusServer(this.ip)) {
            sb.append("as a radius server in ");
            sb.append(ClassID.CLUSTER);
            sb.append(" ");
            sb.append(this.vSwitch.getCluster().getAlias());
            this.setErrorMsg(sb.toString());
            return false;
        }
        if (this.vSwitch.isIPExistedAsNeighbor(this.ip)) {
            sb.append("as a neighbor in ");
            sb.append(ClassID.VSWITCH);
            sb.append(" ");
            sb.append(this.vSwitch.getName());
            this.setErrorMsg(sb.toString());
            return false;
        }
        if (this.vSwitch.isIPExistedAsRoutIP(this.ip)) {
            sb.append("as a rout IP in ");
            sb.append(ClassID.VSWITCH);
            sb.append(" ");
            sb.append(this.vSwitch.getName());
            this.setErrorMsg(sb.toString());
            return false;
        }
        if (this.vSwitch.isIPExistedAsSNMPManager(this.ip)) {
            sb.append("as an SNMP manager IP in ");
            sb.append(ClassID.VSWITCH);
            sb.append(" ");
            sb.append(this.vSwitch.getName());
            this.setErrorMsg(sb.toString());
            return false;
        }
        if (!NetUtil.isMaskValid(this.mask)) {
            this.setErrorMsg(ErrorMessage.MASK_IS_NOT_VALID.getMessage(this.mask));
            return false;
        }
        if (this.vSwitch.isUnderTakeover() && this.activity.equals(NetConfigActivityConstant.NET_CONFIG_ACTIVITY_INACTIVE.getDescriptionName())) {
            this.setErrorMsg("You cannot add IP " + this.activity + " to " + ClassID.VSWITCH + " " + this.vSwitch.getName() + ".  It is in takeover state");
            return false;
        }
        return true;
    }
}

