/*
 * Decompiled with CFR 0.152.
 */
package com.sanrad.nms.server.logic.volume.validators;

import com.sanrad.log.SrLogCategories;
import com.sanrad.log.SrLogger;
import com.sanrad.nms.server.logic.AliasObjectValidator;
import com.sanrad.nms.server.logic.ErrorMessage;
import com.sanrad.nms.server.logic.LogicObjectImpl;
import com.sanrad.nms.server.logic.cluster.ClusterImpl;
import com.sanrad.nms.server.logic.physstorage.DirectAccessDevice;
import com.sanrad.nms.server.logic.physstorage.GeneralSCSIDevice;
import com.sanrad.nms.server.logic.physstorage.SubDirectAccessDevice;
import com.sanrad.nms.server.logic.volume.SnapshotVolume;
import com.sanrad.nms.server.logic.volume.VolumeManager;
import com.sanrad.nms.server.logic.volume.VolumeNode;
import com.sanrad.nms.server.logic.volume.VolumeNodeImpl;
import com.sanrad.nms.server.logic.volume.copy.CopyOperationManagerImpl;
import com.sanrad.nms.server.logic.vswitch.VSwitch;
import com.sanrad.nms.server.logic.vswitch.VSwitchImpl;
import com.sanrad.nms.server.util.ClassID;
import java.rmi.RemoteException;
import java.util.List;

public abstract class VolumeValidator
extends AliasObjectValidator {
    protected Object children;
    protected ClassID classId;
    protected VolumeManager volumeMgr;
    private static SrLogger theLogger = SrLogger.getLogger();

    public VolumeValidator(String alias) {
        super(alias);
    }

    public VolumeValidator(ClusterImpl cluster, ClassID classId, String alias, Object children, VolumeManager volumeMgr) {
        super(alias);
        this.cluster = cluster;
        this.children = children;
        this.classId = classId;
        this.volumeMgr = volumeMgr;
    }

    protected boolean canBeVolumeChild(Object child) throws RemoteException {
        CopyOperationManagerImpl copyMgr = this.cluster.getCopyOperManager();
        if (child instanceof List) {
            for (Object curObj : (List)child) {
                if (this.canBeVolumeChild(curObj)) continue;
                return false;
            }
        } else if (child != null) {
            VolumeNodeImpl childNode = (VolumeNodeImpl)child;
            if (copyMgr.isInvolvedInActiveCopyOper(((LogicObjectImpl)child).getCommKeyClassId())) {
                String[] msg = new String[]{this.alias, childNode.getAlias()};
                this.setErrorMsg(ErrorMessage.CHILD_VOLUME_IS_PART_OF_COPY_OPER.getMessage(msg));
                return false;
            }
            if (child instanceof SnapshotVolume) {
                this.setErrorMsg(childNode.getClassId() + " " + childNode.getAlias() + " cannot be a child of a volume");
                return false;
            }
            if (child instanceof DirectAccessDevice && ((DirectAccessDevice)child).getSubDirectAccessDevices().size() > 0) {
                this.setErrorMsg(ClassID.DIRECT_ACCESS_DEVICE + " " + ((DirectAccessDevice)child).getAlias() + " is split - it cannot be a child of a volume");
                return false;
            }
        }
        return true;
    }

    public static String getDefaultAlias() {
        return "$vol$" + System.currentTimeMillis();
    }

    protected boolean isChildNonFunction(VolumeNodeImpl child) {
        VolumeNodeImpl childImpl = child;
        VSwitchImpl[] vSwitches = childImpl.getConnectedVSwitches();
        for (int i = 0; i < vSwitches.length; ++i) {
            if (!child.isNonFunctional(vSwitches[i])) continue;
            return true;
        }
        return false;
    }

    protected boolean isChildNonFunction(VolumeNodeImpl child, VSwitchImpl vSwitch) {
        return child.isNonFunctional(vSwitch);
    }

    protected boolean isAliasExists() throws RemoteException {
        if (this.children != null) {
            if (this.children instanceof List) {
                for (VolumeNodeImpl child : (List)this.children) {
                    if (!child.getAlias().equals(this.alias)) continue;
                    return true;
                }
            } else {
                VolumeNode child = (VolumeNode)this.children;
                if (child.getAlias().equals(this.alias)) {
                    return true;
                }
            }
        }
        return this.volumeMgr.isAliasExist(this.alias);
    }

    protected VolumeNode getChildNonFunction() throws RemoteException {
        if (this.children != null) {
            if (this.children instanceof List) {
                for (VolumeNodeImpl child : (List)this.children) {
                    if (!this.isChildNonFunction(child)) continue;
                    return child;
                }
            } else {
                VolumeNodeImpl child = (VolumeNodeImpl)this.children;
                if (this.isChildNonFunction(child)) {
                    return child;
                }
            }
        }
        return null;
    }

    protected VolumeNode getChildLocalCopy() throws RemoteException {
        if (this.children != null) {
            if (this.children instanceof List) {
                for (VolumeNodeImpl child : (List)this.children) {
                    if (!child.isDROfflineLocalCopy()) continue;
                    return child;
                }
            } else {
                VolumeNodeImpl child = (VolumeNodeImpl)this.children;
                if (child.isDROfflineLocalCopy()) {
                    return child;
                }
            }
        }
        return null;
    }

    protected VolumeNode getChildNonFunction(VSwitchImpl vSwitch) throws RemoteException {
        if (this.children != null) {
            if (this.children instanceof List) {
                for (VolumeNodeImpl child : (List)this.children) {
                    if (!this.isChildNonFunction(child, vSwitch)) continue;
                    return child;
                }
            } else {
                VolumeNodeImpl child = (VolumeNodeImpl)this.children;
                if (this.isChildNonFunction(child)) {
                    return child;
                }
            }
        }
        return null;
    }

    protected boolean isExistChildInCopyOper(VSwitch vSwitch) throws RemoteException {
        CopyOperationManagerImpl copyMgr = this.cluster.getCopyOperManager();
        if (this.children != null) {
            if (this.children instanceof List) {
                for (VolumeNodeImpl child : (List)this.children) {
                    if (!copyMgr.isInvolvedInCopyOper(child.getCommKeyClassId())) continue;
                    return true;
                }
            } else {
                VolumeNode child = (VolumeNode)this.children;
                if (copyMgr.isInvolvedInCopyOper(child.getCommKeyClassId())) {
                    return true;
                }
            }
        }
        return false;
    }

    protected VolumeNode getChildStorageIsMissing() throws RemoteException {
        if (this.children != null) {
            if (this.children instanceof List) {
                for (VolumeNodeImpl child : (List)this.children) {
                    if (!this.isStorageNodeMissing(child)) continue;
                    return child;
                }
            } else {
                VolumeNode child = (VolumeNode)this.children;
                if (this.isStorageNodeMissing(child)) {
                    return child;
                }
            }
        }
        return null;
    }

    protected boolean isStorageNodeMissing(VolumeNode node) {
        try {
            DirectAccessDevice parent;
            GeneralSCSIDevice child;
            if (node instanceof GeneralSCSIDevice ? (child = (GeneralSCSIDevice)node).isMissing() : node instanceof SubDirectAccessDevice && (parent = ((SubDirectAccessDevice)node).getDirectAccessDeviceParent()).isMissing()) {
                return true;
            }
        }
        catch (RemoteException e) {
            theLogger.error(SrLogCategories.LEGACY, e, new Object[0]);
            return false;
        }
        return false;
    }

    @Override
    public boolean isValid() throws RemoteException {
        if (!super.isValid()) {
            return false;
        }
        return this.canBeVolumeChild(this.children);
    }

    public VSwitchImpl[] forWhichVswitchIsValid() throws RemoteException {
        if (!this.isValid() || this.cluster == null) {
            return null;
        }
        return this.cluster.getConnectedVSwitches();
    }
}

