/*
 * Decompiled with CFR 0.152.
 */
package com.sanrad.nms.server.logic.volume.validators;

import com.sanrad.nms.server.logic.cluster.ClusterImpl;
import com.sanrad.nms.server.logic.physstorage.GeneralSCSIDevice;
import com.sanrad.nms.server.logic.volume.VolumeManager;
import com.sanrad.nms.server.logic.volume.VolumeNodeImpl;
import com.sanrad.nms.server.logic.volume.validators.NonVirtualVolumeValidator;
import com.sanrad.nms.server.util.ClassID;
import java.rmi.RemoteException;

public class TransparentVolumeValidator
extends NonVirtualVolumeValidator {
    public TransparentVolumeValidator(ClusterImpl cluster, String alias, GeneralSCSIDevice child, VolumeManager volumeMgr) {
        super(cluster, ClassID.TRANSPARENT_VOLUME, alias, child, volumeMgr);
    }

    @Override
    protected boolean isAliasExists() throws RemoteException {
        return this.volumeMgr.isAliasExist(this.alias);
    }

    @Override
    public boolean isValid() throws RemoteException {
        ClassID childClassId = ((VolumeNodeImpl)this.children).getClassId();
        if (childClassId.isVolume() || !childClassId.isVolumeNode()) {
            this.setErrorMsg("Volume " + this.children + " cannot be a trasparent volume child because it is not a physical entity");
            return false;
        }
        if (((GeneralSCSIDevice)this.children).isExposed()) {
            this.setErrorMsg("Volume " + this.children + " cannot be a trasparent volume child because it is exposed");
            return false;
        }
        if (((GeneralSCSIDevice)this.children).isSnapshotSource()) {
            this.setErrorMsg("Volume " + this.children + " cannot be a trasparent volume child because it is a snapshot volume source");
            return false;
        }
        return super.isValid();
    }
}

