/*
 * Decompiled with CFR 0.152.
 */
package com.sanrad.nms.server.logic.volume.validators;

import com.sanrad.log.SrLogCategories;
import com.sanrad.log.SrLogger;
import com.sanrad.nms.server.logic.ErrorMessage;
import com.sanrad.nms.server.logic.cluster.ClusterImpl;
import com.sanrad.nms.server.logic.physstorage.DirectAccessDeviceImpl;
import com.sanrad.nms.server.logic.physstorage.GeneralSCSIDevice;
import com.sanrad.nms.server.logic.physstorage.GeneralSCSIDeviceImpl;
import com.sanrad.nms.server.logic.physstorage.SubDirectAccessDevice;
import com.sanrad.nms.server.logic.volume.VolumeManager;
import com.sanrad.nms.server.logic.volume.VolumeNode;
import com.sanrad.nms.server.logic.volume.VolumeNodeImpl;
import com.sanrad.nms.server.logic.volume.validators.VolumeValidator;
import com.sanrad.nms.server.logic.vswitch.VSwitchImpl;
import com.sanrad.nms.server.util.ClassID;
import java.rmi.RemoteException;
import java.util.List;

public abstract class SyncVolumeValidator
extends VolumeValidator {
    protected List<VSwitchImpl> vSwitches;
    private static SrLogger theLogger = SrLogger.getLogger();

    public SyncVolumeValidator(ClusterImpl cluster, ClassID classId, String alias, Object children, VolumeManager volumeMgr, List<VSwitchImpl> vSwitchesToCreateOn) {
        super(cluster, classId, alias, children, volumeMgr);
        this.vSwitches = vSwitchesToCreateOn;
    }

    @Override
    public boolean isValid() throws RemoteException {
        if (super.isValid()) {
            VolumeNode nonFunctionVolumeChild = this.getChildNonFunction();
            if (this.getChildNonFunction() != null) {
                String[] msgParama = new String[]{this.classId.toString(), nonFunctionVolumeChild.getClassId().toString(), nonFunctionVolumeChild.getAlias()};
                this.setErrorMsg(ErrorMessage.VOLUME_OVER_NONFUNCTIONAL_VOLUME.getMessage(msgParama));
                return false;
            }
            VolumeNode missingStorageChild = this.getChildStorageIsMissing();
            if (missingStorageChild != null) {
                String[] msgParama = new String[]{this.classId.toString(), missingStorageChild.getClassId().toString(), missingStorageChild.getAlias()};
                this.setErrorMsg(ErrorMessage.VOLUME_OVER_MISSING_STORAGE.getMessage(msgParama));
                return false;
            }
        }
        return true;
    }

    @Override
    protected boolean isStorageNodeMissing(VolumeNode node) {
        try {
            for (VSwitchImpl vSwitch : this.vSwitches) {
                DirectAccessDeviceImpl parent;
                GeneralSCSIDeviceImpl child;
                if (!(node instanceof GeneralSCSIDevice ? (child = (GeneralSCSIDeviceImpl)node).isMissing(vSwitch) : node instanceof SubDirectAccessDevice && (parent = (DirectAccessDeviceImpl)((SubDirectAccessDevice)node).getDirectAccessDeviceParent()).isMissing(vSwitch))) continue;
                return true;
            }
        }
        catch (RemoteException re) {
            theLogger.error(SrLogCategories.LEGACY, re, new Object[0]);
            return false;
        }
        return false;
    }

    @Override
    protected boolean isChildNonFunction(VolumeNodeImpl child) {
        for (VSwitchImpl vSwitch : this.vSwitches) {
            if (!child.isNonFunctional(vSwitch)) continue;
            return true;
        }
        return false;
    }
}

