/*
 * Decompiled with CFR 0.152.
 */
package com.sanrad.nms.server.logic.volume.validators;

import com.sanrad.nms.server.logic.cluster.ClusterImpl;
import com.sanrad.nms.server.logic.volume.SnapshotManager;
import com.sanrad.nms.server.logic.volume.SnapshotVolumeImpl;
import com.sanrad.nms.server.logic.volume.VolumeManager;
import com.sanrad.nms.server.logic.volume.VolumeNode;
import com.sanrad.nms.server.logic.volume.VolumeNodeImpl;
import com.sanrad.nms.server.logic.volume.validators.VirtualVolumeValidator;
import com.sanrad.nms.server.util.ClassID;
import com.sanrad.nms.server.util.types.constants.VolumeStateConstant;
import java.rmi.RemoteException;
import java.util.List;

public class SnapshotVolumeValidator
extends VirtualVolumeValidator {
    private VolumeNodeImpl source;
    private int threshold;
    public static final int MAX_SNAPSHOTS_PER_SOURCE_VOLUME = 36;

    public SnapshotVolumeValidator(String alias) {
        super(alias);
    }

    public SnapshotVolumeValidator(ClusterImpl cluster, VolumeNodeImpl source, String alias, VolumeNode child, int threshold, VolumeManager volumeMgr) {
        super(cluster, ClassID.SNAPSHOT_VOLUME, alias, child, volumeMgr);
        this.source = source;
        this.threshold = threshold;
    }

    @Override
    public boolean isValid() throws RemoteException {
        List<SnapshotVolumeImpl> snapshots;
        if (!super.isValid()) {
            return false;
        }
        if (this.isChildStorageMissing()) {
            return false;
        }
        SnapshotManager snapMng = this.cluster.getStorage().getVolumeMgr().getSnapshotManager();
        if (snapMng.isSourceOfSnapshot(this.source) && (snapshots = snapMng.getSnapshotsForSourceVolume(this.source)).size() == 36) {
            this.setErrorMsg("You cannot create more than 36 " + this.classId + "s on one source volume. Please remove existing " + "snapshots before resuming a schedule or taking new snapshots.");
            return false;
        }
        if (this.threshold < 6 || this.threshold >= 100) {
            this.setErrorMsg("Load threshold should be between 6% to 100%");
            return false;
        }
        return true;
    }

    public boolean isValidForRestoreOperation(SnapshotVolumeImpl snapshotVolume) throws RemoteException {
        if (!snapshotVolume.isInActiveState()) {
            this.setErrorMsg("A snapshot volume must be activated in order to restore a production volume");
            return false;
        }
        if (snapshotVolume.isExposed()) {
            this.setErrorMsg("A snapshot volume cannot be exposed during a restore operation");
            return false;
        }
        if (snapshotVolume.isInState(VolumeStateConstant.VOLUME_STATE_OUT_OF_SYNC)) {
            this.setErrorMsg("A snapshot volume is out of sync");
            return false;
        }
        if (snapshotVolume.isInvolvedInAnotherRestoreOperation()) {
            this.setErrorMsg("The snapshot volume is already under a restore operation");
            return false;
        }
        if (snapshotVolume.isUsedByAPair()) {
            this.setErrorMsg("The snapshot volume is used by a pair");
            return false;
        }
        VolumeNodeImpl snapshotSource = snapshotVolume.getSourceVolume();
        if (snapshotSource.isExposed()) {
            this.setErrorMsg("A snapshot source volume cannot be exposed during a restore operation");
            return false;
        }
        if (snapshotSource.isNonFunctional()) {
            this.setErrorMsg("A snapshot source volume is non-functional and cannot be restored");
            return false;
        }
        return true;
    }
}

