/*
 * Decompiled with CFR 0.152.
 */
package com.sanrad.nms.server.logic.volume.validators;

import com.sanrad.nms.server.logic.ErrorMessage;
import com.sanrad.nms.server.logic.cluster.ClusterImpl;
import com.sanrad.nms.server.logic.volume.VolumeManager;
import com.sanrad.nms.server.logic.volume.VolumeNodeImpl;
import com.sanrad.nms.server.logic.volume.copy.CopyOperationImpl;
import com.sanrad.nms.server.logic.volume.validators.VolumeOperationValidator;
import com.sanrad.nms.server.logic.vswitch.VSwitchImpl;
import java.rmi.RemoteException;
import java.util.ArrayList;

public class RemovChildValidator
extends VolumeOperationValidator {
    public RemovChildValidator(ClusterImpl cluster, VolumeNodeImpl source, String alias, Object children, VolumeManager volumeMgr, VolumeNodeImpl[] childToRetract) {
        super(cluster, source, alias, children, volumeMgr, childToRetract);
    }

    @Override
    public boolean isValid() throws RemoteException {
        return super.isValid();
    }

    @Override
    public VSwitchImpl[] forWhichVswitchIsValid() throws RemoteException {
        VSwitchImpl[] validVs = super.forWhichVswitchIsValid();
        if (validVs == null || validVs.length == 0) {
            return validVs;
        }
        ArrayList<VSwitchImpl> vSwitchToSet = new ArrayList<VSwitchImpl>();
        for (VSwitchImpl vs : validVs) {
            vSwitchToSet.add(vs);
        }
        for (VSwitchImpl current : vSwitchToSet) {
            for (int i = 0; i < this.multiDestination.length; ++i) {
                if (!this.multiDestination[i].isInvolvedInActiveCopy(current)) continue;
                CopyOperationImpl oper = this.multiDestination[i].getCopyOperIfInvolved();
                String[] msg = new String[]{this.source.getAlias(), this.multiDestination[i].getClassId().toString() + " " + this.multiDestination[i].getAlias(), this.multiDestination[i].getAlias(), oper.getRestartType().toString()};
                this.setErrorMsg(ErrorMessage.CANNOT_REMOVE_CHILD_VOLUME_IS_PART_OF_COPY_OPER.getMessage(msg));
                return null;
            }
        }
        if (vSwitchToSet.isEmpty()) {
            return null;
        }
        validVs = new VSwitchImpl[vSwitchToSet.size()];
        vSwitchToSet.toArray(validVs);
        return validVs;
    }
}

