/*
 * Decompiled with CFR 0.152.
 */
package com.sanrad.nms.server.logic.volume.validators;

import com.sanrad.nms.server.logic.ErrorMessage;
import com.sanrad.nms.server.logic.cluster.ClusterImpl;
import com.sanrad.nms.server.logic.lu.LUImpl;
import com.sanrad.nms.server.logic.volume.SnapshotVolume;
import com.sanrad.nms.server.logic.volume.TransparentVolume;
import com.sanrad.nms.server.logic.volume.VolumeImpl;
import com.sanrad.nms.server.logic.volume.VolumeManager;
import com.sanrad.nms.server.logic.volume.VolumeNodeImpl;
import com.sanrad.nms.server.logic.volume.validators.VolumeOperationValidator;
import com.sanrad.nms.server.logic.vswitch.VSwitchImpl;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Iterator;

public class AddChildValidator
extends VolumeOperationValidator {
    public AddChildValidator(ClusterImpl cluster, VolumeNodeImpl source, String alias, Object child, VolumeManager volumeMgr, VolumeNodeImpl destination) {
        super(cluster, source, alias, child, volumeMgr, destination);
    }

    @Override
    public VSwitchImpl[] forWhichVswitchIsValid() throws RemoteException {
        VSwitchImpl[] validVs = super.forWhichVswitchIsValid();
        if (validVs == null || validVs.length == 0) {
            return validVs;
        }
        if (this.source instanceof TransparentVolume || this.destination instanceof TransparentVolume) {
            this.setErrorMsg(ErrorMessage.CANNOT_INVOLVE_TRANSPARENT_VOLUME_IN_OTHER_VOLUME.getMessage());
            return null;
        }
        if (this.source instanceof SnapshotVolume || this.destination instanceof SnapshotVolume) {
            this.setErrorMsg(ErrorMessage.CANNOT_INVOLVE_SNAPSHOT_VOLUME_IN_OTHER_VOLUME.getMessage());
            return null;
        }
        ArrayList<VSwitchImpl> vSwitchToSet = new ArrayList<VSwitchImpl>();
        for (int i = 0; i < validVs.length; ++i) {
            vSwitchToSet.add(validVs[i]);
        }
        Iterator itr = vSwitchToSet.iterator();
        while (itr.hasNext()) {
            String[] msg;
            String[] msg2;
            VSwitchImpl current = (VSwitchImpl)itr.next();
            if (this.source instanceof VolumeImpl && ((VolumeImpl)this.source).getChildren(current).size() >= this.MAX_NUM_OF_CHILDREN) {
                msg2 = new String[]{this.classId.toString(), Integer.toString(this.MAX_NUM_OF_CHILDREN)};
                this.setErrorMsg(ErrorMessage.CANNOT_CREATE_VOLUME_WITH_MORE_THEN_X_CHILDREN.getMessage(msg2));
                itr.remove();
                continue;
            }
            if (!this.destination.isRedundant() && !this.destination.isKnownByVSwitch(current)) {
                String[] msgParts = new String[]{this.destination.getAlias(), current.getClassId() + " " + current.getMgmIPAddr()};
                this.setErrorMsg(ErrorMessage.CHILD_NOT_REDUNDANT.getMessage(msgParts));
                return null;
            }
            if (this.destination.getParentVolume(current) != null) {
                VolumeImpl parentVol = this.destination.getParentVolume(current);
                msg = new String[]{parentVol.getClassId().toString(), parentVol.getAlias()};
                this.setErrorMsg(ErrorMessage.NEW_CHILD_ALREADY_HAS_PARENT.getMessage(msg));
                itr.remove();
                continue;
            }
            if (this.destination.getParentLU(current) != null) {
                LUImpl parentLu = this.destination.getParentLU(current);
                msg = new String[]{parentLu.getClassId().toString(), parentLu.getAlias()};
                this.setErrorMsg(ErrorMessage.NEW_CHILD_ALREADY_HAS_PARENT.getMessage(msg));
                itr.remove();
                continue;
            }
            if (!this.destination.isSnapshotSource(current)) continue;
            msg2 = new String[]{this.destination.getClassId().toString() + " " + this.destination.getAlias(), this.source.getAlias(), this.destination.getAlias()};
            this.setErrorMsg(ErrorMessage.NEW_CHILD_IS_SNAPSHOT_SOURCE.getMessage(msg2));
            itr.remove();
        }
        if (vSwitchToSet.isEmpty()) {
            return null;
        }
        if (this.destination.getBlockSize() != this.source.getBlockSize()) {
            String[] msg = new String[]{this.destination.getAlias(), this.source.getAlias()};
            this.setErrorMsg(ErrorMessage.NEW_CHILD_HAS_DIFERENT_BLOCK_SIZE.getMessage(msg));
            return null;
        }
        validVs = new VSwitchImpl[vSwitchToSet.size()];
        vSwitchToSet.toArray(validVs);
        return validVs;
    }
}

