/*
 * Decompiled with CFR 0.152.
 */
package com.sanrad.nms.server.logic.volume;

import com.sanrad.log.SrLogCategories;
import com.sanrad.log.SrLogger;
import com.sanrad.nms.server.RemoteObjectImpl;
import com.sanrad.nms.server.logic.IllegalValueException;
import com.sanrad.nms.server.logic.physstorage.Storageable;
import com.sanrad.nms.server.logic.volume.VirtualVolume;
import com.sanrad.nms.server.logic.volume.VirtualVolumeImpl;
import com.sanrad.nms.server.logic.volume.Volume;
import com.sanrad.nms.server.logic.volume.VolumeImpl;
import com.sanrad.nms.server.logic.volume.VolumeNodeImpl;
import com.sanrad.nms.server.logic.volume.VolumeTree;
import java.rmi.RemoteException;
import java.util.List;
import java.util.Vector;

public class VolumeTreeImpl
extends RemoteObjectImpl
implements VolumeTree {
    private VolumeNodeImpl root;
    private static SrLogger theLogger = SrLogger.getLogger();

    public VolumeTreeImpl(VolumeNodeImpl root) throws RemoteException {
        this.root = root;
    }

    public int getChildCount(Object parent) {
        return ((VolumeImpl)parent).getChildCount();
    }

    public VolumeNodeImpl getRoot() {
        return this.root;
    }

    public boolean isLeaf(Object node) {
        return ((VolumeImpl)node).isLeaf();
    }

    public boolean isInTree(Volume volume) {
        if (this.root.equals(volume)) {
            return true;
        }
        if (this.root instanceof VolumeImpl && volume instanceof VirtualVolume) {
            return ((VolumeImpl)this.root).isVolumeDescendant((VirtualVolume)volume);
        }
        return false;
    }

    public boolean addChild(VirtualVolumeImpl child) throws RemoteException {
        VirtualVolumeImpl directParentOfChild;
        VolumeImpl parent;
        if (this.root instanceof VolumeImpl && (parent = ((VolumeImpl)this.root).getDescendantVolume(directParentOfChild = (VirtualVolumeImpl)child.getParentVolume())) != null) {
            parent.insert(child);
            parent.updateChild(child);
            return true;
        }
        return false;
    }

    @Override
    public VolumeNodeImpl getTreeRoot() {
        return this.getRoot();
    }

    @Override
    public Vector<VolumeNodeImpl> getRootChildren() throws RemoteException {
        return (Vector)this.getTreeRoot().getChildren();
    }

    private VolumeImpl getVolumeByAlias(String alias, VolumeImpl parent, List<VolumeNodeImpl> children) {
        if (parent.getAlias().equals(alias)) {
            return parent;
        }
        if (children != null) {
            for (VolumeNodeImpl obj : children) {
                if (obj instanceof VirtualVolumeImpl) {
                    VirtualVolumeImpl volume = (VirtualVolumeImpl)obj;
                    return this.getVolumeByAlias(alias, volume, volume.getChildren());
                }
                if (obj instanceof Storageable) continue;
                theLogger.error(SrLogCategories.LEGACY, obj.getClass(), " not found in ", this.getClass(), "::getVolumeByAlias()");
            }
        }
        return null;
    }

    @Override
    public VolumeImpl getVolumeByAlias(String alias) {
        VolumeImpl root = (VolumeImpl)this.getRoot();
        return this.getVolumeByAlias(alias, root, root.getChildren());
    }

    public boolean isAliasExist(String alias) {
        VolumeImpl root = (VolumeImpl)this.getTreeRoot();
        return root.isAliasExist(alias);
    }

    public void clear() throws RemoteException {
        this.root = null;
    }

    public synchronized int synchronize() throws RemoteException, IllegalValueException {
        int retVal = this.root.synchronize();
        return retVal;
    }

    public int getTotalVolumeCount() throws RemoteException {
        return this.root.getChildrenOfVirtualVolumeTypeCount() + 1;
    }
}

