/*
 * Decompiled with CFR 0.152.
 */
package com.sanrad.nms.server.logic.volume;

import com.sanrad.log.SrLogCategories;
import com.sanrad.log.SrLogger;
import com.sanrad.nms.server.logic.ClientParameterCode;
import com.sanrad.nms.server.logic.DataMgrAdapter;
import com.sanrad.nms.server.logic.ErrorMessage;
import com.sanrad.nms.server.logic.IllegalValueException;
import com.sanrad.nms.server.logic.InvalidElementException;
import com.sanrad.nms.server.logic.LogicObjectImpl;
import com.sanrad.nms.server.logic.SynchronizeEvent;
import com.sanrad.nms.server.logic.SynchronizeListener;
import com.sanrad.nms.server.logic.SystemRootImpl;
import com.sanrad.nms.server.logic.cluster.ClusterImpl;
import com.sanrad.nms.server.logic.physstorage.Storageable;
import com.sanrad.nms.server.logic.storage.StorageImpl;
import com.sanrad.nms.server.logic.volume.VirtualVolume;
import com.sanrad.nms.server.logic.volume.Volume;
import com.sanrad.nms.server.logic.volume.VolumeNode;
import com.sanrad.nms.server.logic.volume.VolumeNodeImpl;
import com.sanrad.nms.server.logic.volume.VolumeParentable;
import com.sanrad.nms.server.logic.volume.validators.CreateVolumeValidator;
import com.sanrad.nms.server.logic.volume.validators.RemovChildValidator;
import com.sanrad.nms.server.logic.vswitch.VSwitchImpl;
import com.sanrad.nms.server.mgr.ConfigElementData;
import com.sanrad.nms.server.util.ClassID;
import com.sanrad.nms.server.util.CommKeyClassId;
import com.sanrad.nms.server.util.CommKeyUtil;
import com.sanrad.nms.server.util.Parameter;
import com.sanrad.nms.server.util.ParameterCode;
import com.sanrad.nms.server.util.types.ConfigElementDataList;
import com.sanrad.nms.server.util.types.SrInteger;
import com.sanrad.nms.server.util.types.SrString;
import com.sanrad.nms.server.util.types.SrType;
import com.sanrad.nms.server.util.types.constants.VolumeOperationType;
import com.sanrad.nms.server.util.types.constants.VolumeStateConstant;
import com.sanrad.util.Util;
import com.sanrad.util.concurrent.CompleteFuture;
import com.sanrad.util.concurrent.ErrorAssertingListener;
import com.sanrad.util.concurrent.SrFuture;
import java.math.BigInteger;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Vector;

public abstract class VolumeImpl
extends VolumeNodeImpl
implements Volume,
SynchronizeListener,
VolumeParentable {
    private static Map<ParameterCode, ParameterCode.Flags> theParameterCodeFlagsMap;
    private final Vector<VolumeNodeImpl> childrenVec = new Vector();
    private static SrLogger theLogger;
    public static final Integer BELONG_TO_ALL_VSWITCHES;

    protected VolumeImpl(ClusterImpl cluster, ClassID classId, ConfigElementData aCED) throws RemoteException, IllegalValueException, InvalidElementException {
        super(cluster, classId, aCED);
        this.validateAndInit(aCED, theParameterCodeFlagsMap);
    }

    @Override
    public String getAlias() {
        return this.getAlias(null);
    }

    @Override
    public String getAlias(VSwitchImpl vSwitch) {
        return (String)this.getValueOf(vSwitch, ParameterCode.VOLUME_ALIAS, vSwitch == null);
    }

    @Override
    public int getBlockSize(VSwitchImpl vSwitch) {
        SrInteger blockSize = (SrInteger)this.getSrValueOf(vSwitch, ParameterCode.VIRTUAL_VOLUME_BLOCK_SIZE, vSwitch == null);
        return blockSize == null ? -1 : blockSize.intValue();
    }

    @Override
    public double getBlockNum(VSwitchImpl vSwitch) {
        return this.getNumberOfBlocks(vSwitch).doubleValue();
    }

    @Override
    public double getBlockNum() {
        return this.getBlockNum(null);
    }

    @Override
    public BigInteger getNumberOfBlocks() {
        return this.getNumberOfBlocks(null);
    }

    @Override
    public BigInteger getNumberOfBlocks(VSwitchImpl vSwitch) {
        Object blockNumber = this.getValueOf(vSwitch, ParameterCode.VIRTUAL_VOLUME_ACTUAL_NUM_OF_BLOCKS, vSwitch == null);
        if (blockNumber instanceof String) {
            return new BigInteger((String)blockNumber);
        }
        return (BigInteger)blockNumber;
    }

    @Override
    public BigInteger getCapacityInBlocks() throws RemoteException {
        return this.getNumberOfBlocks();
    }

    @Override
    public BigInteger getPotentialCapacity() throws RemoteException {
        return this.getPotentialCapacity(null);
    }

    public BigInteger getPotentialCapacity(VSwitchImpl vSwitch) {
        BigInteger numOfBlocks = (BigInteger)this.getValueOf(vSwitch, ParameterCode.VIRTUAL_VOLUME_POTENTIAL_NUM_OF_BLOCKS, vSwitch == null);
        return Util.blocksToBytes(numOfBlocks, this.getBlockSize(vSwitch));
    }

    @Override
    public BigInteger getCapacityInBytes() throws RemoteException {
        BigInteger blockSize = new BigInteger(Integer.toString(this.getBlockSize()));
        return blockSize.multiply(this.getNumberOfBlocks());
    }

    public void setLeafsFree(boolean free) {
        ArrayList<VolumeNodeImpl> storageDevices = new ArrayList<VolumeNodeImpl>();
        this.getLeafs(storageDevices);
        for (VolumeNodeImpl storageDevice : storageDevices) {
            storageDevice.setFree(free);
        }
    }

    private void getLeafs(List<VolumeNodeImpl> leafs) {
        Enumeration e = this.children();
        while (e.hasMoreElements()) {
            Object node = e.nextElement();
            if (!this.equals(((VolumeNodeImpl)node).getParentVolume())) continue;
            if (node instanceof Storageable) {
                leafs.add((VolumeNodeImpl)node);
                continue;
            }
            if (!(node instanceof VolumeImpl)) continue;
            ((VolumeImpl)node).getLeafs(leafs);
        }
    }

    @Override
    public boolean isOneOfTheVolumesInHierarchyNeedSync() throws RemoteException {
        if (this.isNeedSync()) {
            return true;
        }
        for (VolumeNodeImpl child : this.getChildren()) {
            if (!child.isOneOfTheVolumesInHierarchyNeedSync()) continue;
            return true;
        }
        return false;
    }

    @Override
    public Vector getLeafs() {
        Vector<VolumeNodeImpl> leafs = new Vector<VolumeNodeImpl>();
        this.getLeafs(leafs);
        return leafs;
    }

    protected CommKeyClassId[] getChildrenCommKeyClassId() {
        return this.getChildrenCommKeyClassId(null);
    }

    protected CommKeyClassId[] getChildrenCommKeyClassId(VSwitchImpl aVSwitch) {
        CommKeyClassId[] childrenCommKeyClassId = (CommKeyClassId[])this.getSrArrayValueOf(aVSwitch, ParameterCode.VOLUME_CHILDREN, aVSwitch == null);
        return childrenCommKeyClassId;
    }

    @Override
    public List<VolumeNodeImpl> getChildren() {
        return this.childrenVec;
    }

    public Vector getChildren(VSwitchImpl vSwitch) {
        CommKeyClassId[] childrenCommKeyClassId = this.getChildrenCommKeyClassId(vSwitch);
        Vector<Object> childrenInParamList = new Vector<Object>();
        for (int i = 0; childrenCommKeyClassId != null && i < childrenCommKeyClassId.length; ++i) {
            Object child = this.cluster.getCommKeyRefMap().getRefByCommKeyClassID(childrenCommKeyClassId[i]);
            childrenInParamList.add(child);
        }
        return childrenInParamList;
    }

    private Enumeration children() {
        return this.childrenVec.elements();
    }

    public int getChildCount() {
        return this.childrenVec.size();
    }

    public boolean isLeaf() {
        return this.getChildCount() == 0;
    }

    public void insert(VolumeNodeImpl child) throws RemoteException {
        if (!this.childrenVec.contains(child)) {
            this.childrenVec.insertElementAt(child, 0);
        }
    }

    public void updateChild(VolumeNodeImpl child) throws RemoteException {
        if (child == null) {
            return;
        }
        this.addPropagationStateDependentObjectAndListener(child);
        child.setParent(this, 0);
        child.setFree(false);
        child.setParentLU(null);
    }

    public void removeChild(VolumeNodeImpl volume) {
        Iterator<VolumeNodeImpl> iter = this.childrenVec.iterator();
        while (iter.hasNext()) {
            if (!volume.equals(iter.next())) continue;
            iter.remove();
            this.removePropagationStateDependentObjectAndListener(volume);
            return;
        }
    }

    public boolean isVolumeChild(VolumeNode volume) {
        return this.childrenVec.contains(volume);
    }

    public boolean isVolumeChild(VSwitchImpl vSwitch, VolumeNode volume) throws RemoteException {
        Vector children = this.getChildren(vSwitch);
        return children.contains(volume);
    }

    public boolean isVolumeDescendant(VirtualVolume volume) {
        if (this.isVolumeChild(volume)) {
            return true;
        }
        for (VolumeNodeImpl child : this.childrenVec) {
            VolumeImpl v;
            if (!(child instanceof VolumeImpl) || !(v = (VolumeImpl)child).isVolumeDescendant(volume)) continue;
            return true;
        }
        return false;
    }

    public VolumeImpl getDescendantVolume(VolumeImpl volume) {
        if (volume.equals(this)) {
            return this;
        }
        for (VolumeNodeImpl child : this.childrenVec) {
            VolumeImpl v = (VolumeImpl)child;
            if (!v.equals(volume)) continue;
            return v;
        }
        return null;
    }

    protected final void setChild(VolumeNodeImpl childNode) throws RemoteException {
        if (childNode != null) {
            if (childNode.getParentVolume() == null && childNode.getParentLU() == null) {
                this.cluster.getVolumeMgr().removeVolumeFromForest(childNode);
            }
            this.insert(childNode);
            this.updateChild(childNode);
            childNode.addSynchronizeListener(this);
            childNode.setExposed(this.isExposed());
        }
    }

    protected void setChildrenByCommKeyClassId(CommKeyClassId childrenCommKeyClassId) throws RemoteException {
        VolumeNodeImpl child = (VolumeNodeImpl)this.cluster.getCommKeyRefMap().getRefByCommKeyClassID(childrenCommKeyClassId);
        if (child != null) {
            this.setChild(child);
        } else {
            ConfigElementData rebuildElement = new ConfigElementData(ClassID.GENERAL_VOLUME);
            rebuildElement.setValue(ParameterCode.VSWITCH_ID, CommKeyUtil.getVSwitchData(childrenCommKeyClassId));
        }
    }

    protected boolean setChildren(VSwitchImpl vSwitch, Vector childrenOldListbyVSwitch) throws RemoteException {
        Vector childrenInParamList = this.getChildren(vSwitch);
        Vector oldChildren = (Vector)this.childrenVec.clone();
        if (!this.childrenVec.containsAll(childrenInParamList) || !childrenInParamList.containsAll(this.childrenVec)) {
            int i;
            this.childrenVec.clear();
            CommKeyClassId[] childrenCommKeyClassId = this.getChildrenCommKeyClassId(vSwitch);
            for (i = 0; i < childrenCommKeyClassId.length; ++i) {
                this.setChildrenByCommKeyClassId(childrenCommKeyClassId[i]);
            }
            for (i = 0; i < childrenCommKeyClassId.length; ++i) {
                VolumeNodeImpl childRef = (VolumeNodeImpl)this.cluster.getCommKeyRefMap().getRefByCommKeyClassID(childrenCommKeyClassId[i]);
                this.updateChild(childRef);
            }
            for (VolumeNodeImpl node : oldChildren) {
                if (this.childrenVec.contains(node)) continue;
                if (node.getParentVolume().equals(this)) {
                    this.cluster.getStorage().returnVolumeToForest(node);
                    continue;
                }
                this.removePropagationStateDependentObjectAndListener(node);
            }
        }
        if (childrenOldListbyVSwitch != null && !childrenOldListbyVSwitch.isEmpty()) {
            for (VolumeNodeImpl node : this.childrenVec) {
                if (childrenOldListbyVSwitch.contains(node)) continue;
            }
        }
        return true;
    }

    @Override
    public HashMap changeParameterList(ConfigElementData aCED) throws RemoteException, IllegalValueException, InvalidElementException {
        VSwitchImpl vSwitch = this.getVSwitch(aCED);
        Vector childrenOldList = this.getChildren(vSwitch);
        HashMap changedValues = super.changeParameterList(aCED);
        this.toStringValue = this.getAlias();
        boolean childrenWasSet = aCED.getParametersList().containsKey(ParameterCode.VOLUME_CHILDREN);
        if (childrenWasSet) {
            this.setChildren(this.getVSwitch(aCED), childrenOldList);
        }
        if (changedValues.containsKey(ParameterCode.VIRTUAL_VOLUME_ACTUAL_NUM_OF_BLOCKS) || changedValues.containsKey(ParameterCode.VIRTUAL_VOLUME_POTENTIAL_NUM_OF_BLOCKS) || childrenWasSet) {
            changedValues.put(ParameterCode.VOLUME_SPACE, null);
        }
        return changedValues;
    }

    @Override
    public SrFuture<Void> deleteElement() throws RemoteException, IllegalValueException {
        ConfigElementData ced = new ConfigElementData(this.getCommKeys(), this.getClassId());
        CommKeyClassId[] childrenCommKeyClassId = new CommKeyClassId[this.childrenVec.size()];
        for (int i = 0; i < this.childrenVec.size(); ++i) {
            VolumeNodeImpl child = this.childrenVec.elementAt(i);
            childrenCommKeyClassId[i] = new CommKeyClassId(child.getCommKeys(), child.getClassId());
        }
        Parameter childrenParameter = new Parameter(ParameterCode.VOLUME_CHILDREN, childrenCommKeyClassId);
        ced.addParameter(childrenParameter);
        return this.deleteElement(ced);
    }

    public boolean isAliasExist(String alias) {
        if (alias.equals(this.getAlias())) {
            return true;
        }
        for (VolumeNodeImpl child : this.getChildren()) {
            if (!(child instanceof VolumeImpl) || !((VolumeImpl)child).isAliasExist(alias)) continue;
            return true;
        }
        return false;
    }

    protected boolean isChildOfVolume(VolumeNode child) {
        for (VolumeNodeImpl volChild : this.getChildren()) {
            if (!((Object)volChild).equals(child)) continue;
            return true;
        }
        return false;
    }

    @Override
    public void setExposed(boolean exposed) {
        for (VolumeNodeImpl child : this.childrenVec) {
            if (!this.equals(child.getParentVolume())) continue;
            child.setExposed(exposed);
        }
        super.setExposed(exposed);
    }

    @Override
    public BigInteger getAccessibleSpace() {
        return this.getAccessibleSpace(null);
    }

    public BigInteger getAccessibleSpace(VSwitchImpl vSwitch) {
        BigInteger numOfBlocks = (BigInteger)this.getValueOf(vSwitch, ParameterCode.VIRTUAL_VOLUME_ACTUAL_NUM_OF_BLOCKS, vSwitch == null);
        return Util.blocksToBytes(numOfBlocks, this.getBlockSize(vSwitch));
    }

    @Override
    public BigInteger getAllocatedSpace() throws RemoteException {
        BigInteger allocatedSpace = BigInteger.ZERO;
        Enumeration e = this.children();
        while (e.hasMoreElements()) {
            VolumeNode child = (VolumeNode)e.nextElement();
            if (child.getAllocatedSpace() == null) continue;
            allocatedSpace = allocatedSpace.add(child.getAllocatedSpace());
        }
        return allocatedSpace;
    }

    @Override
    protected String isValid(HashMap parameterList) {
        String alias = (String)parameterList.get(ClientParameterCode.VOLUME_ALIAS);
        if (alias != null) {
            String errorMsg = this.isAliasValid(alias);
            if (errorMsg != null) {
                return errorMsg;
            }
            if (alias.equals("")) {
                alias = CreateVolumeValidator.getDefaultAlias();
            }
            if (this.cluster.getVolumeMgr().isAliasExist(alias)) {
                return ErrorMessage.ALIAS_ALREADY_IN_USE.getMessage(alias);
            }
            if (this.cluster.getStoragePool().isAliasExist(alias)) {
                return ErrorMessage.ALIAS_ALREADY_IN_USE.getMessage(alias);
            }
            parameterList.put(ClientParameterCode.VOLUME_ALIAS, new SrString(alias));
        }
        return null;
    }

    @Override
    public void clear() throws RemoteException {
        this.setParent(null, -1);
        this.childrenVec.clear();
        super.clear();
    }

    @Override
    public int getChildrenOfVirtualVolumeTypeCount() {
        int childrenCount = 0;
        Enumeration e = this.children();
        while (e.hasMoreElements()) {
            VolumeNodeImpl child = (VolumeNodeImpl)e.nextElement();
            if (child instanceof Volume) {
                ++childrenCount;
            }
            childrenCount += child.getChildrenOfVirtualVolumeTypeCount();
        }
        return childrenCount;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof Volume) {
            try {
                Volume otherVolume = (Volume)obj;
                List<? extends VolumeNode> otherChildren = ((Volume)obj).getChildren();
                List<VolumeNodeImpl> children = this.getChildren();
                if (otherVolume.getClassId().equals(this.getClassId()) && otherChildren.size() == children.size()) {
                    boolean equal = false;
                    for (VolumeNode volumeNode : otherChildren) {
                        equal = children.contains(volumeNode);
                        if (equal) continue;
                        return super.equals(obj);
                    }
                    return true;
                }
                return super.equals(obj);
            }
            catch (RemoteException re) {
                theLogger.logAndAssert(SrLogCategories.EXCEPTION, re, "got a remote exception in the server.");
            }
        }
        return false;
    }

    @Override
    public synchronized int synchronize() throws RemoteException, IllegalValueException {
        theLogger.trace(SrLogCategories.LEGACY, "Start Sync volume ", this.getAlias());
        if (this.isSynchronizePending()) {
            theLogger.trace(SrLogCategories.LEGACY, "Already synchronizing ", this.getClassId(), " ", this.toString());
            return 1;
        }
        theLogger.trace(SrLogCategories.LEGACY, "Start to synchronize ", this.getClassId(), " ", this.toString());
        this.setSynchronizePending(true);
        int syncChildrenRetVal = 0;
        StringBuffer errMsg = new StringBuffer();
        boolean errOccured = false;
        Enumeration e = this.children();
        while (e.hasMoreElements()) {
            try {
                VolumeNodeImpl child = (VolumeNodeImpl)e.nextElement();
                int childRetVal = child.synchronize();
                theLogger.trace(SrLogCategories.LEGACY, "Sync of volume ", this.getAlias(), " Child", child.getAlias(), " status ", childRetVal);
                if (childRetVal <= syncChildrenRetVal) continue;
                syncChildrenRetVal = childRetVal;
            }
            catch (IllegalValueException ive) {
                theLogger.warn(SrLogCategories.LEGACY, ive);
                errMsg.append(" \n");
                errMsg.append(ive.getMessage());
                errOccured = true;
            }
        }
        if (errOccured) {
            this.setSynchronizePending(false);
            throw new IllegalValueException(errMsg.toString());
        }
        switch (syncChildrenRetVal) {
            case 1: 
            case 2: {
                return 2;
            }
            case 3: {
                this.setSynchronizePending(false);
                return 3;
            }
        }
        if (!this.isNeedToSynchronize()) {
            this.setSynchronizePending(false);
            return 0;
        }
        int retVal = this.synchronizeMe();
        theLogger.trace(SrLogCategories.LEGACY, "Sync of volume ", this.getAlias(), " SyncMe status ", retVal);
        return retVal;
    }

    @Override
    public synchronized boolean isNeedToSynchronize() throws RemoteException {
        if (super.isNeedToSynchronize()) {
            return true;
        }
        if (this.isInconsistent()) {
            for (VSwitchImpl curVS : this.cluster.getVSwitches()) {
                if (curVS.isConnected()) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    protected abstract int createMeOnOtherVswitch() throws RemoteException, IllegalValueException;

    @Override
    protected synchronized int synchronizeMe() throws RemoteException, IllegalValueException {
        try {
            if (this.canBeSynchronized() != null) {
                return 2;
            }
            if (super.isNeedToSynchronize() && !this.isInSynchronizingMode()) {
                this.setSynchronizingMode(true);
                int retVal = this.createMeOnOtherVswitch();
                switch (retVal) {
                    case 1: 
                    case 2: {
                        retVal = 2;
                        break;
                    }
                    case 3: {
                        this.setSynchronizePending(false);
                    }
                }
                return retVal;
            }
            HashMap<Object, VolumeNodeImpl[]> childrenByVswitch = this.getChildrenListByVSwitch();
            for (Object key : childrenByVswitch.keySet()) {
                VolumeNodeImpl[] existOnThis;
                if (!(key instanceof VSwitchImpl) || (existOnThis = childrenByVswitch.get(key)).length == 0) continue;
                CommKeyClassId thisVswitchData = ((VSwitchImpl)key).getCommKeyClassId();
                List<VSwitchImpl> vSwitches = this.getVSwitches();
                ArrayList<CommKeyClassId> vSwitchesToSync = new ArrayList<CommKeyClassId>();
                for (int i = 0; i < vSwitches.size(); ++i) {
                    CommKeyClassId current = vSwitches.get(i).getCommKeyClassId();
                    if (thisVswitchData.equals(current)) continue;
                    vSwitchesToSync.add(current);
                }
                CommKeyClassId[] vSwitchesToSyncData = new CommKeyClassId[vSwitchesToSync.size()];
                vSwitchesToSync.toArray(vSwitchesToSyncData);
                int lowestPosition = 100;
                VolumeNodeImpl childToSync = null;
                for (int i = 0; i < existOnThis.length; ++i) {
                    int currPosition = existOnThis[i].getPositionInParent((VSwitchImpl)key);
                    if (currPosition >= lowestPosition) continue;
                    lowestPosition = currPosition;
                    childToSync = existOnThis[i];
                }
                if (vSwitchesToSyncData.length <= 0) {
                    return 2;
                }
                ErrorAssertingListener.listenTo(this.addChild(childToSync, VolumeOperationType.VOL_OPER_ADD_CHILD, vSwitchesToSyncData, this.getCommKeyClassId()));
                return 2;
            }
            return 0;
        }
        catch (IllegalValueException ive) {
            theLogger.warn(SrLogCategories.LEGACY, ive.getMessage());
            this.setSynchronizePending(false);
            throw ive;
        }
    }

    @Override
    protected String canBeSynchronized() throws RemoteException, IllegalValueException {
        Enumeration e = this.children();
        while (e.hasMoreElements()) {
            VolumeNodeImpl child = (VolumeNodeImpl)e.nextElement();
            if (!child.isNeedToSynchronize()) continue;
            if (!child.isSynchronizePending()) {
                StringBuffer msg = new StringBuffer("Volume ");
                msg.append(this.getAlias());
                msg.append(" cannot be synchronized. ");
                msg.append(child.getClassId());
                msg.append(" ");
                msg.append(child);
                msg.append("is not synchronized yet");
                throw new IllegalValueException(msg.toString());
            }
            return child.getClassId() + " " + child + " is not synchronized yet";
        }
        return null;
    }

    @Override
    public synchronized void synchronizingCompleted(SynchronizeEvent event) {
        try {
            this.syncDataWasChanged();
        }
        catch (RemoteException re) {
            theLogger.logAndAssert(SrLogCategories.EXCEPTION, re, "got a remote exception in the server.");
        }
        catch (IllegalValueException ive) {
            theLogger.logAndAssert(SrLogCategories.EXCEPTION, ive, "got an illegal value exception.");
        }
    }

    @Override
    public void registerToPropagatedStateChange() {
        for (VolumeNodeImpl child : this.getChildren()) {
            this.addPropagationStateDependentObjectAndListener(child);
        }
    }

    public void registerToPropagatedStateListenerForAllLeafs(LogicObjectImpl obj) throws RemoteException {
        obj.addPropagationStateDependentObjectAndListener(this);
        Vector leafs = this.getLeafs();
        Enumeration e = leafs.elements();
        while (e.hasMoreElements()) {
            obj.addPropagationStateDependentObjectAndListener((LogicObjectImpl)e.nextElement());
        }
    }

    public void unRegisterToPropagatedStateListenerForAllLeafs(LogicObjectImpl obj) {
        obj.removePropagationStateDependentObjectAndListener(this);
        Vector leafs = this.getLeafs();
        Enumeration e = leafs.elements();
        while (e.hasMoreElements()) {
            obj.removePropagationStateDependentObjectAndListener((LogicObjectImpl)e.nextElement());
        }
    }

    @Override
    public SrFuture<Void> resize(CommKeyClassId newChild, String cubeVolAlias) throws RemoteException, IllegalValueException {
        return new CompleteFuture<Void>("VolumeImpl.resize");
    }

    public boolean isInconsistent() {
        if (this.isRedundant() && this.getConnectedVSwitchCounter() > 1) {
            VSwitchImpl[] vSwitches = this.getConnectedVSwitches();
            ArrayList<CommKeyClassId[]> allChildren = new ArrayList<CommKeyClassId[]>();
            for (int i = 0; i < vSwitches.length; ++i) {
                allChildren.add(this.getChildrenCommKeyClassId(vSwitches[i]));
            }
            int childrenCount = ((CommKeyClassId[])allChildren.get(0)).length;
            for (int i = 1; i < allChildren.size(); ++i) {
                if (childrenCount == ((CommKeyClassId[])allChildren.get(i)).length) continue;
                theLogger.debug(SrLogCategories.DEBUG, this, " has ", childrenCount, " children in VS ", vSwitches[0], "(", allChildren.get(0), ") and ", ((CommKeyClassId[])allChildren.get(i)).length, " in VS ", vSwitches[i], "(", allChildren.get(i), ")");
                return true;
            }
        }
        return false;
    }

    public boolean isIllegal() {
        for (VolumeNodeImpl child : this.getChildren()) {
            int i;
            if (!child.isRedundant() || child.getConnectedVSwitchCounter() <= 1) continue;
            VSwitchImpl[] vSwitches = child.getConnectedVSwitches();
            VolumeImpl[] parents = new VolumeImpl[vSwitches.length];
            for (i = 0; i < vSwitches.length; ++i) {
                parents[i] = child.getParentVolume(vSwitches[i]);
            }
            for (i = 0; i < parents.length; ++i) {
                if (parents[i] != null && !parents[i].equals(this)) {
                    return true;
                }
                if (parents[i] != null) continue;
                theLogger.trace(SrLogCategories.LEGACY, child.getClassId(), " ", child, " has a null parent volume in ", ClassID.VSWITCH, " ", vSwitches[i]);
            }
        }
        return false;
    }

    public boolean isExistOneChildNonFunctional(VSwitchImpl vSwitch) throws RemoteException {
        Enumeration iter = this.children();
        while (iter.hasMoreElements()) {
            VolumeNodeImpl child = (VolumeNodeImpl)iter.nextElement();
            if (!child.isInState(vSwitch, VolumeStateConstant.VOLUME_STATE_NONFUNCTIONAL)) continue;
            return true;
        }
        return false;
    }

    public SrFuture<Void> addChild(VolumeNodeImpl childToAdd, VolumeOperationType oper, CommKeyClassId[] vSwitchesToSet, CommKeyClassId operationInvoker) throws RemoteException, IllegalValueException {
        CommKeyClassId newchild = childToAdd.getCommKeyClassId();
        ConfigElementData vol = new ConfigElementData(this.getCommKeys(), this.getClassId());
        CommKeyClassId[] childrenData = null;
        if (vSwitchesToSet == null || vSwitchesToSet.length != 1) {
            List<VolumeNodeImpl> volChildren = this.getChildren();
            childrenData = new CommKeyClassId[volChildren.size()];
            for (int i = 0; i < volChildren.size(); ++i) {
                childrenData[i] = volChildren.get(i).getCommKeyClassId();
            }
        } else {
            VSwitchImpl vs = (VSwitchImpl)SystemRootImpl.getInstance().getRefByStub(vSwitchesToSet[0]);
            childrenData = this.getChildrenCommKeyClassId(vs);
        }
        vol.addParameter(new Parameter(ParameterCode.VOLUME_CHILDREN, childrenData));
        vol.setValue(ParameterCode.VOLUME_OPERATION_DST, newchild);
        vol.setValues(ParameterCode.VSWITCH_ID, vSwitchesToSet);
        vol.setOperationInvoker(operationInvoker);
        return DataMgrAdapter.getInstance().operate(vol, oper);
    }

    public SrFuture<Void> removeChildren(CommKeyClassId[] childrenToRemove, VolumeOperationType operType) throws RemoteException, IllegalValueException {
        int i;
        VSwitchImpl[] connectedVSwitches;
        VolumeNodeImpl[] children = new VolumeNodeImpl[childrenToRemove.length];
        for (int i2 = 0; i2 < children.length; ++i2) {
            children[i2] = (VolumeNodeImpl)SystemRootImpl.getInstance().getRefByStub(childrenToRemove[i2]);
        }
        StorageImpl storage = this.cluster.getStorage();
        RemovChildValidator validator = new RemovChildValidator(this.cluster, (VolumeNodeImpl)this, this.getAlias(), this.getChildren(), storage.getVolumeMgr(), children);
        validator.turnOffAliasValidation();
        validator.turnOffNonFunctionalValidation();
        VSwitchImpl[] vSwitchToSet = validator.forWhichVswitchIsValid();
        if (vSwitchToSet == null || vSwitchToSet.length == 0) {
            throw new IllegalValueException(validator.getErrorMsg());
        }
        CommKeyClassId[] newListToRemove = childrenToRemove;
        VSwitchImpl[] vSwitchToRemove = connectedVSwitches = this.getConnectedVSwitches();
        ArrayList<CommKeyClassId[]> allChildren = new ArrayList<CommKeyClassId[]>();
        for (i = 0; i < connectedVSwitches.length; ++i) {
            allChildren.add(this.getChildrenCommKeyClassId(connectedVSwitches[i]));
        }
        for (i = 0; i < childrenToRemove.length; ++i) {
            ArrayList<VSwitchImpl> existInVSwitch = new ArrayList<VSwitchImpl>();
            block3: for (int j = 0; j < allChildren.size(); ++j) {
                CommKeyClassId[] oneVSchildrenList = (CommKeyClassId[])allChildren.get(j);
                for (int k = 0; k < oneVSchildrenList.length; ++k) {
                    if (!oneVSchildrenList[k].equals(childrenToRemove[i])) continue;
                    existInVSwitch.add(connectedVSwitches[j]);
                    continue block3;
                }
            }
            if (existInVSwitch.size() >= connectedVSwitches.length) continue;
            newListToRemove = new CommKeyClassId[]{childrenToRemove[i]};
            vSwitchToRemove = new VSwitchImpl[existInVSwitch.size()];
            existInVSwitch.toArray(vSwitchToRemove);
            break;
        }
        ConfigElementData element = new ConfigElementData(this.getCommKeys(), this.getClassId());
        element.addParameter(new Parameter(ParameterCode.VOLUME_OPERATION_DST, newListToRemove));
        element.setValue(ParameterCode.VOLUME_OPERATION_SRC, this.getCommKeyClassId());
        CommKeyClassId[] vSwitchList = new CommKeyClassId[vSwitchToRemove.length];
        for (int i3 = 0; i3 < vSwitchToRemove.length; ++i3) {
            vSwitchList[i3] = vSwitchToRemove[i3].getCommKeyClassId();
        }
        element.addParameter(new Parameter(ParameterCode.VSWITCH_ID, vSwitchList));
        List<VolumeNodeImpl> myChildren = this.getChildren();
        CommKeyClassId[] myChildrenList = new CommKeyClassId[myChildren.size()];
        for (int i4 = 0; i4 < myChildren.size(); ++i4) {
            myChildrenList[i4] = myChildren.get(i4).getCommKeyClassId();
        }
        element.addParameter(new Parameter(ParameterCode.VOLUME_CHILDREN, myChildrenList));
        if (this.getParentVolume() != null) {
            VolumeImpl parent = this.getParentVolume();
            element.setValue(ParameterCode.VIRTUAL_VOLUME_PARENT, parent.getCommKeyClassId());
            List<? extends VolumeNode> myParentChildren = parent.getChildren();
            CommKeyClassId[] childrenData = new CommKeyClassId[myParentChildren.size()];
            for (int i5 = 0; i5 < myParentChildren.size(); ++i5) {
                childrenData[i5] = myParentChildren.get(i5).getCommKeyClassId();
            }
            element.addParameter(new Parameter(ParameterCode.VIRTUAL_VOLUME_MY_PARENTS_CHILDREN, childrenData));
        } else if (this.getParentLU() != null) {
            element.setValue(ParameterCode.VIRTUAL_VOLUME_LU, this.getParentLU().getCommKeyClassId());
        }
        return DataMgrAdapter.getInstance().operate(element, operType);
    }

    public HashMap<Object, CommKeyClassId[]> getChildrenCommKeyClassIdListByVSwitch() throws RemoteException {
        HashMap<Object, VolumeNodeImpl[]> listByNodes = this.getChildrenListByVSwitch();
        HashMap<Object, CommKeyClassId[]> listByCommKeyClassId = new HashMap<Object, CommKeyClassId[]>();
        for (Object key : listByNodes.keySet()) {
            VolumeNodeImpl[] keyList = listByNodes.get(key);
            CommKeyClassId[] commKeyClassIdList = new CommKeyClassId[keyList.length];
            for (int i = 0; i < keyList.length; ++i) {
                commKeyClassIdList[i] = keyList[i].getCommKeyClassId();
            }
            listByCommKeyClassId.put(key, commKeyClassIdList);
        }
        return listByCommKeyClassId;
    }

    protected HashMap<Object, VolumeNodeImpl[]> getChildrenListByVSwitch() {
        VSwitchImpl[] vSwitches = this.getConnectedVSwitches();
        ArrayList<CommKeyClassId[]> allChildren = new ArrayList<CommKeyClassId[]>();
        for (int i = 0; i < vSwitches.length; ++i) {
            allChildren.add(this.getChildrenCommKeyClassId(vSwitches[i]));
        }
        HashMap<Object, VolumeNodeImpl[]> listByVSwitch = new HashMap<Object, VolumeNodeImpl[]>();
        Vector<VolumeNodeImpl> existInAll = new Vector<VolumeNodeImpl>();
        for (int i = 0; i < allChildren.size(); ++i) {
            Vector<VolumeNodeImpl> existOnlyInThis = new Vector<VolumeNodeImpl>();
            CommKeyClassId[] oneVSchildrenList = (CommKeyClassId[])allChildren.get(i);
            for (int k = 0; k < oneVSchildrenList.length; ++k) {
                VolumeNodeImpl child = (VolumeNodeImpl)SystemRootImpl.getInstance().getRefByStub(oneVSchildrenList[k]);
                if (child == null) continue;
                boolean childExist = true;
                for (int j = 0; j < allChildren.size(); ++j) {
                    if (j == i) continue;
                    childExist = false;
                    CommKeyClassId[] otherVSchildrenList = (CommKeyClassId[])allChildren.get(j);
                    for (int p = 0; p < otherVSchildrenList.length; ++p) {
                        VolumeNodeImpl otherChild = (VolumeNodeImpl)SystemRootImpl.getInstance().getRefByStub(otherVSchildrenList[p]);
                        if (!child.equals(otherChild)) continue;
                        childExist = true;
                        break;
                    }
                    if (childExist) continue;
                    existOnlyInThis.add(child);
                    break;
                }
                if (!childExist || i != 0) continue;
                existInAll.add(child);
            }
            VolumeNodeImpl[] exitInThisList = new VolumeNodeImpl[existOnlyInThis.size()];
            existOnlyInThis.toArray(exitInThisList);
            listByVSwitch.put(vSwitches[i], exitInThisList);
        }
        VolumeNodeImpl[] existInAllList = new VolumeNodeImpl[existInAll.size()];
        existInAll.toArray(existInAllList);
        listByVSwitch.put(BELONG_TO_ALL_VSWITCHES, existInAllList);
        return listByVSwitch;
    }

    @Override
    public void childVolumeStateWasChanged() throws RemoteException {
    }

    @Override
    public void childCapacityWasChanged() throws RemoteException {
        ErrorAssertingListener.listenTo(this.reReadVolumeCapacity());
    }

    public SrFuture<Void> reReadVolumeCapacity() {
        if (this.getCommKeys() != null) {
            ConfigElementData element = new ConfigElementData(this.getCommKeyClassId());
            element.setValue(ParameterCode.VIRTUAL_VOLUME_ACTUAL_NUM_OF_BLOCKS, (SrType)null);
            element.setValue(ParameterCode.VIRTUAL_VOLUME_POTENTIAL_NUM_OF_BLOCKS, (SrType)null);
            return this.refreshFields(element);
        }
        return new CompleteFuture<Void>("VolumeImpl.reReadVolumeCapacity");
    }

    @Override
    public boolean isIllegalDownHierarchy() {
        Enumeration iter = this.children();
        while (iter.hasMoreElements()) {
            if (!((VolumeNodeImpl)iter.nextElement()).isIllegalDownHierarchy()) continue;
            return true;
        }
        return this.isIllegal();
    }

    @Override
    public boolean isIllegalUpHierarchy() {
        if (super.isIllegalUpHierarchy()) {
            return true;
        }
        return this.isIllegal();
    }

    @Override
    public boolean isDiskMissingDownHierarchy(VSwitchImpl vswitch) {
        Enumeration iter = this.children();
        while (iter.hasMoreElements()) {
            if (!((VolumeNodeImpl)iter.nextElement()).isDiskMissingDownHierarchy(vswitch)) continue;
            return true;
        }
        return false;
    }

    protected List<VolumeNodeImpl> getNonFunctionalChildren(VSwitchImpl vSwitch) {
        ArrayList<VolumeNodeImpl> nonFuncChildren = new ArrayList<VolumeNodeImpl>();
        for (VolumeNodeImpl child : this.getChildren()) {
            if (!child.isNonFunctional(vSwitch)) continue;
            nonFuncChildren.add(child);
        }
        return nonFuncChildren;
    }

    protected Vector<VolumeNodeImpl> getChildrenListForClusterSync(VSwitchImpl vSwitchToSync) {
        Vector<VolumeNodeImpl> childrenForAutoSync = new Vector<VolumeNodeImpl>();
        VolumeStateConstant specialState = this.getMyTypeSpecialStateAfterAddChild();
        for (VolumeNodeImpl child : this.getChildren()) {
            if (specialState != null && child.isInState(specialState)) continue;
            VSwitchImpl[] vSwitchesChildExistOn = child.getConnectedVSwitches();
            boolean existOnVSToSync = false;
            for (int i = 0; i < vSwitchesChildExistOn.length; ++i) {
                if (!vSwitchesChildExistOn[i].equals(vSwitchToSync)) continue;
                existOnVSToSync = true;
            }
            if (!existOnVSToSync) {
                return null;
            }
            childrenForAutoSync.add(child);
        }
        return childrenForAutoSync;
    }

    protected VolumeStateConstant getMyTypeSpecialStateAfterAddChild() {
        return null;
    }

    @Override
    public void updateElementWithCreationParameters(ConfigElementData element, ClusterImpl remoteCluster) throws RemoteException, IllegalValueException {
        super.updateElementWithCreationParameters(element, remoteCluster);
    }

    @Override
    protected boolean isAliasAlreadyExsist(ClusterImpl remoteCluster, String alias) throws RemoteException {
        return remoteCluster.getStorage().getVolumeByAlias(alias) != null;
    }

    @Override
    public ConfigElementDataList buildCedListForRemoveVolumeTree(Vector subdisks, ConfigElementDataList elementList) throws RemoteException {
        List<VolumeNodeImpl> children = this.getChildren();
        ConfigElementData element = new ConfigElementData(this.getCommKeyClassId());
        elementList.add(element);
        for (VolumeNodeImpl child : children) {
            elementList.addAll(child.buildCedListForRemoveVolumeTree(subdisks, elementList));
        }
        this.getCluster().prepareVSwitchIDs(element, "prepare element for remove volume tree", this.getConnectedVSwitchesAsList());
        return elementList;
    }

    @Override
    public boolean isProvisioned() {
        return this.getDevicesOfVolume().get(0).isProvisioned();
    }

    public boolean isMismatch(VSwitchImpl vSwitch) {
        return this.isInState(vSwitch, VolumeStateConstant.VOLUME_STATE_MISMATCH);
    }

    public boolean isNonValidate(VSwitchImpl vswitch) {
        return this.isInState(vswitch, VolumeStateConstant.VOLUME_STATE_NON_VALIDATE);
    }

    @Override
    protected ArrayList<ParameterCode> getParamsForCreation() {
        ArrayList<ParameterCode> params = new ArrayList<ParameterCode>();
        params.add(ParameterCode.VOLUME_ALIAS);
        params.add(ParameterCode.VOLUME_CHILDREN);
        return params;
    }

    @Override
    protected List<LogicObjectImpl> getChildElementsForDeletion() {
        ArrayList<VolumeNodeImpl> children = new ArrayList<VolumeNodeImpl>();
        for (VolumeNodeImpl child : this.getChildren()) {
            if (ClassID.DIRECT_ACCESS_DEVICE.equals(child.getClassId())) continue;
            children.add(child);
        }
        return Util.convertListType(children);
    }

    static {
        HashMap<ParameterCode, ParameterCode.Flags> parameterCodeFlagsMap = new HashMap<ParameterCode, ParameterCode.Flags>();
        parameterCodeFlagsMap.put(ParameterCode.VOLUME_ALIAS, new ParameterCode.Flags(true, false));
        parameterCodeFlagsMap.put(ParameterCode.VOLUME_CHILDREN, new ParameterCode.Flags(true, false));
        parameterCodeFlagsMap.put(ParameterCode.VIRTUAL_VOLUME_ACTUAL_NUM_OF_BLOCKS, new ParameterCode.Flags(true, false));
        parameterCodeFlagsMap.put(ParameterCode.VIRTUAL_VOLUME_BLOCK_SIZE, new ParameterCode.Flags(true, false));
        parameterCodeFlagsMap.put(ParameterCode.VIRTUAL_VOLUME_POTENTIAL_NUM_OF_BLOCKS, new ParameterCode.Flags(true, false));
        theParameterCodeFlagsMap = Collections.unmodifiableMap(parameterCodeFlagsMap);
        theLogger = SrLogger.getLogger();
        BELONG_TO_ALL_VSWITCHES = new Integer(100);
    }
}

