/*
 * Decompiled with CFR 0.152.
 */
package com.sanrad.nms.server.logic.volume;

import com.sanrad.log.SrLogCategories;
import com.sanrad.log.SrLogger;
import com.sanrad.nms.server.logic.IllegalValueException;
import com.sanrad.nms.server.logic.volume.VirtualVolume;
import com.sanrad.nms.server.logic.volume.VirtualVolumeImpl;
import com.sanrad.nms.server.logic.volume.Volume;
import com.sanrad.nms.server.logic.volume.VolumeImpl;
import com.sanrad.nms.server.logic.volume.VolumeNode;
import com.sanrad.nms.server.logic.volume.VolumeNodeImpl;
import com.sanrad.nms.server.logic.volume.VolumeTree;
import com.sanrad.nms.server.logic.volume.VolumeTreeImpl;
import java.rmi.RemoteException;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.Vector;

public class VolumeForest {
    private Vector<VolumeTreeImpl> myForest = new Vector();
    private static SrLogger theLogger = SrLogger.getLogger();

    public boolean addVolumeTree(VolumeTreeImpl tree) throws RemoteException {
        Vector<VolumeNodeImpl> children = tree.getRootChildren();
        for (VolumeNodeImpl child : children) {
            if (!(child instanceof VolumeImpl)) continue;
            VolumeImpl volume = (VolumeImpl)child;
            Iterator<VolumeTreeImpl> i = this.myForest.iterator();
            while (i.hasNext()) {
                VolumeTreeImpl treeElement = i.next();
                if (!volume.equals(treeElement.getRoot())) continue;
                i.remove();
            }
        }
        this.myForest.addElement(tree);
        return true;
    }

    private void createTreeAndAddVolumeAsRoot(VolumeImpl volume) throws RemoteException {
        VolumeTreeImpl newTree = new VolumeTreeImpl(volume);
        this.addVolumeTree(newTree);
    }

    public void addVolume(VolumeImpl volume) throws RemoteException {
        VolumeTreeImpl tree;
        if (volume instanceof VirtualVolume && (tree = this.getTreeOf(((VirtualVolumeImpl)volume).getParentVolume())) != null) {
            tree.addChild((VirtualVolumeImpl)volume);
        }
        this.createTreeAndAddVolumeAsRoot(volume);
    }

    public boolean removeVolumeTreeRoot(VolumeTree tree) throws RemoteException {
        Vector children = tree.getRootChildren();
        VolumeNode parent = tree.getTreeRoot();
        if (children != null) {
            Enumeration e = children.elements();
            while (e.hasMoreElements()) {
                Object node = e.nextElement();
                if (!(node instanceof Volume) || !parent.equals(((VolumeNodeImpl)node).getParentVolume())) continue;
                VolumeImpl volume = (VolumeImpl)node;
                volume.removeParent();
                this.addVolume(volume);
            }
        }
        return this.myForest.remove(tree);
    }

    public boolean removeVolumeTree(VolumeTree tree) {
        return this.myForest.remove(tree);
    }

    public boolean removeVolumeTreeRoot(Volume root) throws RemoteException {
        VolumeTreeImpl tree = this.getTreeOf(root);
        if (tree != null) {
            return this.removeVolumeTreeRoot(tree);
        }
        return false;
    }

    public boolean removeVolumeTree(Volume root) {
        VolumeTreeImpl tree = this.getTreeOf(root);
        return this.removeVolumeTree(tree);
    }

    public void removeAll() {
        this.myForest.removeAllElements();
    }

    public int size() {
        return this.myForest.size();
    }

    public Vector<VolumeTreeImpl> getAll() {
        return this.myForest;
    }

    public VolumeTreeImpl getTreeOf(Volume volume) {
        if (volume != null) {
            Enumeration<VolumeTreeImpl> e = this.myForest.elements();
            while (e.hasMoreElements()) {
                VolumeTreeImpl tree = e.nextElement();
                if (!tree.isInTree(volume)) continue;
                return tree;
            }
        }
        return null;
    }

    public VolumeImpl getVolumeByAlias(String alias) {
        VolumeTreeImpl tree;
        VolumeImpl volume = null;
        Enumeration<VolumeTreeImpl> e = this.myForest.elements();
        while (e.hasMoreElements() && (volume = (tree = e.nextElement()).getVolumeByAlias(alias)) == null) {
        }
        return volume;
    }

    public boolean isAliasExist(String alias) {
        Enumeration<VolumeTreeImpl> e = this.myForest.elements();
        while (e.hasMoreElements()) {
            VolumeTreeImpl tree = e.nextElement();
            if (!tree.isAliasExist(alias)) continue;
            return true;
        }
        return false;
    }

    public synchronized boolean synchronize() throws RemoteException, IllegalValueException {
        StringBuffer errMsg = new StringBuffer();
        boolean errOccured = false;
        Enumeration<VolumeTreeImpl> e = this.myForest.elements();
        while (e.hasMoreElements()) {
            try {
                VolumeTreeImpl tree = e.nextElement();
                tree.synchronize();
            }
            catch (IllegalValueException ive) {
                theLogger.warn(SrLogCategories.LEGACY, ive);
                errMsg.append(" \n");
                errMsg.append(ive.getMessage());
                errOccured = true;
            }
        }
        if (errOccured) {
            throw new IllegalValueException(errMsg.toString());
        }
        return false;
    }

    public int getTotalVolumeCount() throws RemoteException {
        int totalVolumeCount = 0;
        Enumeration<VolumeTreeImpl> e = this.myForest.elements();
        while (e.hasMoreElements()) {
            VolumeTreeImpl tree = e.nextElement();
            totalVolumeCount += tree.getTotalVolumeCount();
        }
        return totalVolumeCount;
    }

    public Vector<VolumeNodeImpl> getAllVolumeRoots() {
        Vector<VolumeNodeImpl> roots = new Vector<VolumeNodeImpl>();
        Enumeration<VolumeTreeImpl> e = this.myForest.elements();
        while (e.hasMoreElements()) {
            VolumeTreeImpl tree = e.nextElement();
            roots.addElement(tree.getRoot());
        }
        return roots;
    }
}

