/*
 * Decompiled with CFR 0.152.
 */
package com.sanrad.nms.server.logic.volume;

import com.sanrad.nms.server.alarm.AlarmGenerator;
import com.sanrad.nms.server.alarm.volume.StripeVolumeAlarmGenerator;
import com.sanrad.nms.server.logic.IllegalValueException;
import com.sanrad.nms.server.logic.InvalidElementException;
import com.sanrad.nms.server.logic.cluster.ClusterImpl;
import com.sanrad.nms.server.logic.storage.StorageImpl;
import com.sanrad.nms.server.logic.volume.StripeVolume;
import com.sanrad.nms.server.logic.volume.VirtualVolumeImpl;
import com.sanrad.nms.server.logic.volume.validators.StripeVolumeSyncValidator;
import com.sanrad.nms.server.logic.vswitch.VSwitch;
import com.sanrad.nms.server.mgr.ConfigElementData;
import com.sanrad.nms.server.util.ClassID;
import com.sanrad.nms.server.util.Parameter;
import com.sanrad.nms.server.util.ParameterCode;
import com.sanrad.util.Util;
import com.sanrad.util.concurrent.ErrorAssertingListener;
import java.math.BigInteger;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public class StripeVolumeImpl
extends VirtualVolumeImpl
implements StripeVolume {
    private static Map<ParameterCode, ParameterCode.Flags> theParameterCodeFlagsMap;

    public StripeVolumeImpl(ClusterImpl cluster, ConfigElementData aCED) throws RemoteException, IllegalValueException, InvalidElementException {
        super(cluster, ClassID.STRIPE_VOLUME, aCED);
        this.validateAndInit(aCED, theParameterCodeFlagsMap);
    }

    @Override
    public BigInteger getStripeSize() {
        return this.getStripeSize(null);
    }

    public BigInteger getStripeSize(VSwitch vSwitch) {
        BigInteger stripeSizeBlocks = (BigInteger)this.getValueOf(vSwitch, ParameterCode.VIRTUAL_VOLUME_STRIPE_SIZE, vSwitch == null);
        return Util.blocksToBytes(stripeSizeBlocks, this.getBlockSize());
    }

    @Override
    protected int createMeOnOtherVswitch() throws RemoteException, IllegalValueException {
        StorageImpl storage = this.cluster.getStorage();
        StripeVolumeSyncValidator validator = new StripeVolumeSyncValidator(this.cluster, this.getAlias(), this.getChildren(), this.getStripeSize(), storage.getVolumeMgr(), this.cluster.getOtherVSwitches(this.getVSwitches()));
        if (!validator.isValid()) {
            throw new IllegalValueException(validator.getErrorMsg());
        }
        ErrorAssertingListener.listenTo(storage.createStripeVolume(this.getAlias(), this.getChildren(), this.getStripeSize(), this.cluster.getOtherVSwitches(this.getVSwitches()), this.getConnectedVSwitches()[0], this.getCommKeyClassId()));
        return 2;
    }

    @Override
    public AlarmGenerator getAlarmGenerator() {
        return StripeVolumeAlarmGenerator.getInstance();
    }

    @Override
    public boolean isIllegal() {
        boolean inconsistent = super.isInconsistent();
        if (!inconsistent) {
            return super.isIllegal();
        }
        return inconsistent;
    }

    @Override
    public boolean isInconsistent() {
        return false;
    }

    @Override
    public void updateElementWithCreationParameters(ConfigElementData element, ClusterImpl remoteCluster) throws RemoteException, IllegalValueException {
        super.updateElementWithCreationParameters(element, remoteCluster);
        element.addParameter(new Parameter(ParameterCode.VIRTUAL_VOLUME_STRIPE_SIZE, this.getSrArrayValueOf(ParameterCode.VIRTUAL_VOLUME_STRIPE_SIZE)));
    }

    @Override
    protected ArrayList<ParameterCode> getParamsForCreation() {
        ArrayList<ParameterCode> params = super.getParamsForCreation();
        params.add(ParameterCode.VIRTUAL_VOLUME_STRIPE_SIZE);
        return params;
    }

    static {
        HashMap<ParameterCode, ParameterCode.Flags> parameterCodeFlagsMap = new HashMap<ParameterCode, ParameterCode.Flags>();
        parameterCodeFlagsMap.put(ParameterCode.VIRTUAL_VOLUME_STRIPE_SIZE, new ParameterCode.Flags(true, false));
        theParameterCodeFlagsMap = Collections.unmodifiableMap(parameterCodeFlagsMap);
    }
}

