/*
 * Decompiled with CFR 0.152.
 */
package com.sanrad.nms.server.logic.volume;

import com.sanrad.log.SrLogger;
import com.sanrad.nms.server.logic.volume.SnapshotMap;
import com.sanrad.nms.server.logic.volume.SnapshotVolume;
import com.sanrad.nms.server.logic.volume.SnapshotVolumeImpl;
import com.sanrad.nms.server.logic.volume.VolumeNode;
import com.sanrad.nms.server.logic.volume.VolumeNodeImpl;
import com.sanrad.nms.server.logic.vswitch.VSwitch;
import com.sanrad.nms.server.logic.vswitch.VSwitchImpl;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;

public class SnapshotManager {
    HashMap<VSwitchImpl, SnapshotMap> mySnapshotMaps = new HashMap();
    private static SrLogger theLogger = SrLogger.getLogger();

    public void addSnapshot(VolumeNodeImpl source, SnapshotVolumeImpl snapshot, VSwitchImpl vSwitch) {
        SnapshotMap map = this.mySnapshotMaps.get(vSwitch);
        if (map == null) {
            SnapshotMap newMap = new SnapshotMap();
            this.mySnapshotMaps.put(vSwitch, newMap);
            map = newMap;
        }
        map.addSnapshot(source, snapshot);
    }

    public List<SnapshotVolumeImpl> getSnapshotsForSourceVolume(VolumeNodeImpl sourceVolume, VSwitchImpl vSwitch) {
        SnapshotMap map = this.mySnapshotMaps.get(vSwitch);
        if (map == null) {
            return null;
        }
        return map.getSnapshotsForSourceVolume(sourceVolume);
    }

    public List<SnapshotVolumeImpl> getSnapshotsForSourceVolume(VolumeNodeImpl sourceVolume) {
        ArrayList<SnapshotVolumeImpl> retVal = new ArrayList<SnapshotVolumeImpl>();
        Iterator<VSwitchImpl> itr = this.mySnapshotMaps.keySet().iterator();
        while (itr.hasNext()) {
            SnapshotMap map = this.mySnapshotMaps.get(itr.next());
            List<SnapshotVolumeImpl> snaps = map.getSnapshotsForSourceVolume(sourceVolume);
            if (snaps == null) continue;
            for (SnapshotVolumeImpl snap : snaps) {
                if (retVal.contains(snap)) continue;
                retVal.add(snap);
            }
        }
        return retVal;
    }

    public boolean isSourceOfSnapshot(VolumeNodeImpl sourceVolume, VSwitch vSwitch) {
        SnapshotMap map = this.mySnapshotMaps.get(vSwitch);
        if (map == null) {
            return false;
        }
        return map.isSourceOfSnapshot(sourceVolume);
    }

    public boolean isSourceOfSnapshot(VolumeNodeImpl sourceVolume) {
        boolean retVal = false;
        Iterator<VSwitchImpl> itr = this.mySnapshotMaps.keySet().iterator();
        while (itr.hasNext()) {
            SnapshotMap map = this.mySnapshotMaps.get(itr.next());
            retVal = retVal || map.isSourceOfSnapshot(sourceVolume);
        }
        return retVal;
    }

    public void removeAll() {
        this.mySnapshotMaps.clear();
    }

    public void removeAll(VSwitch vSwitch) {
        SnapshotMap map = this.mySnapshotMaps.get(vSwitch);
        if (map != null) {
            map.removeAll();
        }
    }

    public void removeSnapshot(SnapshotVolumeImpl snapshotVolume, VSwitchImpl vSwitch) {
        SnapshotMap map = this.mySnapshotMaps.get(vSwitch);
        if (map != null) {
            map.removeSnapshot(snapshotVolume);
        }
    }

    public void removeSnapshot(SnapshotVolumeImpl snapshotVolume) {
        Iterator<VSwitchImpl> itr = this.mySnapshotMaps.keySet().iterator();
        while (itr.hasNext()) {
            SnapshotMap map = this.mySnapshotMaps.get(itr.next());
            map.removeSnapshot(snapshotVolume);
        }
    }

    public void removeSnapshotBySource(SnapshotVolumeImpl snapshotVolume, VolumeNodeImpl source, VSwitch vSwitch) {
        SnapshotMap map = this.mySnapshotMaps.get(vSwitch);
        if (map != null) {
            map.removeSnapshotBySource(snapshotVolume, source);
        }
    }

    public void removeSnapshotBySource(SnapshotVolume snapshotVolume, VolumeNode source) {
        Iterator<VSwitchImpl> itr = this.mySnapshotMaps.keySet().iterator();
        while (itr.hasNext()) {
            SnapshotMap map = this.mySnapshotMaps.get(itr.next());
            map.removeSnapshotBySource(snapshotVolume, source);
        }
    }

    public VolumeNode getSourceOfSnapshot(SnapshotVolumeImpl snap) {
        SnapshotMap map;
        VolumeNodeImpl source = null;
        Iterator<VSwitchImpl> itr = this.mySnapshotMaps.keySet().iterator();
        while (itr.hasNext() && (source = (map = this.mySnapshotMaps.get(itr.next())).getSourceOfSnapshot(snap)) == null) {
        }
        return source;
    }

    public VolumeNodeImpl getSourceOfSnapshot(SnapshotVolumeImpl snap, VSwitchImpl vSwitch) {
        SnapshotMap map = this.mySnapshotMaps.get(vSwitch);
        if (map != null) {
            return map.getSourceOfSnapshot(snap);
        }
        return null;
    }
}

