/*
 * Decompiled with CFR 0.152.
 */
package com.sanrad.nms.server.logic.volume;

import com.sanrad.nms.server.alarm.AlarmGenerator;
import com.sanrad.nms.server.alarm.volume.CubeVolumeAlarmGenerator;
import com.sanrad.nms.server.logic.IllegalValueException;
import com.sanrad.nms.server.logic.InvalidElementException;
import com.sanrad.nms.server.logic.cluster.ClusterImpl;
import com.sanrad.nms.server.logic.storage.StorageImpl;
import com.sanrad.nms.server.logic.volume.ConcatinationVolumeImpl;
import com.sanrad.nms.server.logic.volume.CubeVolume;
import com.sanrad.nms.server.logic.volume.CubeVolumeSyncValidator;
import com.sanrad.nms.server.logic.volume.VolumeNodeImpl;
import com.sanrad.nms.server.logic.vswitch.VSwitchImpl;
import com.sanrad.nms.server.mgr.ConfigElementData;
import com.sanrad.nms.server.util.ClassID;
import com.sanrad.nms.server.util.ParameterCode;
import com.sanrad.util.concurrent.ErrorAssertingListener;
import java.rmi.RemoteException;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Vector;

public class CubeVolumeImpl
extends ConcatinationVolumeImpl
implements CubeVolume {
    private static Map<ParameterCode, ParameterCode.Flags> theParameterCodeFlagsMap;

    public CubeVolumeImpl(ClusterImpl cluster, ConfigElementData aCED) throws RemoteException, IllegalValueException, InvalidElementException {
        super(cluster, ClassID.CUBE_VOLUME, aCED);
        this.validateAndInit(aCED, theParameterCodeFlagsMap);
    }

    @Override
    protected int createMeOnOtherVswitch() throws RemoteException, IllegalValueException {
        StorageImpl storage = this.cluster.getStorage();
        List<VSwitchImpl> vSwitchToSync = this.cluster.getOtherVSwitches(this.getVSwitches());
        Vector<VolumeNodeImpl> childrenForSync = this.getChildrenListForClusterSync(vSwitchToSync.get(0));
        CubeVolumeSyncValidator validator = new CubeVolumeSyncValidator(this.cluster, this.getAlias(), childrenForSync, storage.getVolumeMgr(), vSwitchToSync);
        if (!validator.isValid()) {
            throw new IllegalValueException(validator.getErrorMsg());
        }
        ErrorAssertingListener.listenTo(storage.createCubeVolume(this.getAlias(), childrenForSync, vSwitchToSync, this.getConnectedVSwitches()[0], this.getCommKeyClassId()));
        return 2;
    }

    @Override
    public AlarmGenerator getAlarmGenerator() {
        return CubeVolumeAlarmGenerator.getInstance();
    }

    static {
        HashMap parameterCodeFlagsMap = new HashMap();
        theParameterCodeFlagsMap = Collections.unmodifiableMap(parameterCodeFlagsMap);
    }
}

