/*
 * Decompiled with CFR 0.152.
 */
package com.sanrad.nms.server.logic.validation.volume;

import com.sanrad.nms.server.ServerPropertiesFetcher;
import com.sanrad.nms.server.logic.ClientParameterCode;
import com.sanrad.nms.server.logic.cluster.ClusterImpl;
import com.sanrad.nms.server.logic.validation.CreationValidator;
import com.sanrad.nms.server.logic.validation.volume.GeneralVolumeCreationValidator;
import com.sanrad.nms.server.logic.validation.volume.VolumeCreationValidator;
import com.sanrad.nms.server.logic.volume.SnapshotManager;
import com.sanrad.nms.server.logic.volume.SnapshotVolumeImpl;
import com.sanrad.nms.server.logic.volume.VolumeNodeImpl;
import com.sanrad.nms.server.util.ClientConfigElementData;
import com.sanrad.nms.server.util.CommKeyClassId;
import java.util.ArrayList;
import java.util.List;

public class SnapshotVolumeCreationValidator
extends VolumeCreationValidator {
    private static final int MAX_SNAPSHOTS_PER_SOURCE_VOLUME = ServerPropertiesFetcher.getMaxSnapshotPerVolume();

    @Override
    public String validate(ClientConfigElementData aCed) {
        if (aCed.containsKey(ClientParameterCode.VOLUME_SPACE)) {
            return new SnapshotPoolingCreationValidator().validate(aCed);
        }
        return super.validate(aCed);
    }

    public SnapshotVolumeCreationValidator() {
        this.addMandatoryParameter(ClientParameterCode.SNAPSHOT_VOLUME_SOURCE);
        this.addMandatoryParameter(ClientParameterCode.SNAPSHOT_VOLUME_THRESHOLD);
        this.addCreationParameter(ClientParameterCode.SNAPSHOT_VOLUME_CONFIG_FLAGS, false);
    }

    @Override
    protected String innerValidate(ClientConfigElementData aCed) {
        String superError = super.innerValidate(aCed);
        if (superError != null) {
            return superError;
        }
        ArrayList<CreationValidator.ElementValidation> validations = new ArrayList<CreationValidator.ElementValidation>();
        validations.add(new VolumeCreationValidator.ChildrenCountValidation(aCed, 1, 1));
        validations.add(new VolumeCreationValidator.StorageMissingValidation(aCed));
        validations.add(new SnapshotPerSourceValidation(aCed));
        validations.add(new ThresholdRangeValidation(aCed));
        return this.executeValidations(validations);
    }

    private static class SnapshotPoolingCreationValidator
    extends GeneralVolumeCreationValidator {
        SnapshotPoolingCreationValidator() {
            this.addMandatoryParameter(ClientParameterCode.SNAPSHOT_VOLUME_SOURCE);
            this.addMandatoryParameter(ClientParameterCode.SNAPSHOT_VOLUME_THRESHOLD);
        }

        @Override
        protected String innerValidate(ClientConfigElementData aCed) {
            String superError = super.innerValidate(aCed);
            if (superError != null) {
                return superError;
            }
            ArrayList<CreationValidator.ElementValidation> validations = new ArrayList<CreationValidator.ElementValidation>();
            validations.add(new SnapshotPerSourceValidation(aCed));
            validations.add(new ThresholdRangeValidation(aCed));
            return this.executeValidations(validations);
        }
    }

    private static class ThresholdRangeValidation
    extends CreationValidator.NumberRangeValidation {
        ThresholdRangeValidation(ClientConfigElementData aCed) {
            super(aCed, ClientParameterCode.SNAPSHOT_VOLUME_THRESHOLD, "100", "6", "%");
        }
    }

    private static class SnapshotPerSourceValidation
    extends CreationValidator.ElementValidation {
        SnapshotPerSourceValidation(ClientConfigElementData aCed) {
            super(aCed);
        }

        @Override
        protected ClientParameterCode getParameterCode() {
            return ClientParameterCode.SNAPSHOT_VOLUME_SOURCE;
        }

        @Override
        protected String validate() {
            if (!this.myCed.isNested(ClientParameterCode.SNAPSHOT_VOLUME_SOURCE)) {
                ClusterImpl cluster = (ClusterImpl)SnapshotVolumeCreationValidator.getLogicObject(this.myCed.getClusterId());
                VolumeNodeImpl source = (VolumeNodeImpl)SnapshotVolumeCreationValidator.getLogicObject((CommKeyClassId)this.myCed.getValue(ClientParameterCode.SNAPSHOT_VOLUME_SOURCE));
                SnapshotManager snapMgr = cluster.getVolumeMgr().getSnapshotManager();
                List<SnapshotVolumeImpl> snapshots = snapMgr.getSnapshotsForSourceVolume(source);
                if (snapshots.size() >= MAX_SNAPSHOTS_PER_SOURCE_VOLUME) {
                    return "You cannot create more than " + MAX_SNAPSHOTS_PER_SOURCE_VOLUME + " " + this.myCed.getClassId() + "s on one source volume. Please remove existing " + "snapshots before resuming a schedule or taking new snapshots.";
                }
            }
            return null;
        }
    }
}

