/*
 * Decompiled with CFR 0.152.
 */
package com.sanrad.nms.server.logic.validation.volume;

import com.sanrad.nms.server.ServerPropertiesFetcher;
import com.sanrad.nms.server.logic.ClientParameterCode;
import com.sanrad.nms.server.logic.cluster.ClusterImpl;
import com.sanrad.nms.server.logic.validation.CreationValidator;
import com.sanrad.nms.server.logic.volume.SnapshotManager;
import com.sanrad.nms.server.logic.volume.SnapshotVolumeImpl;
import com.sanrad.nms.server.logic.volume.VolumeNodeImpl;
import com.sanrad.nms.server.logic.vswitch.VSwitchImpl;
import com.sanrad.nms.server.util.ClientConfigElementData;
import com.sanrad.nms.server.util.CommKeyClassId;
import com.sanrad.nms.server.util.types.constants.SnapshotSchedulerStateConstant;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

public class SnapshotSchedulerCreationValidator
extends CreationValidator {
    private static final int MAX_SNAPS_PER_VOLUME = ServerPropertiesFetcher.getMaxSnapshotPerVolume();

    public SnapshotSchedulerCreationValidator() {
        this.addMandatoryParameter(ClientParameterCode.SNAPSHOT_SCHEDULER_PERIOD);
        this.addMandatoryParameter(ClientParameterCode.SNAPSHOT_SCHEDULER_SNAP_COUNT);
        this.addMandatoryParameter(ClientParameterCode.SNAPSHOT_SCHEDULER_START_AT);
        this.addMandatoryParameter(ClientParameterCode.SNAPSHOT_SCHEDULER_SNAPSHOT_SIZE);
        this.addMandatoryParameter(ClientParameterCode.SNAPSHOT_SCHEDULER_STATE);
        this.addMandatoryParameter(ClientParameterCode.SNAPSHOT_VOLUME_SOURCE);
    }

    @Override
    protected String innerValidate(ClientConfigElementData aCed) {
        ArrayList<CreationValidator.ElementValidation> validations = new ArrayList<CreationValidator.ElementValidation>();
        validations.add(new SnapshotsCountValidation(aCed));
        validations.add(new SchedulerStateValidation(aCed));
        validations.add(new StartAtTimeValidation(aCed));
        return this.executeValidations(validations);
    }

    private static class StartAtTimeValidation
    extends CreationValidator.ElementValidation {
        StartAtTimeValidation(ClientConfigElementData aCed) {
            super(aCed);
        }

        @Override
        protected ClientParameterCode getParameterCode() {
            return ClientParameterCode.SNAPSHOT_SCHEDULER_START_AT;
        }

        @Override
        protected String validate() {
            Date userDate = (Date)this.myCed.getValue(ClientParameterCode.SNAPSHOT_SCHEDULER_START_AT);
            if (userDate.getTime() > 0L) {
                CommKeyClassId sourceVolumeId = (CommKeyClassId)this.myCed.getValue(ClientParameterCode.SNAPSHOT_VOLUME_SOURCE);
                VolumeNodeImpl sourceVolume = (VolumeNodeImpl)SnapshotSchedulerCreationValidator.getLogicObject(sourceVolumeId);
                VSwitchImpl vswitch = sourceVolume.getActiveVswitch();
                long vswitchDate = vswitch.getDateAndTime();
                if (userDate.getTime() < vswitchDate) {
                    return "Snapshot schedule start time is set to the past";
                }
            }
            return null;
        }
    }

    private static class SchedulerStateValidation
    extends CreationValidator.ElementValidation {
        SchedulerStateValidation(ClientConfigElementData aCed) {
            super(aCed);
        }

        @Override
        protected ClientParameterCode getParameterCode() {
            return ClientParameterCode.SNAPSHOT_SCHEDULER_STATE;
        }

        @Override
        protected String validate() {
            SnapshotSchedulerStateConstant state = (SnapshotSchedulerStateConstant)this.myCed.getValue(ClientParameterCode.SNAPSHOT_SCHEDULER_STATE);
            if (SnapshotSchedulerStateConstant.RUNNING.equals(state)) {
                return "Cannot create and run a scheduler at the same time";
            }
            return null;
        }
    }

    private static class SnapshotsCountValidation
    extends CreationValidator.ElementValidation {
        SnapshotsCountValidation(ClientConfigElementData aCed) {
            super(aCed);
        }

        @Override
        protected ClientParameterCode getParameterCode() {
            return ClientParameterCode.SNAPSHOT_SCHEDULER_SNAP_COUNT;
        }

        @Override
        protected String validate() {
            CommKeyClassId sourceVolumeId = (CommKeyClassId)this.myCed.getValue(ClientParameterCode.SNAPSHOT_VOLUME_SOURCE);
            ClusterImpl cluster = (ClusterImpl)SnapshotSchedulerCreationValidator.getLogicObject(this.myCed.getClusterId());
            VolumeNodeImpl sourceVolume = (VolumeNodeImpl)SnapshotSchedulerCreationValidator.getLogicObject(sourceVolumeId);
            SnapshotManager snapMgr = cluster.getVolumeMgr().getSnapshotManager();
            List<SnapshotVolumeImpl> existSnapshots = snapMgr.getSnapshotsForSourceVolume(sourceVolume);
            int existsSnapsCount = existSnapshots.size();
            Long requestSnapCount = (Long)this.myCed.getValue(ClientParameterCode.SNAPSHOT_SCHEDULER_SNAP_COUNT);
            int maxAllowedSnaps = MAX_SNAPS_PER_VOLUME - existsSnapsCount;
            if (requestSnapCount > (long)maxAllowedSnaps) {
                StringBuilder sb = new StringBuilder();
                sb.append("There are alraedy ");
                sb.append(existsSnapsCount);
                sb.append(" snapshots for volume ");
                sb.append(sourceVolume.getAlias());
                sb.append(", therefore snapshots scheduler cannot have more than ");
                sb.append(maxAllowedSnaps);
                sb.append(" recent copies");
                return sb.toString();
            }
            return null;
        }
    }
}

