/*
 * Decompiled with CFR 0.152.
 */
package com.sanrad.nms.server.logic.validation.volume;

import com.sanrad.nms.server.Server;
import com.sanrad.nms.server.logic.ClientParameterCode;
import com.sanrad.nms.server.logic.validation.CreationValidator;
import com.sanrad.nms.server.logic.validation.volume.GeneralVolumeCreationValidator;
import com.sanrad.nms.server.logic.validation.volume.VolumeCreationValidator;
import com.sanrad.nms.server.util.ClientConfigElementData;
import com.sanrad.util.SrConstantsBundleKeys;
import java.util.ArrayList;

public class MirrorVolumeCreationValidator
extends CreationValidator {
    @Override
    public String validate(ClientConfigElementData aCed) {
        if (aCed.containsKey(ClientParameterCode.VOLUME_SPACE)) {
            return new StoragePoolingMirrorValidator().validate(aCed);
        }
        return new SimpleMirrorValidator().validate(aCed);
    }

    @Override
    protected String innerValidate(ClientConfigElementData aCed) {
        return null;
    }

    private static class SimpleMirrorValidator
    extends VolumeCreationValidator {
        private static final int MAX_MIRROR_CHILD_COUNT = Server.CONSTANSTS_BUNDLE.getIntResource(SrConstantsBundleKeys.VOLUME_MAX_NUM_OF_MIRROR_CHILDREN);
        private static final int MIN_MIRROR_CHILD_COUNT = 2;

        private SimpleMirrorValidator() {
        }

        @Override
        protected String innerValidate(ClientConfigElementData aCed) {
            String superError = super.innerValidate(aCed);
            if (superError != null) {
                return superError;
            }
            ArrayList<CreationValidator.ElementValidation> validations = new ArrayList<CreationValidator.ElementValidation>();
            validations.add(new VolumeCreationValidator.ChildrenCountValidation(aCed, MAX_MIRROR_CHILD_COUNT, 2));
            return this.executeValidations(validations);
        }
    }

    private static class StoragePoolingMirrorValidator
    extends GeneralVolumeCreationValidator {
        private StoragePoolingMirrorValidator() {
        }
    }
}

