/*
 * Decompiled with CFR 0.152.
 */
package com.sanrad.nms.server.logic.validation.volume;

import com.sanrad.nms.server.logic.ClientParameterCode;
import com.sanrad.nms.server.logic.ErrorMessage;
import com.sanrad.nms.server.logic.cluster.ClusterImpl;
import com.sanrad.nms.server.logic.validation.CreationValidator;
import com.sanrad.nms.server.logic.validation.volume.VolumeCreationValidator;
import com.sanrad.nms.server.logic.volume.JournalVolumeImpl;
import com.sanrad.nms.server.logic.volume.VolumeNodeImpl;
import com.sanrad.nms.server.logic.vswitch.VSwitchImpl;
import com.sanrad.nms.server.util.ClassID;
import com.sanrad.nms.server.util.ClientConfigElementData;
import com.sanrad.nms.server.util.CommKeyClassId;
import java.util.ArrayList;
import java.util.List;

public class JournalVolumeCreationValidator
extends VolumeCreationValidator {
    public JournalVolumeCreationValidator() {
        this.addMandatoryParameter(ClientParameterCode.JOURNAL_VOLUME_PRECENT_THRESH);
        this.addMandatoryParameter(ClientParameterCode.JOURNAL_VOLUME_ACTIVE_ON_VSWITCH_ID);
    }

    @Override
    protected String innerValidate(ClientConfigElementData aCed) {
        String superError = super.innerValidate(aCed);
        if (superError != null) {
            return superError;
        }
        ArrayList<CreationValidator.ElementValidation> validations = new ArrayList<CreationValidator.ElementValidation>();
        validations.add(new VolumeCreationValidator.ChildrenCountValidation(aCed, 1, 1));
        validations.add(new VolumeCreationValidator.StorageMissingValidation(aCed));
        validations.add(new ThresholdRangeValidation(aCed));
        validations.add(new JounalChildTypeValidation(aCed));
        validations.add(new JournalChildExistanceValidation(aCed));
        validations.add(new UniqueActiveJournalValidation(aCed));
        return this.executeValidations(validations);
    }

    private static class UniqueActiveJournalValidation
    extends CreationValidator.ElementValidation {
        UniqueActiveJournalValidation(ClientConfigElementData aCed) {
            super(aCed);
        }

        @Override
        protected ClientParameterCode getParameterCode() {
            return ClientParameterCode.JOURNAL_VOLUME_ACTIVE_ON_VSWITCH_ID;
        }

        @Override
        protected String validate() {
            ClusterImpl cluster = (ClusterImpl)JournalVolumeCreationValidator.getLogicObject(this.myCed.getClusterId());
            List<? extends VolumeNodeImpl> allJournalVolumesInCluster = cluster.getStorage().getInteranlVolumesByType(ClassID.JOURNAL_VOLUME);
            CommKeyClassId activeVsId = (CommKeyClassId)this.myCed.getValue(ClientParameterCode.JOURNAL_VOLUME_ACTIVE_ON_VSWITCH_ID);
            for (VolumeNodeImpl volumeNodeImpl : allJournalVolumesInCluster) {
                JournalVolumeImpl journal = (JournalVolumeImpl)volumeNodeImpl;
                VSwitchImpl vswitchActiveOn = journal.getActiveOnVSwitch();
                if (vswitchActiveOn == null || !activeVsId.equals(vswitchActiveOn.getCommKeyClassId())) continue;
                VSwitchImpl vswitch = (VSwitchImpl)JournalVolumeCreationValidator.getLogicObject(activeVsId);
                return ErrorMessage.VSWITCH_HAS_ACTIVE_JOURNAL.getMessage(vswitch.getName());
            }
            return null;
        }
    }

    private static class JournalChildExistanceValidation
    extends VolumeCreationValidator.VolumeChildrenValidation {
        private VSwitchImpl myActiveVswitch;
        private String myAlias;

        JournalChildExistanceValidation(ClientConfigElementData aCed) {
            super(aCed);
            CommKeyClassId vsId = (CommKeyClassId)aCed.getValue(ClientParameterCode.JOURNAL_VOLUME_ACTIVE_ON_VSWITCH_ID);
            this.myActiveVswitch = (VSwitchImpl)JournalVolumeCreationValidator.getLogicObject(vsId);
            this.myAlias = (String)aCed.getValue(ClientParameterCode.VOLUME_ALIAS);
        }

        @Override
        protected ClientParameterCode getParameterCode() {
            return ClientParameterCode.VOLUME_CHILDREN;
        }

        @Override
        protected String validateChild(VolumeNodeImpl aChild) {
            if (!aChild.isKnownByVSwitch(this.myActiveVswitch)) {
                return "Cannot create Journal " + this.myAlias + " active on " + ClassID.VSWITCH + " " + this.myActiveVswitch.getName() + " ,the volume " + aChild.getAlias() + " is unknown in this " + ClassID.VSWITCH;
            }
            return null;
        }
    }

    private static class JounalChildTypeValidation
    extends VolumeCreationValidator.VolumeChildrenTypeValidation {
        JounalChildTypeValidation(ClientConfigElementData aCed) {
            super(aCed);
        }

        @Override
        protected boolean isValidType(ClassID aType) {
            return super.isValidType(aType) && !ClassID.TRANSPARENT_VOLUME.equals(aType);
        }
    }

    private static class ThresholdRangeValidation
    extends CreationValidator.NumberRangeValidation {
        ThresholdRangeValidation(ClientConfigElementData aCed) {
            super(aCed, ClientParameterCode.JOURNAL_VOLUME_PRECENT_THRESH, "100", "6", "%");
        }
    }
}

