/*
 * Decompiled with CFR 0.152.
 */
package com.sanrad.nms.server.logic.validation.iscsi;

import com.sanrad.nms.server.Server;
import com.sanrad.nms.server.logic.ClientParameterCode;
import com.sanrad.nms.server.logic.ErrorMessage;
import com.sanrad.nms.server.logic.SystemRootImpl;
import com.sanrad.nms.server.logic.cluster.ClusterImpl;
import com.sanrad.nms.server.logic.validation.CreationValidator;
import com.sanrad.nms.server.logic.vswitch.VSwitchImpl;
import com.sanrad.nms.server.util.ClassID;
import com.sanrad.nms.server.util.ClientConfigElementData;
import com.sanrad.util.SrConstantsBundleKeys;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class TargetCreationValidator
extends CreationValidator {
    public TargetCreationValidator() {
        this.addMandatoryParameter(ClientParameterCode.TARGET_ALIAS);
        this.addMandatoryParameter(ClientParameterCode.TARGET_NAME);
        this.addMandatoryParameter(ClientParameterCode.TARGET_EXPOSED_ON);
    }

    @Override
    protected String innerValidate(ClientConfigElementData aCed) {
        ArrayList<CreationValidator.ElementValidation> validations = new ArrayList<CreationValidator.ElementValidation>();
        CreationValidator.AliasValidation targetAliasValidator = new CreationValidator.AliasValidation(aCed, ClientParameterCode.TARGET_ALIAS);
        targetAliasValidator.setNonValidCharacters(Arrays.asList(Character.valueOf('&'), Character.valueOf('#'), Character.valueOf('+'), Character.valueOf('!'), Character.valueOf('*')));
        validations.add(targetAliasValidator);
        validations.add(new TargetAliasValidation(aCed));
        validations.add(new NameValidation(aCed));
        validations.add(new ExposedOnVSwitchValidation(aCed));
        validations.add(new TargetsCountValidation(aCed));
        return this.executeValidations(validations);
    }

    private static class TargetsCountValidation
    extends CreationValidator.ElementValidation {
        public static final int ISCSI_TARGET_MAX_NUMBER = Server.CONSTANSTS_BUNDLE.getIntResource(SrConstantsBundleKeys.ISCSI_TARGET_MAX_NUMBER);

        TargetsCountValidation(ClientConfigElementData aCed) {
            super(aCed);
        }

        @Override
        protected ClientParameterCode getParameterCode() {
            return null;
        }

        @Override
        protected String validate() {
            ClusterImpl cluster = (ClusterImpl)TargetCreationValidator.getLogicObject(this.myCed.getClusterId());
            if (cluster.getTargetListMgr().size() >= ISCSI_TARGET_MAX_NUMBER) {
                return "You cannot create more than " + ISCSI_TARGET_MAX_NUMBER + " " + ClassID.ISCSI_TARGET + "s";
            }
            return null;
        }
    }

    private static class ExposedOnVSwitchValidation
    extends CreationValidator.ElementValidation {
        ExposedOnVSwitchValidation(ClientConfigElementData aCed) {
            super(aCed);
        }

        @Override
        protected ClientParameterCode getParameterCode() {
            return ClientParameterCode.TARGET_EXPOSED_ON;
        }

        @Override
        protected String validate() {
            ClusterImpl cluster = (ClusterImpl)TargetCreationValidator.getLogicObject(this.myCed.getClusterId());
            String exposedOnVswitch = (String)this.myCed.getValue(ClientParameterCode.TARGET_EXPOSED_ON);
            List<VSwitchImpl> vswitches = cluster.getVSwitches();
            boolean isExists = false;
            for (VSwitchImpl vs : vswitches) {
                if (!vs.getName().equals(exposedOnVswitch)) continue;
                isExists = true;
                break;
            }
            if (!isExists) {
                if (exposedOnVswitch.length() == 0) {
                    return ErrorMessage.VSWITCH_EMPTY_VALUE.getMessage();
                }
                return ErrorMessage.VSWITCH_DOESNOT_EXIST.getMessage(exposedOnVswitch);
            }
            return null;
        }
    }

    private static class NameValidation
    extends CreationValidator.ElementValidation {
        NameValidation(ClientConfigElementData aCed) {
            super(aCed);
        }

        @Override
        protected ClientParameterCode getParameterCode() {
            return ClientParameterCode.TARGET_NAME;
        }

        @Override
        protected String validate() {
            String name = (String)this.myCed.getValue(ClientParameterCode.TARGET_NAME);
            ArrayList vswitchGroups = SystemRootImpl.getInstance().getAllVSwitchGroups();
            int i = vswitchGroups.size();
            while (i-- > 0) {
                ClusterImpl sysCluster;
                Object vsGroup = vswitchGroups.get(i);
                if (!(vsGroup instanceof ClusterImpl) || !(sysCluster = (ClusterImpl)vsGroup).getTargetListMgr().isNameExist(name)) continue;
                return ErrorMessage.NAME_ALREADY_IN_USE.getMessage(new String[]{name, sysCluster.toString()});
            }
            if (name.length() > 223) {
                return ErrorMessage.TARGET_WWWI_TOO_LONG.getMessage(Integer.toString(223));
            }
            return null;
        }
    }

    private static class TargetAliasValidation
    extends CreationValidator.ElementValidation {
        TargetAliasValidation(ClientConfigElementData aCed) {
            super(aCed);
        }

        @Override
        protected ClientParameterCode getParameterCode() {
            return ClientParameterCode.TARGET_ALIAS;
        }

        @Override
        protected String validate() {
            ClusterImpl cluster = (ClusterImpl)TargetCreationValidator.getLogicObject(this.myCed.getClusterId());
            String alias = (String)this.myCed.getValue(ClientParameterCode.TARGET_ALIAS);
            if (cluster.getTargetListMgr().isAliasExist(alias)) {
                return ErrorMessage.ALIAS_ALREADY_IN_USE.getMessage(alias);
            }
            if (cluster.getRemoteTargetListMgr().isNameExist(alias)) {
                return ErrorMessage.ALIAS_ALREADY_IN_USE_BY_REMOTE_TARGET.getMessage(alias);
            }
            return null;
        }
    }
}

