/*
 * Decompiled with CFR 0.152.
 */
package com.sanrad.nms.server.logic.validation.iscsi;

import com.sanrad.nms.server.logic.ClientParameterCode;
import com.sanrad.nms.server.logic.ErrorMessage;
import com.sanrad.nms.server.logic.cluster.ClusterImpl;
import com.sanrad.nms.server.logic.dr.DRPairImpl;
import com.sanrad.nms.server.logic.dr.DRRootImpl;
import com.sanrad.nms.server.logic.lu.LUImpl;
import com.sanrad.nms.server.logic.target.TargetImpl;
import com.sanrad.nms.server.logic.validation.CreationValidator;
import com.sanrad.nms.server.logic.volume.SnapshotVolumeImpl;
import com.sanrad.nms.server.logic.volume.VolumeNodeImpl;
import com.sanrad.nms.server.logic.volume.copy.CopyOperationManagerImpl;
import com.sanrad.nms.server.logic.vswitch.VSwitchImpl;
import com.sanrad.nms.server.util.ClassID;
import com.sanrad.nms.server.util.ClientConfigElementData;
import com.sanrad.nms.server.util.CommKeyClassId;
import com.sanrad.util.StorageSize;
import java.math.BigInteger;
import java.util.ArrayList;

public class LunCreationValidator
extends CreationValidator {
    private static final StorageSize MIN_VOL_SIZE = StorageSize.MEGA;

    public LunCreationValidator() {
        this.addMandatoryParameter(ClientParameterCode.LU_LUN);
        this.addMandatoryParameter(ClientParameterCode.LU_PARENT_TARGET);
        this.addMandatoryParameter(ClientParameterCode.LU_VOLUME_CHILD);
        this.addCreationParameter(ClientParameterCode.LU_SERIAL_NUMBER, false);
    }

    @Override
    protected String innerValidate(ClientConfigElementData aCed) {
        ArrayList<CreationValidator.ElementValidation> validations = new ArrayList<CreationValidator.ElementValidation>();
        validations.add(new AlreadyExposedValidation(aCed));
        validations.add(new LuNumberInUseValidation(aCed));
        validations.add(new LuNumberRangeValidation(aCed));
        validations.add(new VolumeTypeValidation(aCed));
        validations.add(new TargetTypeValidation(aCed));
        validations.add(new VolumeSizeValidation(aCed));
        validations.add(new InvolvedInCopyOperValidation(aCed));
        validations.add(new VolumeExistenceValidation(aCed));
        validations.add(new GDRValidation(aCed));
        validations.add(new SnapshotExposureValidation(aCed));
        return this.executeValidations(validations);
    }

    private static TargetImpl getTarget(ClientConfigElementData aCed) {
        if (aCed.isNested(ClientParameterCode.LU_PARENT_TARGET)) {
            return null;
        }
        CommKeyClassId ckid = (CommKeyClassId)aCed.getValue(ClientParameterCode.LU_PARENT_TARGET);
        return (TargetImpl)LunCreationValidator.getLogicObject(ckid);
    }

    private static ClassID getVolumeClassID(ClientConfigElementData aCed) {
        return LunCreationValidator.getElementClassID(aCed, ClientParameterCode.LU_VOLUME_CHILD);
    }

    private static BigInteger getVolumeSize(ClientConfigElementData aCed) {
        if (aCed.isNested(ClientParameterCode.LU_VOLUME_CHILD)) {
            ClientConfigElementData nestedVol = (ClientConfigElementData)aCed.getValue(ClientParameterCode.LU_VOLUME_CHILD);
            return (BigInteger)nestedVol.getValue(ClientParameterCode.VOLUME_SPACE);
        }
        VolumeNodeImpl volume = LunCreationValidator.getChildVolume(aCed);
        return volume.getAccessibleSpace();
    }

    private static String getVolumeAlias(ClientConfigElementData aCed) {
        if (aCed.isNested(ClientParameterCode.LU_VOLUME_CHILD)) {
            ClientConfigElementData nestedVol = (ClientConfigElementData)aCed.getValue(ClientParameterCode.LU_VOLUME_CHILD);
            return (String)nestedVol.getValue(ClientParameterCode.VOLUME_ALIAS);
        }
        VolumeNodeImpl volume = LunCreationValidator.getChildVolume(aCed);
        return volume.getAlias();
    }

    private static String getExposedOnVswitch(ClientConfigElementData aCed) {
        if (aCed.isNested(ClientParameterCode.LU_PARENT_TARGET)) {
            ClientConfigElementData nestedVol = (ClientConfigElementData)aCed.getValue(ClientParameterCode.LU_PARENT_TARGET);
            return (String)nestedVol.getValue(ClientParameterCode.TARGET_EXPOSED_ON);
        }
        CommKeyClassId tarId = (CommKeyClassId)aCed.getValue(ClientParameterCode.LU_PARENT_TARGET);
        TargetImpl target = (TargetImpl)LunCreationValidator.getLogicObject(tarId);
        return target.getExposedOnVSwitch();
    }

    private static VolumeNodeImpl getChildVolume(ClientConfigElementData aCed) {
        if (!aCed.isNested(ClientParameterCode.LU_VOLUME_CHILD)) {
            CommKeyClassId volId = (CommKeyClassId)aCed.getValue(ClientParameterCode.LU_VOLUME_CHILD);
            return (VolumeNodeImpl)LunCreationValidator.getLogicObject(volId);
        }
        return null;
    }

    private static class SnapshotExposureValidation
    extends CreationValidator.ElementValidation {
        SnapshotExposureValidation(ClientConfigElementData aCed) {
            super(aCed);
        }

        @Override
        protected ClientParameterCode getParameterCode() {
            return ClientParameterCode.LU_VOLUME_CHILD;
        }

        @Override
        protected String validate() {
            VolumeNodeImpl sourceVolume;
            VolumeNodeImpl volume;
            if (!this.myCed.isNested(ClientParameterCode.LU_VOLUME_CHILD) && ClassID.SNAPSHOT_VOLUME.equals((volume = LunCreationValidator.getChildVolume(this.myCed)).getClassId()) && (sourceVolume = ((SnapshotVolumeImpl)volume).getSourceVolume()).isExposed()) {
                TargetImpl sourceVolTarget = sourceVolume.getParentLU().getParentTarget();
                String sourceVolVswitch = sourceVolTarget.getExposedOnVSwitch();
                String targetParentVswitch = LunCreationValidator.getExposedOnVswitch(this.myCed);
                if (!targetParentVswitch.equals(sourceVolVswitch)) {
                    return ClassID.SNAPSHOT_VOLUME + " " + volume + " cannot be exposed on a different " + ClassID.VSWITCH + " than its source volume";
                }
            }
            return null;
        }
    }

    private static class AlreadyExposedValidation
    extends CreationValidator.ElementValidation {
        AlreadyExposedValidation(ClientConfigElementData aCed) {
            super(aCed);
        }

        @Override
        protected ClientParameterCode getParameterCode() {
            return ClientParameterCode.LU_VOLUME_CHILD;
        }

        @Override
        protected String validate() {
            VolumeNodeImpl volume;
            if (!this.myCed.isNested(ClientParameterCode.LU_VOLUME_CHILD) && (volume = LunCreationValidator.getChildVolume(this.myCed)).isExposed()) {
                String target = volume.getParentLU().getParentTarget().getName();
                return "Cannot expose volume. " + volume.getAlias() + " is already exposed under target " + target;
            }
            return null;
        }
    }

    private static class GDRValidation
    extends CreationValidator.ElementValidation {
        GDRValidation(ClientConfigElementData aCed) {
            super(aCed);
        }

        @Override
        protected ClientParameterCode getParameterCode() {
            return ClientParameterCode.LU_VOLUME_CHILD;
        }

        @Override
        protected String validate() {
            if (!this.myCed.isNested(ClientParameterCode.LU_VOLUME_CHILD)) {
                VolumeNodeImpl volume = LunCreationValidator.getChildVolume(this.myCed);
                DRPairImpl drPair = DRRootImpl.getInstance().getPairContainsISCSIDisk(volume);
                if (drPair != null) {
                    return "Volume " + volume + " cannot be exposed since it belongs to pair " + drPair + " as primary remote or secondary local";
                }
                if (volume.isDROfflineLocalCopy()) {
                    return "Volume " + volume + " is used for DR offline local copy";
                }
            }
            return null;
        }
    }

    private static class VolumeExistenceValidation
    extends CreationValidator.ElementValidation {
        VolumeExistenceValidation(ClientConfigElementData aCed) {
            super(aCed);
        }

        @Override
        protected ClientParameterCode getParameterCode() {
            return ClientParameterCode.LU_VOLUME_CHILD;
        }

        @Override
        protected String validate() {
            if (!this.myCed.isNested(ClientParameterCode.LU_VOLUME_CHILD)) {
                String exposedOnVswitchName = LunCreationValidator.getExposedOnVswitch(this.myCed);
                VolumeNodeImpl volume = LunCreationValidator.getChildVolume(this.myCed);
                VSwitchImpl[] vSwitches = volume.getConnectedVSwitches();
                boolean isVolumeExistsOnVs = false;
                for (int i = 0; i < vSwitches.length; ++i) {
                    String name = vSwitches[i].getName();
                    if (!exposedOnVswitchName.equals(name)) continue;
                    isVolumeExistsOnVs = true;
                    break;
                }
                if (!isVolumeExistsOnVs) {
                    return "You cannot expose " + volume.getClassId() + " " + volume + " on " + ClassID.VSWITCH + " " + exposedOnVswitchName + ".  The volume doesn't exist on this " + ClassID.VSWITCH;
                }
            }
            return null;
        }
    }

    private static class InvolvedInCopyOperValidation
    extends CreationValidator.ElementValidation {
        InvolvedInCopyOperValidation(ClientConfigElementData aCed) {
            super(aCed);
        }

        @Override
        protected ClientParameterCode getParameterCode() {
            return ClientParameterCode.LU_VOLUME_CHILD;
        }

        @Override
        protected String validate() {
            if (!this.myCed.isNested(ClientParameterCode.LU_VOLUME_CHILD)) {
                VSwitchImpl vSwitch;
                VolumeNodeImpl volume = LunCreationValidator.getChildVolume(this.myCed);
                ClusterImpl cluster = (ClusterImpl)LunCreationValidator.getLogicObject(this.myCed.getClusterId());
                if (!cluster.isSingleVSwitchMode() && (vSwitch = volume.isInvolvedInActiveCopyDownHirarchy()) != null) {
                    return volume.getClassId() + " " + volume + " is part of copy operation on " + ClassID.VSWITCH + " " + vSwitch + ". You cannot expose it until the operation is done/aborted";
                }
                CopyOperationManagerImpl copyMgr = cluster.getCopyOperManager();
                if (copyMgr.isInvolvedInActiveCopyOper(volume.getCommKeyClassId())) {
                    return "You cannot expose " + volume.getClassId() + " " + volume + ".  It's a part of a copy Operation";
                }
            }
            return null;
        }
    }

    private static class VolumeSizeValidation
    extends CreationValidator.ElementValidation {
        VolumeSizeValidation(ClientConfigElementData aCed) {
            super(aCed);
        }

        @Override
        protected ClientParameterCode getParameterCode() {
            return ClientParameterCode.LU_VOLUME_CHILD;
        }

        @Override
        protected String validate() {
            BigInteger accessibleSpace = LunCreationValidator.getVolumeSize(this.myCed);
            ClassID volClassId = LunCreationValidator.getVolumeClassID(this.myCed);
            if (!volClassId.equals(ClassID.TRANSPARENT_VOLUME) && accessibleSpace.compareTo(MIN_VOL_SIZE.getValue()) < 0 && !accessibleSpace.equals(BigInteger.ZERO)) {
                return "You cannot expose " + volClassId + " " + LunCreationValidator.getVolumeAlias(this.myCed) + ". The volume size must be 1 " + MIN_VOL_SIZE + " or greater";
            }
            return null;
        }
    }

    private static class TargetTypeValidation
    extends CreationValidator.ElementValidation {
        TargetTypeValidation(ClientConfigElementData aCed) {
            super(aCed);
        }

        @Override
        protected ClientParameterCode getParameterCode() {
            return ClientParameterCode.LU_PARENT_TARGET;
        }

        @Override
        protected String validate() {
            TargetImpl target = LunCreationValidator.getTarget(this.myCed);
            ClassID targetClass = null;
            if (target != null) {
                targetClass = target.getClassId();
            } else {
                ClientConfigElementData targetCed = (ClientConfigElementData)this.myCed.getValue(ClientParameterCode.LU_PARENT_TARGET);
                targetClass = targetCed.getClassId();
            }
            if (!ClassID.ISCSI_TARGET.equals(targetClass)) {
                return "Type " + targetClass + " is not applicable as LU parent target";
            }
            return null;
        }
    }

    private static class VolumeTypeValidation
    extends CreationValidator.ElementValidation {
        VolumeTypeValidation(ClientConfigElementData aCed) {
            super(aCed);
        }

        @Override
        protected ClientParameterCode getParameterCode() {
            return ClientParameterCode.LU_VOLUME_CHILD;
        }

        @Override
        protected String validate() {
            ClassID volChildClassId = LunCreationValidator.getVolumeClassID(this.myCed);
            if (!volChildClassId.isVolumeNode()) {
                return "Type " + volChildClassId + " is not applicable as LU volume";
            }
            return null;
        }
    }

    private static class LuNumberRangeValidation
    extends CreationValidator.NumberRangeValidation {
        LuNumberRangeValidation(ClientConfigElementData aCed) {
            super(aCed, ClientParameterCode.LU_LUN, String.valueOf(LUImpl.MAX_LUN_VALUE), "0", "");
        }
    }

    private static class LuNumberInUseValidation
    extends CreationValidator.ElementValidation {
        LuNumberInUseValidation(ClientConfigElementData aCed) {
            super(aCed);
        }

        @Override
        protected ClientParameterCode getParameterCode() {
            return ClientParameterCode.LU_LUN;
        }

        @Override
        protected String validate() {
            String error = null;
            if (!this.myCed.isNested(ClientParameterCode.LU_PARENT_TARGET)) {
                int luNumIntVal;
                Long luNumber = (Long)this.myCed.getValue(ClientParameterCode.LU_LUN);
                TargetImpl target = LunCreationValidator.getTarget(this.myCed);
                if (target.isLUNumberExist(luNumIntVal = luNumber.intValue())) {
                    String[] msgParts = new String[]{String.valueOf(luNumIntVal), target.getAlias()};
                    return ErrorMessage.LUN_ALREADY_IN_USE.getMessage(msgParts);
                }
            }
            return error;
        }
    }
}

