/*
 * Decompiled with CFR 0.152.
 */
package com.sanrad.nms.server.logic.validation;

import com.sanrad.log.SrLogger;
import com.sanrad.nms.server.Server;
import com.sanrad.nms.server.logic.ClientParameterCode;
import com.sanrad.nms.server.logic.GeneralLogicObjectImpl;
import com.sanrad.nms.server.logic.LogicMgrAOImpl;
import com.sanrad.nms.server.logic.validation.iscsi.LunCreationValidator;
import com.sanrad.nms.server.logic.validation.iscsi.TargetCreationValidator;
import com.sanrad.nms.server.logic.validation.raid.AttachedRaidCreationValidator;
import com.sanrad.nms.server.logic.validation.volume.ConcatVolumeCreationValidator;
import com.sanrad.nms.server.logic.validation.volume.GeneralVolumeCreationValidator;
import com.sanrad.nms.server.logic.validation.volume.JournalVolumeCreationValidator;
import com.sanrad.nms.server.logic.validation.volume.MirrorVolumeCreationValidator;
import com.sanrad.nms.server.logic.validation.volume.SnapshotSchedulerCreationValidator;
import com.sanrad.nms.server.logic.validation.volume.SnapshotVolumeCreationValidator;
import com.sanrad.nms.server.logic.validation.volume.StripeVolumeCreationValidator;
import com.sanrad.nms.server.logic.validation.volume.TransparentVolumeCreationValidator;
import com.sanrad.nms.server.logic.validation.volume.VolumeCreationValidator;
import com.sanrad.nms.server.util.ClassID;
import com.sanrad.nms.server.util.ClientConfigElementData;
import com.sanrad.nms.server.util.CommKeyClassId;
import com.sanrad.nms.server.util.ConfigOperation;
import com.sanrad.util.SrConstantsBundleKeys;
import com.sanrad.util.Util;
import java.math.BigInteger;
import java.util.HashMap;
import java.util.List;
import java.util.Set;

public abstract class CreationValidator {
    protected static SrLogger theLogger = SrLogger.getLogger();
    private static final HashMap<ClassID, CreationValidator> theClassIdToValidatorsMap = new HashMap();
    private HashMap<ClientParameterCode, Boolean> myCreateParamsToMandatoryMap = new HashMap();

    protected CreationValidator() {
    }

    public static CreationValidator getCreationValidator(ClassID aClassId) {
        return theClassIdToValidatorsMap.get(aClassId);
    }

    public String validate(ClientConfigElementData aCed) {
        if (!ConfigOperation.CREATE.equals((Object)aCed.getConfigOperation())) {
            throw new IllegalArgumentException("The Client CED " + aCed + " is not a creation CED");
        }
        if (aCed.isCreated()) {
            return null;
        }
        String error = this.validateCreationParamsExist(aCed);
        if (error == null) {
            error = this.validateElementIDs(aCed);
        }
        if (error != null) {
            return error;
        }
        return this.innerValidate(aCed);
    }

    protected abstract String innerValidate(ClientConfigElementData var1);

    protected void addMandatoryParameter(ClientParameterCode aParam) {
        this.addCreationParameter(aParam, Boolean.TRUE);
    }

    protected void addCreationParameter(ClientParameterCode aParam, Boolean aManadatory) {
        this.myCreateParamsToMandatoryMap.put(aParam, aManadatory);
    }

    protected String validateCreationParamsExist(ClientConfigElementData aCed) {
        Set<ClientParameterCode> allKeys = aCed.keySet();
        for (ClientParameterCode code : this.myCreateParamsToMandatoryMap.keySet()) {
            if (!this.myCreateParamsToMandatoryMap.get(code).booleanValue()) continue;
            if (!allKeys.contains(code)) {
                return this.getMandatoryParamErrorMsg(aCed, code);
            }
            if (aCed.getValue(code) != null || code.isNullable()) continue;
            return this.getMandatoryParamNullErrorMsg(aCed, code);
        }
        return null;
    }

    protected String getMandatoryParamErrorMsg(ClientConfigElementData aCed, ClientParameterCode aCode) {
        StringBuilder sb = new StringBuilder();
        sb.append(aCode);
        sb.append(" is mandatory when creating a ");
        sb.append(aCed.getClassId());
        sb.append(", Client CED: ");
        sb.append(aCed);
        return sb.toString();
    }

    protected String getMandatoryParamNullErrorMsg(ClientConfigElementData aCed, ClientParameterCode aCode) {
        StringBuilder sb = new StringBuilder();
        sb.append(aCode);
        sb.append(" is mandatory and cannot be null when creating a ");
        sb.append(aCed.getClassId());
        sb.append(", Client CED: ");
        sb.append(aCed);
        return sb.toString();
    }

    private String validateElementIDs(ClientConfigElementData aCed) {
        CommKeyClassId errorId = null;
        if (aCed.isCreated() && CreationValidator.getLogicObject(aCed.getCommKeyClassId()) == null) {
            errorId = aCed.getCommKeyClassId();
        }
        for (ClientParameterCode code : aCed.keySet()) {
            Object value = aCed.getValue(code);
            if (!(value instanceof CommKeyClassId) || CreationValidator.getLogicObject((CommKeyClassId)value) != null) continue;
            errorId = (CommKeyClassId)value;
        }
        if (errorId != null) {
            return "No element found for ID " + errorId;
        }
        return null;
    }

    protected String executeValidations(List<ElementValidation> aValidationList) {
        if (aValidationList == null) {
            return null;
        }
        for (ElementValidation validation : aValidationList) {
            String error = validation.validate();
            if (error == null) continue;
            return error;
        }
        return null;
    }

    protected static ClassID getElementClassID(ClientConfigElementData aCed, ClientParameterCode aElementCode) {
        ClassID volClassId = null;
        if (aCed.isNested(aElementCode)) {
            ClientConfigElementData nestedCed = (ClientConfigElementData)aCed.getValue(aElementCode);
            volClassId = nestedCed.getClassId();
        } else {
            CommKeyClassId value = (CommKeyClassId)aCed.getValue(aElementCode);
            if (value == null) {
                return null;
            }
            volClassId = value.getClassID();
        }
        return volClassId;
    }

    protected static <T extends GeneralLogicObjectImpl> T getLogicObject(CommKeyClassId aId) {
        return (T)LogicMgrAOImpl.getInstance().getLogicObject(aId);
    }

    static {
        theClassIdToValidatorsMap.put(ClassID.ISCSI_TARGET, new TargetCreationValidator());
        theClassIdToValidatorsMap.put(ClassID.LUN, new LunCreationValidator());
        theClassIdToValidatorsMap.put(ClassID.GENERAL_VOLUME, new GeneralVolumeCreationValidator());
        theClassIdToValidatorsMap.put(ClassID.CONCAT_VOLUME, new ConcatVolumeCreationValidator());
        theClassIdToValidatorsMap.put(ClassID.CUBE_VOLUME, new ConcatVolumeCreationValidator());
        theClassIdToValidatorsMap.put(ClassID.TRANSPARENT_VOLUME, new TransparentVolumeCreationValidator());
        theClassIdToValidatorsMap.put(ClassID.MIRROR_VOLUME, new MirrorVolumeCreationValidator());
        theClassIdToValidatorsMap.put(ClassID.SNAPSHOT_VOLUME, new SnapshotVolumeCreationValidator());
        theClassIdToValidatorsMap.put(ClassID.STRIPE_VOLUME, new StripeVolumeCreationValidator());
        theClassIdToValidatorsMap.put(ClassID.JOURNAL_VOLUME, new JournalVolumeCreationValidator());
        theClassIdToValidatorsMap.put(ClassID.SNAPSHOT_SCHEDULER, new SnapshotSchedulerCreationValidator());
        theClassIdToValidatorsMap.put(ClassID.ATTACHED_RAID, new AttachedRaidCreationValidator());
    }

    protected static class NumberRangeValidation
    extends ElementValidation {
        private ClientParameterCode myNumberCode;
        private BigInteger myMaxValue;
        private BigInteger myMinValue;
        private String myUnits;

        protected NumberRangeValidation(ClientConfigElementData aCed, ClientParameterCode aNumberCode, String aMaxValue, String aMinValue, String aUnits) {
            super(aCed);
            if (aNumberCode == null) {
                throw new IllegalArgumentException("ClientParameterCode for number value must be supplied");
            }
            this.myNumberCode = aNumberCode;
            this.myMaxValue = new BigInteger(aMaxValue);
            this.myMinValue = new BigInteger(aMinValue);
            this.myUnits = aUnits;
        }

        @Override
        protected ClientParameterCode getParameterCode() {
            return this.myNumberCode;
        }

        @Override
        protected String validate() {
            Object cedValue = this.myCed.getValue(this.myNumberCode);
            if (cedValue == null) {
                return null;
            }
            BigInteger value = new BigInteger(String.valueOf(cedValue));
            if (value.compareTo(this.myMaxValue) > 0 || value.compareTo(this.myMinValue) < 0) {
                return this.buildMessage();
            }
            return null;
        }

        private String buildMessage() {
            StringBuilder sb = new StringBuilder();
            sb.append(this.myNumberCode);
            sb.append(" should be between ");
            sb.append(this.myMinValue);
            sb.append(this.myUnits);
            sb.append(" to ");
            sb.append(this.myMaxValue);
            sb.append(this.myUnits);
            return sb.toString();
        }
    }

    protected static class AliasValidation
    extends ElementValidation {
        private static final int ALIAS_MAX_LENGTH = Server.CONSTANSTS_BUNDLE.getIntResource(SrConstantsBundleKeys.ALIAS_MAX_LENGTH);
        private List<Character> myNonValidCharacters = VolumeCreationValidator.INVALID_ALIAS_CHARS;
        ClientParameterCode myAliasCode;

        public AliasValidation(ClientConfigElementData aCed, ClientParameterCode aAliasCode) {
            super(aCed);
            if (aAliasCode == null) {
                throw new IllegalArgumentException("ClientParameterCode for alias must be supplied");
            }
            this.myAliasCode = aAliasCode;
        }

        public void setNonValidCharacters(List<Character> aNonValidCharacters) {
            Util.validateInputNotNull(aNonValidCharacters, "Non valid characters list");
            this.myNonValidCharacters = aNonValidCharacters;
        }

        @Override
        protected ClientParameterCode getParameterCode() {
            return this.myAliasCode;
        }

        @Override
        protected String validate() {
            String alias = (String)this.myCed.getValue(this.myAliasCode);
            if (alias == null) {
                return null;
            }
            if (alias.length() > ALIAS_MAX_LENGTH) {
                return "Alias cannot exceed " + ALIAS_MAX_LENGTH + " characters. Please select a different alias";
            }
            char[] chars = new char[alias.length()];
            alias.getChars(0, alias.length(), chars, 0);
            for (int i = 0; i < chars.length; ++i) {
                if (!this.myNonValidCharacters.contains(Character.valueOf(chars[i]))) continue;
                StringBuffer errorMsg = new StringBuffer("Alias ");
                errorMsg.append(alias);
                errorMsg.append(" is not valid. Alias cannot contain the characters ");
                errorMsg.append(this.myNonValidCharacters);
                errorMsg.append(". Please select a different alias");
                return errorMsg.toString();
            }
            return null;
        }
    }

    public static abstract class ElementValidation {
        protected ClientConfigElementData myCed;

        protected ElementValidation(ClientConfigElementData aCed) {
            if (aCed == null) {
                throw new IllegalArgumentException("A client CED must be supplied");
            }
            this.myCed = aCed;
        }

        protected abstract String validate();

        protected abstract ClientParameterCode getParameterCode();
    }
}

