/*
 * Decompiled with CFR 0.152.
 */
package com.sanrad.nms.server.logic.target;

import com.sanrad.nms.server.Server;
import com.sanrad.nms.server.logic.ErrorMessage;
import com.sanrad.nms.server.logic.LogicObjectValidator;
import com.sanrad.nms.server.logic.SystemRootImpl;
import com.sanrad.nms.server.logic.cluster.ClusterImpl;
import com.sanrad.nms.server.logic.vswitch.VSwitchImpl;
import com.sanrad.util.SrConstantsBundleKeys;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public abstract class TargetValidator
extends LogicObjectValidator {
    private String alias;
    private String name;
    private String vSwitchExposedOn;
    private static final List<Character> NON_VALID_CHARACTERS = Arrays.asList(Character.valueOf('&'), Character.valueOf('#'), Character.valueOf('+'), Character.valueOf('!'), Character.valueOf('*'));
    private static final int ALIAS_MAX_LENGTH = Integer.parseInt(Server.CONSTANSTS_BUNDLE.getString(SrConstantsBundleKeys.ALIAS_MAX_LENGTH));
    protected ClusterImpl cluster;

    public TargetValidator(ClusterImpl cluster, String name, String alias, String vSwitchExposedOn) {
        this.cluster = cluster;
        this.alias = alias;
        this.name = name;
        this.vSwitchExposedOn = vSwitchExposedOn;
    }

    public static String getDefaultAlias() {
        return "$tar$" + System.currentTimeMillis();
    }

    @Override
    public boolean isValid() throws RemoteException {
        String errMsg = this.isAliasValid(this.alias);
        if (errMsg != null) {
            this.setErrorMsg(errMsg);
            return false;
        }
        errMsg = this.isAliasValid(this.name);
        if (errMsg != null) {
            this.setErrorMsg(errMsg);
            return false;
        }
        if (this.cluster.getTargetListMgr().isAliasExist(this.alias)) {
            this.setErrorMsg(ErrorMessage.ALIAS_ALREADY_IN_USE.getMessage(this.alias));
            return false;
        }
        if (this.cluster.getRemoteTargetListMgr().isNameExist(this.alias)) {
            this.setErrorMsg(ErrorMessage.ALIAS_ALREADY_IN_USE_BY_REMOTE_TARGET.getMessage(this.alias));
            return false;
        }
        ArrayList vswitchGroups = SystemRootImpl.getInstance().getAllVSwitchGroups();
        int i = vswitchGroups.size();
        while (i-- > 0) {
            ClusterImpl sysCluster;
            Object vsGroup = vswitchGroups.get(i);
            if (!(vsGroup instanceof ClusterImpl) || !(sysCluster = (ClusterImpl)vsGroup).getTargetListMgr().isNameExist(this.name)) continue;
            this.setErrorMsg(ErrorMessage.NAME_ALREADY_IN_USE.getMessage(new String[]{this.name, sysCluster.toString()}));
            return false;
        }
        if (this.name.length() > 223) {
            this.setErrorMsg(ErrorMessage.TARGET_WWWI_TOO_LONG.getMessage(Integer.toString(223)));
            return false;
        }
        List<VSwitchImpl> vswitches = this.cluster.getVSwitches();
        boolean isExists = false;
        for (VSwitchImpl vs : vswitches) {
            if (!vs.getName().equals(this.vSwitchExposedOn)) continue;
            isExists = true;
            break;
        }
        if (!isExists) {
            if (this.vSwitchExposedOn == null || this.vSwitchExposedOn.length() == 0) {
                this.setErrorMsg(ErrorMessage.VSWITCH_EMPTY_VALUE.getMessage());
            } else {
                this.setErrorMsg(ErrorMessage.VSWITCH_DOESNOT_EXIST.getMessage(this.vSwitchExposedOn));
            }
            return false;
        }
        return true;
    }

    public String isAliasValid(String alias) {
        if (alias.length() > ALIAS_MAX_LENGTH) {
            return "Alias cannot exceed " + ALIAS_MAX_LENGTH + " characters. Please select a different alias";
        }
        char[] chars = new char[alias.length()];
        alias.getChars(0, alias.length(), chars, 0);
        for (int i = 0; i < chars.length; ++i) {
            if (!NON_VALID_CHARACTERS.contains(Character.valueOf(chars[i]))) continue;
            StringBuffer errorMsg = new StringBuffer("Alias ");
            errorMsg.append(alias);
            errorMsg.append(" is not valid. Alias cannot contain the characters ");
            errorMsg.append(NON_VALID_CHARACTERS);
            errorMsg.append(". Please select a different alias");
            return errorMsg.toString();
        }
        return null;
    }
}

