/*
 * Decompiled with CFR 0.152.
 */
package com.sanrad.nms.server.logic.target;

import com.sanrad.log.SrLogger;
import com.sanrad.nms.server.logic.AlreadyKnownByVSwitch;
import com.sanrad.nms.server.logic.IllegalValueException;
import com.sanrad.nms.server.logic.InvalidElementException;
import com.sanrad.nms.server.logic.cluster.ClusterImpl;
import com.sanrad.nms.server.logic.target.TargetQosGroupImpl;
import com.sanrad.nms.server.logic.vswitch.VSwitchImpl;
import com.sanrad.nms.server.mgr.ConfigElementData;
import com.sanrad.nms.server.util.ParameterCode;
import com.sanrad.nms.server.util.types.SrString;
import com.sanrad.util.Util;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.List;

public class TargetQosMgr {
    private static SrLogger theLogger = SrLogger.getLogger();
    private ClusterImpl myCluster = null;
    private ArrayList<TargetQosGroupImpl> myQosGroups = new ArrayList();

    public TargetQosMgr(ClusterImpl aCluster) {
        if (aCluster == null) {
            throw new IllegalArgumentException("Cluster should no be null");
        }
        this.myCluster = aCluster;
    }

    public void clear() {
        this.myQosGroups.clear();
    }

    private TargetQosGroupImpl findQosGroup(ConfigElementData aCED) {
        SrString cedAlias = (SrString)aCED.getValue(ParameterCode.TARGET_QOS_GROUP_ALIAS);
        VSwitchImpl cedVs = this.myCluster.getVSwitch(aCED);
        for (TargetQosGroupImpl qosGroup : this.myQosGroups) {
            if (!Util.equalsWithNull(qosGroup.getAlias(), cedAlias) || !Util.equalsWithNull(qosGroup.getActiveVswitch(), cedVs)) continue;
            return qosGroup;
        }
        return null;
    }

    public List<TargetQosGroupImpl> getGroups() {
        return new ArrayList<TargetQosGroupImpl>(this.myQosGroups);
    }

    public TargetQosGroupImpl newISCSITargetQosGroup(ConfigElementData aCED) throws IllegalValueException, RemoteException, InvalidElementException, AlreadyKnownByVSwitch {
        TargetQosGroupImpl alreadyExistGroup = this.findQosGroup(aCED);
        if (alreadyExistGroup != null) {
            throw new AlreadyKnownByVSwitch(alreadyExistGroup);
        }
        TargetQosGroupImpl group = new TargetQosGroupImpl(this.myCluster, aCED);
        group.changeParameterList(aCED);
        this.myQosGroups.add(group);
        return group;
    }

    public void removeISCSITargetQosGroup(TargetQosGroupImpl aQosGroup) {
        this.myQosGroups.remove(aQosGroup);
    }
}

