/*
 * Decompiled with CFR 0.152.
 */
package com.sanrad.nms.server.logic.target;

import com.sanrad.log.SrLogCategories;
import com.sanrad.log.SrLogger;
import com.sanrad.nms.server.event.SrChangeElementEvent;
import com.sanrad.nms.server.logic.DataMgrAdapter;
import com.sanrad.nms.server.logic.IllegalValueException;
import com.sanrad.nms.server.logic.InvalidElementException;
import com.sanrad.nms.server.logic.LogicMgrAOImpl;
import com.sanrad.nms.server.logic.identity.CHAPCredentialsImpl;
import com.sanrad.nms.server.logic.lu.LUImpl;
import com.sanrad.nms.server.logic.target.ISCSITargetImpl;
import com.sanrad.nms.server.logic.target.Target;
import com.sanrad.nms.server.logic.target.TargetImpl;
import com.sanrad.nms.server.logic.volume.VolumeImpl;
import com.sanrad.nms.server.logic.volume.VolumeNodeImpl;
import com.sanrad.nms.server.logic.volume.VolumeTreeImpl;
import com.sanrad.nms.server.logic.vswitch.VSwitchImpl;
import com.sanrad.nms.server.mgr.ConfigElementData;
import com.sanrad.nms.server.util.Parameter;
import com.sanrad.nms.server.util.ParameterCode;
import com.sanrad.nms.server.util.types.ConfigElementDataList;
import com.sanrad.nms.server.util.types.ElementData;
import com.sanrad.nms.server.util.types.SrInteger;
import com.sanrad.util.concurrent.DefaultFutureListener;
import com.sanrad.util.concurrent.SrFuture;
import java.math.BigInteger;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Vector;

public class TargetList {
    private ArrayList<ISCSITargetImpl> myList = new ArrayList();
    private static SrLogger theLogger = SrLogger.getLogger();

    public void addTarget(ISCSITargetImpl target) {
        this.myList.add(target);
    }

    public void removeAll() {
        this.myList.clear();
    }

    public VolumeNodeImpl removeLU(LUImpl lu) {
        TargetImpl target = lu.getParentTarget();
        return target.removeLU(lu);
    }

    public List<ISCSITargetImpl> getTargetsExposedOnVSwitch(String vSwitchName) {
        ArrayList<ISCSITargetImpl> targets = new ArrayList<ISCSITargetImpl>();
        for (ISCSITargetImpl target : this.myList) {
            if (!target.getExposedOnVSwitch().equals(vSwitchName)) continue;
            targets.add(target);
        }
        return targets;
    }

    public List<ISCSITargetImpl> getTargetsExposedOnVSwitch(VSwitchImpl vSwitch, String vSwitchName) {
        ArrayList<ISCSITargetImpl> targets = new ArrayList<ISCSITargetImpl>();
        for (ISCSITargetImpl target : this.myList) {
            String exposedOnVSwitch = target.getExposedOnVSwitch(vSwitch);
            if (exposedOnVSwitch == null || !exposedOnVSwitch.equals(vSwitchName)) continue;
            targets.add(target);
        }
        return targets;
    }

    public List<ISCSITargetImpl> getTargetsNotExposedOnVSwitch(String vSwitchName) {
        ArrayList<ISCSITargetImpl> targets = new ArrayList<ISCSITargetImpl>();
        for (ISCSITargetImpl target : this.myList) {
            if (target.getExposedOnVSwitch().equals(vSwitchName)) continue;
            targets.add(target);
        }
        return targets;
    }

    public boolean removeTarget(Target target) {
        return this.myList.remove(target);
    }

    public Vector<ISCSITargetImpl> getAll() {
        return new Vector<ISCSITargetImpl>(this.myList);
    }

    public ISCSITargetImpl getTargetByAlias(String alias) {
        for (ISCSITargetImpl target : this.myList) {
            if (!target.getAlias().equals(alias)) continue;
            return target;
        }
        return null;
    }

    public ISCSITargetImpl getTargetByName(String name) {
        for (ISCSITargetImpl target : this.myList) {
            if (!target.getName().equals(name)) continue;
            return target;
        }
        return null;
    }

    public Target getTargetByChapCredential(CHAPCredentialsImpl chap) {
        for (ISCSITargetImpl target : this.myList) {
            if (!((TargetImpl)chap.getISCSIDevice()).equals(target)) continue;
            return target;
        }
        return null;
    }

    public int size() {
        return this.myList.size();
    }

    public void addLU(LUImpl lu) throws RemoteException {
        TargetImpl target = lu.getParentTarget();
        target.addLU(lu);
    }

    public Vector<VolumeTreeImpl> getVolumeTrees() throws RemoteException {
        Vector<VolumeTreeImpl> volumeTrees = new Vector<VolumeTreeImpl>();
        for (ISCSITargetImpl target : this.myList) {
            for (LUImpl lu : target.getLUs()) {
                VolumeNodeImpl volume = lu.getVolumeChild();
                VolumeTreeImpl tree = new VolumeTreeImpl(volume);
                volumeTrees.addElement(tree);
            }
        }
        return volumeTrees;
    }

    public boolean isAliasExist(String alias) {
        for (ISCSITargetImpl target : this.myList) {
            if (!target.getAlias().equals(alias)) continue;
            return true;
        }
        return false;
    }

    public boolean isNameExist(String name) {
        for (ISCSITargetImpl target : this.myList) {
            if (!target.getName().equals(name)) continue;
            return true;
        }
        return false;
    }

    public boolean isVolumeAliasExist(String alias) {
        for (ISCSITargetImpl target : this.myList) {
            for (LUImpl lu : target.getLUs()) {
                VolumeNodeImpl volume = lu.getVolumeChild();
                if (!(volume instanceof VolumeImpl) || !((VolumeImpl)volume).isAliasExist(alias)) continue;
                return true;
            }
        }
        return false;
    }

    public VolumeImpl getVolumeByAlias(String alias) {
        for (ISCSITargetImpl target : this.myList) {
            for (LUImpl lu : target.getLUs()) {
                VolumeNodeImpl volume = lu.getVolumeChild();
                if (!(volume instanceof VolumeImpl) || !((VolumeImpl)volume).isAliasExist(alias)) continue;
                return (VolumeImpl)volume;
            }
        }
        return null;
    }

    public SrFuture<Void> readExposedOn() throws RemoteException {
        final SrFuture<Void> retFuture = new SrFuture<Void>("TargetList.readExposedOn");
        final ArrayList<SrFuture<Void>> midFutures = new ArrayList<SrFuture<Void>>();
        if (this.myList.size() > 0) {
            ConfigElementDataList cedList = new ConfigElementDataList();
            for (ISCSITargetImpl target : this.myList) {
                ConfigElementData element = new ConfigElementData(target.getCommKeys(), target.getClassId());
                element.addParameter(new Parameter(ParameterCode.ISCSI_TARGET_DEFAULT_EXPOSE_ON));
                cedList.add(element);
            }
            for (ElementData curElementData : cedList) {
                midFutures.add(DataMgrAdapter.getInstance().readElement((ConfigElementData)curElementData));
            }
        }
        Runnable toRun = new Runnable(){

            @Override
            public void run() {
                LogicMgrAOImpl.getInstance().updateFutureByGivenFutures(midFutures, retFuture);
            }
        };
        DefaultFutureListener.listenTo(toRun, midFutures);
        return retFuture;
    }

    public BigInteger getAccessibleSpace() {
        BigInteger accessibleSpace = BigInteger.ZERO;
        for (ISCSITargetImpl target : this.myList) {
            accessibleSpace = accessibleSpace.add(target.getAccessibleSpace());
        }
        return accessibleSpace;
    }

    public synchronized int synchronize() throws RemoteException, IllegalValueException {
        StringBuffer errMsg = new StringBuffer();
        boolean errOccured = false;
        int retVal = 0;
        for (ISCSITargetImpl target : this.myList) {
            try {
                int targetRetVal = target.synchronize();
                if (targetRetVal <= retVal) continue;
                retVal = targetRetVal;
            }
            catch (IllegalValueException ive) {
                errMsg.append("\n");
                errMsg.append(ive.getMessage());
                errOccured = true;
                theLogger.warn(SrLogCategories.LEGACY, ive, " when trying to synchronize ", target.getClassId(), " ", target);
            }
        }
        if (errOccured) {
            throw new IllegalValueException(errMsg.toString());
        }
        return retVal;
    }

    public int getTotalVolumeCount() throws RemoteException {
        int totalVolumeCount = 0;
        for (ISCSITargetImpl target : this.myList) {
            totalVolumeCount += target.getTotalVolumeCount();
        }
        return totalVolumeCount;
    }

    public List<ISCSITargetImpl> getTargetsOfVolume(VolumeNodeImpl volume) {
        ArrayList<ISCSITargetImpl> targets = new ArrayList<ISCSITargetImpl>();
        for (ISCSITargetImpl target : this.getAll()) {
            for (LUImpl lu : target.getLUs()) {
                VolumeNodeImpl volumeChild = lu.getVolumeChild();
                if (!volume.equals(volumeChild)) continue;
                targets.add(target);
            }
        }
        return targets;
    }

    public HashMap<VolumeNodeImpl, List<ISCSITargetImpl>> getTargetsWithSameVolume() {
        HashMap<VolumeNodeImpl, List<ISCSITargetImpl>> targets = new HashMap<VolumeNodeImpl, List<ISCSITargetImpl>>();
        for (ISCSITargetImpl target : this.getAll()) {
            for (LUImpl lu : target.getLUs()) {
                VolumeNodeImpl volume = lu.getVolumeChild();
                List<ISCSITargetImpl> targetParents = this.getTargetsOfVolume(volume);
                targetParents.remove(target);
                if (targetParents.isEmpty()) continue;
                List<ISCSITargetImpl> currentTargetParents = targets.get(volume);
                if (currentTargetParents != null) {
                    currentTargetParents.addAll(targetParents);
                    continue;
                }
                targets.put(volume, targetParents);
            }
        }
        return targets;
    }

    public List<VolumeNodeImpl> getAllVolumeRoots() {
        ArrayList<VolumeNodeImpl> roots = new ArrayList<VolumeNodeImpl>();
        for (ISCSITargetImpl target : this.myList) {
            List<VolumeNodeImpl> volumes = target.getAllVolumeRoots();
            roots.addAll(volumes);
        }
        return roots;
    }

    public void updateVswitch(VSwitchImpl vswitch) throws InvalidElementException {
        if (vswitch != null) {
            ConfigElementData vsChangeElement = new ConfigElementData(vswitch.getCommKeyClassId());
            String vsName = vswitch.getName();
            int targetCount = this.getTargetsExposedOnVSwitch(vsName).size() + this.getTargetsNotExposedOnVSwitch(vsName).size();
            vsChangeElement.setValue(ParameterCode.VSWITCH_TARGETS_COUNT, new SrInteger(targetCount));
            SrChangeElementEvent vswitchChangeEvent = new SrChangeElementEvent((Object)this, vsChangeElement);
            vswitch.getCluster().elementEvent(vswitchChangeEvent);
        } else {
            theLogger.warn(SrLogCategories.INFORMATIVE, "could not update vswitch with ParameterCode.VSWITCH_TARGETS_COUNT since the given vswitch is null");
        }
    }
}

