/*
 * Decompiled with CFR 0.152.
 */
package com.sanrad.nms.server.logic.target;

import com.sanrad.log.SrLogCategories;
import com.sanrad.log.SrLogger;
import com.sanrad.nms.server.logic.ClientParameterCode;
import com.sanrad.nms.server.logic.ErrorMessage;
import com.sanrad.nms.server.logic.IllegalValueException;
import com.sanrad.nms.server.logic.InvalidElementException;
import com.sanrad.nms.server.logic.LogicObjectImpl;
import com.sanrad.nms.server.logic.VirtualizationHierarchyObject;
import com.sanrad.nms.server.logic.acl.AclEntryImpl;
import com.sanrad.nms.server.logic.acl.AclImpl;
import com.sanrad.nms.server.logic.acl.PolicyManagerImpl;
import com.sanrad.nms.server.logic.cluster.ClusterImpl;
import com.sanrad.nms.server.logic.dr.DRRootImpl;
import com.sanrad.nms.server.logic.identity.IdentityImpl;
import com.sanrad.nms.server.logic.lu.LUImpl;
import com.sanrad.nms.server.logic.scsi.SCSIDeviceImpl;
import com.sanrad.nms.server.logic.target.Target;
import com.sanrad.nms.server.logic.target.TargetValidator;
import com.sanrad.nms.server.logic.volume.SnapshotVolumeImpl;
import com.sanrad.nms.server.logic.volume.VolumeNodeImpl;
import com.sanrad.nms.server.logic.vswitch.VSwitchImpl;
import com.sanrad.nms.server.mgr.ConfigElementData;
import com.sanrad.nms.server.util.ClassID;
import com.sanrad.nms.server.util.ParameterCode;
import com.sanrad.nms.server.util.types.SrString;
import com.sanrad.nms.server.util.types.constants.IdentityPurposeConstant;
import com.sanrad.nms.server.util.types.constants.SCSITargetDeviceStatusConstant;
import com.sanrad.util.Util;
import java.math.BigInteger;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.Vector;

public abstract class TargetImpl
extends SCSIDeviceImpl
implements Target,
VirtualizationHierarchyObject {
    private static Map<ParameterCode, ParameterCode.Flags> theParameterCodeFlagsMap;
    protected Vector<LUImpl> myLuList = new Vector();
    private String name = null;
    private static SrLogger theLogger;

    protected TargetImpl(ClusterImpl cluster, ClassID classId, ConfigElementData aCED) throws RemoteException, IllegalValueException, InvalidElementException {
        super(cluster, classId, aCED);
        this.validateAndInit(aCED, theParameterCodeFlagsMap);
    }

    @Override
    public HashMap changeParameterList(ConfigElementData aCED) throws RemoteException, IllegalValueException, InvalidElementException {
        HashMap changedValues = super.changeParameterList(aCED);
        if (aCED.getParametersList().containsKey(ParameterCode.ISCSI_TARGET_DEFAULT_EXPOSE_ON) && aCED.getValue(ParameterCode.ISCSI_TARGET_DEFAULT_EXPOSE_ON) == null) {
            StringBuffer msg = new StringBuffer();
            msg.append(this.getClassId());
            msg.append(" ");
            msg.append(this.toString());
            msg.append(" - Exposed On value set to NULL");
            theLogger.warn(SrLogCategories.LEGACY, msg);
            throw new IllegalValueException(msg.toString());
        }
        this.name = this.getName();
        this.toStringValue = this.getAlias();
        return changedValues;
    }

    @Override
    public HashMap getClientParameterList() throws RemoteException {
        HashMap parameterList = super.getClientParameterList();
        parameterList.put(ClientParameterCode.SCSI_TARGET_PORT, this.getPorts());
        return parameterList;
    }

    @Override
    public String getName() {
        return this.getName(null);
    }

    @Override
    public abstract String getName(VSwitchImpl var1);

    @Override
    public String getExposedOnVSwitch() {
        return this.getExposedOnVSwitch(null);
    }

    public String getExposedOnVSwitch(VSwitchImpl vSwitch) {
        String exposedOn = (String)this.getValueOf(vSwitch, ParameterCode.ISCSI_TARGET_DEFAULT_EXPOSE_ON, vSwitch == null);
        return exposedOn;
    }

    public VSwitchImpl getExposedOnVSwitchObject() {
        return this.getExposedOnVSwitchObject(null);
    }

    public VSwitchImpl getExposedOnVSwitchObject(VSwitchImpl vSwitch) {
        String vswitchName = this.getExposedOnVSwitch(vSwitch);
        VSwitchImpl vswitchExposedOn = this.getCluster().getVSwitchByName(vswitchName);
        return vswitchExposedOn;
    }

    @Override
    public String getAlias() {
        return this.getAlias(null);
    }

    @Override
    public abstract String getAlias(VSwitchImpl var1);

    @Override
    public SCSITargetDeviceStatusConstant getStatus() throws RemoteException {
        return this.getStatus(null);
    }

    public SCSITargetDeviceStatusConstant getStatus(VSwitchImpl vSwitch) throws RemoteException {
        return (SCSITargetDeviceStatusConstant)this.getSrValueOf(vSwitch, ParameterCode.SCSI_TARGET_STATUS, vSwitch == null);
    }

    public boolean isExposedOnDifferentVSwitches() {
        String[] names;
        if (this.isRedundant() && (names = this.getExposedOnVSwitches()).length > 0) {
            String name = names[0];
            for (int i = 1; i < names.length; ++i) {
                if (names[i].equals(name)) continue;
                return true;
            }
        }
        return false;
    }

    public String[] getExposedOnVSwitches() {
        VSwitchImpl[] vSwitches = this.getConnectedVSwitches();
        String[] names = new String[vSwitches.length];
        for (int i = 0; i < vSwitches.length; ++i) {
            names[i] = this.getExposedOnVSwitch(vSwitches[i]);
        }
        return names;
    }

    @Override
    public boolean equals(Object obj) {
        if (super.equals(obj)) {
            return true;
        }
        if (obj instanceof TargetImpl) {
            return ((TargetImpl)obj).name.equals(this.name);
        }
        return false;
    }

    @Override
    public synchronized void syncDataWasChanged() throws RemoteException, IllegalValueException {
        theLogger.info(SrLogCategories.LEGACY, "syncDataWasChanged called  ", this.toString());
        if (!this.isSynchronizePending()) {
            return;
        }
        try {
            if (this.isNeedToSynchronize()) {
                this.synchronizeMe();
                return;
            }
        }
        catch (IllegalValueException ive) {
            theLogger.warn(SrLogCategories.LEGACY, ive);
            this.errorInSynchronizing();
            return;
        }
        this.doneSynchronizing();
    }

    @Override
    public synchronized int synchronize() throws RemoteException, IllegalValueException {
        theLogger.trace(SrLogCategories.LEGACY, "Start Sync of target ", this.getAlias());
        if (this.isSynchronizePending()) {
            theLogger.trace(SrLogCategories.LEGACY, "Already synchronizing ", this.getClassId(), " ", this.toString());
            return 1;
        }
        int retVal = 0;
        try {
            retVal = super.synchronize();
            theLogger.trace(SrLogCategories.LEGACY, "Sync of target ", this.getAlias(), " After Super completion status ", retVal);
            if (retVal != 3) {
                retVal = this.synchronizeLUs();
                switch (retVal) {
                    case 3: {
                        this.setSynchronizePending(false);
                        break;
                    }
                    case 1: {
                        retVal = 2;
                    }
                }
            }
        }
        catch (IllegalValueException ive) {
            theLogger.warn(SrLogCategories.LEGACY, ive.getMessage());
            this.setSynchronizePending(false);
            throw ive;
        }
        return retVal;
    }

    private int synchronizeLUs() throws RemoteException, IllegalValueException {
        theLogger.trace(SrLogCategories.LEGACY, "Start Sync LUS of target ", this.getAlias());
        int retVal = 0;
        StringBuffer errMsg = new StringBuffer();
        boolean errOccured = false;
        Enumeration<LUImpl> e = this.getLUs().elements();
        while (e.hasMoreElements()) {
            try {
                LUImpl lu = e.nextElement();
                int luRetVal = lu.synchronize();
                theLogger.trace(SrLogCategories.LEGACY, "Sync of target ", this.getAlias(), " Lu ", lu.toString(), " status ", luRetVal);
                if (luRetVal <= retVal) continue;
                retVal = luRetVal;
            }
            catch (IllegalValueException ive) {
                theLogger.warn(SrLogCategories.LEGACY, ive);
                errMsg.append(" \n");
                errMsg.append(ive.getMessage());
                errOccured = true;
            }
        }
        if (errOccured) {
            this.setSynchronizePending(false);
            throw new IllegalValueException(errMsg.toString());
        }
        return retVal;
    }

    public void addLU(LUImpl lu) throws RemoteException {
        this.myLuList.addElement(lu);
    }

    public VolumeNodeImpl removeLU(LUImpl lu) {
        VolumeNodeImpl volume = lu.getVolumeChild();
        this.myLuList.remove(lu);
        return volume;
    }

    public Vector<LUImpl> getLUs() {
        return this.myLuList;
    }

    @Override
    protected String canBeDeleted() {
        if (!this.isEmpty()) {
            return ErrorMessage.CANNOT_DELETE_TARGET_WITH_LU.getMessage(this.getAlias());
        }
        return null;
    }

    @Override
    public boolean isLUNumberExist(int lun) {
        return this.isLUNumberExist(null, lun);
    }

    public boolean isLUNumberExist(VSwitchImpl vSwitch, int lun) {
        for (LUImpl lu : this.getLUs()) {
            Integer luNumber = lu.getLUN(vSwitch);
            if (luNumber == null || luNumber != lun) continue;
            return true;
        }
        return false;
    }

    @Override
    public int getLUCount() {
        return this.getLUs().size();
    }

    public int getLUCount(VSwitchImpl vSwitch) {
        Vector<LUImpl> lus = this.getLUs();
        int luCount = 0;
        Enumeration<LUImpl> e = lus.elements();
        while (e.hasMoreElements()) {
            LUImpl lu = e.nextElement();
            if (!lu.isKnownByVSwitch(vSwitch)) continue;
            ++luCount;
        }
        return luCount;
    }

    @Override
    public int getLUCount(int lun) {
        List<LUImpl> lus = this.getLUs(lun);
        if (lus == null) {
            return 0;
        }
        return lus.size();
    }

    public int getLUCount(VSwitchImpl vSwitch, int lun) {
        int luCount = 0;
        for (LUImpl lu : this.getLUs(lun)) {
            if (!lu.isKnownByVSwitch(vSwitch)) continue;
            ++luCount;
        }
        return luCount;
    }

    public LUImpl getLU(int lun) throws RemoteException {
        for (LUImpl lu : this.getLUs()) {
            if (lu.getLUN() != lun) continue;
            return lu;
        }
        return null;
    }

    @Override
    public boolean isEmpty() {
        return this.myLuList.isEmpty();
    }

    @Override
    protected String isValid(HashMap parameterList) {
        String exposedOn;
        String name;
        String alias = (String)parameterList.get(ClientParameterCode.TARGET_ALIAS);
        if (alias != null) {
            String errorMsg = this.isAliasValid(alias);
            if (errorMsg != null) {
                return errorMsg;
            }
            if (alias.equals("")) {
                alias = TargetValidator.getDefaultAlias();
            }
            if (this.cluster.getTargetListMgr().isAliasExist(alias)) {
                return ErrorMessage.ALIAS_ALREADY_IN_USE.getMessage(alias);
            }
            parameterList.put(ClientParameterCode.TARGET_ALIAS, new SrString(alias));
        }
        if ((name = (String)parameterList.get(ClientParameterCode.TARGET_NAME)) != null) {
            if (this.getLUCount() > 0) {
                return this.getClassId() + " " + this.getAlias() + " has LUs. You cannot change its name";
            }
            if (name.length() > 223) {
                return this.getClassId() + " " + this.getAlias() + ". WWWWI is limited to " + 223 + "characters";
            }
            if (this.cluster.getTargetListMgr().isNameExist(name)) {
                return ErrorMessage.NAME_ALREADY_IN_USE.getMessage(name);
            }
            parameterList.put(ClientParameterCode.TARGET_NAME, new SrString(name));
        }
        if ((exposedOn = (String)parameterList.get(ClientParameterCode.TARGET_EXPOSED_ON)) != null) {
            VSwitchImpl vSwitch = this.getCluster().getVSwitchUnderTakeover();
            VSwitchImpl otherVswitch = this.getOtherVSwitchFromCluster(vSwitch);
            if (vSwitch != null && vSwitch.getName().equals(exposedOn) && !otherVswitch.isDeletionPending()) {
                return "You cannot change the parameter " + ParameterCode.ISCSI_TARGET_DEFAULT_EXPOSE_ON + " to " + exposedOn + ".  That " + ClassID.VSWITCH + " was taken over";
            }
            for (LUImpl lu : this.getLUs()) {
                VolumeNodeImpl volume = lu.getVolumeChild();
                if (DRRootImpl.getInstance().getPairUsingVolume(volume) != null) {
                    return "You cannot change the parameter " + ParameterCode.ISCSI_TARGET_DEFAULT_EXPOSE_ON + " to " + exposedOn + ".  That " + volume + " is part of pair ";
                }
                VSwitchImpl volumeVSwitch = volume.isInvolvedInActiveCopyDownHirarchy();
                if (volumeVSwitch == null) continue;
                return volume.getClassId() + " " + volume + " is part of copy operation on " + ClassID.VSWITCH + " " + volumeVSwitch + ". You cannot change the exposed on " + ClassID.VSWITCH + " until the operation is done/aborted";
            }
            parameterList.put(ClientParameterCode.TARGET_EXPOSED_ON, new SrString(exposedOn));
        }
        return null;
    }

    @Override
    public void clear() throws RemoteException {
        this.myLuList = new Vector();
        super.clear();
    }

    public BigInteger getAccessibleSpace() {
        BigInteger accessibleSpace = BigInteger.ZERO;
        for (LUImpl lu : this.myLuList) {
            BigInteger luAccessibleSpace = lu.getAccessibleSpace();
            if (luAccessibleSpace == null) continue;
            accessibleSpace = accessibleSpace.add(luAccessibleSpace);
        }
        return accessibleSpace;
    }

    public int getTotalVolumeCount() throws RemoteException {
        int totalVolumeCount = 0;
        Enumeration<LUImpl> e = this.myLuList.elements();
        while (e.hasMoreElements()) {
            LUImpl lu = e.nextElement();
            totalVolumeCount += lu.getTotalVolumeCount();
        }
        return totalVolumeCount;
    }

    public boolean isTheorTarget(VSwitchImpl vSwitch) {
        return this.getLUCount(vSwitch) == 0;
    }

    @Override
    public void registerToPropagatedStateChange() {
        this.cluster.addPropagationStateDependentObjectAndListener(this);
    }

    private List<LUImpl> getLUs(int lun) {
        ArrayList<LUImpl> luList = null;
        for (LUImpl lu : this.myLuList) {
            if (lu.getLUN() != lun) continue;
            if (luList == null) {
                luList = new ArrayList<LUImpl>();
            }
            luList.add(lu);
        }
        return luList;
    }

    public LUImpl isLUVolumeChildConsistence(LUImpl lu) {
        for (LUImpl otherLu : this.myLuList) {
            if (!otherLu.getLUN().equals(lu.getLUN()) || otherLu.equals(lu)) continue;
            return otherLu;
        }
        return null;
    }

    public LUImpl isLUNConsistence(LUImpl lu) throws RemoteException {
        for (LUImpl otherLu : this.myLuList) {
            if (!otherLu.getVolumeChild().equals(lu.getVolumeChild()) || otherLu.equals(lu)) continue;
            return otherLu;
        }
        return null;
    }

    public List<VolumeNodeImpl> getAllVolumeRoots() {
        ArrayList<VolumeNodeImpl> roots = new ArrayList<VolumeNodeImpl>();
        for (LUImpl lu : this.myLuList) {
            roots.add(lu.getVolumeChild());
        }
        return roots;
    }

    @Override
    public AclImpl getAclForTarget() {
        PolicyManagerImpl policyMgr = this.getCluster().getPolicyManager();
        Hashtable aclMap = policyMgr.getAllAcl();
        return (AclImpl)aclMap.get(this);
    }

    public boolean isExposedOnDeadVswitch() {
        String exposedOn = this.getExposedOnVSwitch();
        VSwitchImpl[] vSwitches = this.getConnectedVSwitches();
        for (int i = 0; i < vSwitches.length; ++i) {
            if (!exposedOn.equals(vSwitches[i].getName())) continue;
            return !vSwitches[i].isConnected();
        }
        return false;
    }

    @Override
    public boolean isLegitimateForVolumeOperation() {
        return !this.isExposedOnDeadVswitch() && !this.isExposedOnDifferentVSwitches();
    }

    @Override
    public HashMap checkConsistencyBetweenVSwitches() {
        List<String> inconsistencyValsList;
        HashMap<ParameterCode, String[]> map = super.checkConsistencyBetweenVSwitches();
        AclImpl acl = this.getAclForTarget();
        if (acl != null && (inconsistencyValsList = acl.isDefaultAccessInconsistent()) != null) {
            String[] inconsistencyVals = inconsistencyValsList.toArray(new String[inconsistencyValsList.size()]);
            if (map == null) {
                map = new HashMap<ParameterCode, String[]>();
            }
            map.put(ParameterCode.ACL_ENTRY_ACCESS, inconsistencyVals);
        }
        return map;
    }

    public Vector getAllSnapshotVolumeSources() {
        Vector<VolumeNodeImpl> allSources = new Vector<VolumeNodeImpl>();
        for (LUImpl lu : this.getLUs()) {
            VolumeNodeImpl volumeChild = lu.getVolumeChild();
            if (volumeChild.isSnapshotSource()) {
                allSources.addElement(volumeChild);
                continue;
            }
            if (!volumeChild.getClassId().equals(ClassID.SNAPSHOT_VOLUME)) continue;
            allSources.addElement(((SnapshotVolumeImpl)volumeChild).getSourceVolume());
        }
        return allSources;
    }

    public Vector<VolumeNodeImpl> getAllSnapshotVolumeSources(VSwitchImpl vSwitch) {
        Vector<VolumeNodeImpl> allSources = new Vector<VolumeNodeImpl>();
        for (LUImpl lu : this.getLUs()) {
            VolumeNodeImpl volumeChild = lu.getVolumeChild();
            if (volumeChild.isSnapshotSource(vSwitch)) {
                allSources.addElement(volumeChild);
                continue;
            }
            if (!volumeChild.getClassId().equals(ClassID.SNAPSHOT_VOLUME)) continue;
            allSources.addElement(((SnapshotVolumeImpl)volumeChild).getSourceVolume());
        }
        return allSources;
    }

    public IdentityImpl knowIdentity(IdentityPurposeConstant identityPurpose, ArrayList existedRemoteInitiatorNames) throws RemoteException {
        AclImpl acl = this.getAclForTarget();
        for (AclEntryImpl aclEntry : acl.getEntries()) {
            IdentityImpl aclEntryIdentity = aclEntry.getIdentity();
            if (!aclEntryIdentity.getPurpose().equals(identityPurpose) || !aclEntryIdentity.areNamesEqual(existedRemoteInitiatorNames)) continue;
            return aclEntryIdentity;
        }
        return null;
    }

    public IdentityImpl getIdentityOfInitiatorNames(IdentityPurposeConstant identityPurpose, ArrayList remoteInitiatorNames) throws RemoteException {
        AclImpl acl = this.getAclForTarget();
        for (AclEntryImpl aclEntry : acl.getEntries()) {
            IdentityImpl aclEntryIdentity = aclEntry.getIdentity();
            if (!aclEntryIdentity.getPurpose().equals(identityPurpose) || aclEntryIdentity.isNameExist((String)remoteInitiatorNames.get(0)) == null) continue;
            return aclEntryIdentity;
        }
        return null;
    }

    @Override
    protected List<LogicObjectImpl> getChildElementsForDeletion() {
        return Util.convertListType(this.myLuList);
    }

    static {
        HashMap<ParameterCode, ParameterCode.Flags> parameterCodeFlagsMap = new HashMap<ParameterCode, ParameterCode.Flags>();
        parameterCodeFlagsMap.put(ParameterCode.SCSI_TARGET_STATUS, new ParameterCode.Flags(true, false));
        theParameterCodeFlagsMap = Collections.unmodifiableMap(parameterCodeFlagsMap);
        theLogger = SrLogger.getLogger();
    }
}

