/*
 * Decompiled with CFR 0.152.
 */
package com.sanrad.nms.server.logic.target;

import com.sanrad.nms.server.logic.ClientParameterCode;
import com.sanrad.nms.server.logic.IllegalValueException;
import com.sanrad.nms.server.logic.InvalidElementException;
import com.sanrad.nms.server.logic.cluster.ClusterImpl;
import com.sanrad.nms.server.logic.statistics.StatisticsImpl;
import com.sanrad.nms.server.logic.target.ISCSITargetImpl;
import com.sanrad.nms.server.logic.target.SCSITargetPort;
import com.sanrad.nms.server.logic.vswitch.VSwitchImpl;
import com.sanrad.nms.server.mgr.ConfigElementData;
import com.sanrad.nms.server.mgr.polling.PollingGroupType;
import com.sanrad.nms.server.util.ClassID;
import com.sanrad.nms.server.util.CommKeyClassId;
import com.sanrad.nms.server.util.ParameterCode;
import com.sanrad.nms.server.util.types.constants.SCSIPortRoleConstant;
import com.sanrad.nms.server.util.types.constants.SCSITransportType;
import java.math.BigInteger;
import java.rmi.RemoteException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public class SCSITargetPortImpl
extends StatisticsImpl
implements SCSITargetPort {
    private static Map<ParameterCode, ParameterCode.Flags> theParameterCodeFlagsMap;
    private static HashMap<ParameterCode, ClientParameterCode> s_parametersToCalculateMap;

    public SCSITargetPortImpl(ClusterImpl cluster, ConfigElementData aCED) throws RemoteException, IllegalValueException, InvalidElementException {
        super(cluster, ClassID.SCSI_TARGET_PORT, aCED, s_parametersToCalculateMap);
        this.validateAndInit(aCED, theParameterCodeFlagsMap);
    }

    @Override
    public HashMap changeParameterList(ConfigElementData aCED) throws RemoteException, IllegalValueException, InvalidElementException {
        HashMap changedValues = super.changeParameterList(aCED);
        this.toStringValue = this.getName();
        return changedValues;
    }

    private ISCSITargetImpl getTargetImpl() {
        for (int i = 0; i < this.getConnectedVSwitchCounter(); ++i) {
            CommKeyClassId scsiTargetCommKeyClassId;
            VSwitchImpl vswitch = this.getConnectedVSwitches()[i];
            if (vswitch == null || (scsiTargetCommKeyClassId = (CommKeyClassId)this.getSrValueOf(vswitch, ParameterCode.ISCSI_TARGET_ID)) == null) continue;
            CommKeyClassId iscsiTargetCommKeyClassId = this.getCluster().getISCSIId(scsiTargetCommKeyClassId);
            ISCSITargetImpl targetImpl = (ISCSITargetImpl)this.cluster.getCommKeyRefMap().getRefByCommKeyClassID(iscsiTargetCommKeyClassId);
            if (targetImpl == null) continue;
            return targetImpl;
        }
        return null;
    }

    @Override
    public VSwitchImpl getDominantVswitch() {
        VSwitchImpl targetVS;
        ISCSITargetImpl target = this.getTargetImpl();
        if (target != null && this.isKnownByVSwitch(targetVS = target.getActiveVswitch())) {
            return targetVS;
        }
        return super.getDominantVswitch();
    }

    @Override
    protected PollingGroupType getGroupType() {
        return PollingGroupType.SCSI_TARGET_PORT_STATISTICS_GROUP_TYPE;
    }

    @Override
    public SCSIPortRoleConstant getRole() {
        return (SCSIPortRoleConstant)this.getValueOf(this.getParentVSwitch(), ParameterCode.SCSI_PORT_ROLE);
    }

    @Override
    public SCSITransportType getTransportType() {
        return (SCSITransportType)this.getSrValueOf(ParameterCode.SCSI_PORT_TRANSPORT_TYPE);
    }

    @Override
    public String getName() {
        return (String)this.getValueOf(this.getParentVSwitch(), ParameterCode.SCSI_TARGET_PORT_NAME);
    }

    @Override
    public BigInteger getReadMB() {
        return (BigInteger)this.getValueOf(this.getParentVSwitch(), ParameterCode.SCSI_TARGET_PORT_READ_MB);
    }

    @Override
    public BigInteger getWrittenMB() {
        return (BigInteger)this.getValueOf(this.getParentVSwitch(), ParameterCode.SCSI_TARGET_PORT_WRITTEN_MB);
    }

    @Override
    public BigInteger getInCommands() {
        return (BigInteger)this.getValueOf(this.getParentVSwitch(), ParameterCode.SCSI_TARGET_PORT_IN_COMMANDS);
    }

    @Override
    public ISCSITargetImpl getTarget() {
        return this.getTargetImpl();
    }

    static {
        HashMap<ParameterCode, ParameterCode.Flags> parameterCodeFlagsMap = new HashMap<ParameterCode, ParameterCode.Flags>();
        parameterCodeFlagsMap.put(ParameterCode.ISCSI_TARGET_ID, new ParameterCode.Flags(true, false));
        parameterCodeFlagsMap.put(ParameterCode.SCSI_PORT_ROLE, new ParameterCode.Flags(true, false));
        parameterCodeFlagsMap.put(ParameterCode.SCSI_PORT_TRANSPORT_TYPE, new ParameterCode.Flags(true, false));
        parameterCodeFlagsMap.put(ParameterCode.SCSI_TARGET_PORT_NAME, new ParameterCode.Flags(true, false));
        parameterCodeFlagsMap.put(ParameterCode.SCSI_TARGET_PORT_IN_COMMANDS, new ParameterCode.Flags(true, false));
        parameterCodeFlagsMap.put(ParameterCode.SCSI_TARGET_PORT_READ_MB, new ParameterCode.Flags(true, false));
        parameterCodeFlagsMap.put(ParameterCode.SCSI_TARGET_PORT_WRITTEN_MB, new ParameterCode.Flags(true, false));
        theParameterCodeFlagsMap = Collections.unmodifiableMap(parameterCodeFlagsMap);
        s_parametersToCalculateMap = new HashMap();
        s_parametersToCalculateMap.put(ParameterCode.SCSI_TARGET_PORT_IN_COMMANDS, ClientParameterCode.SCSI_TARGET_PORT_IN_COMMANDS_PER_SEC);
        s_parametersToCalculateMap.put(ParameterCode.SCSI_TARGET_PORT_READ_MB, ClientParameterCode.SCSI_TARGET_PORT_READ_MB_PER_SEC);
        s_parametersToCalculateMap.put(ParameterCode.SCSI_TARGET_PORT_WRITTEN_MB, ClientParameterCode.SCSI_TARGET_PORT_WRITTEN_MB_PER_SEC);
    }
}

