/*
 * Decompiled with CFR 0.152.
 */
package com.sanrad.nms.server.logic.target;

import com.sanrad.log.SrLogCategories;
import com.sanrad.log.SrLogger;
import com.sanrad.nms.server.logic.IllegalValueException;
import com.sanrad.nms.server.logic.identity.CHAPCredentialsImpl;
import com.sanrad.nms.server.logic.target.ISCSIRemoteTarget;
import com.sanrad.nms.server.logic.target.ISCSIRemoteTargetImpl;
import java.rmi.RemoteException;
import java.util.ArrayList;

public class RemoteTargetList {
    private ArrayList<ISCSIRemoteTargetImpl> m_list = new ArrayList();
    private static SrLogger theLogger = SrLogger.getLogger();

    public int size() {
        return this.m_list.size();
    }

    public void addRemoteTarget(ISCSIRemoteTargetImpl target) {
        this.m_list.add(target);
    }

    public boolean removeRemoteTarget(ISCSIRemoteTarget target) {
        return this.m_list.remove(target);
    }

    public void removeAll() {
        this.m_list.clear();
    }

    public ISCSIRemoteTarget[] getAll() {
        ISCSIRemoteTarget[] array = new ISCSIRemoteTarget[this.m_list.size()];
        return this.m_list.toArray(array);
    }

    public ISCSIRemoteTarget getRemoteTargetByAlias(String alias) throws RemoteException {
        for (int index = 0; index < this.m_list.size(); ++index) {
            ISCSIRemoteTarget target = this.m_list.get(index);
            if (!target.getAlias().equals(alias)) continue;
            return target;
        }
        return null;
    }

    public ISCSIRemoteTargetImpl getRemoteTargetByName(String name) {
        for (int index = 0; index < this.m_list.size(); ++index) {
            ISCSIRemoteTargetImpl target = this.m_list.get(index);
            if (!target.getName().equals(name)) continue;
            return target;
        }
        return null;
    }

    public boolean isNameExist(String name) {
        for (int index = 0; index < this.m_list.size(); ++index) {
            ISCSIRemoteTargetImpl target = this.m_list.get(index);
            if (!target.getName().equals(name)) continue;
            return true;
        }
        return false;
    }

    public ISCSIRemoteTarget getRemoteTargetByChapCredential(CHAPCredentialsImpl element) throws RemoteException {
        for (int index = 0; index < this.m_list.size(); ++index) {
            ISCSIRemoteTarget target = this.m_list.get(index);
            if (!((ISCSIRemoteTarget)((Object)element.getISCSIDevice())).equals(target)) continue;
            return target;
        }
        return null;
    }

    public synchronized int synchronize() throws RemoteException, IllegalValueException {
        StringBuffer errMsg = new StringBuffer();
        boolean errOccured = false;
        int retVal = 0;
        for (int index = 0; index < this.m_list.size(); ++index) {
            ISCSIRemoteTarget target = this.m_list.get(index);
            try {
                int targetRetVal = target.synchronize();
                if (targetRetVal <= retVal) continue;
                retVal = targetRetVal;
                continue;
            }
            catch (IllegalValueException ive) {
                errMsg.append("\n");
                errMsg.append(ive.getMessage());
                errOccured = true;
                theLogger.warn(SrLogCategories.LEGACY, ive, " when trying to synchronize ", target.getClassId(), " ", target);
            }
        }
        if (errOccured) {
            throw new IllegalValueException(errMsg.toString());
        }
        return retVal;
    }
}

