/*
 * Decompiled with CFR 0.152.
 */
package com.sanrad.nms.server.logic.target;

import com.sanrad.log.SrLogCategories;
import com.sanrad.log.SrLogger;
import com.sanrad.nms.server.alarm.AlarmGenerator;
import com.sanrad.nms.server.alarm.target.ISCSIRemoteTargetAlarmGenerator;
import com.sanrad.nms.server.logic.ClientParameterCode;
import com.sanrad.nms.server.logic.IllegalValueException;
import com.sanrad.nms.server.logic.InvalidElementException;
import com.sanrad.nms.server.logic.LogicMgrAOImpl;
import com.sanrad.nms.server.logic.SitesSynchronizeable;
import com.sanrad.nms.server.logic.cluster.ClusterImpl;
import com.sanrad.nms.server.logic.identity.CHAPCredentialsImpl;
import com.sanrad.nms.server.logic.identity.CredentialsValidator;
import com.sanrad.nms.server.logic.identity.Identity;
import com.sanrad.nms.server.logic.identity.IdentityImpl;
import com.sanrad.nms.server.logic.initiator.ISCSIInitiator;
import com.sanrad.nms.server.logic.initiator.ISCSIInitiatorImpl;
import com.sanrad.nms.server.logic.iscsi.ISCSISession;
import com.sanrad.nms.server.logic.scsi.RemoteTargetImpl;
import com.sanrad.nms.server.logic.storage.StorageImpl;
import com.sanrad.nms.server.logic.target.ISCSIRemoteTarget;
import com.sanrad.nms.server.logic.target.ISCSIRemoteTargetPortal;
import com.sanrad.nms.server.logic.target.ISCSIRemoteTargetPortalImpl;
import com.sanrad.nms.server.logic.target.ISCSIRemoteTargetPortalValidator;
import com.sanrad.nms.server.logic.target.ISCSITargetImpl;
import com.sanrad.nms.server.logic.vswitch.PortalTableRowImpl;
import com.sanrad.nms.server.logic.vswitch.VSwitch;
import com.sanrad.nms.server.logic.vswitch.VSwitchImpl;
import com.sanrad.nms.server.mgr.ConfigElementData;
import com.sanrad.nms.server.util.ClassID;
import com.sanrad.nms.server.util.CommKeyClassId;
import com.sanrad.nms.server.util.ParameterCode;
import com.sanrad.nms.server.util.types.ConfigElementDataList;
import com.sanrad.nms.server.util.types.SrGauge;
import com.sanrad.nms.server.util.types.SrInteger;
import com.sanrad.nms.server.util.types.SrIpAddress;
import com.sanrad.nms.server.util.types.SrString;
import com.sanrad.nms.server.util.types.SrType;
import com.sanrad.util.concurrent.CompleteFuture;
import com.sanrad.util.concurrent.DefaultFutureListener;
import com.sanrad.util.concurrent.ErrorAssertingListener;
import com.sanrad.util.concurrent.FailedFuture;
import com.sanrad.util.concurrent.SrFuture;
import java.math.BigInteger;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class ISCSIRemoteTargetImpl
extends RemoteTargetImpl
implements ISCSIRemoteTarget,
SitesSynchronizeable {
    private static final int PORTAL_AND_TAG_EXISTED = 1;
    private static final int PORTAL_ADDRESS_AND_PORT_ONLY_EXISTED = 0;
    private static final int PORTAL_NOT_EXISTED = -1;
    private ArrayList m_iscsiSessions = new ArrayList();
    private List<ISCSIRemoteTargetPortalImpl> myPortals = new ArrayList<ISCSIRemoteTargetPortalImpl>();
    private CHAPCredentialsImpl myChapCredentials;
    private ArrayList<PendingCreatedRemotePortal> myPendingCreatedRemotePortals = new ArrayList();
    private static SrLogger theLogger = SrLogger.getLogger();
    private static Map<ParameterCode, ParameterCode.Flags> theParameterCodeFlagsMap;

    public ISCSIRemoteTargetImpl(ClusterImpl cluster, ConfigElementData aCED) throws RemoteException, IllegalValueException, InvalidElementException {
        super(cluster, ClassID.ISCSI_REMOTE_TARGET, aCED);
        this.validateAndInit(aCED, theParameterCodeFlagsMap);
    }

    @Override
    public HashMap getClientParameterList() throws RemoteException {
        HashMap paramList = super.getClientParameterList();
        paramList.put(ClientParameterCode.ISCSI_REMOTE_TARGET_NUM_OF_PORTALS, this.getNumberOfPortals());
        return paramList;
    }

    @Override
    public SrFuture<Void> changeElement(HashMap parameterList) throws IllegalValueException {
        final SrFuture<Void> retFuture = new SrFuture<Void>("ISCSIRemoteTargetImpl.changeElement");
        final ArrayList<SrFuture<Void>> midFutures = new ArrayList<SrFuture<Void>>();
        Object chapUserName = parameterList.get(ClientParameterCode.ISCSI_REMOTE_TARGET_CHAP_USER_NAME);
        Object chapPassword = parameterList.get(ClientParameterCode.ISCSI_REMOTE_TARGET_CHAP_PASSWORD);
        boolean valuesChanged = false;
        HashMap map = new HashMap();
        if (chapUserName != null) {
            valuesChanged = true;
            map.put(ClientParameterCode.ISCSI_REMOTE_TARGET_CHAP_USER_NAME, chapUserName);
        }
        if (chapPassword != null) {
            valuesChanged = true;
            map.put(ClientParameterCode.ISCSI_REMOTE_TARGET_CHAP_PASSWORD, chapPassword);
        }
        if (this.myChapCredentials != null && valuesChanged) {
            midFutures.add(this.myChapCredentials.changeElement(map));
        } else {
            theLogger.warn(SrLogCategories.LEGACY, "CHAP Credentials of ", this.getClassId(), " ", this, " at cluster ", this.getCluster(), " is null - change cannot be made");
        }
        midFutures.add(super.changeElement(parameterList));
        Runnable toRun = new Runnable(){

            @Override
            public void run() {
                LogicMgrAOImpl.getInstance().updateFutureByGivenFutures(midFutures, retFuture);
            }
        };
        DefaultFutureListener.listenTo(toRun, midFutures);
        return retFuture;
    }

    @Override
    protected String isValid(HashMap parameterList) {
        String result = super.isValid(parameterList);
        if (result == null) {
            String userName = (String)parameterList.get(ClientParameterCode.ISCSI_REMOTE_TARGET_CHAP_USER_NAME);
            String password = (String)parameterList.get(ClientParameterCode.ISCSI_REMOTE_TARGET_CHAP_PASSWORD);
            IdentityImpl chapCredParentIdentity = null;
            if (this.myChapCredentials != null) {
                chapCredParentIdentity = this.myChapCredentials.getIdentityParent();
            }
            CredentialsValidator chapCredValidator = new CredentialsValidator(chapCredParentIdentity, ClassID.CHAP_CREDENTIALS, userName, password, false);
            if (userName != null) {
                result = chapCredValidator.isUserNameValid(userName);
                if (result != null) {
                    return result;
                }
                parameterList.put(ClientParameterCode.ISCSI_REMOTE_TARGET_CHAP_USER_NAME, new SrString(userName));
            }
            if (password != null) {
                result = chapCredValidator.isPasswordValid(userName);
                if (result != null) {
                    return result;
                }
                parameterList.put(ClientParameterCode.ISCSI_REMOTE_TARGET_CHAP_PASSWORD, new SrString(password));
            }
        }
        return result;
    }

    @Override
    public void clear() throws RemoteException {
        this.clearAllSessions();
        this.clearAllPortals();
        this.clearAllPendingCreatingRemotePortals();
        this.setCHAPCredentials(null);
        super.clear();
    }

    @Override
    protected String canBeDeleted() {
        String prefixMsg = "You cannot delete the remote target " + this.getName();
        if (this.isConnected()) {
            return prefixMsg + " because it is not disconnected.";
        }
        if (!this.isConfigured().booleanValue()) {
            return prefixMsg + " because it is not configured.";
        }
        if (this.areVolumesConnected()) {
            return prefixMsg + " because it has volumes connected.";
        }
        return null;
    }

    public SrFuture<Void> siteSynchronizationDelete() throws RemoteException, IllegalValueException {
        if (!this.areVolumesConnected()) {
            ConfigElementData ced = new ConfigElementData(this.getCommKeyClassId());
            return this.deleteElement(ced);
        }
        return new CompleteFuture<Void>("ISCSIRemoteTargetImpl.siteSynchronizationDelete");
    }

    @Override
    public AlarmGenerator getAlarmGenerator() {
        return ISCSIRemoteTargetAlarmGenerator.getInstance();
    }

    @Override
    public void registerToPropagatedStateChange() {
        this.cluster.addPropagationStateDependentObjectAndListener(this);
    }

    @Override
    public void syncDataWasChanged() throws RemoteException, IllegalValueException {
        theLogger.info(SrLogCategories.LEGACY, "syncDataWasChanged called  ", this.toString());
        if (!this.isSynchronizePending()) {
            return;
        }
        try {
            if (this.isNeedToSynchronize()) {
                this.synchronizeMe();
                return;
            }
        }
        catch (IllegalValueException ive) {
            theLogger.warn(SrLogCategories.LEGACY, ive);
            this.errorInSynchronizing();
            return;
        }
        this.doneSynchronizing();
    }

    @Override
    public int synchronize() throws RemoteException, IllegalValueException {
        theLogger.trace(SrLogCategories.LEGACY, "Start Sync of remote target ", this.getName());
        if (this.isSynchronizePending()) {
            theLogger.trace(SrLogCategories.LEGACY, "Already synchronizing ", this.getClassId(), " ", this.toString());
            return 1;
        }
        int retVal = 0;
        try {
            retVal = super.synchronize();
            theLogger.trace(SrLogCategories.LEGACY, "Sync of remote target ", this.getName(), " After Super completion status ", retVal);
            if (retVal != 3) {
                switch (retVal) {
                    case 3: {
                        this.setSynchronizePending(false);
                        break;
                    }
                    case 1: {
                        retVal = 2;
                    }
                }
            }
            if (!this.isNeedToSynchronize()) {
                retVal = this.synchronizePortals();
            }
            if (!this.isNeedToSynchronize()) {
                this.setSynchronizePending(false);
                return retVal;
            }
            theLogger.trace(SrLogCategories.LEGACY, "Sync of ISCSI remote target ", this.getName(), " SyncMe status ", retVal);
        }
        catch (IllegalValueException ive) {
            theLogger.warn(SrLogCategories.LEGACY, ive);
            this.setSynchronizePending(false);
            throw ive;
        }
        return retVal;
    }

    private int synchronizePortals() throws RemoteException, IllegalValueException {
        theLogger.trace(SrLogCategories.LEGACY, "Start Sync portals of remote target ", this.getName());
        int retVal = 0;
        StringBuffer errMsg = new StringBuffer();
        boolean errOccured = false;
        for (ISCSIRemoteTargetPortalImpl portal : this.myPortals) {
            try {
                int portalRetVal = portal.synchronize();
                theLogger.trace(SrLogCategories.LEGACY, "Sync of remote target ", this.getName(), " Portal ", portal, " status ", portalRetVal);
                if (portalRetVal <= retVal) continue;
                retVal = portalRetVal;
            }
            catch (IllegalValueException ive) {
                theLogger.warn(SrLogCategories.LEGACY, ive);
                errMsg.append(" \n");
                errMsg.append(ive.getMessage());
                errOccured = true;
            }
        }
        if (errOccured) {
            this.setSynchronizePending(false);
            throw new IllegalValueException(errMsg.toString());
        }
        return retVal;
    }

    @Override
    protected int synchronizeMe() throws RemoteException, IllegalValueException {
        if (this.canBeSynchronized() != null) {
            return 2;
        }
        if (super.isNeedToSynchronize()) {
            int retVal = this.createMeOnOtherVswitch();
            switch (retVal) {
                case 1: 
                case 2: {
                    retVal = 2;
                    break;
                }
                case 3: {
                    this.setSynchronizePending(false);
                }
            }
            return retVal;
        }
        return 0;
    }

    protected int createMeOnOtherVswitch() throws RemoteException, IllegalValueException {
        StorageImpl storage = this.cluster.getStorage();
        List<VSwitchImpl> vSwitchToSync = this.cluster.getOtherVSwitches(this.getVSwitches());
        VSwitch[] vswitch = new VSwitch[]{vSwitchToSync.get(0)};
        Identity myIdentity = this.getIdentity();
        String chapUserName = this.myChapCredentials != null ? this.myChapCredentials.getUserName() : null;
        ErrorAssertingListener.listenTo(storage.createISCSIRemoteTarget(this.getName(), this.getAlias(), myIdentity.getAlias(), chapUserName, "", this.getPortalsIPs(), this.getPortalsPorts(), this.getPortalsGroupTags(), false, vswitch));
        return 2;
    }

    @Override
    public ISCSIInitiator[] getAllConnectedInitiators() throws RemoteException {
        ArrayList<ISCSIInitiatorImpl> initiators = new ArrayList<ISCSIInitiatorImpl>();
        VSwitchImpl[] connectedVswitches = this.getConnectedVSwitches();
        for (int index = 0; index < connectedVswitches.length; ++index) {
            ISCSIInitiatorImpl initiator = this.getInitiator(connectedVswitches[index]);
            if (initiator == null) continue;
            initiators.add(initiator);
        }
        ISCSIInitiator[] array = new ISCSIInitiator[initiators.size()];
        return initiators.toArray(array);
    }

    public ISCSIInitiatorImpl getInitiator(VSwitch vswitch) throws RemoteException {
        CommKeyClassId scsiInitiatorParentKey = (CommKeyClassId)this.getSrValueOf(vswitch, ParameterCode.SCSI_INITIATOR_ID, false);
        CommKeyClassId iscsiInitiatorParentKey = this.cluster.getISCSIId(scsiInitiatorParentKey);
        ISCSIInitiatorImpl initiatorImpl = (ISCSIInitiatorImpl)this.cluster.getCommKeyRefMap().getRefByCommKeyClassID(iscsiInitiatorParentKey);
        return initiatorImpl;
    }

    public Identity getIdentity() throws RemoteException {
        CommKeyClassId targetIdentity = (CommKeyClassId)this.getSrValueOf(ParameterCode.IDENTITY_ID);
        Identity identity = (Identity)this.getCluster().getCommKeyRefMap().getRefByCommKeyClassID(targetIdentity);
        return identity;
    }

    @Override
    public String toString() {
        return this.getAlias();
    }

    @Override
    public BigInteger getNumberOfPortals() throws RemoteException {
        return new BigInteger(String.valueOf(this.myPortals.size()));
    }

    @Override
    public String getCHAPUserName() {
        return this.myChapCredentials == null ? null : this.myChapCredentials.getUserName();
    }

    @Override
    public ISCSISession[] getISCSISessions() throws RemoteException {
        ISCSISession[] array = new ISCSISession[this.m_iscsiSessions.size()];
        return this.m_iscsiSessions.toArray(array);
    }

    @Override
    public ISCSIRemoteTargetPortal[] getISCSIPortals() throws RemoteException {
        ISCSIRemoteTargetPortal[] array = new ISCSIRemoteTargetPortal[this.myPortals.size()];
        return this.myPortals.toArray(array);
    }

    @Override
    public SrFuture<Void> createISCSIRemoteTargetPortal(String ip, int port, int portalGroupTag) throws RemoteException, IllegalValueException {
        return this.createISCSIRemoteTargetPortal(ip, port, portalGroupTag, null);
    }

    public SrFuture<Void> createISCSIRemoteTargetPortal(String ip, int port, int portalGroupTag, CommKeyClassId remotePortalIdToRemoveIfNeeded) throws RemoteException, IllegalValueException {
        VSwitchImpl[] connectedVSwitches = this.getConnectedVSwitches();
        return this.createISCSIRemoteTargetPortal(ip, port, portalGroupTag, connectedVSwitches, remotePortalIdToRemoveIfNeeded);
    }

    public SrFuture<Void> createISCSIRemoteTargetPortal(String ip, int port, int portalGroupTag, VSwitchImpl[] vSwitches, CommKeyClassId remotePortalIdToRemoveIfNeeded) throws RemoteException, IllegalValueException {
        final SrFuture<Void> retFuture = new SrFuture<Void>("ISCSIRemoteTargetImpl.createISCSIRemoteTargetPortal");
        final ArrayList<SrFuture<Void>> midFutures = new ArrayList<SrFuture<Void>>();
        for (int index = 0; index < vSwitches.length; ++index) {
            VSwitchImpl currentVSwitch = vSwitches[index];
            boolean isRemotePortalCreatedOnPending = this.isRemotePortalCreatedOnPending(ip, port, currentVSwitch.getCommKeyClassId());
            if (isRemotePortalCreatedOnPending) continue;
            this.addPendingCreatedRemotePortal(ip, port, currentVSwitch.getCommKeyClassId());
            ConfigElementData element = this.createElementISCSIRemoteTargetPortal(ip, port, portalGroupTag, currentVSwitch, remotePortalIdToRemoveIfNeeded);
            midFutures.add(this.getCluster().createElement(element, ClassID.ISCSI_REMOTE_TARGET_PORTAL, ip + " : " + String.valueOf(port)));
        }
        Runnable toRun = new Runnable(){

            @Override
            public void run() {
                LogicMgrAOImpl.getInstance().updateFutureByGivenFutures(midFutures, retFuture);
            }
        };
        DefaultFutureListener.listenTo(toRun, midFutures);
        return retFuture;
    }

    public ConfigElementDataList createElementISCSIRemoteTargetPortal(String ip, int port, int portalGroupTag, CommKeyClassId remotePortalIdToRemoveIfNeeded) throws RemoteException, IllegalValueException {
        VSwitchImpl[] connectedVSwitches = this.getConnectedVSwitches();
        ConfigElementDataList elements = new ConfigElementDataList();
        for (int index = 0; index < connectedVSwitches.length; ++index) {
            elements.add(this.createElementISCSIRemoteTargetPortal(ip, port, portalGroupTag, connectedVSwitches[index], remotePortalIdToRemoveIfNeeded));
        }
        return elements;
    }

    public ConfigElementData createElementISCSIRemoteTargetPortal(String ip, int port, int portalGroupTag, VSwitchImpl vSwitch, CommKeyClassId remotePortalIdToRemoveIfNeeded) throws RemoteException, IllegalValueException {
        String[] ips = new String[1];
        BigInteger[] ports = new BigInteger[1];
        Integer[] groupTag = new Integer[1];
        ips[0] = ip;
        ports[0] = new BigInteger(String.valueOf(port));
        groupTag[0] = new Integer(portalGroupTag);
        ISCSIRemoteTargetPortalValidator validator = new ISCSIRemoteTargetPortalValidator(this, ips, ports, groupTag, vSwitch);
        if (!validator.isValid()) {
            throw new IllegalValueException(validator.getErrorMsg());
        }
        ConfigElementData element = new ConfigElementData(ClassID.ISCSI_REMOTE_TARGET_PORTAL);
        SrType[] vSwitchestoSet = new CommKeyClassId[]{vSwitch.getCommKeyClassId()};
        element.setValues(ParameterCode.VSWITCH_ID, vSwitchestoSet);
        element.setValue(ParameterCode.ISCSI_REMOTE_TARGET_ID, this.getCommKeyClassId());
        element.setValue(ParameterCode.ISCSI_REMOTE_TARGET_PORTAL_IP, new SrIpAddress(ip));
        element.setValue(ParameterCode.ISCSI_REMOTE_TARGET_PORTAL_PORT, new SrGauge(port));
        element.setValue(ParameterCode.ISCSI_REMOTE_TARGET_PORTAL_GROUP_TAG, new SrInteger(portalGroupTag));
        if (remotePortalIdToRemoveIfNeeded != null) {
            element.setValue(ParameterCode.ISCSI_REMOTE_TARGET_PORTAL_ID, remotePortalIdToRemoveIfNeeded);
        }
        return element;
    }

    private boolean hasPortals() {
        return this.myPortals.size() > 0;
    }

    private boolean areVolumesConnected() {
        return this.getCluster().getStorage().areVolumesConnectedToRemoteTarget(this.getName());
    }

    public void addSession(ISCSISession session) {
        this.m_iscsiSessions.add(session);
    }

    public void removeSession(ISCSISession session) {
        this.m_iscsiSessions.remove(session);
    }

    public void clearAllSessions() {
        this.m_iscsiSessions.clear();
    }

    public void addPortal(ISCSIRemoteTargetPortalImpl portal) throws RemoteException {
        this.myPortals.add(portal);
    }

    public SrFuture<Void> removePortal(ISCSIRemoteTargetPortal portal) throws RemoteException {
        this.myPortals.remove(portal);
        try {
            if (this.isInDeletionProcess() && this.hasPortals()) {
                ISCSIRemoteTargetPortal nextPortalToDelete = this.myPortals.get(0);
                return nextPortalToDelete.deleteElement();
            }
            if (this.isInDeletionProcess()) {
                ConfigElementData ced = new ConfigElementData(this.getCommKeyClassId());
                return this.deleteElement(ced);
            }
        }
        catch (IllegalValueException ive) {
            theLogger.logAndAssert(SrLogCategories.EXCEPTION, ive, "got an illegal value exception in the server.");
        }
        return new CompleteFuture<Void>("ISCSIRemoteTargetImpl.removePortal");
    }

    public void clearAllPortals() {
        this.myPortals.clear();
    }

    public int isPortalExisted(String ip, int port, int groupTag, VSwitchImpl vswitch) throws RemoteException {
        for (ISCSIRemoteTargetPortalImpl portal : this.myPortals) {
            List<VSwitchImpl> remotePortalConnectedVSwitches = portal.getConnectedVSwitchesAsList();
            if (vswitch != null && !remotePortalConnectedVSwitches.contains(vswitch)) {
                return -1;
            }
            String existedIP = portal.getIPAddress(vswitch);
            BigInteger existedPort = portal.getPort(vswitch);
            Integer existedTag = portal.getPortalGroupTag(vswitch);
            if (existedIP == null || !existedIP.equals(ip) || existedPort == null || existedPort.intValue() != port) continue;
            if (existedTag != null && existedTag == groupTag) {
                return 1;
            }
            return 0;
        }
        return -1;
    }

    public ISCSIRemoteTargetPortalImpl getPortalTableRow(String ip, int port, int groupTag) throws RemoteException {
        for (ISCSIRemoteTargetPortalImpl portal : this.myPortals) {
            if (!portal.getIPAddress().equals(ip) || portal.getPort().intValue() != port || portal.getPortalGroupTag() != groupTag) continue;
            return portal;
        }
        return null;
    }

    private String[] getPortalsIPs() throws RemoteException {
        String[] ips = new String[this.myPortals.size()];
        for (int index = 0; index < this.myPortals.size(); ++index) {
            ISCSIRemoteTargetPortal portal = this.myPortals.get(index);
            ips[index] = ((ISCSIRemoteTargetPortalImpl)portal).getIPAddress();
        }
        return ips;
    }

    private BigInteger[] getPortalsPorts() throws RemoteException {
        BigInteger[] ports = new BigInteger[this.myPortals.size()];
        int index = 0;
        for (ISCSIRemoteTargetPortalImpl portal : this.myPortals) {
            ports[index++] = portal.getPort();
        }
        return ports;
    }

    private Integer[] getPortalsGroupTags() throws RemoteException {
        Integer[] groupTags = new Integer[this.myPortals.size()];
        int index = 0;
        for (ISCSIRemoteTargetPortalImpl portal : this.myPortals) {
            groupTags[index++] = portal.getPortalGroupTag();
        }
        return groupTags;
    }

    private void addPendingCreatedRemotePortal(String ip, int port, CommKeyClassId vSwitchId) {
        PendingCreatedRemotePortal p = new PendingCreatedRemotePortal(ip, port, vSwitchId);
        this.myPendingCreatedRemotePortals.add(p);
    }

    public void removePendingCreatedRemotePortalIfNeeded(ISCSIRemoteTargetPortalImpl remotePortal, CommKeyClassId vSwitchId) throws RemoteException {
        Iterator<PendingCreatedRemotePortal> iter = this.myPendingCreatedRemotePortals.iterator();
        while (iter.hasNext()) {
            PendingCreatedRemotePortal p = iter.next();
            if (!p.isEquivalent(remotePortal.getIPAddress(), remotePortal.getPort().intValue(), vSwitchId)) continue;
            iter.remove();
        }
    }

    private boolean isRemotePortalCreatedOnPending(String ip, int port, CommKeyClassId vSwitchId) {
        for (PendingCreatedRemotePortal p : this.myPendingCreatedRemotePortals) {
            if (!p.isEquivalent(ip, port, vSwitchId)) continue;
            return true;
        }
        return false;
    }

    private void clearAllPendingCreatingRemotePortals() {
        this.myPendingCreatedRemotePortals.clear();
    }

    public void setCHAPCredentials(CHAPCredentialsImpl credentials) {
        this.myChapCredentials = credentials;
    }

    public CHAPCredentialsImpl getCHAPCredentials() {
        return this.myChapCredentials;
    }

    public boolean anyPortalsDefined() throws RemoteException {
        return this.myPortals.size() > 0;
    }

    public boolean anyPortalsDefined(VSwitchImpl vSwitch) {
        for (int index = 0; index < this.myPortals.size(); ++index) {
            ISCSIRemoteTargetPortalImpl portal = this.myPortals.get(index);
            if (!portal.isKnownByVSwitch(vSwitch)) continue;
            return true;
        }
        return false;
    }

    @Override
    public SrFuture<Void> synchronizeDiscoveryElementOnRemoteCluster(ClusterImpl remoteCluster) throws RemoteException {
        return new CompleteFuture<Void>("ISCSIRemoteTargetImpl.synchronizeDiscoveryElementOnRemoteCluster");
    }

    @Override
    public SrFuture<Void> synchronizeNewElementOnRemoteCluster(ClusterImpl remoteCluster) throws RemoteException {
        return new CompleteFuture<Void>("ISCSIRemoteTargetImpl.synchronizeNewElementOnRemoteCluster");
    }

    public SrFuture<Void> synchronizeNewElementOnRemoteCluster(ClusterImpl remoteCluster, VSwitchImpl[] createOnVSwiches) throws RemoteException {
        ArrayList<ClusterImpl> clustersInOtherSites = new ArrayList<ClusterImpl>(1);
        clustersInOtherSites.add(remoteCluster);
        ISCSITargetImpl equivalentLocalTarget = this.getCluster().findEquivLocalTargetOfRemoteTargetInRemoteClusters(clustersInOtherSites, this.getName());
        if (equivalentLocalTarget != null) {
            VSwitchImpl vswitch = equivalentLocalTarget.getExposedOnVSwitchObject();
            ArrayList<PortalTableRowImpl> localTargetPortals = remoteCluster.getAllTargetPortals(vswitch);
            return this.createAllLocalPortalsInRemoteCluster(localTargetPortals, createOnVSwiches);
        }
        return new CompleteFuture<Void>("ISCSIRemoteTargetImpl.synchronizeNewElementOnRemoteCluster");
    }

    @Override
    public void synchronizeChangeElementOnRemoteCluster(ClusterImpl remoteCluster, HashMap changedValues) throws RemoteException {
    }

    @Override
    public SrFuture<Void> synchronizePreRemoveElementOnRemoteCluster(ClusterImpl remoteCluster) throws RemoteException {
        return new CompleteFuture<Void>("ISCSIRemoteTargetImpl.synchronizePreRemoveElementOnRemoteCluster");
    }

    @Override
    public void synchronizePostRemoveElementOnRemoteCluster(ClusterImpl remoteCluster) throws RemoteException {
    }

    public SrFuture<Void> createLocalPortalInRemoteCluster(final PortalTableRowImpl portal, final VSwitchImpl[] createOnVSwitches) {
        final SrFuture<Void> retFuture = new SrFuture<Void>("ISCSIRemoteTargetImpl.createLocalPortalInRemoteCluster");
        SrFuture<Void> clearFuture = this.clearIrrelevantPortalsBeforeAddPortal(portal.getCluster());
        Runnable toRunAfterClear = new Runnable(){

            @Override
            public void run() {
                final ArrayList<SrFuture<Void>> midFutures = new ArrayList<SrFuture<Void>>();
                try {
                    String ip = portal.getIPAddress();
                    int port = portal.getPort();
                    if (portal.isIpTableRowExist()) {
                        int tag = portal.getTag();
                        if (createOnVSwitches != null) {
                            for (int index1 = 0; index1 < createOnVSwitches.length; ++index1) {
                                VSwitchImpl onVSwitch = createOnVSwitches[index1];
                                VSwitchImpl[] createOnVSwitch = new VSwitchImpl[]{onVSwitch};
                                int existed = ISCSIRemoteTargetImpl.this.isPortalExisted(ip, port, tag, onVSwitch);
                                if (existed == -1) {
                                    midFutures.add(ISCSIRemoteTargetImpl.this.createISCSIRemoteTargetPortal(ip, port, tag, createOnVSwitch, null));
                                    continue;
                                }
                                if (existed != 0) continue;
                                ISCSIRemoteTargetPortalImpl remotePortal = ISCSIRemoteTargetImpl.this.getExistedRemotePortal(ip, port, false, tag, null);
                                midFutures.add(ISCSIRemoteTargetImpl.this.createISCSIRemoteTargetPortal(ip, port, tag, createOnVSwitch, remotePortal.getCommKeyClassId()));
                            }
                        }
                    }
                }
                catch (IllegalValueException ive) {
                    theLogger.error(SrLogCategories.EXCEPTION, ive, "reach here only if the remote portal is already configured in the remote target - just continue with the next portal");
                }
                catch (RemoteException e) {
                    theLogger.error(SrLogCategories.EXCEPTION, e, new Object[0]);
                }
                Runnable toRun = new Runnable(){

                    @Override
                    public void run() {
                        LogicMgrAOImpl.getInstance().updateFutureByGivenFutures(midFutures, retFuture);
                    }
                };
                DefaultFutureListener.listenTo(toRun, midFutures);
            }
        };
        DefaultFutureListener.listenTo(toRunAfterClear, clearFuture);
        return retFuture;
    }

    private SrFuture<Void> clearIrrelevantPortalsBeforeAddPortal(ClusterImpl aLocalCluster) {
        VSwitchImpl localTargetVswitch;
        VSwitchImpl localOtherVswitch;
        final SrFuture<Void> retFuture = new SrFuture<Void>("ISCSIRemoteTargetImpl.createAllLocalPortalsInRemoteCluster");
        final ArrayList<SrFuture<Void>> midFutures = new ArrayList<SrFuture<Void>>();
        ISCSITargetImpl localTarget = aLocalCluster.getTargetListMgr().getTargetByName(this.getName());
        if (localTarget != null && (localOtherVswitch = aLocalCluster.getOtherVSwitch(localTargetVswitch = localTarget.getExposedOnVSwitchObject())) != null) {
            ArrayList<PortalTableRowImpl> localOtherVswitchPortals = aLocalCluster.getAllTargetPortals(localOtherVswitch);
            for (ISCSIRemoteTargetPortalImpl remotePortal : this.myPortals) {
                for (PortalTableRowImpl localPortal : localOtherVswitchPortals) {
                    if (!remotePortal.getIPAddress().equals(localPortal.getIPAddress())) continue;
                    try {
                        midFutures.add(remotePortal.deleteElement());
                    }
                    catch (IllegalValueException ive) {
                        theLogger.error(SrLogCategories.EXCEPTION, ive, new Object[0]);
                    }
                    catch (RemoteException e) {
                        theLogger.error(SrLogCategories.EXCEPTION, e, new Object[0]);
                    }
                }
            }
        }
        Runnable toRun = new Runnable(){

            @Override
            public void run() {
                LogicMgrAOImpl.getInstance().updateFutureByGivenFutures(midFutures, retFuture);
            }
        };
        DefaultFutureListener.listenTo(toRun, midFutures);
        return retFuture;
    }

    public SrFuture<Void> createAllLocalPortalsInRemoteCluster(ArrayList localPortalsToCreate, VSwitchImpl[] createOnVSwitches) throws RemoteException {
        final SrFuture<Void> retFuture = new SrFuture<Void>("ISCSIRemoteTargetImpl.createAllLocalPortalsInRemoteCluster");
        final ArrayList<SrFuture<Void>> midFutures = new ArrayList<SrFuture<Void>>();
        for (int index0 = 0; index0 < localPortalsToCreate.size(); ++index0) {
            PortalTableRowImpl portal = (PortalTableRowImpl)localPortalsToCreate.get(index0);
            midFutures.add(this.createLocalPortalInRemoteCluster(portal, createOnVSwitches));
        }
        Runnable toRun = new Runnable(){

            @Override
            public void run() {
                LogicMgrAOImpl.getInstance().updateFutureByGivenFutures(midFutures, retFuture);
            }
        };
        DefaultFutureListener.listenTo(toRun, midFutures);
        return retFuture;
    }

    @Override
    protected SrFuture<Void> deleteElement(ConfigElementData ced) throws IllegalValueException {
        final CompleteFuture<Void> retFuture = new CompleteFuture<Void>("ISCSIRemoteTargetImpl.deleteElement");
        if (!this.isInDeletionProcess()) {
            String msg = this.canBeDeleted();
            if (msg != null) {
                theLogger.trace(SrLogCategories.LEGACY, msg);
                throw new IllegalValueException(msg);
            }
            this.setInDeletionProcess(retFuture);
        }
        if (this.hasPortals()) {
            SrFuture<Void> tempPortalFuture;
            ISCSIRemoteTargetPortal portal = this.myPortals.get(0);
            try {
                tempPortalFuture = portal.deleteElement();
            }
            catch (RemoteException e) {
                tempPortalFuture = new FailedFuture<Void>(e, "ISCSIRemoteTargetImpl.deleteElement.failed");
                theLogger.error(SrLogCategories.EXCEPTION, e, "RemoteException was thrown inside a server context");
            }
            final SrFuture<Void> portalFuture = tempPortalFuture;
            Runnable toRun = new Runnable(){

                @Override
                public void run() {
                    LogicMgrAOImpl.getInstance().updateFutureByGivenFuture(portalFuture, retFuture);
                }
            };
            DefaultFutureListener.listenTo(toRun, portalFuture);
            return retFuture;
        }
        this.clearInDeletionProcess();
        final SrFuture<Void> delFuture = this.deleteElementFromDataMgr(ced);
        Runnable toRun = new Runnable(){

            @Override
            public void run() {
                LogicMgrAOImpl.getInstance().updateFutureByGivenFuture(delFuture, retFuture);
            }
        };
        DefaultFutureListener.listenTo(toRun, delFuture);
        return retFuture;
    }

    public ISCSIRemoteTargetPortalImpl getExistedRemotePortal(String ip, int port, boolean checkGroupTag, int groupTag, VSwitchImpl vswitch) throws RemoteException {
        for (int index = 0; index < this.myPortals.size(); ++index) {
            ISCSIRemoteTargetPortalImpl portal = this.myPortals.get(index);
            String existedIP = portal.getIPAddress(vswitch);
            BigInteger existedPort = portal.getPort(vswitch);
            Integer existedTag = portal.getPortalGroupTag(vswitch);
            if (existedIP == null || !existedIP.equals(ip) || existedPort == null || existedPort.intValue() != port) continue;
            if (checkGroupTag) {
                if (existedTag == null || existedTag != groupTag) continue;
                return portal;
            }
            return portal;
        }
        return null;
    }

    public ISCSITargetImpl getConfiguredAsLocalTargetOnSameCluster() throws RemoteException {
        ClusterImpl cluster = this.getCluster();
        ISCSITargetImpl target = cluster.getStorage().getTargetListMgr().getTargetByName(this.getName());
        return target;
    }

    @Override
    protected ArrayList<ParameterCode> getParamsForCreation() {
        ArrayList<ParameterCode> retVal = new ArrayList<ParameterCode>();
        retVal.add(ParameterCode.SCSI_REMOTE_TARGET_ALIAS);
        retVal.add(ParameterCode.ISCSI_REMOTE_TARGET_IDENTITY_ALIAS);
        retVal.add(ParameterCode.ISCSI_REMOTE_TARGET_CHAP_USER_NAME);
        retVal.add(ParameterCode.ISCSI_REMOTE_TARGET_CHAP_PASSWORD);
        retVal.add(ParameterCode.ISCSI_REMOTE_TARGET_PORTAL_IP);
        retVal.add(ParameterCode.ISCSI_REMOTE_TARGET_PORTAL_PORT);
        retVal.add(ParameterCode.ISCSI_REMOTE_TARGET_PORTAL_GROUP_TAG);
        return retVal;
    }

    static {
        HashMap<ParameterCode, ParameterCode.Flags> parameterCodeFlagsMap = new HashMap<ParameterCode, ParameterCode.Flags>();
        parameterCodeFlagsMap.put(ParameterCode.SCSI_INITIATOR_ID, new ParameterCode.Flags(true, false));
        parameterCodeFlagsMap.put(ParameterCode.IDENTITY_ID, new ParameterCode.Flags(true, false));
        parameterCodeFlagsMap.put(ParameterCode.ISCSI_REMOTE_TARGET_NUM_OF_PORTALS, new ParameterCode.Flags(true, false));
        theParameterCodeFlagsMap = Collections.unmodifiableMap(parameterCodeFlagsMap);
    }

    public class PendingCreatedRemotePortal {
        private String m_ip;
        private int m_port;
        private CommKeyClassId m_vSwitchId;

        public PendingCreatedRemotePortal(String ip, int port, CommKeyClassId vSwitchId) {
            this.m_ip = ip;
            this.m_port = port;
            this.m_vSwitchId = vSwitchId;
        }

        public boolean isEquivalent(String ip, int port, CommKeyClassId vSwitchId) {
            return ip.equals(this.m_ip) && port == this.m_port && vSwitchId.equals(this.m_vSwitchId);
        }

        public String toString() {
            StringBuffer sb = new StringBuffer(this.m_ip);
            sb.append(":");
            sb.append(this.m_port);
            sb.append(" on ");
            sb.append(this.m_vSwitchId.getClassID());
            sb.append(" ");
            sb.append(this.m_vSwitchId);
            return super.toString();
        }
    }
}

