/*
 * Decompiled with CFR 0.152.
 */
package com.sanrad.nms.server.logic.target;

import com.sanrad.nms.server.logic.ErrorMessage;
import com.sanrad.nms.server.logic.LogicObjectValidator;
import com.sanrad.nms.server.logic.initiator.ISCSIInitiatorImpl;
import com.sanrad.nms.server.util.ClassID;
import com.sanrad.util.NetUtil;
import java.rmi.RemoteException;

public class ISCSIRemoteDiscoveryPortalValidator
extends LogicObjectValidator {
    private ISCSIInitiatorImpl m_initiator;
    private String m_ip;
    private Integer m_port;

    public ISCSIRemoteDiscoveryPortalValidator(ISCSIInitiatorImpl initiator, String ip, Integer port) {
        this.m_initiator = initiator;
        this.m_ip = ip;
        this.m_port = port;
    }

    @Override
    public boolean isValid() throws RemoteException {
        try {
            if (!NetUtil.isNetworkIpValid(this.m_ip)) {
                this.setErrorMsg(ErrorMessage.IP_IS_NOT_VALID.getMessage(this.m_ip));
                return false;
            }
        }
        catch (IllegalArgumentException iae) {
            this.setErrorMsg(ErrorMessage.IP_IS_NOT_VALID.getMessage(this.m_ip));
            return false;
        }
        StringBuffer sb = new StringBuffer();
        sb.append(ClassID.ISCSI_REMOTE_DISCOVERY_PORTAL);
        sb.append(" ");
        sb.append(this.m_ip);
        if (this.m_initiator.isRemoteDiscoveryPortalExistedAsLocalIP(this.m_ip)) {
            sb.append(" already exists as a local IP");
            this.setErrorMsg(sb.toString());
            return false;
        }
        if (this.m_initiator.isRemoteDiscoveryPortalExistedAsRoutIP(this.m_ip)) {
            sb.append(" already exists as a rout IP");
            this.setErrorMsg(sb.toString());
            return false;
        }
        if (this.m_initiator.isRemoteDiscoveryPortalExistedAsLocalPortal(this.m_ip, this.m_port)) {
            sb.append(":");
            sb.append(this.m_port);
            sb.append(" already exists as a local portal");
            this.setErrorMsg(sb.toString());
            return false;
        }
        if (this.m_initiator.isRemoteDiscoveryPortalExistedAsSNMPManager(this.m_ip)) {
            sb.append(" already exists as an SNMP manager IP");
            this.setErrorMsg(sb.toString());
            return false;
        }
        if (this.m_initiator.isRemoteDiscoveryPortalExistedAsISNSServer(this.m_ip)) {
            sb.append(" already exists as an ISNS server IP");
            this.setErrorMsg(sb.toString());
            return false;
        }
        if (this.m_initiator.isRemoteDiscoveryPortalExistedAsRadiusServer(this.m_ip)) {
            sb.append(" already exists as a radius server IP");
            this.setErrorMsg(sb.toString());
            return false;
        }
        if (this.m_initiator.isRemoteDiscoveryPortalExistedAsNeighbor(this.m_ip)) {
            sb.append(" already exists as a neighbor IP");
            this.setErrorMsg(sb.toString());
            return false;
        }
        if (this.m_initiator.isRemoteDiscoveryPortalExisted(this.m_ip, this.m_port)) {
            sb.append(":");
            sb.append(this.m_port);
            sb.append(" already exists");
            this.setErrorMsg(sb.toString());
            return false;
        }
        return true;
    }
}

