/*
 * Decompiled with CFR 0.152.
 */
package com.sanrad.nms.server.logic.storage.pooling;

import com.sanrad.nms.server.logic.physstorage.DirectAccessDeviceImpl;
import com.sanrad.nms.server.logic.storage.pooling.StorageResource;
import com.sanrad.nms.server.logic.vswitch.VSwitchImpl;
import com.sanrad.util.Util;
import com.sanrad.util.filter.SrCompoundFilter;
import com.sanrad.util.filter.SrFilterSimpleRule;
import com.sanrad.util.filter.SrFilteredArrayList;
import java.util.ArrayList;
import java.util.List;

public class StorageResourceFilter {
    private ArrayList<StorageResource> myDisks;

    public StorageResourceFilter(List<StorageResource> aResources) {
        if (aResources == null || aResources.isEmpty()) {
            throw new IllegalArgumentException("Storage Resources must be supplied");
        }
        this.myDisks = new ArrayList<StorageResource>(aResources);
    }

    public List<StorageResource> getAttachToVswitchDisks(VSwitchImpl aAttachToVswitch, VSwitchImpl aExposedOn) {
        SrFilterSimpleRule filter = null;
        filter = aExposedOn != null ? new SrCompoundFilter(new RaidBelongingFilter(aAttachToVswitch), new ExposedOnFilter(aExposedOn)) : new RaidBelongingFilter(aAttachToVswitch);
        return this.getFilteredList(filter);
    }

    public List<StorageResource> getAttachToVswitchDisks(VSwitchImpl aAttachToVswitch) {
        return this.getAttachToVswitchDisks(aAttachToVswitch, null);
    }

    public List<StorageResource> getDisksExposedOn(VSwitchImpl aExposedOn) {
        return this.getFilteredList(new ExposedOnFilter(aExposedOn));
    }

    public List<StorageResource> getSameRaidDisks(String aEntityName) {
        return this.getFilteredList(new RaidFilter(aEntityName));
    }

    public List<StorageResource> getFilteredList(SrFilterSimpleRule<StorageResource> aFilter) {
        if (aFilter == null) {
            throw new IllegalArgumentException("Filter must be supplied");
        }
        SrFilteredArrayList<StorageResource> list = new SrFilteredArrayList<StorageResource>(this.myDisks);
        list.addRule(aFilter);
        return list.getAllOfMatched();
    }

    public List<DirectAccessDeviceImpl> getFilteredList(SrFilterSimpleRule<DirectAccessDeviceImpl> ... aFilters) {
        return this.getFilteredList(new SrFilterSimpleRule[]{new SrCompoundFilter<DirectAccessDeviceImpl>(aFilters)});
    }

    private static class RaidFilter
    extends SrFilterSimpleRule<StorageResource> {
        private String myWwn;

        RaidFilter(String aWwn) {
            if (aWwn == null) {
                throw new IllegalArgumentException("WWN must be supplied");
            }
            this.myWwn = aWwn;
        }

        @Override
        public boolean isValid(StorageResource aResource, Object ... aParams) {
            return this.myWwn.contains(aResource.getDisk().getEntityName());
        }
    }

    private static class ExposedOnFilter
    extends SrFilterSimpleRule<StorageResource> {
        private VSwitchImpl myExposedOnVswitch;

        ExposedOnFilter(VSwitchImpl aExposedOnVswitch) {
            if (aExposedOnVswitch == null) {
                throw new IllegalArgumentException("RAID attached V-Switch must be supplied");
            }
            this.myExposedOnVswitch = aExposedOnVswitch;
        }

        @Override
        public boolean isValid(StorageResource aDisk, Object ... aParams) {
            return aDisk.isExposedOnVswitch(this.myExposedOnVswitch) || aDisk.getExposedOnVswitches().isEmpty();
        }
    }

    private static class RaidBelongingFilter
    extends SrFilterSimpleRule<StorageResource> {
        private VSwitchImpl myAttachToVswitch;

        RaidBelongingFilter(VSwitchImpl aAttachToVswitch) {
            Util.validateInputNotNull(aAttachToVswitch, "RAID attached V-Switch");
            this.myAttachToVswitch = aAttachToVswitch;
        }

        @Override
        public boolean isValid(StorageResource aDisk, Object ... aParams) {
            return this.myAttachToVswitch.equals(aDisk.getRaidAttachedVswitch());
        }
    }
}

