/*
 * Decompiled with CFR 0.152.
 */
package com.sanrad.nms.server.logic.storage.pooling;

import com.sanrad.nms.server.logic.physstorage.DirectAccessDeviceImpl;
import com.sanrad.nms.server.logic.storage.pooling.StorageFilter;
import com.sanrad.nms.server.logic.storage.pooling.StorageResource;
import com.sanrad.nms.server.logic.vswitch.VSwitchImpl;
import com.sanrad.nms.server.util.AllocationPolicy;
import com.sanrad.nms.server.util.CommKeyClassId;
import com.sanrad.util.CompoundComparator;
import com.sanrad.util.Util;
import com.sanrad.util.virtualization.Allocable;
import com.sanrad.util.virtualization.AllocationUtil;
import java.math.BigInteger;
import java.util.Comparator;
import java.util.List;

public class StorageResourceComparator
implements Comparator<StorageResource> {
    private CompoundComparator<StorageResource> myComparator;

    public StorageResourceComparator(VSwitchImpl aRaidAttachedVswitch, VSwitchImpl aExposedOnVswitch, List<DirectAccessDeviceImpl> aAllDisks, AllocationPolicy aPolicy) {
        if (aExposedOnVswitch == null) {
            throw new IllegalArgumentException("Exposed-on V-Switch must be supplied");
        }
        if (aAllDisks == null) {
            throw new IllegalArgumentException("Disks must be supplied");
        }
        this.myComparator = new CompoundComparator(CompoundComparator.Mode.SIMPLE, new AllocationPolicyComparator(aPolicy), new ExposedOnComparator(aExposedOnVswitch), new RaidBelongingComparator(aRaidAttachedVswitch), new RaidSizeComparator(aAllDisks), new AllocableSizeComparator());
    }

    @Override
    public int compare(StorageResource o1, StorageResource o2) {
        return this.myComparator.compare(o1, o2);
    }

    public static class AllocableSizeComparator<T extends Allocable>
    implements Comparator<T> {
        @Override
        public int compare(T o1, T o2) {
            return o1.getAllocationSpace().compareTo(o2.getAllocationSpace());
        }
    }

    private static class AllocationPolicyComparator
    implements Comparator<StorageResource> {
        AllocationPolicy myPolicy;

        AllocationPolicyComparator(AllocationPolicy aPolicy) {
            Util.validateInputNotNull(aPolicy, "Volume Allocation Policy");
            this.myPolicy = aPolicy;
        }

        @Override
        public int compare(StorageResource o1, StorageResource o2) {
            boolean stor2Problematic;
            boolean stor1Forbidden = false;
            boolean stor2Forbidden = false;
            boolean stor1Allocated = false;
            boolean stor2Allocated = false;
            boolean stor1NotInList = false;
            boolean stor2NotInList = false;
            if (this.myPolicy.contains(AllocationPolicy.FORBIDDEN_STORAGES)) {
                List<CommKeyClassId> forbiddenResources = this.myPolicy.getStorageResources();
                stor1Forbidden = forbiddenResources.contains(o1.getDisk().getCommKeyClassId());
                stor2Forbidden = forbiddenResources.contains(o2.getDisk().getCommKeyClassId());
            }
            if (this.myPolicy.contains(AllocationPolicy.DONT_REUSE_ALLOCATED)) {
                stor1Allocated = o1.hasVirtualAllocations();
                stor2Allocated = o2.hasVirtualAllocations();
            }
            if (this.myPolicy.contains(AllocationPolicy.ALLOWED_STORAGES)) {
                List<CommKeyClassId> allowedResources = this.myPolicy.getStorageResources();
                stor1NotInList = !allowedResources.contains(o1.getDisk().getCommKeyClassId());
                stor2NotInList = !allowedResources.contains(o2.getDisk().getCommKeyClassId());
            }
            boolean stor1Problematic = stor1Forbidden || stor1Allocated || stor1NotInList;
            boolean bl = stor2Problematic = stor2Forbidden || stor2Allocated || stor2NotInList;
            if (stor1Problematic && !stor2Problematic) {
                return -1;
            }
            if (!stor1Problematic && stor2Problematic) {
                return 1;
            }
            return 0;
        }
    }

    public static class RaidSizeComparator
    implements Comparator<StorageResource> {
        private List<DirectAccessDeviceImpl> myAllDisks;

        public RaidSizeComparator(List<DirectAccessDeviceImpl> aAllDisks) {
            if (aAllDisks == null) {
                throw new IllegalArgumentException("Disks must be supplied");
            }
            this.myAllDisks = aAllDisks;
        }

        @Override
        public int compare(StorageResource o1, StorageResource o2) {
            BigInteger raidSize2;
            String entityName1 = o1.getDisk().getEntityName();
            String entityName2 = o2.getDisk().getEntityName();
            StorageFilter filter = new StorageFilter(this.myAllDisks);
            List<DirectAccessDeviceImpl> raidDisks1 = filter.getSameRaidDisks(entityName1);
            List<DirectAccessDeviceImpl> raidDisks2 = filter.getSameRaidDisks(entityName2);
            BigInteger raidSize1 = AllocationUtil.getMaxSize(raidDisks1);
            int sizeComparison = raidSize1.compareTo(raidSize2 = AllocationUtil.getMaxSize(raidDisks2));
            if (sizeComparison != 0) {
                return sizeComparison;
            }
            return entityName1.compareTo(entityName2);
        }
    }

    public static class RaidBelongingComparator
    implements Comparator<StorageResource> {
        private VSwitchImpl myRaidAttachedVswitch;

        RaidBelongingComparator(VSwitchImpl aRaidAttachedVswitch) {
            this.myRaidAttachedVswitch = aRaidAttachedVswitch;
        }

        @Override
        public int compare(StorageResource o1, StorageResource o2) {
            if (this.myRaidAttachedVswitch == null) {
                return 0;
            }
            VSwitchImpl attachToVswitch1 = o1.getRaidAttachedVswitch();
            VSwitchImpl attachToVswitch2 = o2.getRaidAttachedVswitch();
            if (this.myRaidAttachedVswitch.equals(attachToVswitch1) && !this.myRaidAttachedVswitch.equals(attachToVswitch2)) {
                return 1;
            }
            if (!this.myRaidAttachedVswitch.equals(attachToVswitch1) && this.myRaidAttachedVswitch.equals(attachToVswitch2)) {
                return -1;
            }
            return 0;
        }
    }

    public static class ExposedOnComparator
    implements Comparator<StorageResource> {
        private VSwitchImpl myExposedOnVswitch;

        ExposedOnComparator(VSwitchImpl aExposedOnVswitch) {
            if (aExposedOnVswitch == null) {
                throw new IllegalArgumentException("Exposed-on V-Switch must be supplied");
            }
            this.myExposedOnVswitch = aExposedOnVswitch;
        }

        @Override
        public int compare(StorageResource o1, StorageResource o2) {
            boolean match1 = o1.isExposedOnVswitch(this.myExposedOnVswitch);
            boolean match2 = o2.isExposedOnVswitch(this.myExposedOnVswitch);
            if (match1 && !match2) {
                return 1;
            }
            if (!match1 && match2) {
                return -1;
            }
            return 0;
        }
    }
}

