/*
 * Decompiled with CFR 0.152.
 */
package com.sanrad.nms.server.logic.storage.pooling;

import com.sanrad.log.SrLogCategories;
import com.sanrad.log.SrLogger;
import com.sanrad.nms.server.logic.physstorage.DirectAccessDeviceImpl;
import com.sanrad.nms.server.logic.storage.StoragePoolMgr;
import com.sanrad.nms.server.logic.storage.pooling.StorageAllocation;
import com.sanrad.nms.server.logic.storage.pooling.StorageFilter;
import com.sanrad.nms.server.logic.storage.pooling.StorageResource;
import com.sanrad.nms.server.logic.storage.pooling.StorageResourceComparator;
import com.sanrad.nms.server.logic.storage.pooling.StorageResourceFilter;
import com.sanrad.nms.server.logic.vswitch.VSwitchImpl;
import com.sanrad.nms.server.util.AllocationPolicy;
import com.sanrad.nms.server.util.types.constants.PhysicalStorageDriveTypeConstant;
import com.sanrad.nms.server.util.types.constants.PhysicalStorageRaidLevelConstant;
import com.sanrad.util.Util;
import com.sanrad.util.filter.SortKeyProvider;
import com.sanrad.util.filter.SrFilteredArrayList;
import com.sanrad.util.filter.SrSortingMap;
import com.sanrad.util.virtualization.Allocable;
import com.sanrad.util.virtualization.AllocableGroup;
import com.sanrad.util.virtualization.AllocationUtil;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class StoragePoolingTool {
    private static SrLogger theLogger = SrLogger.getLogger();
    private SrSortingMap<StorageSortKey, StorageResource> myAttachedResourcesMap = new SrSortingMap<StorageSortKey, StorageResource>(new StorageSortKeyProvider());
    private HashSet<Integer> myAttachedBlockSizes = new HashSet();
    private SrSortingMap<StorageSortKey, StorageResource> myNotAttachedResourcesMap = new SrSortingMap<StorageSortKey, StorageResource>(new StorageSortKeyProvider());
    private HashSet<Integer> myNotAttachedBlockSizes = new HashSet();

    public StoragePoolingTool(List<DirectAccessDeviceImpl> aAllDisks) {
        Util.validateInputNotNull(aAllDisks, "Disks");
        SrFilteredArrayList<DirectAccessDeviceImpl> filter = new SrFilteredArrayList<DirectAccessDeviceImpl>(aAllDisks);
        filter.addRule(new StorageFilter.RaidAttachedFilter());
        for (DirectAccessDeviceImpl disk : filter.getAllOfMatched()) {
            this.myAttachedResourcesMap.add(new StorageResource(disk));
            this.myAttachedBlockSizes.add(disk.getBlockSize());
        }
        for (DirectAccessDeviceImpl disk : filter.getAllOfUnMatched()) {
            this.myNotAttachedResourcesMap.add(new StorageResource(disk));
            this.myNotAttachedBlockSizes.add(disk.getBlockSize());
        }
    }

    public Map<StorageAllocation, BigInteger> allocate(PhysicalStorageDriveTypeConstant aDriveType, PhysicalStorageRaidLevelConstant aRaidLevel, Integer aBlockSize, BigInteger aSize, VSwitchImpl aRaidAttachedVswitch, VSwitchImpl aExposedOnVswitch) {
        return this.allocate(aDriveType, aRaidLevel, aBlockSize, aSize, aRaidAttachedVswitch, aExposedOnVswitch, AllocationPolicy.REUSE_ALLOCATED);
    }

    public Map<StorageAllocation, BigInteger> allocate(PhysicalStorageDriveTypeConstant aDriveType, PhysicalStorageRaidLevelConstant aRaidLevel, Integer aBlockSize, BigInteger aSize, VSwitchImpl aRaidAttachedVswitch, VSwitchImpl aExposedOnVswitch, AllocationPolicy aPolicy) {
        Util.validateInputNotNull(aDriveType, "Drive Type");
        Util.validateInputNotNull(aRaidLevel, "Raid Level");
        Util.validateInputNotNull(aBlockSize, "Block Size");
        Util.validateInputNotNull(aSize, "Size");
        Util.validateInputNotNull(aRaidAttachedVswitch, "RAID-attached V-Switch");
        Util.validateInputNotNull(aExposedOnVswitch, "Exposed-on V-Switch");
        StorageSortKey sortKey = new StorageSortKey(aDriveType, aRaidLevel, aBlockSize);
        List<StorageResource> resources = this.myAttachedResourcesMap.getGroup(sortKey);
        if (aPolicy != null && aPolicy.contains(AllocationPolicy.IGNORE_RAID_ATTACHMENT)) {
            resources.addAll(this.myNotAttachedResourcesMap.getGroup(sortKey));
        }
        if (resources == null) {
            return null;
        }
        return this.createAndSetAllocation(resources, aSize, aRaidAttachedVswitch, aExposedOnVswitch, aPolicy);
    }

    private Map<StorageAllocation, BigInteger> createAndSetAllocation(List<StorageResource> aResources, BigInteger aSize, VSwitchImpl aRaidAttachedVswitch, VSwitchImpl aExposedOnVswitch, AllocationPolicy aPolicy) {
        Util.validateInputNotNull(aResources, "Resources");
        Util.validateInputNotNull(aSize, "Size");
        Util.validateInputNotNull(aRaidAttachedVswitch, "RAID-attached V-Switch");
        Util.validateInputNotNull(aExposedOnVswitch, "Exposed-on V-Switch");
        if (aPolicy == null) {
            aPolicy = AllocationPolicy.REUSE_ALLOCATED;
        }
        if (aPolicy.contains(AllocationPolicy.EXTRA_BLOCK) && !aResources.isEmpty()) {
            Integer blockSize = aResources.get(0).getDisk().getBlockSize();
            aSize = aSize.add(new BigInteger(blockSize.toString()));
        }
        Collections.sort(aResources, new StorageResourceComparator(aRaidAttachedVswitch, aExposedOnVswitch, StoragePoolingTool.convertResourcesToDisks(aResources), aPolicy));
        Collections.reverse(aResources);
        Map<StorageResource, BigInteger> resourceToAllocationMap = AllocationUtil.getSimpleAllocation(aSize, aResources);
        if (resourceToAllocationMap == null) {
            return null;
        }
        if ((resourceToAllocationMap = AllocationUtil.filterAllocationBySize(resourceToAllocationMap, new BigInteger(String.valueOf(aResources.get(0).getDisk().getBlockSize())))).isEmpty()) {
            return null;
        }
        HashMap<StorageAllocation, BigInteger> allocationMap = new HashMap<StorageAllocation, BigInteger>();
        for (StorageResource storage : resourceToAllocationMap.keySet()) {
            BigInteger size = resourceToAllocationMap.get(storage);
            StorageAllocation alloc = storage.allocateVirtualSpace(size, aExposedOnVswitch);
            allocationMap.put(alloc, size);
        }
        return allocationMap;
    }

    public List<Map<StorageAllocation, BigInteger>> allocateMirror(PhysicalStorageDriveTypeConstant aDriveType, PhysicalStorageRaidLevelConstant aRaidLevel, Integer aBlockSize, BigInteger aSize, VSwitchImpl aRaidAttachedVswitch) {
        Util.validateInputNotNull(aDriveType, "Drive Type");
        Util.validateInputNotNull(aRaidLevel, "Raid Level");
        Util.validateInputNotNull(aBlockSize, "Block Size");
        Util.validateInputNotNull(aSize, "Size");
        Util.validateInputNotNull(aRaidAttachedVswitch, "RAID-attached V-Switch");
        ArrayList<StorageResource> resources = new ArrayList<StorageResource>();
        List<StorageResource> tempList = this.myAttachedResourcesMap.getGroup(new StorageSortKey(aDriveType, aRaidLevel, aBlockSize));
        if (tempList == null) {
            return null;
        }
        resources.addAll(tempList);
        List<Map<StorageAllocation, BigInteger>> mirrAlloc = this.allocateMirrorBetweenRaids(resources, aSize, aRaidAttachedVswitch, true, false);
        if (mirrAlloc != null) {
            theLogger.trace(SrLogCategories.STORAGE_ALLOCATION, "Mirror allocated on metro-cluster RAIDs, using exposed-on-consistent disks");
        }
        if (mirrAlloc == null) {
            mirrAlloc = this.allocateMirrorBetweenRaids(resources, aSize, aRaidAttachedVswitch, false, false);
            theLogger.trace(SrLogCategories.STORAGE_ALLOCATION, "Mirror allocated on metro-cluster RAIDs, using exposed-on-not-consistent disks");
        }
        if (mirrAlloc == null) {
            mirrAlloc = this.allocateMirrorBetweenRaids(resources, aSize, aRaidAttachedVswitch, true, true);
            theLogger.trace(SrLogCategories.STORAGE_ALLOCATION, "Mirror allocated on one V-Switch RAIDs, using exposed-on-consistent disks");
        }
        if (mirrAlloc == null) {
            mirrAlloc = this.allocateMirrorBetweenRaids(resources, aSize, aRaidAttachedVswitch, false, true);
            theLogger.trace(SrLogCategories.STORAGE_ALLOCATION, "Mirror allocated on one V-Switch RAIDs, using exposed-on-not-consistent disks");
        }
        if (mirrAlloc == null) {
            ArrayList<Map<StorageAllocation, BigInteger>> tempAllocList = new ArrayList<Map<StorageAllocation, BigInteger>>();
            Map<StorageAllocation, BigInteger> firstMirrLeg = this.allocate(aDriveType, aRaidLevel, aBlockSize, aSize, aRaidAttachedVswitch, aRaidAttachedVswitch, AllocationPolicy.DONT_REUSE_ALLOCATED);
            if (firstMirrLeg == null) {
                return null;
            }
            Map<StorageAllocation, BigInteger> secondMirrLeg = this.allocate(aDriveType, aRaidLevel, aBlockSize, aSize, aRaidAttachedVswitch, aRaidAttachedVswitch, AllocationPolicy.DONT_REUSE_ALLOCATED);
            if (secondMirrLeg == null) {
                for (StorageAllocation alloc : firstMirrLeg.keySet()) {
                    alloc.getResource().freeLastAllocation();
                }
                return null;
            }
            tempAllocList.add(firstMirrLeg);
            tempAllocList.add(secondMirrLeg);
            mirrAlloc = tempAllocList;
        }
        return mirrAlloc;
    }

    public List<DirectAccessDeviceImpl> getAllDisks(PhysicalStorageDriveTypeConstant aDriveType, PhysicalStorageRaidLevelConstant aRaidLevel, Integer aBlockSize, AllocationPolicy aPolicy) {
        List<StorageResource> notAttachedList;
        Util.validateInputNotNull(aDriveType, "Drive Type");
        Util.validateInputNotNull(aRaidLevel, "Raid Level");
        Util.validateInputNotNull(aBlockSize, "Block Size");
        ArrayList<DirectAccessDeviceImpl> retList = new ArrayList<DirectAccessDeviceImpl>();
        StorageSortKey key = new StorageSortKey(aDriveType, aRaidLevel, aBlockSize);
        List<StorageResource> attachedList = this.myAttachedResourcesMap.getGroup(key);
        if (attachedList != null) {
            retList.addAll(StoragePoolingTool.convertResourcesToDisks(attachedList));
        }
        if ((notAttachedList = this.myNotAttachedResourcesMap.getGroup(key)) != null) {
            retList.addAll(StoragePoolingTool.convertResourcesToDisks(notAttachedList));
        }
        return retList;
    }

    public Set<Integer> getBlockSizes(AllocationPolicy aPolicy) {
        HashSet<Integer> retValue = new HashSet<Integer>(this.myAttachedBlockSizes);
        if (aPolicy != null && aPolicy.contains(AllocationPolicy.IGNORE_RAID_ATTACHMENT)) {
            retValue.addAll(this.myNotAttachedBlockSizes);
        }
        return retValue;
    }

    private List<Map<StorageAllocation, BigInteger>> allocateMirrorBetweenRaids(List<StorageResource> aAllDisks, BigInteger aSize, VSwitchImpl aRaidAttachedVswitch, boolean aUseMatchingExposedOnDisks, boolean aAllowBetweenSameVswitchRaids) {
        Util.validateInputNotNull(aAllDisks, "Resources");
        Util.validateInputNotNull(aSize, "Size");
        Util.validateInputNotNull(aRaidAttachedVswitch, "RAID-attached V-Switch");
        StorageResourceFilter filter = new StorageResourceFilter(aAllDisks);
        VSwitchImpl exposedOnVswitchForFilter = aUseMatchingExposedOnDisks ? aRaidAttachedVswitch : null;
        List<StorageResource> raidAttachedVswitchDisks = filter.getAttachToVswitchDisks(aRaidAttachedVswitch, exposedOnVswitchForFilter);
        VSwitchImpl otherRaidAttachedVswitch = aRaidAttachedVswitch.getCluster().getOtherVSwitch(aRaidAttachedVswitch);
        List<Object> otherRaidAttachedVswitchDisks = null;
        if (otherRaidAttachedVswitch != null) {
            otherRaidAttachedVswitchDisks = filter.getAttachToVswitchDisks(otherRaidAttachedVswitch, exposedOnVswitchForFilter);
        } else {
            otherRaidAttachedVswitchDisks = new ArrayList();
            otherRaidAttachedVswitch = aRaidAttachedVswitch;
        }
        if (aAllowBetweenSameVswitchRaids) {
            if (!raidAttachedVswitchDisks.isEmpty()) {
                List<AllocableGroup> localRaids = StoragePoolMgr.sort(raidAttachedVswitchDisks, new SortKeyProvider<String, StorageResource>(){

                    @Override
                    public String getSortBy(StorageResource aValue) {
                        return aValue.getDisk().getEntityName();
                    }
                });
                Collections.sort(localRaids, new StorageResourceComparator.AllocableSizeComparator());
                Collections.reverse(localRaids);
                raidAttachedVswitchDisks.retainAll(localRaids.get(0).getAllDisks());
            }
            if (!otherRaidAttachedVswitchDisks.isEmpty()) {
                List<AllocableGroup> remoteRaids = StoragePoolMgr.sort(otherRaidAttachedVswitchDisks, new SortKeyProvider<String, StorageResource>(){

                    @Override
                    public String getSortBy(StorageResource aValue) {
                        return aValue.getDisk().getEntityName();
                    }
                });
                Collections.sort(remoteRaids, new StorageResourceComparator.AllocableSizeComparator());
                Collections.reverse(remoteRaids);
                otherRaidAttachedVswitchDisks.retainAll(remoteRaids.get(0).getAllDisks());
            }
        }
        BigInteger raidSize = AllocationUtil.getMaxSize(raidAttachedVswitchDisks);
        BigInteger otherRaidSize = AllocationUtil.getMaxSize(otherRaidAttachedVswitchDisks);
        List<StorageResource> otherDisks = aUseMatchingExposedOnDisks ? filter.getDisksExposedOn(aRaidAttachedVswitch) : new ArrayList<StorageResource>(aAllDisks);
        otherDisks.removeAll(raidAttachedVswitchDisks);
        otherDisks.removeAll(otherRaidAttachedVswitchDisks);
        List<AllocableGroup> otherRaids = StoragePoolMgr.sort(otherDisks, new SortKeyProvider<String, StorageResource>(){

            @Override
            public String getSortBy(StorageResource aValue) {
                return aValue.getDisk().getEntityName();
            }
        });
        List otherRaidsAllocables = Util.convertListType(otherRaids);
        final BigInteger raidsDifference = raidSize.subtract(otherRaidSize);
        Allocable raidsDifferenceAlloc = new Allocable(){

            @Override
            public BigInteger getAllocationSpace() {
                return raidsDifference.abs();
            }
        };
        otherRaidsAllocables.add(raidsDifferenceAlloc);
        List<List<Allocable>> tempMirrorSplits = AllocationUtil.getMaxMirrorSizeSplitting(otherRaidsAllocables);
        AllocableGroup bigRaidLegGroup = new AllocableGroup();
        AllocableGroup smallRaidLegGroup = new AllocableGroup();
        for (List<Allocable> mirrorSplit : tempMirrorSplits) {
            if (mirrorSplit.contains(raidsDifferenceAlloc)) {
                mirrorSplit.remove(raidsDifferenceAlloc);
                bigRaidLegGroup.addAll(mirrorSplit);
                continue;
            }
            smallRaidLegGroup.addAll(mirrorSplit);
        }
        List bigLegDisks = bigRaidLegGroup.getAllDisks();
        List smallLegDisks = smallRaidLegGroup.getAllDisks();
        if (raidsDifference.signum() >= 0) {
            raidAttachedVswitchDisks.addAll(bigLegDisks);
            otherRaidAttachedVswitchDisks.addAll(smallLegDisks);
        } else {
            otherRaidAttachedVswitchDisks.addAll(bigLegDisks);
            raidAttachedVswitchDisks.addAll(smallLegDisks);
        }
        BigInteger mirrLegMaxSize = AllocationUtil.getMaxSize(raidAttachedVswitchDisks);
        BigInteger otherMirrLegMaxSize = AllocationUtil.getMaxSize(otherRaidAttachedVswitchDisks);
        if (mirrLegMaxSize.compareTo(aSize) >= 0 && otherMirrLegMaxSize.compareTo(aSize) >= 0) {
            Map<StorageAllocation, BigInteger> mirrorLegAlloc = this.createAndSetAllocation(raidAttachedVswitchDisks, aSize, aRaidAttachedVswitch, aRaidAttachedVswitch, null);
            Map<StorageAllocation, BigInteger> otherMirrorLegAlloc = this.createAndSetAllocation(otherRaidAttachedVswitchDisks, aSize, otherRaidAttachedVswitch, aRaidAttachedVswitch, null);
            ArrayList<Map<StorageAllocation, BigInteger>> result = new ArrayList<Map<StorageAllocation, BigInteger>>();
            result.add(mirrorLegAlloc);
            result.add(otherMirrorLegAlloc);
            return result;
        }
        return null;
    }

    private static List<DirectAccessDeviceImpl> convertResourcesToDisks(List<StorageResource> aResources) {
        Util.validateInputNotNull(aResources, "Resources");
        ArrayList<DirectAccessDeviceImpl> disks = new ArrayList<DirectAccessDeviceImpl>();
        for (StorageResource resource : aResources) {
            disks.add(resource.getDisk());
        }
        return disks;
    }

    private static class StorageSortKeyProvider
    implements SortKeyProvider<StorageSortKey, StorageResource> {
        private StorageSortKeyProvider() {
        }

        @Override
        public StorageSortKey getSortBy(StorageResource aValue) {
            DirectAccessDeviceImpl disk = aValue.getDisk();
            return new StorageSortKey(disk.getDriveType(), disk.getRaidLevel(), disk.getBlockSize());
        }
    }

    private static class StorageSortKey {
        ArrayList<Object> myAttrList = new ArrayList();

        StorageSortKey(PhysicalStorageDriveTypeConstant aDriveType, PhysicalStorageRaidLevelConstant aRaidLevel, Integer aBlockSize) {
            Util.validateInputNotNull(aDriveType, "Drive Type");
            Util.validateInputNotNull(aRaidLevel, "Raid Level");
            Util.validateInputNotNull(aBlockSize, "Block Size");
            this.myAttrList.add(aDriveType);
            this.myAttrList.add(aRaidLevel);
            this.myAttrList.add(aBlockSize);
        }

        public boolean equals(Object o) {
            if (o instanceof StorageSortKey) {
                StorageSortKey other = (StorageSortKey)o;
                return this.myAttrList.equals(other.myAttrList);
            }
            return false;
        }

        public String toString() {
            return "StorageSortKey:" + this.myAttrList.toString();
        }

        public int hashCode() {
            return this.toString().hashCode();
        }
    }
}

