/*
 * Decompiled with CFR 0.152.
 */
package com.sanrad.nms.server.logic.storage.pooling;

import com.sanrad.nms.server.logic.cluster.ClusterImpl;
import com.sanrad.nms.server.logic.dr.DRRootImpl;
import com.sanrad.nms.server.logic.physstorage.DirectAccessDeviceImpl;
import com.sanrad.nms.server.logic.storage.StoragePoolMgr;
import com.sanrad.nms.server.logic.vswitch.VSwitchImpl;
import com.sanrad.nms.server.util.types.constants.PhysicalStorageRaidLevelConstant;
import com.sanrad.util.filter.SrCompoundFilter;
import com.sanrad.util.filter.SrFilterSimpleRule;
import com.sanrad.util.filter.SrFilteredArrayList;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.List;

public class StorageFilter {
    private ArrayList<DirectAccessDeviceImpl> myDisks;

    public StorageFilter(List<DirectAccessDeviceImpl> aDisks) {
        if (aDisks == null) {
            throw new IllegalArgumentException("Disks must be supplied");
        }
        this.myDisks = new ArrayList<DirectAccessDeviceImpl>(aDisks);
    }

    public List<DirectAccessDeviceImpl> getAttachToVswitchDisks(VSwitchImpl aAttachToVswitch, VSwitchImpl aExposedOn) {
        SrFilterSimpleRule filter = null;
        filter = aExposedOn != null ? new SrCompoundFilter(new RaidBelongingFilter(aAttachToVswitch), new ExposedOnFilter(aExposedOn)) : new RaidBelongingFilter(aAttachToVswitch);
        return this.getFilteredList((SrFilterSimpleRule<DirectAccessDeviceImpl>)filter);
    }

    public List<DirectAccessDeviceImpl> getAttachToVswitchDisks(VSwitchImpl aAttachToVswitch) {
        return this.getAttachToVswitchDisks(aAttachToVswitch, null);
    }

    public List<DirectAccessDeviceImpl> getDisksExposedOn(VSwitchImpl aExposedOn) {
        return this.getFilteredList((SrFilterSimpleRule<DirectAccessDeviceImpl>)new ExposedOnFilter(aExposedOn));
    }

    public List<DirectAccessDeviceImpl> getSameRaidDisks(String aEntityName) {
        return this.getFilteredList((SrFilterSimpleRule<DirectAccessDeviceImpl>)new RaidFilter(aEntityName));
    }

    public List<DirectAccessDeviceImpl> getAvailableForAllocDisks() {
        return this.getFilteredList((SrFilterSimpleRule<DirectAccessDeviceImpl>)new AllocableDisksFilter());
    }

    public List<DirectAccessDeviceImpl> getFilteredList(SrFilterSimpleRule<DirectAccessDeviceImpl> aFilter) {
        if (aFilter == null) {
            throw new IllegalArgumentException("Filter must be supplied");
        }
        SrFilteredArrayList<DirectAccessDeviceImpl> list = new SrFilteredArrayList<DirectAccessDeviceImpl>(this.myDisks);
        list.addRule(aFilter);
        return list.getAllOfMatched();
    }

    public List<DirectAccessDeviceImpl> getFilteredList(SrFilterSimpleRule<DirectAccessDeviceImpl> ... aFilters) {
        return this.getFilteredList((SrFilterSimpleRule<DirectAccessDeviceImpl>)new SrCompoundFilter<DirectAccessDeviceImpl>(aFilters));
    }

    public static class RaidAttachedFilter
    extends SrFilterSimpleRule<DirectAccessDeviceImpl> {
        @Override
        public boolean isValid(DirectAccessDeviceImpl aNewObject, Object ... aParams) {
            ClusterImpl cluster = aNewObject.getCluster();
            boolean isRaidAttached = cluster.getAttachedRaidsMgr().getRaidByStorageEntityName(aNewObject.getEntityNameValue()) != null;
            return isRaidAttached;
        }
    }

    public static class AllocableDisksFilter
    extends SrFilterSimpleRule<DirectAccessDeviceImpl> {
        @Override
        public boolean isValid(DirectAccessDeviceImpl aNewObject, Object ... aParams) {
            boolean isEnabled = aNewObject.isEnabled();
            boolean isGDRUsed = DRRootImpl.getInstance().isUsedByPair(aNewObject);
            ClusterImpl cluster = aNewObject.getCluster();
            boolean hasFreeSpace = BigInteger.ZERO.compareTo(aNewObject.getAllocationSpace()) < 0;
            return isEnabled && !isGDRUsed && hasFreeSpace;
        }
    }

    public static class RaidLevelFilter
    extends SrFilterSimpleRule<DirectAccessDeviceImpl> {
        private PhysicalStorageRaidLevelConstant myRaidLevel;

        public RaidLevelFilter(PhysicalStorageRaidLevelConstant aRaidLevel) {
            this.myRaidLevel = aRaidLevel;
        }

        @Override
        public boolean isValid(DirectAccessDeviceImpl aDisk, Object ... aParams) {
            return this.myRaidLevel == null || this.myRaidLevel.equals(aDisk.getRaidLevel());
        }
    }

    private static class RaidFilter
    extends SrFilterSimpleRule<DirectAccessDeviceImpl> {
        private String myWwn;

        RaidFilter(String aWwn) {
            if (aWwn == null) {
                throw new IllegalArgumentException("WWN must be supplied");
            }
            this.myWwn = aWwn;
        }

        @Override
        public boolean isValid(DirectAccessDeviceImpl aDisk, Object ... aParams) {
            return this.myWwn.contains(aDisk.getEntityName());
        }
    }

    private static class ExposedOnFilter
    extends SrFilterSimpleRule<DirectAccessDeviceImpl> {
        private VSwitchImpl myExposedOnVswitch;

        ExposedOnFilter(VSwitchImpl aExposedOnVswitch) {
            if (aExposedOnVswitch == null) {
                throw new IllegalArgumentException("RAID attached V-Switch must be supplied");
            }
            this.myExposedOnVswitch = aExposedOnVswitch;
        }

        @Override
        public boolean isValid(DirectAccessDeviceImpl aDisk, Object ... aParams) {
            return aDisk.isExposedOnVswitch(this.myExposedOnVswitch);
        }
    }

    private static class RaidBelongingFilter
    extends SrFilterSimpleRule<DirectAccessDeviceImpl> {
        private VSwitchImpl myAttachToVswitch;

        RaidBelongingFilter(VSwitchImpl aAttachToVswitch) {
            if (aAttachToVswitch == null) {
                throw new IllegalArgumentException("RAID attached V-Switch must be supplied");
            }
            this.myAttachToVswitch = aAttachToVswitch;
        }

        @Override
        public boolean isValid(DirectAccessDeviceImpl aDisk, Object ... aParams) {
            ClusterImpl cluster = this.myAttachToVswitch.getCluster();
            VSwitchImpl attachToVswitch = StoragePoolMgr.getRaidAttachedVswitch(cluster, aDisk.getEntityNameValue());
            return this.myAttachToVswitch.equals(attachToVswitch);
        }
    }
}

