/*
 * Decompiled with CFR 0.152.
 */
package com.sanrad.nms.server.logic.storage;

import com.sanrad.log.SrLogCategories;
import com.sanrad.log.SrLogger;
import com.sanrad.nms.server.logic.CommKeyRefMap;
import com.sanrad.nms.server.logic.IllegalValueException;
import com.sanrad.nms.server.logic.InvalidElementException;
import com.sanrad.nms.server.logic.cluster.ClusterImpl;
import com.sanrad.nms.server.logic.dr.DRRootImpl;
import com.sanrad.nms.server.logic.physstorage.DirectAccessDeviceImpl;
import com.sanrad.nms.server.logic.physstorage.GeneralSCSIDevice;
import com.sanrad.nms.server.logic.physstorage.GeneralSCSIDeviceImpl;
import com.sanrad.nms.server.logic.physstorage.LUIdentifierImpl;
import com.sanrad.nms.server.logic.physstorage.Storageable;
import com.sanrad.nms.server.logic.vswitch.VSwitchImpl;
import com.sanrad.nms.server.mgr.ConfigElementData;
import com.sanrad.nms.server.util.ClassID;
import com.sanrad.nms.server.util.CommKeyClassId;
import com.sanrad.nms.server.util.ParameterCode;
import com.sanrad.nms.server.util.types.SrEntityNameFormat;
import com.sanrad.nms.server.util.types.SrInteger;
import com.sanrad.nms.server.util.types.SrLunFormat;
import com.sanrad.nms.server.util.types.SrString;
import com.sanrad.nms.server.util.types.constants.PhysStorTransportTypeConstant;
import com.sanrad.nms.server.util.types.constants.PhysicalStorageDriveTypeConstant;
import com.sanrad.nms.server.util.types.constants.PhysicalStorageTypeConstant;
import com.sanrad.util.Util;
import com.sanrad.util.filter.SrFilterSimpleRule;
import com.sanrad.util.filter.SrFilteredArrayList;
import java.math.BigInteger;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Vector;

public class StoragePool {
    private ArrayList<GeneralSCSIDeviceImpl> myPool = new ArrayList();
    private static SrLogger theLogger = SrLogger.getLogger();
    private static final int IBM_RAID_WWN_LENGTH = 16;

    public BigInteger getTotalCapacity() {
        BigInteger capacity = BigInteger.ZERO;
        for (GeneralSCSIDeviceImpl storage : this.getAll()) {
            BigInteger total = storage.getTotalSpace();
            if (total == null) continue;
            capacity = capacity.add(storage.getTotalSpace());
        }
        return capacity;
    }

    public boolean addStorage(GeneralSCSIDeviceImpl storage) {
        this.myPool.add(storage);
        return true;
    }

    public boolean isContain(GeneralSCSIDeviceImpl storage) {
        return this.myPool.contains(storage);
    }

    public boolean removeStorage(GeneralSCSIDeviceImpl storage) {
        return this.myPool.remove(storage);
    }

    public void storageChanged(GeneralSCSIDeviceImpl storage) throws RemoteException, IllegalValueException, InvalidElementException {
        if (storage == null) {
            return;
        }
        ClusterImpl cluster = storage.getCluster();
        GeneralSCSIDeviceImpl matchDevice = this.getMatchingSCSIDevice(storage);
        if (matchDevice != null) {
            int noOfConnectedVSwitches = cluster.getConnectedVSwitches().length;
            List<VSwitchImpl> storageVSwitches = storage.getConnectedVSwitchesAsList();
            List<VSwitchImpl> matchDeviceVSwitches = matchDevice.getConnectedVSwitchesAsList();
            boolean complementaryElements = storageVSwitches.size() < noOfConnectedVSwitches && matchDeviceVSwitches.size() < noOfConnectedVSwitches && !storageVSwitches.containsAll(matchDeviceVSwitches);
            matchDevice = this.getMatchingSCSIDevice(storage);
            if (complementaryElements) {
                matchDevice.merge(storage);
                DRRootImpl.getInstance().notifyVolumeReplaced(storage, matchDevice);
            }
        }
    }

    private GeneralSCSIDeviceImpl getMatchingSCSIDevice(GeneralSCSIDeviceImpl storage) throws RemoteException {
        if (PhysStorTransportTypeConstant.PHYS_STOR_TRANS_TYPE_ISCSI.equals(storage.getTransportType())) {
            ClusterImpl cluster = storage.getCluster();
            int numberOfConnectedVSwitches = cluster.getConnectedVSwitches().length;
            List<VSwitchImpl> storageVSwitches = storage.getConnectedVSwitchesAsList();
            if (storageVSwitches.size() < numberOfConnectedVSwitches) {
                VSwitchImpl otherVs = cluster.getOtherVSwitch(storageVSwitches.get(0));
                GeneralSCSIDevice match = this.getSCSIDeviceByEntityNameAndLun(storage.getTypeConstant(), storage.getEntityName(), storage.getLUN(), storage.getSerialNumber(), false, otherVs);
                return (GeneralSCSIDeviceImpl)match;
            }
        }
        return null;
    }

    private GeneralSCSIDevice getSCSIDeviceByEntityNameAndLun(PhysicalStorageTypeConstant type, String entityName, String lunStr, String lunSn, boolean ignoreSn, VSwitchImpl vswitch) throws RemoteException {
        for (GeneralSCSIDeviceImpl device : this.getAll()) {
            if (vswitch != null && !device.isKnownByVSwitch(vswitch) || !device.getTypeConstant().equals(type) || !device.getEntityName().equals(entityName) || !device.getLUN().equals(lunStr)) continue;
            if (ignoreSn) {
                return device;
            }
            String deviceSn = device.getSerialNumber();
            if ((lunSn == null || deviceSn == null || deviceSn.length() <= 0 || !deviceSn.equals(lunSn)) && (lunSn != null && lunSn.length() != 0 || deviceSn != null && deviceSn.length() != 0)) continue;
            return device;
        }
        return null;
    }

    public void removeAll() {
        this.myPool.clear();
    }

    public int size() {
        return this.myPool.size();
    }

    public List<GeneralSCSIDeviceImpl> getAll() {
        return this.myPool;
    }

    public Storageable getStorageByAlias(String alias) {
        for (GeneralSCSIDeviceImpl storage : this.getAll()) {
            if (!storage.getAlias().equals(alias)) continue;
            return storage;
        }
        return null;
    }

    public GeneralSCSIDevice[] getStoragesByEntityName(String entityName) {
        ArrayList<GeneralSCSIDeviceImpl> storages = new ArrayList<GeneralSCSIDeviceImpl>();
        for (GeneralSCSIDeviceImpl storage : this.getAll()) {
            if (!storage.getEntityName().equals(entityName)) continue;
            storages.add(storage);
        }
        GeneralSCSIDevice[] storagesArray = new GeneralSCSIDevice[storages.size()];
        return storages.toArray(storagesArray);
    }

    public List<GeneralSCSIDevice> getStoragesByRaidWWN(String aRaidWWN) {
        if (aRaidWWN == null || aRaidWWN.length() < 16) {
            return new ArrayList<GeneralSCSIDevice>();
        }
        final String raidIdentifier = aRaidWWN.substring(0, 15);
        SrFilterSimpleRule<GeneralSCSIDevice> belongsToRaidRule = new SrFilterSimpleRule<GeneralSCSIDevice>(){

            @Override
            public boolean isValid(GeneralSCSIDevice newObject, Object ... params) {
                return ((GeneralSCSIDeviceImpl)newObject).getEntityName().contains(raidIdentifier);
            }
        };
        SrFilteredArrayList<GeneralSCSIDeviceImpl> filteredList = new SrFilteredArrayList<GeneralSCSIDeviceImpl>(new ArrayList<GeneralSCSIDeviceImpl>(this.getAll()), belongsToRaidRule);
        return filteredList.getAllOfMatched();
    }

    public GeneralSCSIDevice getStoragesByEntityNameAndLUN(String entityName, int lun) {
        GeneralSCSIDevice[] devices = this.getStoragesByEntityName(entityName);
        for (int i = 0; i < devices.length; ++i) {
            if (Integer.parseInt(((GeneralSCSIDeviceImpl)devices[i]).getLUN()) != lun) continue;
            return devices[i];
        }
        return null;
    }

    public GeneralSCSIDeviceImpl getSCSIDeviceParameterList(ClusterImpl clusterForDebug, ConfigElementData aCED) throws RemoteException {
        String serialNoValue;
        SrString serialNo = (SrString)aCED.getValue(ParameterCode.PHYSICAL_STORAGE_SERIAL_NUMBER);
        CommKeyClassId[] luIds = (CommKeyClassId[])aCED.getValue(ParameterCode.PHYSICAL_STORAGE_LU_IDENTIFIER);
        Object alias = aCED.getValue(ParameterCode.PHYSICAL_STORAGE_ALIAS);
        CommKeyClassId vSwitch = (CommKeyClassId)aCED.getValue(ParameterCode.VSWITCH_ID);
        StringBuffer msg = new StringBuffer();
        msg.append(vSwitch);
        msg.append(" - New element: ");
        msg.append(alias);
        msg.append("; Serial No. ");
        msg.append(serialNo);
        LUIdentifierImpl luId = null;
        if (luIds != null) {
            luId = (LUIdentifierImpl)clusterForDebug.getCommKeyRefMap().getRefByCommKeyClassID(luIds[0]);
            if (luId != null) {
                msg.append("; LU ID (assoc., codeset, type, value): ");
                msg.append(luId.getAssociation());
                msg.append(", ");
                msg.append(luId.getCodeSet());
                msg.append(", ");
                msg.append(luId.getType());
                msg.append(", ");
                msg.append(luId.getValue());
            } else {
                msg.append("; LU ID is null (in logic) ");
            }
        } else {
            msg.append("; LU ID is null (in parameterList) ");
        }
        theLogger.trace(SrLogCategories.LEGACY, msg);
        PhysicalStorageTypeConstant type = (PhysicalStorageTypeConstant)aCED.getValue(ParameterCode.PHYSICAL_STORAGE_TYPE);
        SrLunFormat blockNum = (SrLunFormat)aCED.getValue(ParameterCode.DIRECT_ACCESS_DEVICE_BLOCK_NUM);
        BigInteger blockNumValue = null;
        if (blockNum != null) {
            blockNumValue = (BigInteger)blockNum.value();
        }
        SrInteger blockSize = (SrInteger)aCED.getValue(ParameterCode.DIRECT_ACCESS_DEVICE_BLOCK_SIZE);
        Integer blockSizeValue = null;
        if (blockSize != null) {
            blockSizeValue = (Integer)blockSize.value();
        }
        boolean storageComparison3 = clusterForDebug.isStorageComparison3();
        String string = serialNoValue = serialNo != null ? (String)serialNo.value() : null;
        if (serialNo != null && !serialNo.equals("") && luIds != null && !storageComparison3) {
            return this.getSCSIDeviceBySerialNoAndLUIds(serialNoValue, luIds, type, blockNumValue, blockSizeValue);
        }
        SrEntityNameFormat entityName = (SrEntityNameFormat)aCED.getValue(ParameterCode.PHYSICAL_STORAGE_ENTITY_NAME);
        String lun = GeneralSCSIDeviceImpl.formatSCSIDeviceLUN((SrLunFormat)aCED.getValue(ParameterCode.PHYSICAL_STORAGE_LUN));
        return this.getSCSIDeviceByEntityNameAndLun(entityName, lun, type, serialNoValue, blockNumValue, blockSizeValue);
    }

    private boolean isDeviceBlockEquals(GeneralSCSIDeviceImpl device, BigInteger blockNum, Integer blockSize) {
        if (device.getClassId().equals(ClassID.DIRECT_ACCESS_DEVICE)) {
            BigInteger deviceBlockNum = ((DirectAccessDeviceImpl)device).getNumberOfBlocks();
            int deviceBlockSize = ((DirectAccessDeviceImpl)device).getBlockSize();
            boolean blockSizeEqual = deviceBlockSize == blockSize || deviceBlockSize == 1 || blockSize == 1;
            boolean blockNumEqual = deviceBlockNum.compareTo(blockNum) == 0 || blockNum.compareTo(BigInteger.ZERO) == 0 || deviceBlockNum.compareTo(BigInteger.ZERO) == 0;
            return blockNumEqual && blockSizeEqual;
        }
        return true;
    }

    private GeneralSCSIDeviceImpl getSCSIDeviceByEntityNameAndLun(SrEntityNameFormat entityName, String lun, PhysicalStorageTypeConstant type, String serialNo, BigInteger blockNum, Integer blockSize) {
        for (GeneralSCSIDeviceImpl device : this.getAll()) {
            boolean snExists;
            boolean deviceSNExists;
            String deviceSerialNo = device.getSerialNumber();
            boolean bl = deviceSNExists = deviceSerialNo != null && deviceSerialNo.length() > 0;
            if (deviceSNExists && device.getLUIdentifier() != null) continue;
            ClusterImpl cluster = device.getCluster();
            boolean storageComparison3 = cluster.isStorageComparison3();
            boolean bl2 = snExists = serialNo != null && serialNo.length() > 0;
            if (!storageComparison3 && (!deviceSNExists || !snExists || !deviceSerialNo.equals(serialNo)) && (deviceSNExists || snExists) || !device.getTypeConstant().equals(type) || !device.getEntityNameValue().equals(entityName) || !device.getLUN().equals(lun) || !this.isDeviceBlockEquals(device, blockNum, blockSize)) continue;
            return device;
        }
        return null;
    }

    public GeneralSCSIDevice getSCSIDeviceByEntityNameLunAndSerialNumber(String entityName, String lunStr, String lunSn, PhysicalStorageTypeConstant type) throws RemoteException {
        return this.getSCSIDeviceByEntityNameAndLun(type, entityName, lunStr, lunSn, false, null);
    }

    public GeneralSCSIDevice getSCSIDeviceByEntityNameAndLun(String entityName, String lunStr, PhysicalStorageTypeConstant type) throws RemoteException {
        return this.getSCSIDeviceByEntityNameAndLun(type, entityName, lunStr, null, true, null);
    }

    private GeneralSCSIDeviceImpl getSCSIDeviceBySerialNoAndLUIds(String serialNo, CommKeyClassId[] luIdsCommKeyClassId, PhysicalStorageTypeConstant type, BigInteger blockNum, Integer blockSize) {
        if (luIdsCommKeyClassId.length > 0) {
            for (GeneralSCSIDeviceImpl device : this.getAll()) {
                if (!device.getTypeConstant().equals(type)) continue;
                List<LUIdentifierImpl> deviceLuIds = device.getLUIdentifier();
                String deviceSerialNo = device.getSerialNumber();
                if (deviceSerialNo != null && !deviceSerialNo.equals("") && deviceLuIds != null && deviceLuIds.size() > 0) {
                    if (deviceSerialNo.equals(serialNo) && luIdsCommKeyClassId.length == deviceLuIds.size()) {
                        CommKeyRefMap refMap = device.getCluster().getCommKeyRefMap();
                        Vector<LUIdentifierImpl> luIds = new Vector<LUIdentifierImpl>(luIdsCommKeyClassId.length);
                        for (int i = 0; i < luIdsCommKeyClassId.length; ++i) {
                            LUIdentifierImpl luId = (LUIdentifierImpl)refMap.getRefByCommKeyClassID(luIdsCommKeyClassId[i]);
                            luIds.addElement(luId);
                        }
                        if (!deviceLuIds.containsAll(luIds) || !this.isDeviceBlockEquals(device, blockNum, blockSize)) continue;
                        return device;
                    }
                    if (!deviceSerialNo.equals(serialNo)) {
                        theLogger.trace(SrLogCategories.LEGACY, device.getClassId(), " ", device.getAlias(), " - SerialNo ", deviceSerialNo, " is not equal to ", serialNo);
                        continue;
                    }
                    theLogger.trace(SrLogCategories.LEGACY, device.getClassId(), " ", device.getAlias(), " - LU ID size ", deviceLuIds.size(), " is not equal to ", luIdsCommKeyClassId.length);
                    continue;
                }
                if (deviceLuIds != null && deviceLuIds.size() != 0) continue;
                if (deviceSerialNo != null) {
                    theLogger.trace(SrLogCategories.LEGACY, device.getClassId(), " ", device.getAlias(), " Serial# ", deviceSerialNo, " ; deviceLuIds ", deviceLuIds, " - LU ID is empty ==> is not equal to serialNo with length ", luIdsCommKeyClassId.length);
                    continue;
                }
                theLogger.trace(SrLogCategories.LEGACY, device.getClassId(), " ", device.getAlias(), " Serial# is null ==> is not equal to ", serialNo);
            }
        }
        return null;
    }

    public boolean isAliasExist(String alias) {
        if (this.isSCSIDeviceAliasExist(alias)) {
            return true;
        }
        return this.getSubDirectAccessDevice(alias) != null;
    }

    public boolean isSCSIDeviceAliasExist(String alias) {
        for (GeneralSCSIDeviceImpl device : this.getAll()) {
            if (!device.getAlias().equals(alias)) continue;
            return true;
        }
        return false;
    }

    public DirectAccessDeviceImpl getSubDirectAccessDevice(String aSubDiskAlias) {
        for (GeneralSCSIDeviceImpl device : this.getAll()) {
            if (!(device instanceof DirectAccessDeviceImpl) || !((DirectAccessDeviceImpl)device).isSubDirectAccessDeviceAliasExist(aSubDiskAlias)) continue;
            return (DirectAccessDeviceImpl)device;
        }
        return null;
    }

    public int synchronize() throws RemoteException, IllegalValueException {
        StringBuffer errMsg = new StringBuffer();
        boolean errOccured = false;
        int retVal = 0;
        for (GeneralSCSIDeviceImpl device : this.getAll()) {
            try {
                int deviceRetVal = device.synchronize();
                if (deviceRetVal <= retVal) continue;
                retVal = deviceRetVal;
            }
            catch (IllegalValueException ive) {
                theLogger.error(SrLogCategories.EXCEPTION, ive, new Object[0]);
                if (ive.getMessage() != null) {
                    errMsg.append(ive.getMessage());
                }
                errOccured = true;
            }
        }
        if (errOccured) {
            throw new IllegalValueException(errMsg.toString());
        }
        return retVal;
    }

    public List<DirectAccessDeviceImpl> getAllDisks() {
        return this.getAllDisks(null);
    }

    public List<DirectAccessDeviceImpl> getAllDisks(final PhysicalStorageDriveTypeConstant aDriveType) {
        SrFilterSimpleRule<GeneralSCSIDeviceImpl> onlyDisksRule = new SrFilterSimpleRule<GeneralSCSIDeviceImpl>(){

            @Override
            public boolean isValid(GeneralSCSIDeviceImpl aNewObject, Object ... aParams) {
                return PhysicalStorageTypeConstant.PHYS_STOR_TYPE_DIRECT_ACCESS_DEVICE.equals(aNewObject.getTypeConstant());
            }
        };
        SrFilterSimpleRule<GeneralSCSIDeviceImpl> driveTypeRule = new SrFilterSimpleRule<GeneralSCSIDeviceImpl>(){

            @Override
            public boolean isValid(GeneralSCSIDeviceImpl aNewObject, Object ... aParams) {
                if (aDriveType == null) {
                    return true;
                }
                return aDriveType.equals(aNewObject.getDriveType());
            }
        };
        SrFilteredArrayList<GeneralSCSIDeviceImpl> filteredList = new SrFilteredArrayList<GeneralSCSIDeviceImpl>();
        filteredList.addRule(onlyDisksRule);
        filteredList.addRule(driveTypeRule);
        filteredList.addAll((Collection<GeneralSCSIDeviceImpl>)this.getAll());
        return Util.convertListType(filteredList.getAllOfMatched());
    }
}

