/*
 * Decompiled with CFR 0.152.
 */
package com.sanrad.nms.server.logic.storage;

import com.sanrad.log.SrLogCategories;
import com.sanrad.nms.server.RemoteObjectImpl;
import com.sanrad.nms.server.alarm.AlarmMgrImpl;
import com.sanrad.nms.server.alarm.AlarmsNotificationData;
import com.sanrad.nms.server.comm.snmp.raid.RaidSnmpMgr;
import com.sanrad.nms.server.comm.snmp.trap.SrTrapType;
import com.sanrad.nms.server.logic.ElementEventImpl;
import com.sanrad.nms.server.logic.LogicMgrAOImpl;
import com.sanrad.nms.server.logic.storage.SrStorageNotification;
import com.sanrad.nms.server.logic.storage.SrStorageNotificationImpl;
import com.sanrad.nms.server.logic.storage.SrStorageNotificationMgr;
import com.sanrad.nms.server.user.UserManagerImpl;
import com.sanrad.nms.server.util.CommKeyClassId;
import com.sanrad.nms.server.util.types.SrIpAddress;
import com.sanrad.nms.server.util.types.SrString;
import com.sanrad.security.StringCodec;
import com.sanrad.util.MailSender;
import com.sanrad.util.SrConstantsBundleKeys;
import com.sanrad.util.SrResourceBundle;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;

public class SrStorageNotificationMgrImpl
extends RemoteObjectImpl
implements SrStorageNotificationMgr {
    private static SrResourceBundle consts = SrResourceBundle.getInstance("constants", Locale.US);
    private static final Integer MAX_NOTIFICATIONS_PER_VS = consts.getIntResource(SrConstantsBundleKeys.MAX_STORAGE_NOTIFICATIONS_PER_VS);
    private static SrStorageNotificationMgrImpl theObj = null;
    private static MailSender theMailSender = new MailSender();
    private static String theSenderString = null;
    private static String theHostString = null;
    private static String theRecipientString = null;
    private static String theSmtpUserString = null;
    private static String theSmtpPasswordString = null;
    private Map<CommKeyClassId, ArrayList<SrStorageNotificationImpl>> theVsCKCIToStorageNotificationsMap = new HashMap<CommKeyClassId, ArrayList<SrStorageNotificationImpl>>();

    private SrStorageNotificationMgrImpl() throws RemoteException {
    }

    public static SrStorageNotificationMgrImpl getInstance() throws RemoteException {
        return theObj;
    }

    public boolean addNotification(SrStorageNotificationImpl aNotification, SrTrapType aType) {
        assert (aNotification != null) : "The given notification should not be null.";
        ArrayList<SrStorageNotificationImpl> currentList = this.theVsCKCIToStorageNotificationsMap.get(aNotification.getVSwitchId());
        if (currentList == null) {
            currentList = new ArrayList(MAX_NOTIFICATIONS_PER_VS);
            this.theVsCKCIToStorageNotificationsMap.put(aNotification.getVSwitchId(), currentList);
        } else if (currentList.size() >= MAX_NOTIFICATIONS_PER_VS) {
            return this.replaceNotification(aNotification, currentList.get(0), aType);
        }
        if (!currentList.add(aNotification)) {
            return false;
        }
        this.sendEvent(EventType.ADDED, aNotification, null);
        String subject = "";
        String text = "";
        if (SrTrapType.NEXSAN_RAID_TRAP_EVENT.equals(aType)) {
            subject = this.getNexsanEmailSubject(aNotification);
            text = this.getNexsanEmailText(aNotification);
        } else if (SrTrapType.IBM_RAID_TRAP_EVENT.equals(aType)) {
            subject = this.getIbmEmailSubject(aNotification);
            text = this.getIbmEmailText(aNotification);
        } else {
            return true;
        }
        if (theRecipientString != null) {
            theMailSender.initMessage(theHostString, theSmtpUserString, theSmtpPasswordString, theSenderString, theRecipientString, subject);
            theMailSender.sendMail(text);
        }
        return true;
    }

    private String getNexsanEmailSubject(SrStorageNotificationImpl aNotification) {
        SrString srDeviceHostName = aNotification.getDeviceHostName();
        String deviceHostName = srDeviceHostName != null ? srDeviceHostName.toDisplayString() : "Nexsan";
        SrIpAddress srDeviceHostIp = aNotification.getDeviceHostIP();
        String deviceHostIp = srDeviceHostIp != null ? srDeviceHostIp.toDisplayString() : "";
        String severity = aNotification.getSeverity();
        StringBuffer retVal = new StringBuffer();
        retVal.append(deviceHostName);
        retVal.append(" http://");
        retVal.append(deviceHostIp);
        retVal.append(" ");
        retVal.append(severity);
        retVal.append(" Event");
        return retVal.toString();
    }

    private String getNexsanEmailText(SrStorageNotificationImpl aNotification) {
        SrString srDeviceHostName = aNotification.getDeviceHostName();
        String deviceHostName = srDeviceHostName != null ? srDeviceHostName.toDisplayString() : "Nexsan";
        SrIpAddress srDeviceHostIp = aNotification.getDeviceHostIP();
        String deviceHostIp = srDeviceHostIp != null ? srDeviceHostIp.toDisplayString() : "";
        SrString srDesc = aNotification.getRaidDescription();
        String description = srDesc != null ? srDesc.toDisplayString() : "";
        String severity = aNotification.getSeverity();
        StringBuffer retVal = new StringBuffer();
        retVal.append("<html>");
        retVal.append("<body>");
        retVal.append("<br>");
        retVal.append(severity);
        retVal.append(" Event from ");
        retVal.append(deviceHostName);
        retVal.append(". http://");
        retVal.append(deviceHostIp);
        retVal.append("<br>");
        retVal.append("<br>");
        retVal.append(description);
        retVal.append("</body>");
        retVal.append("</html>");
        return retVal.toString();
    }

    private String getIbmEmailSubject(SrStorageNotificationImpl aNotification) {
        SrString srDeviceHostName = aNotification.getDeviceHostName();
        String deviceHostName = srDeviceHostName != null ? srDeviceHostName.toDisplayString() : "IBM";
        SrString srDeviceUserLabel = aNotification.getDeviceUserLabel();
        String deviceUserLabel = srDeviceUserLabel != null ? srDeviceUserLabel.toDisplayString() : "";
        StringBuffer retVal = new StringBuffer();
        retVal.append(deviceHostName);
        retVal.append(" ");
        retVal.append(deviceUserLabel);
        retVal.append(" Event");
        return retVal.toString();
    }

    private String getIbmEmailText(SrStorageNotificationImpl aNotification) {
        SrString srDesc = aNotification.getRaidDescription();
        String description = srDesc != null ? srDesc.toDisplayString() : "";
        StringBuffer retVal = new StringBuffer();
        retVal.append("<html>");
        retVal.append("<body>");
        retVal.append("<br>");
        retVal.append(description);
        retVal.append("</body>");
        retVal.append("</html>");
        return retVal.toString();
    }

    private boolean replaceNotification(SrStorageNotificationImpl aNewNotification, SrStorageNotificationImpl aOldNotification, SrTrapType aType) {
        if (aNewNotification == null || aOldNotification == null) {
            return false;
        }
        ArrayList<SrStorageNotificationImpl> currentList = this.theVsCKCIToStorageNotificationsMap.get(aNewNotification.getVSwitchId());
        if (currentList == null || currentList.isEmpty()) {
            return this.addNotification(aNewNotification, aType);
        }
        if (currentList.contains(aOldNotification)) {
            Integer oldNotificationPosition = currentList.indexOf(aOldNotification);
            if (currentList.remove(aOldNotification) && currentList.add(aNewNotification)) {
                this.sendEvent(EventType.REPLACED, aOldNotification, aNewNotification);
                return true;
            }
            if (!currentList.contains(aOldNotification)) {
                currentList.add(oldNotificationPosition, aOldNotification);
            }
        }
        return false;
    }

    private boolean removeNotification(SrStorageNotificationImpl aNotification) {
        assert (aNotification != null) : "The given notification should not be null";
        CommKeyClassId currentVS = aNotification.getVSwitchId();
        ArrayList<SrStorageNotificationImpl> curList = this.theVsCKCIToStorageNotificationsMap.get(currentVS);
        if (curList == null) {
            return false;
        }
        if (curList.remove(aNotification)) {
            this.sendEvent(EventType.REMOVED, aNotification, null);
            return true;
        }
        return false;
    }

    public boolean clearAllNotificationsForVS(CommKeyClassId aVswitchId) {
        ArrayList curList = new ArrayList(this.theVsCKCIToStorageNotificationsMap.get(aVswitchId));
        for (SrStorageNotificationImpl notification : curList) {
            this.removeNotification(notification);
        }
        return this.theVsCKCIToStorageNotificationsMap.remove(aVswitchId) != null;
    }

    public void clearAllNotifications() {
        HashSet<CommKeyClassId> setKeys = new HashSet<CommKeyClassId>(this.theVsCKCIToStorageNotificationsMap.keySet());
        for (CommKeyClassId key : setKeys) {
            if (this.clearAllNotificationsForVS(key)) continue;
            theLogger.error(SrLogCategories.ILLEGAL_STATE, "Trying to remove existing VS Key: " + key.toString() + " but the was not found");
        }
    }

    @Override
    public List<? extends SrStorageNotification> getNotifications(CommKeyClassId aVswitchId) throws RemoteException {
        ArrayList retList = this.theVsCKCIToStorageNotificationsMap.get(aVswitchId);
        if (retList == null) {
            retList = new ArrayList();
        }
        return retList;
    }

    private void sendEvent(EventType aType, SrStorageNotificationImpl aNotification, SrStorageNotificationImpl aOldNotification) {
        try {
            switch (aType) {
                case ADDED: {
                    ElementEventImpl eventAdded = new ElementEventImpl((Object)aNotification.getVSwitchId(), aNotification);
                    eventAdded.setParameterList(aNotification.getClientParameterList());
                    LogicMgrAOImpl.getInstance().__elementCreated(eventAdded);
                    break;
                }
                case REMOVED: {
                    ElementEventImpl eventRemove = new ElementEventImpl((Object)aNotification.getVSwitchId(), aNotification);
                    LogicMgrAOImpl.getInstance().__elementRemoved(eventRemove);
                    break;
                }
                case REPLACED: {
                    ElementEventImpl eventRemoved = new ElementEventImpl((Object)aOldNotification.getVSwitchId(), aOldNotification);
                    ElementEventImpl eventCreated = new ElementEventImpl((Object)aNotification.getVSwitchId(), aNotification);
                    eventCreated.setParameterList(aNotification.getClientParameterList());
                    LogicMgrAOImpl.getInstance().__elementRemoved(eventRemoved);
                    LogicMgrAOImpl.getInstance().__elementCreated(eventCreated);
                    break;
                }
                default: {
                    theLogger.error(SrLogCategories.ERROR, new IllegalArgumentException("Trace: Got invalid eventType=" + aType.toString() + " when trying to send Event."), new Object[0]);
                    break;
                }
            }
        }
        catch (RemoteException exp) {
            theLogger.error(SrLogCategories.ERROR, exp, "A remote exception has occured while trying to notify the logic");
        }
    }

    @Override
    public Map<CommKeyClassId, ? extends List<? extends SrStorageNotification>> getAllNotifications() throws RemoteException {
        return this.theVsCKCIToStorageNotificationsMap;
    }

    @Override
    public boolean isInitializationExceptionOccured() throws RemoteException {
        return RaidSnmpMgr.isInitializationExceptionOccured();
    }

    public static void setEmailParameters() {
        String key = UserManagerImpl.getInstance().getCodecKey();
        AlarmsNotificationData data = AlarmMgrImpl.getInstance().getAlarmsNotificationData();
        theSenderString = data.getContactFromAddress();
        theHostString = data.getContactSMTPHost();
        theRecipientString = data.getContactToAddressList();
        theSmtpUserString = data.getContactSMTPUser();
        theSmtpPasswordString = StringCodec.decryptString(key, data.getContactSMTPPassword());
    }

    static {
        try {
            theObj = new SrStorageNotificationMgrImpl();
            SrStorageNotificationMgrImpl.setEmailParameters();
        }
        catch (RemoteException e) {
            theLogger.fatal(SrLogCategories.EXCEPTION, e, "An RMI exception has occured inside a server context.");
        }
    }

    private static enum EventType {
        ADDED,
        REMOVED,
        REPLACED;

    }
}

