/*
 * Decompiled with CFR 0.152.
 */
package com.sanrad.nms.server.logic.storage;

import com.sanrad.nms.server.Server;
import com.sanrad.nms.server.SrServerBundleKeys;
import com.sanrad.nms.server.alarm.AlarmGenerator;
import com.sanrad.nms.server.logic.ClientParameterCode;
import com.sanrad.nms.server.logic.IllegalValueException;
import com.sanrad.nms.server.logic.InvalidElementException;
import com.sanrad.nms.server.logic.LogicObjectImpl;
import com.sanrad.nms.server.logic.cluster.ClusterImpl;
import com.sanrad.nms.server.logic.storage.SrStorageNotification;
import com.sanrad.nms.server.mgr.ConfigElementData;
import com.sanrad.nms.server.util.ClassID;
import com.sanrad.nms.server.util.CommKeyClassId;
import com.sanrad.nms.server.util.ParameterCode;
import com.sanrad.nms.server.util.types.SrIpAddress;
import com.sanrad.nms.server.util.types.SrString;
import com.sanrad.util.BundleKeysInterface;
import java.rmi.RemoteException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public class SrStorageNotificationImpl
extends LogicObjectImpl
implements SrStorageNotification {
    private static Map<ParameterCode, ParameterCode.Flags> theParameterCodeFlagsMap;
    private CommKeyClassId myCkVSwitchId = null;

    public SrStorageNotificationImpl(ClusterImpl aCluster, ConfigElementData aCED) throws RemoteException, IllegalValueException, InvalidElementException {
        super(aCluster, ClassID.STORAGE_NOTIFICATION, aCED);
        this.validateAndInit(aCED, theParameterCodeFlagsMap);
        this.myCkVSwitchId = aCED.getVswitchId();
    }

    public CommKeyClassId getVSwitchId() {
        return this.myCkVSwitchId;
    }

    public SrIpAddress getDeviceHostIP() {
        return (SrIpAddress)this.getSrValueOf(ParameterCode.RAID_TRAP_DEVICE_HOST_IP);
    }

    public SrString getDeviceHostName() {
        return (SrString)this.getSrValueOf(ParameterCode.RAID_TRAP_DEVICE_HOST_NAME);
    }

    public SrString getDeviceUserLabel() {
        return (SrString)this.getSrValueOf(ParameterCode.RAID_TRAP_DEVICE_USER_LABEL);
    }

    public SrString getDeviceErrorCode() {
        return (SrString)this.getSrValueOf(ParameterCode.RAID_TRAP_DEVICE_ERROR_CODE);
    }

    public SrString getTime() {
        return (SrString)this.getSrValueOf(ParameterCode.RAID_TRAP_EVENT_TIME);
    }

    public SrString getRaidDescription() {
        return (SrString)this.getSrValueOf(ParameterCode.RAID_TRAP_DESCRIPTION);
    }

    public SrString getRaidComponentType() {
        return (SrString)this.getSrValueOf(ParameterCode.RAID_TRAP_COMPONENT_TYPE);
    }

    public SrString getRaidComponentLocation() {
        return (SrString)this.getSrValueOf(ParameterCode.RAID_TRAP_COMPONENT_LOCATION);
    }

    @Override
    protected String isValid(HashMap parameterList) {
        return Server.BUNDLE.getString((BundleKeysInterface)SrServerBundleKeys.ELEMENT_NOT_CONFIGURABLE, this.getClassId());
    }

    @Override
    protected String canBeDeleted() {
        return null;
    }

    @Override
    public void registerToPropagatedStateChange() {
    }

    @Override
    public AlarmGenerator getAlarmGenerator() {
        return null;
    }

    @Override
    public String toString() {
        StringBuffer sb = new StringBuffer("[");
        sb.append(this.getClassId()).append("]:").append(this.hashKey());
        sb.append(" DeviceHostIP = ").append(this.getDeviceHostIP());
        sb.append(" DeviceHostName = ").append(this.getDeviceHostName());
        sb.append(" UserLabel = ").append(this.getDeviceUserLabel());
        sb.append(" DateAndTime = ").append(this.getTime());
        sb.append(" Description = ").append(this.getRaidDescription());
        sb.append(" ComponentType = ").append(this.getRaidComponentType());
        sb.append(" ComponentLocation = ").append(this.getRaidComponentLocation());
        return sb.toString();
    }

    @Override
    public boolean equals(Object obj) {
        if (!(obj instanceof SrStorageNotificationImpl)) {
            return false;
        }
        return this.hashKey().equals(((SrStorageNotificationImpl)obj).hashKey());
    }

    @Override
    public HashMap getClientParameterList() throws RemoteException {
        HashMap params = super.getClientParameterList();
        params.put(ClientParameterCode.RAID_TRAP_VSWITCH_ID, this.myCkVSwitchId);
        return params;
    }

    public String getSeverity() {
        SrString srDesc = this.getRaidDescription();
        String description = srDesc != null ? srDesc.toDisplayString() : "";
        int delim = description.indexOf(58);
        if (delim == -1) {
            return "";
        }
        return description.substring(0, delim);
    }

    static {
        HashMap<ParameterCode, ParameterCode.Flags> parameterCodeFlagsMap = new HashMap<ParameterCode, ParameterCode.Flags>();
        parameterCodeFlagsMap.put(ParameterCode.RAID_TRAP_DEVICE_HOST_IP, new ParameterCode.Flags(false, false));
        parameterCodeFlagsMap.put(ParameterCode.RAID_TRAP_DEVICE_HOST_NAME, new ParameterCode.Flags(false, false));
        parameterCodeFlagsMap.put(ParameterCode.RAID_TRAP_DEVICE_USER_LABEL, new ParameterCode.Flags(false, false));
        parameterCodeFlagsMap.put(ParameterCode.RAID_TRAP_DEVICE_ERROR_CODE, new ParameterCode.Flags(false, false));
        parameterCodeFlagsMap.put(ParameterCode.RAID_TRAP_EVENT_TIME, new ParameterCode.Flags(false, false));
        parameterCodeFlagsMap.put(ParameterCode.RAID_TRAP_DESCRIPTION, new ParameterCode.Flags(false, false));
        parameterCodeFlagsMap.put(ParameterCode.RAID_TRAP_COMPONENT_TYPE, new ParameterCode.Flags(false, false));
        parameterCodeFlagsMap.put(ParameterCode.RAID_TRAP_COMPONENT_LOCATION, new ParameterCode.Flags(false, false));
        theParameterCodeFlagsMap = Collections.unmodifiableMap(parameterCodeFlagsMap);
    }
}

