/*
 * Decompiled with CFR 0.152.
 */
package com.sanrad.nms.server.logic.srv.radius;

import com.sanrad.log.SrLogCategories;
import com.sanrad.log.SrLogger;
import com.sanrad.nms.server.alarm.AlarmGenerator;
import com.sanrad.nms.server.alarm.srv.radius.RadiusServerAlarmGenerator;
import com.sanrad.nms.server.logic.IllegalValueException;
import com.sanrad.nms.server.logic.InvalidElementException;
import com.sanrad.nms.server.logic.cluster.ClusterImpl;
import com.sanrad.nms.server.logic.identity.IdentityImpl;
import com.sanrad.nms.server.logic.srv.ExternalServerImpl;
import com.sanrad.nms.server.logic.srv.ExternalServerList;
import com.sanrad.nms.server.logic.srv.radius.RadiusServer;
import com.sanrad.nms.server.logic.vswitch.VSwitch;
import com.sanrad.nms.server.logic.vswitch.VSwitchImpl;
import com.sanrad.nms.server.mgr.ConfigElementData;
import com.sanrad.nms.server.util.ClassID;
import com.sanrad.nms.server.util.ParameterCode;
import com.sanrad.util.concurrent.ErrorAssertingListener;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public class RadiusServerImpl
extends ExternalServerImpl
implements RadiusServer {
    private static SrLogger theLogger = SrLogger.getLogger();
    private static Map<ParameterCode, ParameterCode.Flags> theParameterCodeFlagsMap;

    public RadiusServerImpl(ClusterImpl cluster, ConfigElementData aCED) throws RemoteException, IllegalValueException, InvalidElementException {
        super(cluster, ClassID.RADIUS_SERVER, aCED);
        this.validateAndInit(aCED, theParameterCodeFlagsMap);
    }

    @Override
    public Integer getRadiusServerPort() throws RemoteException {
        return this.getRadiusServerPort(null);
    }

    public Integer getRadiusServerPort(VSwitch vSwitch) throws RemoteException {
        return (Integer)this.getValueOf(vSwitch, ParameterCode.RADIUS_SERVER_PORT, vSwitch == null);
    }

    @Override
    public String getRadiusServerKey() throws RemoteException {
        return this.getRadiusServerKey(null);
    }

    public String getRadiusServerKey(VSwitch vSwitch) throws RemoteException {
        return (String)this.getValueOf(vSwitch, ParameterCode.RADIUS_SERVER_KEY, vSwitch == null);
    }

    @Override
    public String getServerIP(VSwitch vSwitch) throws RemoteException {
        return this.getDisplayStringOf(vSwitch, ParameterCode.RADIUS_SERVER_IP_ADDRESS, vSwitch == null);
    }

    @Override
    public String getAlias() {
        return this.getServerIP();
    }

    @Override
    public String getAlias(VSwitchImpl vSwitch) {
        return "";
    }

    @Override
    protected int synchronizeMe() throws RemoteException, IllegalValueException {
        if (!super.isRedundant()) {
            theLogger.trace(SrLogCategories.LEGACY, "Synchronizing: creating Radius server on other ", ClassID.VSWITCH);
            ErrorAssertingListener.listenTo(this.cluster.createRadiusServer(this.getServerIP(), this.getRadiusServerPort().toString(), this.getRadiusServerKey(), this.cluster.getOtherVSwitches(this.getVSwitches())));
            return 2;
        }
        return 0;
    }

    @Override
    protected String canBeDeleted() {
        IdentityImpl identity = this.getIdentityUsingRADIUS();
        if (identity != null && this.isLastOneInCluster()) {
            String msg = "The " + this.getClassId() + " " + this + " is being used by an " + identity.getClassId() + " " + identity + " for access control.  First remove the " + this.getClassId() + " from the " + identity.getClassId() + " and then delete it.";
            return msg;
        }
        return null;
    }

    @Override
    protected String isValid(HashMap parameterList) {
        return null;
    }

    @Override
    public void registerToPropagatedStateChange() {
    }

    @Override
    public AlarmGenerator getAlarmGenerator() {
        return RadiusServerAlarmGenerator.getInstatnce();
    }

    @Override
    public String toString() {
        return this.serverIpAddress;
    }

    public IdentityImpl getIdentityUsingRADIUS() {
        return this.getCluster().getIdentityUsingRADIUS(this);
    }

    public boolean isLastOneInCluster() {
        ExternalServerList list = this.getCluster().getRadiusServersList();
        return list.size() == 1;
    }

    @Override
    protected ArrayList<ParameterCode> getParamsForCreation() {
        ArrayList<ParameterCode> params = new ArrayList<ParameterCode>();
        params.add(ParameterCode.RADIUS_SERVER_IP_ADDRESS);
        params.add(ParameterCode.RADIUS_SERVER_KEY);
        params.add(ParameterCode.RADIUS_SERVER_PORT);
        return params;
    }

    static {
        HashMap<ParameterCode, ParameterCode.Flags> parameterCodeFlagsMap = new HashMap<ParameterCode, ParameterCode.Flags>();
        parameterCodeFlagsMap.put(ParameterCode.RADIUS_SERVER_IP_ADDRESS, new ParameterCode.Flags(true, false));
        parameterCodeFlagsMap.put(ParameterCode.RADIUS_SERVER_PORT, new ParameterCode.Flags(true, false));
        parameterCodeFlagsMap.put(ParameterCode.RADIUS_SERVER_KEY, new ParameterCode.Flags(true, false));
        theParameterCodeFlagsMap = Collections.unmodifiableMap(parameterCodeFlagsMap);
    }
}

