/*
 * Decompiled with CFR 0.152.
 */
package com.sanrad.nms.server.logic.scsi;

import com.sanrad.log.SrLogCategories;
import com.sanrad.log.SrLogger;
import com.sanrad.nms.server.util.CommKeyClassId;
import java.util.HashMap;

public class SCSIISCSIDeviceMap {
    private static SrLogger theLogger = SrLogger.getLogger();
    private HashMap<CommKeyClassId, CommKeyClassId> m_map = new HashMap();
    private StringBuilder m_mapLog = new StringBuilder();
    private String myClusterName;

    public void setClusterName(String aClusterName) {
        this.myClusterName = aClusterName;
    }

    public void addEntryToMap(CommKeyClassId scsiId, CommKeyClassId iscsiId) {
        CommKeyClassId oldVal = this.m_map.put(scsiId, iscsiId);
        theLogger.info(SrLogCategories.SCSI_ISCSI_MAPPING, "Adding SCSI --> ISCSI entry: ", scsiId, " --> ", iscsiId, " old value = ", oldVal);
        this.m_mapLog.append("Added entries [<" + scsiId + " : " + iscsiId + ">, ");
        oldVal = this.m_map.put(iscsiId, scsiId);
        theLogger.info(SrLogCategories.SCSI_ISCSI_MAPPING, "Adding ISCSI --> SCSI entry: ", iscsiId, " --> ", scsiId, " old value = ", oldVal);
        this.m_mapLog.append("<" + iscsiId + ":" + scsiId + ">]; ");
    }

    public void removeEntryFromMap(CommKeyClassId iscsiId) {
        CommKeyClassId scsiVal = this.m_map.remove(iscsiId);
        theLogger.info(SrLogCategories.SCSI_ISCSI_MAPPING, "Removing ISCSI --> SCSI entry: ", iscsiId, " --> ", scsiVal);
        this.m_mapLog.append("Removed entries [<" + iscsiId + " : " + scsiVal + ">, ");
        CommKeyClassId iscsiVal = this.m_map.remove(scsiVal);
        theLogger.info(SrLogCategories.SCSI_ISCSI_MAPPING, "Removing SCSI --> ISCSI entry: ", scsiVal, " --> ", iscsiVal);
        theLogger.logAndAssert(SrLogCategories.SCSI_ISCSI_MAPPING, iscsiVal != null && iscsiVal.equals(iscsiId), new Object[]{"mapping error, a double mapping was invalidated. iscsiId: ", iscsiId, "; scsiId: ", scsiVal, "; obj: ", iscsiVal});
        this.m_mapLog.append("<" + scsiVal + ":" + iscsiVal + ">]; ");
    }

    public void clearAllEntries() {
        theLogger.info(SrLogCategories.SCSI_ISCSI_MAPPING, "Clearing the bi-directional SCSI <--> ISCSI mapping.");
        this.m_map.clear();
        this.m_mapLog = new StringBuilder();
    }

    public CommKeyClassId getISCSIId(CommKeyClassId scsiId) {
        return this.getOppositeId(scsiId);
    }

    public CommKeyClassId getSCSIId(CommKeyClassId iscsiId) {
        return this.getOppositeId(iscsiId);
    }

    private CommKeyClassId getOppositeId(CommKeyClassId aID) {
        CommKeyClassId retId = this.m_map.get(aID);
        if (retId == null) {
            theLogger.warn(SrLogCategories.SCSI_ISCSI_MAPPING, "Returned value is null for key: ", aID, ". The entire map is: ", this);
        }
        return retId;
    }

    public String toString() {
        return "SCSIISCSIDeviceMap [Associated cluster: " + this.myClusterName + "; Inner Mapping: " + this.m_map + "; Map Log: " + this.m_mapLog + "]";
    }
}

