/*
 * Decompiled with CFR 0.152.
 */
package com.sanrad.nms.server.logic.scsi;

import com.sanrad.nms.server.alarm.AlarmGenerator;
import com.sanrad.nms.server.logic.IllegalValueException;
import com.sanrad.nms.server.logic.InvalidElementException;
import com.sanrad.nms.server.logic.SynchronizeableImpl;
import com.sanrad.nms.server.logic.cluster.ClusterImpl;
import com.sanrad.nms.server.logic.scsi.SCSIDevice;
import com.sanrad.nms.server.logic.scsi.SCSIPort;
import com.sanrad.nms.server.logic.vswitch.VSwitch;
import com.sanrad.nms.server.logic.vswitch.VSwitchImpl;
import com.sanrad.nms.server.mgr.ConfigElementData;
import com.sanrad.nms.server.util.ClassID;
import com.sanrad.nms.server.util.CommKeyClassId;
import com.sanrad.nms.server.util.ParameterCode;
import com.sanrad.nms.server.util.types.constants.SCSIDeviceRoleConstant;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public abstract class SCSIDeviceImpl
extends SynchronizeableImpl
implements SCSIDevice {
    public static final int MAX_WWWI_LEN = 223;
    private ArrayList m_scsiPorts = new ArrayList();
    private static Map<ParameterCode, ParameterCode.Flags> theParameterCodeFlagsMap;

    protected SCSIDeviceImpl(ClusterImpl cluster, ClassID classId, ConfigElementData aCED) throws RemoteException, IllegalValueException, InvalidElementException {
        super(cluster, classId, aCED);
        this.validateAndInit(aCED, theParameterCodeFlagsMap);
    }

    @Override
    protected int synchronizeMe() throws RemoteException, IllegalValueException {
        return 0;
    }

    @Override
    protected String canBeDeleted() {
        return null;
    }

    @Override
    protected String isValid(HashMap parameterList) {
        return null;
    }

    @Override
    public void registerToPropagatedStateChange() {
    }

    @Override
    public AlarmGenerator getAlarmGenerator() {
        return null;
    }

    public CommKeyClassId getSCSIDeviceId() throws RemoteException {
        return this.getSCSIDeviceId(null);
    }

    public CommKeyClassId getSCSIDeviceId(VSwitch vSwitch) throws RemoteException {
        CommKeyClassId commkeyClassId = (CommKeyClassId)this.getSrValueOf(vSwitch, ParameterCode.SCSI_DEVICE_ID, vSwitch == null);
        return commkeyClassId;
    }

    @Override
    public abstract String getAlias();

    @Override
    public abstract String getAlias(VSwitchImpl var1);

    @Override
    public abstract String getName() throws RemoteException;

    public abstract String getName(VSwitchImpl var1);

    @Override
    public SCSIDeviceRoleConstant getRole() {
        return this.getRole(null);
    }

    public SCSIDeviceRoleConstant getRole(VSwitchImpl vSwitch) {
        return (SCSIDeviceRoleConstant)this.getValueOf(vSwitch, ParameterCode.SCSI_DEVICE_ROLE, vSwitch == null);
    }

    @Override
    public Integer getNumberOfPorts() throws RemoteException {
        return this.getNumberOfPorts(null);
    }

    public Integer getNumberOfPorts(VSwitchImpl vSwitch) {
        return (Integer)this.getValueOf(vSwitch, ParameterCode.SCSI_DEVICE_NUM_OF_PORTS, vSwitch == null);
    }

    @Override
    public SCSIPort[] getPorts() throws RemoteException {
        SCSIPort[] array = new SCSIPort[this.m_scsiPorts.size()];
        return this.m_scsiPorts.toArray(array);
    }

    public void addSCSIPort(SCSIPort port) {
        this.m_scsiPorts.add(port);
    }

    public void removeSCSIPort(SCSIPort port) {
        this.m_scsiPorts.remove(port);
    }

    @Override
    public void clear() throws RemoteException {
        this.m_scsiPorts.clear();
        super.clear();
    }

    static {
        HashMap<ParameterCode, ParameterCode.Flags> parameterCodeFlagsMap = new HashMap<ParameterCode, ParameterCode.Flags>();
        parameterCodeFlagsMap.put(ParameterCode.SCSI_DEVICE_ROLE, new ParameterCode.Flags(true, false));
        parameterCodeFlagsMap.put(ParameterCode.SCSI_DEVICE_NUM_OF_PORTS, new ParameterCode.Flags(true, false));
        theParameterCodeFlagsMap = Collections.unmodifiableMap(parameterCodeFlagsMap);
    }
}

