/*
 * Decompiled with CFR 0.152.
 */
package com.sanrad.nms.server.logic.scsi;

import com.sanrad.log.SrLogger;
import com.sanrad.nms.server.logic.ClientParameterCode;
import com.sanrad.nms.server.logic.IllegalValueException;
import com.sanrad.nms.server.logic.InvalidElementException;
import com.sanrad.nms.server.logic.SynchronizeableImpl;
import com.sanrad.nms.server.logic.cluster.ClusterImpl;
import com.sanrad.nms.server.logic.scsi.RemoteTarget;
import com.sanrad.nms.server.logic.vswitch.VSwitch;
import com.sanrad.nms.server.logic.vswitch.VSwitchImpl;
import com.sanrad.nms.server.mgr.ConfigElementData;
import com.sanrad.nms.server.util.ClassID;
import com.sanrad.nms.server.util.ParameterCode;
import com.sanrad.nms.server.util.types.SrString;
import com.sanrad.nms.server.util.types.constants.RemoteTargetFailureTypeConstant;
import com.sanrad.nms.server.util.types.constants.RemoteTargetLoginStatusConstant;
import java.rmi.RemoteException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public abstract class RemoteTargetImpl
extends SynchronizeableImpl
implements RemoteTarget {
    private static SrLogger theLogger = SrLogger.getLogger();
    private static Map<ParameterCode, ParameterCode.Flags> theParameterCodeFlagsMap;

    protected RemoteTargetImpl(ClusterImpl cluster, ClassID classId, ConfigElementData aCED) throws RemoteException, IllegalValueException, InvalidElementException {
        super(cluster, classId, aCED);
        this.validateAndInit(aCED, theParameterCodeFlagsMap);
    }

    @Override
    public HashMap changeParameterList(ConfigElementData aCED) throws RemoteException, IllegalValueException, InvalidElementException {
        Object failureTypeVal;
        HashMap changedValues = super.changeParameterList(aCED);
        Object loginStatusVal = changedValues.get(ParameterCode.SCSI_REMOTE_TARGET_LOGIN_STATUS);
        if (loginStatusVal != null) {
            changedValues.put(ParameterCode.SCSI_REMOTE_TARGET_LOGIN_STATUS, this.getLoginStatus());
        }
        if ((failureTypeVal = changedValues.get(ParameterCode.SCSI_REMOTE_TARGET_FAILURE_TYPE)) != null) {
            changedValues.put(ParameterCode.SCSI_REMOTE_TARGET_FAILURE_TYPE, this.getFailureType());
        }
        return changedValues;
    }

    @Override
    public HashMap getClientParameterList() throws RemoteException {
        HashMap parameterList = super.getClientParameterList();
        parameterList.put(ClientParameterCode.ISCSI_REMOTE_TARGET_LOGIN_STATUS, this.getLoginStatus());
        parameterList.put(ClientParameterCode.ISCSI_REMOTE_TARGET_FAILURE_TYPE, this.getFailureType());
        return parameterList;
    }

    @Override
    protected String isValid(HashMap parameterList) {
        String alias = (String)parameterList.get(ClientParameterCode.ISCSI_REMOTE_TARGET_ALIAS);
        if (alias != null) {
            String errorMsg;
            if (alias.equals("")) {
                alias = this.getName();
            }
            if ((errorMsg = this.isAliasValid(alias)) != null) {
                return errorMsg;
            }
            parameterList.put(ClientParameterCode.ISCSI_REMOTE_TARGET_ALIAS, new SrString(alias));
        }
        return null;
    }

    @Override
    public String getAlias() {
        return this.getAlias(null);
    }

    @Override
    public String getAlias(VSwitchImpl vSwitch) {
        String alias = (String)this.getValueOf(vSwitch, ParameterCode.SCSI_REMOTE_TARGET_ALIAS, vSwitch == null);
        return alias;
    }

    @Override
    public String getName() {
        return this.getName(null);
    }

    public String getName(VSwitchImpl vSwitch) {
        String name = (String)this.getValueOf(vSwitch, ParameterCode.DISCOVERED_TARGET_NAME, vSwitch == null);
        return name;
    }

    @Override
    public Boolean isConfigured(VSwitch vSwitch) {
        Boolean configured = (Boolean)this.getValueOf(vSwitch, ParameterCode.SCSI_REMOTE_TARGET_IS_CONFIGURED, vSwitch == null);
        return configured;
    }

    @Override
    public Boolean isConfigured() {
        VSwitchImpl[] connectedVswitches = this.getConnectedVSwitches();
        for (int index = 0; index < connectedVswitches.length; ++index) {
            VSwitchImpl vswitch = connectedVswitches[index];
            Boolean configured = this.isConfigured(vswitch);
            if (!configured.equals(Boolean.FALSE)) continue;
            return configured;
        }
        return Boolean.TRUE;
    }

    @Override
    public Boolean isDiscovered() throws RemoteException {
        VSwitchImpl[] connectedVswitches = this.getConnectedVSwitches();
        for (int index = 0; index < connectedVswitches.length; ++index) {
            VSwitchImpl vswitch = connectedVswitches[index];
            Boolean discovered = this.isDiscovered(vswitch);
            if (!discovered.equals(Boolean.FALSE)) continue;
            return discovered;
        }
        return Boolean.TRUE;
    }

    @Override
    public Boolean isDiscovered(VSwitch vSwitch) throws RemoteException {
        Boolean discovered = (Boolean)this.getValueOf(vSwitch, ParameterCode.SCSI_REMOTE_TARGET_IS_DISCOVERED, vSwitch == null);
        return discovered;
    }

    @Override
    public HashMap getLoginStatus() {
        HashMap<String, RemoteTargetLoginStatusConstant> statuses = new HashMap<String, RemoteTargetLoginStatusConstant>();
        VSwitchImpl[] connectedVswitches = this.getConnectedVSwitches();
        for (int index = 0; index < connectedVswitches.length; ++index) {
            VSwitchImpl vswitch = connectedVswitches[index];
            RemoteTargetLoginStatusConstant status = this.getLoginStatus(vswitch);
            statuses.put(vswitch.getName(), status);
        }
        return statuses;
    }

    public boolean isConnected() {
        HashMap loginStatuses = this.getLoginStatus();
        boolean isInitiatorConnetced = loginStatuses.containsValue(RemoteTargetLoginStatusConstant.CONNECTED);
        return isInitiatorConnetced;
    }

    public boolean isConnected(VSwitchImpl vSwitch) {
        RemoteTargetLoginStatusConstant loginStatuse = this.getLoginStatus(vSwitch);
        return loginStatuse != null && loginStatuse.equals(RemoteTargetLoginStatusConstant.CONNECTED);
    }

    public RemoteTargetLoginStatusConstant getLoginStatus(VSwitchImpl vSwitch) {
        RemoteTargetLoginStatusConstant status = (RemoteTargetLoginStatusConstant)this.getSrValueOf(vSwitch, ParameterCode.SCSI_REMOTE_TARGET_LOGIN_STATUS, vSwitch == null);
        return status;
    }

    @Override
    public HashMap getFailureType() throws RemoteException {
        HashMap<String, RemoteTargetFailureTypeConstant> types = new HashMap<String, RemoteTargetFailureTypeConstant>();
        VSwitchImpl[] connectedVswitches = this.getConnectedVSwitches();
        for (int index = 0; index < connectedVswitches.length; ++index) {
            VSwitchImpl vswitch = connectedVswitches[index];
            RemoteTargetFailureTypeConstant type = this.getFailureType(vswitch);
            types.put(vswitch.getName(), type);
        }
        return types;
    }

    public RemoteTargetFailureTypeConstant getFailureType(VSwitch vSwitch) throws RemoteException {
        RemoteTargetFailureTypeConstant type = (RemoteTargetFailureTypeConstant)this.getSrValueOf(vSwitch, ParameterCode.SCSI_REMOTE_TARGET_FAILURE_TYPE, vSwitch == null);
        return type;
    }

    static {
        HashMap<ParameterCode, ParameterCode.Flags> parameterCodeFlagsMap = new HashMap<ParameterCode, ParameterCode.Flags>();
        parameterCodeFlagsMap.put(ParameterCode.DISCOVERED_TARGET_NAME, new ParameterCode.Flags(true, false));
        parameterCodeFlagsMap.put(ParameterCode.SCSI_REMOTE_TARGET_ALIAS, new ParameterCode.Flags(true, false));
        parameterCodeFlagsMap.put(ParameterCode.SCSI_REMOTE_TARGET_IS_CONFIGURED, new ParameterCode.Flags(true, false));
        parameterCodeFlagsMap.put(ParameterCode.SCSI_REMOTE_TARGET_IS_DISCOVERED, new ParameterCode.Flags(true, false));
        parameterCodeFlagsMap.put(ParameterCode.SCSI_REMOTE_TARGET_LOGIN_STATUS, new ParameterCode.Flags(true, false));
        parameterCodeFlagsMap.put(ParameterCode.SCSI_REMOTE_TARGET_FAILURE_TYPE, new ParameterCode.Flags(true, false));
        theParameterCodeFlagsMap = Collections.unmodifiableMap(parameterCodeFlagsMap);
    }
}

