/*
 * Decompiled with CFR 0.152.
 */
package com.sanrad.nms.server.logic.raid;

import com.sanrad.nms.server.Server;
import com.sanrad.nms.server.SrServerBundleKeys;
import com.sanrad.nms.server.alarm.AlarmGenerator;
import com.sanrad.nms.server.logic.ClientParameterCode;
import com.sanrad.nms.server.logic.IllegalValueException;
import com.sanrad.nms.server.logic.InvalidElementException;
import com.sanrad.nms.server.logic.LogicObjectImpl;
import com.sanrad.nms.server.logic.cluster.ClusterImpl;
import com.sanrad.nms.server.logic.raid.AttachedRaid;
import com.sanrad.nms.server.mgr.ConfigElementData;
import com.sanrad.nms.server.util.ClassID;
import com.sanrad.nms.server.util.ParameterCode;
import com.sanrad.nms.server.util.types.SrEntityNameFormat;
import com.sanrad.nms.server.util.types.SrIpAddress;
import com.sanrad.nms.server.util.types.SrString;
import com.sanrad.util.BundleKeysInterface;
import com.sanrad.util.Util;
import java.rmi.RemoteException;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class AttachedRaidImpl
extends LogicObjectImpl
implements AttachedRaid {
    private static Map<ParameterCode, ParameterCode.Flags> theParameterCodeFlagsMap;

    public AttachedRaidImpl(ClusterImpl aCluster, ConfigElementData aCED) throws RemoteException, IllegalValueException, InvalidElementException {
        super(aCluster, ClassID.ATTACHED_RAID, aCED);
        this.validateAndInit(aCED, theParameterCodeFlagsMap);
    }

    @Override
    public HashMap changeParameterList(ConfigElementData aCED) throws RemoteException, IllegalValueException, InvalidElementException {
        SrEntityNameFormat uniqueName = (SrEntityNameFormat)aCED.getValue(ParameterCode.ATTACHED_RAID_UNIQUE_NAME);
        SrString name = (SrString)aCED.getValue(ParameterCode.ATTACHED_RAID_NAME);
        if (AttachedRaid.ISCSI_RAID_UNIQUE_NAME.equals(uniqueName)) {
            ConfigElementData iscsiRaidCed = new ConfigElementData(aCED);
            if (name != null) {
                iscsiRaidCed.removeValue(ParameterCode.ATTACHED_RAID_NAME);
                SrEntityNameFormat iscsiTargetName = new SrEntityNameFormat(name.toString().getBytes());
                iscsiRaidCed.setValue(ParameterCode.ATTACHED_RAID_UNIQUE_NAME, iscsiTargetName);
            }
            return super.changeParameterList(iscsiRaidCed);
        }
        return super.changeParameterList(aCED);
    }

    @Override
    public HashMap getClientParameterList() throws RemoteException {
        HashMap params = super.getClientParameterList();
        params.put(ClientParameterCode.VSWITCH_ID, this.getActiveVswitch().getCommKeyClassId());
        return params;
    }

    @Override
    public AlarmGenerator getAlarmGenerator() {
        return null;
    }

    @Override
    protected String canBeDeleted() {
        return null;
    }

    @Override
    protected String isValid(HashMap parameterList) {
        return Server.BUNDLE.getString((BundleKeysInterface)SrServerBundleKeys.ELEMENT_NOT_CONFIGURABLE, this.getClassId());
    }

    @Override
    public void registerToPropagatedStateChange() {
    }

    List<SrIpAddress> getCtrlIps() {
        SrIpAddress ip1 = (SrIpAddress)this.getSrValueOf(ParameterCode.ATTACHED_RAID_CTRL_IP1);
        SrIpAddress ip2 = (SrIpAddress)this.getSrValueOf(ParameterCode.ATTACHED_RAID_CTRL_IP1);
        return Util.convertToList(ip1, ip2);
    }

    public String getName() {
        SrString name = (SrString)this.getSrValueOf(ParameterCode.ATTACHED_RAID_NAME);
        return name != null ? name.toDisplayString() : null;
    }

    public SrEntityNameFormat getWwn() {
        return (SrEntityNameFormat)this.getSrValueOf(ParameterCode.ATTACHED_RAID_UNIQUE_NAME);
    }

    public SrIpAddress getCtrlIp1() {
        return (SrIpAddress)this.getSrValueOf(ParameterCode.ATTACHED_RAID_CTRL_IP1);
    }

    public SrIpAddress getCtrlIp2() {
        return (SrIpAddress)this.getSrValueOf(ParameterCode.ATTACHED_RAID_CTRL_IP2);
    }

    static {
        HashMap<ParameterCode, ParameterCode.Flags> parameterCodeFlagsMap = new HashMap<ParameterCode, ParameterCode.Flags>();
        parameterCodeFlagsMap.put(ParameterCode.ATTACHED_RAID_NAME, new ParameterCode.Flags(false, true));
        parameterCodeFlagsMap.put(ParameterCode.ATTACHED_RAID_UNIQUE_NAME, new ParameterCode.Flags(false, true));
        parameterCodeFlagsMap.put(ParameterCode.ATTACHED_RAID_CTRL_IP1, new ParameterCode.Flags(false, true));
        parameterCodeFlagsMap.put(ParameterCode.ATTACHED_RAID_CTRL_IP2, new ParameterCode.Flags(false, true));
        theParameterCodeFlagsMap = Collections.unmodifiableMap(parameterCodeFlagsMap);
    }
}

