/*
 * Decompiled with CFR 0.152.
 */
package com.sanrad.nms.server.logic.physstorage;

import com.sanrad.nms.server.Server;
import com.sanrad.nms.server.logic.ErrorMessage;
import com.sanrad.nms.server.logic.IllegalValueException;
import com.sanrad.nms.server.logic.LogicObjectValidator;
import com.sanrad.nms.server.logic.cluster.ClusterImpl;
import com.sanrad.nms.server.logic.physstorage.DirectAccessDeviceImpl;
import com.sanrad.nms.server.logic.vswitch.VSwitch;
import com.sanrad.nms.server.logic.vswitch.VSwitchImpl;
import com.sanrad.nms.server.util.CommKeyClassId;
import com.sanrad.util.SrConstantsBundleKeys;
import com.sanrad.util.Util;
import java.math.BigInteger;
import java.rmi.RemoteException;
import java.util.List;

public class SubDirectAccessDeviceValidator
extends LogicObjectValidator {
    private static final int ALIAS_MAX_LENGTH = Integer.parseInt(Server.CONSTANSTS_BUNDLE.getString(SrConstantsBundleKeys.ALIAS_MAX_LENGTH));
    protected DirectAccessDeviceImpl parent;
    protected BigInteger startAddr;
    protected BigInteger size;
    protected ClusterImpl cluster;
    protected String alias;

    public SubDirectAccessDeviceValidator(DirectAccessDeviceImpl parent, String alias, BigInteger startAddr, BigInteger size, ClusterImpl cluster) {
        this.parent = parent;
        this.startAddr = startAddr;
        this.size = size;
        this.cluster = cluster;
        this.alias = alias;
    }

    public static String getDefaultAlias() {
        return "$sdad$" + System.currentTimeMillis();
    }

    @Override
    public boolean isValid() throws RemoteException {
        if (this.alias.length() > ALIAS_MAX_LENGTH) {
            String msg = "Alias cannot exceed " + ALIAS_MAX_LENGTH + " characters. Please select a different alias";
            this.setErrorMsg(msg);
            return false;
        }
        BigInteger parentTotalSpace = this.parent.getTotalSpace();
        if (parentTotalSpace.compareTo(BigInteger.ZERO) == 0) {
            return true;
        }
        String msg = Util.bytesToLargerUnits(this.size);
        BigInteger parentNonAllocatedSpace = this.parent.getNonAllocatedSpace();
        if (this.size.compareTo(parentNonAllocatedSpace) > 0 && parentNonAllocatedSpace.compareTo(BigInteger.ZERO) > 0) {
            this.setErrorMsg(ErrorMessage.CAPACITY_IS_TOO_HIGH.getMessage(msg));
            return false;
        }
        return true;
    }

    public CommKeyClassId[] getLegalVSwitchesForOperation(List<VSwitchImpl> vSwitchToSet) throws IllegalValueException {
        VSwitch[] vSwitches = new VSwitch[vSwitchToSet.size()];
        return this.getLegalVSwitchesForOperation(vSwitchToSet.toArray(vSwitches));
    }

    public CommKeyClassId[] getLegalVSwitchesForOperation(VSwitch[] vSwitchToSet) throws IllegalValueException {
        CommKeyClassId[] toSet = new CommKeyClassId[vSwitchToSet.length];
        for (int i = 0; i < vSwitchToSet.length; ++i) {
            toSet[i] = ((VSwitchImpl)vSwitchToSet[i]).getCommKeyClassId();
        }
        return this.getLegalVSwitchesForOperation(toSet);
    }

    @Override
    public CommKeyClassId[] getLegalVSwitchesForOperation(CommKeyClassId[] vSwitchToSet) throws IllegalValueException {
        CommKeyClassId[] parentExistsOn = this.getVSwitchesAllElementsExistIn(this.parent, this.cluster);
        return this.getVSwitchesToSet(vSwitchToSet, parentExistsOn);
    }
}

