/*
 * Decompiled with CFR 0.152.
 */
package com.sanrad.nms.server.logic.physstorage;

import com.sanrad.log.SrLogCategories;
import com.sanrad.log.SrLogger;
import com.sanrad.nms.server.logic.ErrorMessage;
import com.sanrad.nms.server.logic.cluster.ClusterImpl;
import com.sanrad.nms.server.logic.physstorage.DirectAccessDeviceImpl;
import com.sanrad.nms.server.logic.physstorage.SubDirectAccessDeviceValidator;
import com.sanrad.nms.server.logic.volume.Volume;
import com.sanrad.nms.server.logic.volume.VolumeImpl;
import com.sanrad.nms.server.logic.vswitch.VSwitchImpl;
import com.sanrad.nms.server.util.ClassID;
import java.math.BigInteger;
import java.rmi.RemoteException;
import java.util.List;

public class SubDirectAccessDeviceSyncValidator
extends SubDirectAccessDeviceValidator {
    private List<VSwitchImpl> vSwitches;
    private static SrLogger theLogger = SrLogger.getLogger();

    public SubDirectAccessDeviceSyncValidator(DirectAccessDeviceImpl parent, String alias, BigInteger startAddr, BigInteger size, ClusterImpl cluster, List<VSwitchImpl> vSwitchToSync) {
        super(parent, alias, startAddr, size, cluster);
        this.vSwitches = vSwitchToSync;
    }

    @Override
    public boolean isValid() throws RemoteException {
        VolumeImpl volParent;
        if (super.isValid() && (volParent = this.getParentVolume(this.parent)) != null) {
            String[] msgBody = new String[]{this.parent.getAlias(), ((Volume)volParent).getClassId() + " " + volParent.getAlias()};
            this.setErrorMsg(ErrorMessage.DISK_HAS_VOLUME_CANNOT_CREATE_SUB_DISK.getMessage(msgBody));
            return false;
        }
        try {
            if (this.getLegalVSwitchesForOperation(this.vSwitches).length > 0) {
                return true;
            }
            this.setErrorMsg("Cannot find any legal " + ClassID.VSWITCH + " for Sub Direct Access Device Cluster Sync for: " + this.alias);
        }
        catch (Exception e) {
            String eMessage = e.getMessage();
            eMessage = eMessage == null ? "" : ": " + eMessage;
            this.setErrorMsg("Cannot find any legal " + ClassID.VSWITCH + " for Cluster Sync for Subdisk " + this.alias + eMessage);
            theLogger.error(SrLogCategories.EXCEPTION, e, " Subdisk: ", this.alias);
        }
        return false;
    }

    private VolumeImpl getParentVolume(DirectAccessDeviceImpl storage) {
        for (VSwitchImpl vs : this.vSwitches) {
            VolumeImpl vol = this.parent.getParentVolume(vs);
            if (vol == null) continue;
            return vol;
        }
        return null;
    }
}

