/*
 * Decompiled with CFR 0.152.
 */
package com.sanrad.nms.server.logic.physstorage;

import com.sanrad.log.SrLogCategories;
import com.sanrad.log.SrLogger;
import com.sanrad.nms.server.alarm.AlarmGenerator;
import com.sanrad.nms.server.alarm.physstorage.SubDirectAccessDeviceAlarmGenerator;
import com.sanrad.nms.server.logic.ClientParameterCode;
import com.sanrad.nms.server.logic.ErrorMessage;
import com.sanrad.nms.server.logic.IllegalValueException;
import com.sanrad.nms.server.logic.InvalidElementException;
import com.sanrad.nms.server.logic.LogicObjectImpl;
import com.sanrad.nms.server.logic.cluster.ClusterImpl;
import com.sanrad.nms.server.logic.physstorage.DirectAccessDeviceImpl;
import com.sanrad.nms.server.logic.physstorage.SubDirectAccessDevice;
import com.sanrad.nms.server.logic.physstorage.SubDirectAccessDeviceCreateValidator;
import com.sanrad.nms.server.logic.physstorage.SubDirectAccessDeviceSyncValidator;
import com.sanrad.nms.server.logic.volume.VolumeImpl;
import com.sanrad.nms.server.logic.volume.VolumeNodeImpl;
import com.sanrad.nms.server.logic.volume.copy.CopyOperationImpl;
import com.sanrad.nms.server.logic.vswitch.VSwitchImpl;
import com.sanrad.nms.server.mgr.ConfigElementData;
import com.sanrad.nms.server.util.ClassID;
import com.sanrad.nms.server.util.CommKeyClassId;
import com.sanrad.nms.server.util.Parameter;
import com.sanrad.nms.server.util.ParameterCode;
import com.sanrad.nms.server.util.types.ConfigElementDataList;
import com.sanrad.nms.server.util.types.SrString;
import com.sanrad.nms.server.util.types.constants.SubDirectAccessDeviceOperStatusConstant;
import com.sanrad.util.Util;
import com.sanrad.util.concurrent.ErrorAssertingListener;
import java.math.BigInteger;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Vector;

public class SubDirectAccessDeviceImpl
extends VolumeNodeImpl
implements SubDirectAccessDevice {
    private static Map<ParameterCode, ParameterCode.Flags> theParameterCodeFlagsMap;
    private DirectAccessDeviceImpl directAccessDeviceParent = null;
    private BigInteger endAddress = null;
    private static SrLogger theLogger;

    public SubDirectAccessDeviceImpl(ClusterImpl cluster, ConfigElementData aCED) throws RemoteException, IllegalValueException, InvalidElementException {
        super(cluster, ClassID.SUB_DIRECT_ACCESS_DEVICE, aCED);
        this.validateAndInit(aCED, theParameterCodeFlagsMap);
    }

    @Override
    public HashMap changeParameterList(ConfigElementData aCED) throws RemoteException, IllegalValueException, InvalidElementException {
        HashMap changedValues = super.changeParameterList(aCED);
        CommKeyClassId parentCommKeyClassId = (CommKeyClassId)aCED.getValue(ParameterCode.SUB_DIRECT_ACCESS_DEVICE_DISK_ID);
        if (parentCommKeyClassId != null) {
            this.directAccessDeviceParent = (DirectAccessDeviceImpl)this.cluster.getCommKeyRefMap().getRefByCommKeyClassID(parentCommKeyClassId);
            if (this.directAccessDeviceParent != null) {
                this.endAddress = this.getEndAddress();
                this.directAccessDeviceParent.addSubDirectAccessDevice(this);
            } else {
                throw new NullPointerException(ClassID.DIRECT_ACCESS_DEVICE + " parent not found for " + this.getClassId() + " " + this.getAlias());
            }
        }
        return changedValues;
    }

    @Override
    public DirectAccessDeviceImpl getDirectAccessDeviceParent() {
        return this.directAccessDeviceParent;
    }

    @Override
    public String getAlias() {
        return this.getAlias(null);
    }

    @Override
    public String getAlias(VSwitchImpl vSwitch) {
        return (String)this.getValueOf(vSwitch, ParameterCode.SUB_DIRECT_ACCESS_DEVICE_ALIAS, vSwitch == null);
    }

    @Override
    public String getInfo() {
        return this.getInfo(null);
    }

    public String getInfo(VSwitchImpl vSwitch) {
        return (String)this.getValueOf(vSwitch, ParameterCode.SUB_DIRECT_ACCESS_DEVICE_INFO, vSwitch == null);
    }

    @Override
    public BigInteger getEndAddress() {
        return this.getEndAddress(null);
    }

    public BigInteger getEndAddress(VSwitchImpl vSwitch) {
        BigInteger endAddressBlocks = (BigInteger)this.getValueOf(vSwitch, ParameterCode.SUB_DIRECT_ACCESS_DEVICE_END_ADDR, vSwitch == null);
        int blockSize = this.getBlockSize(vSwitch);
        return Util.blocksToBytes(endAddressBlocks, blockSize);
    }

    @Override
    public BigInteger getStartAddress() {
        return this.getStartAddress(null);
    }

    public BigInteger getStartAddress(VSwitchImpl vSwitch) {
        BigInteger endAddress = this.getEndAddress(vSwitch);
        BigInteger size = this.getSize(vSwitch);
        if (endAddress == null || endAddress.compareTo(BigInteger.ZERO) == 0) {
            endAddress = BigInteger.ONE;
        }
        return endAddress.subtract(size).add(this.getBlockSizeBigInteger(vSwitch));
    }

    public boolean isSpaceFree() {
        return false;
    }

    @Override
    public String getEntityName() {
        return this.getEntityName(null);
    }

    public String getEntityName(VSwitchImpl vSwitch) {
        return this.directAccessDeviceParent.getEntityName(vSwitch);
    }

    public boolean isLeaf() {
        return true;
    }

    @Override
    public int getBlockSize(VSwitchImpl vSwitch) {
        return this.directAccessDeviceParent.getBlockSize(vSwitch);
    }

    public BigInteger getBlockSizeBigInteger(VSwitchImpl vSwitch) {
        return this.directAccessDeviceParent.getBlockSizeBigInteger(vSwitch);
    }

    public Vector<VolumeNodeImpl> getChildren() {
        return null;
    }

    @Override
    public BigInteger getSize() {
        return this.getSize(null);
    }

    public BigInteger getSize(VSwitchImpl vSwitch) {
        BigInteger numberOfBlocks = (BigInteger)this.getValueOf(vSwitch, ParameterCode.SUB_DIRECT_ACCESS_DEVICE_LENGTH, vSwitch == null);
        theLogger.logAndAssert(SrLogCategories.ERROR, numberOfBlocks != null, new Object[]{"numberOfBlocks of " + this.getClassId() + " " + this + " is null."});
        return Util.blocksToBytes(numberOfBlocks, this.getBlockSize(vSwitch));
    }

    @Override
    public BigInteger getNumberOfBlocks(VSwitchImpl vSwitch) {
        return (BigInteger)this.getValueOf(vSwitch, ParameterCode.SUB_DIRECT_ACCESS_DEVICE_LENGTH, vSwitch == null);
    }

    public BigInteger getNumberOfBlocks() {
        return this.getNumberOfBlocks(null);
    }

    @Override
    public double getBlockNum(VSwitchImpl vSwitch) {
        return ((BigInteger)this.getValueOf(vSwitch, ParameterCode.SUB_DIRECT_ACCESS_DEVICE_LENGTH, vSwitch == null)).doubleValue();
    }

    @Override
    public double getBlockNum() {
        return this.getBlockNum(null);
    }

    @Override
    public BigInteger getAccessibleSpace() {
        return this.getSize();
    }

    public BigInteger getPotentialCapacity() {
        return this.getSize();
    }

    @Override
    public BigInteger getAllocatedSpace() {
        return this.getSize();
    }

    @Override
    public SubDirectAccessDeviceOperStatusConstant getOperStatus() {
        return (SubDirectAccessDeviceOperStatusConstant)this.getSrValueOf(ParameterCode.SUB_DIRECT_ACCESS_DEVICE_OPER_STATUS);
    }

    public SubDirectAccessDeviceOperStatusConstant getOperStatus(VSwitchImpl vswitch) {
        return (SubDirectAccessDeviceOperStatusConstant)this.getSrValueOf(vswitch, ParameterCode.SUB_DIRECT_ACCESS_DEVICE_OPER_STATUS);
    }

    @Override
    protected String canBeDeleted() {
        VolumeImpl volumeParent = this.getParentVolume();
        if (volumeParent != null) {
            String[] msgBody = new String[]{this.getAlias(), volumeParent.getClassId() + " " + volumeParent.getAlias()};
            return ErrorMessage.CANNOT_DELETE_SUB_DISK_UNDER_VOLUME.getMessage(msgBody);
        }
        if (!this.isFree()) {
            String[] msgBody = new String[]{"The " + this.getClassId() + " " + this + " is not free and therefore can not be deleted."};
            return ErrorMessage.CANNOT_DELETE_SUB_DISK_UNDER_VOLUME.getMessage(msgBody);
        }
        CopyOperationImpl oper = this.cluster.getCopyOperManager().getCopyForNode(this.getCommKeyClassId());
        if (oper != null) {
            String[] msg = new String[]{this.getClassId().toString() + " " + this.toString(), oper.getCopyType().toString(), oper.getCopyType().toString()};
            return ErrorMessage.CANNOT_DELETE_PHYS_STOR_IN_COPY.getMessage(msg);
        }
        return super.canBeDeleted();
    }

    @Override
    protected String isValid(HashMap parameterList) {
        String info;
        String alias = (String)parameterList.get(ClientParameterCode.SUB_DIRECT_ACCESS_DEVICE_ALIAS);
        if (alias != null) {
            DirectAccessDeviceImpl device;
            String errorMsg = this.isAliasValid(alias);
            if (errorMsg != null) {
                return errorMsg;
            }
            if (alias.equals("")) {
                alias = SubDirectAccessDeviceCreateValidator.getDefaultAlias();
            }
            if ((device = this.cluster.getStoragePool().getSubDirectAccessDevice(alias)) != null) {
                String[] msgParts = new String[]{alias, device.getAlias()};
                return ErrorMessage.SUB_DISK_ALIAS_ALREADY_IN_USE.getMessage(msgParts);
            }
            parameterList.put(ClientParameterCode.SUB_DIRECT_ACCESS_DEVICE_ALIAS, new SrString(alias));
        }
        if ((info = (String)parameterList.get(ClientParameterCode.SUB_DIRECT_ACCESS_DEVICE_INFO)) != null) {
            parameterList.put(ClientParameterCode.SUB_DIRECT_ACCESS_DEVICE_INFO, new SrString(info));
        }
        return null;
    }

    @Override
    protected String canBeSynchronized() throws RemoteException, IllegalValueException {
        StringBuffer msg = new StringBuffer("Subdisk ");
        msg.append(this.getAlias());
        msg.append(" cannot be synchronized. ");
        msg.append(this.directAccessDeviceParent.getClassId());
        msg.append(" ");
        msg.append(this.directAccessDeviceParent.getAlias());
        boolean hasError = false;
        if (this.directAccessDeviceParent.isNeedToSynchronize()) {
            msg.append(" is not synchornized yet");
            hasError = true;
        } else if (!this.directAccessDeviceParent.isRedundant()) {
            msg.append(" is not redundant");
            hasError = true;
        } else if (this.directAccessDeviceParent.isIllegalUpHierarchy()) {
            msg.append(" is Illegal");
            hasError = true;
        }
        if (hasError) {
            theLogger.warn(SrLogCategories.LEGACY, msg);
            return msg.toString();
        }
        return null;
    }

    @Override
    protected int synchronizeMe() throws RemoteException, IllegalValueException {
        if (this.canBeSynchronized() != null) {
            return 3;
        }
        if (!this.isInSynchronizingMode()) {
            SubDirectAccessDeviceSyncValidator validator = new SubDirectAccessDeviceSyncValidator(this.directAccessDeviceParent, this.getAlias(), this.getStartAddress(), this.getSize(), this.cluster, this.cluster.getOtherVSwitches(this.getVSwitches()));
            if (!validator.isValid()) {
                throw new IllegalValueException(validator.getErrorMsg());
            }
            ErrorAssertingListener.listenTo(this.directAccessDeviceParent.createSubDirectAccessDevice(this.getAlias(), this.getStartAddress(), this.getSize(), this.cluster.getOtherVSwitches(this.getVSwitches()), this.getCommKeyClassId()));
            this.setSynchronizingMode(true);
        }
        return 2;
    }

    @Override
    public int getChildrenOfVirtualVolumeTypeCount() {
        return 0;
    }

    @Override
    public boolean equals(Object obj) {
        if (super.equals(obj)) {
            return true;
        }
        if (obj instanceof SubDirectAccessDevice) {
            try {
                return ((SubDirectAccessDeviceImpl)obj).getSrValueOf(ParameterCode.SUB_DIRECT_ACCESS_DEVICE_END_ADDR) != null && ((SubDirectAccessDeviceImpl)obj).getSrValueOf(ParameterCode.SUB_DIRECT_ACCESS_DEVICE_END_ADDR).equals(this.getSrValueOf(ParameterCode.SUB_DIRECT_ACCESS_DEVICE_END_ADDR)) && ((SubDirectAccessDevice)obj).getDirectAccessDeviceParent().equals(this.getDirectAccessDeviceParent());
            }
            catch (RemoteException re) {
                theLogger.logAndAssert(SrLogCategories.EXCEPTION, re, "got a remote exception in the server.");
            }
        }
        return false;
    }

    @Override
    public void registerToPropagatedStateChange() {
        DirectAccessDeviceImpl parent = this.getDirectAccessDeviceParent();
        if (parent != null) {
            this.addPropagationStateDependentObjectAndListener(parent);
            this.cluster.removePropagationStateDependentObjectAndListener(parent);
        } else {
            theLogger.error(SrLogCategories.LEGACY, "parent of ", this.getClassId(), " ", this, " is null");
        }
        this.cluster.addPropagationStateDependentObjectAndListener(this);
    }

    @Override
    public boolean isOneOfTheVolumesInHierarchyNeedSync() throws RemoteException {
        return this.isNeedSync();
    }

    @Override
    public AlarmGenerator getAlarmGenerator() {
        return SubDirectAccessDeviceAlarmGenerator.getInstance();
    }

    @Override
    public synchronized int synchronize() throws RemoteException, IllegalValueException {
        theLogger.trace(SrLogCategories.LEGACY, "Sync of subDisk ", this.getAlias());
        if (this.isSynchronizePending()) {
            theLogger.trace(SrLogCategories.LEGACY, "Already synchronizing ", this.getClassId(), " ", this.toString());
            return 1;
        }
        if (!this.isNeedToSynchronize()) {
            return 0;
        }
        theLogger.trace(SrLogCategories.LEGACY, "Start to synchronize ", this.getClassId(), " ", this.toString());
        this.setSynchronizePending(true);
        int retVal = this.synchronizeMe();
        theLogger.trace(SrLogCategories.LEGACY, "Sync of subDisk ", this.getAlias(), " SyncMe status ", retVal);
        switch (retVal) {
            case 0: 
            case 3: {
                this.setSynchronizePending(false);
            }
        }
        return retVal;
    }

    @Override
    public boolean isInternal(VSwitchImpl vSwitch) {
        return this.getParentLU(vSwitch) == null && this.getParentVolume(vSwitch) == null;
    }

    @Override
    public void updateElementWithCreationParameters(ConfigElementData element, ClusterImpl remoteCluster) throws RemoteException, IllegalValueException {
        element.addParameter(new Parameter(ParameterCode.SUB_DIRECT_ACCESS_DEVICE_LENGTH, this.getSrValueOf(ParameterCode.SUB_DIRECT_ACCESS_DEVICE_LENGTH)));
        element.addParameter(new Parameter(ParameterCode.SUB_DIRECT_ACCESS_DEVICE_END_ADDR, this.getSrValueOf(ParameterCode.SUB_DIRECT_ACCESS_DEVICE_END_ADDR)));
        element.addParameter(new Parameter(ParameterCode.SUB_DIRECT_ACCESS_DEVICE_INFO, this.getSrValueOf(ParameterCode.SUB_DIRECT_ACCESS_DEVICE_INFO)));
        super.updateElementWithCreationParameters(element, remoteCluster);
    }

    @Override
    protected void createIscsiDisk(HashMap devices, ConfigElementData element, ClusterImpl remoteCluster) throws RemoteException, IllegalAccessException, IllegalValueException {
        element.setClassId(ClassID.SUB_DIRECT_ACCESS_DEVICE);
        DirectAccessDeviceImpl disk = this.getDirectAccessDeviceParent();
        ConfigElementData diskCed = (ConfigElementData)devices.get(disk);
        if (diskCed == null) {
            diskCed = new ConfigElementData(ClassID.DIRECT_ACCESS_DEVICE);
            this.getDirectAccessDeviceParent().updateElementWithCreationParameters(diskCed, remoteCluster);
            devices.put(disk, diskCed);
        }
        element.setValue(ParameterCode.SUB_DIRECT_ACCESS_DEVICE_DISK_ID, diskCed);
    }

    @Override
    protected LogicObjectImpl findEquivelentElement(ClusterImpl cluster, LogicObjectImpl childVol) throws RemoteException, IllegalValueException {
        DirectAccessDeviceImpl device;
        Vector<SubDirectAccessDeviceImpl> subdisks;
        if (childVol != null && (subdisks = (device = (DirectAccessDeviceImpl)childVol).getSubDirectAccessDevices()).contains(this)) {
            return subdisks.get(subdisks.indexOf(this));
        }
        return null;
    }

    @Override
    public ConfigElementDataList buildCedListForRemoveVolumeTree(Vector subdisks, ConfigElementDataList elementList) throws RemoteException {
        ConfigElementData element = new ConfigElementData(this.getCommKeyClassId());
        this.getCluster().prepareVSwitchIDs(element, "prepare element for remove volume tree", this.getConnectedVSwitchesAsList());
        elementList.add(element);
        subdisks.addElement(this);
        this.getDirectAccessDeviceParent().buildCedListForRemoveVolumeTree(subdisks, elementList);
        return elementList;
    }

    @Override
    public boolean isProvisioned() {
        return this.getDirectAccessDeviceParent().isProvisioned();
    }

    public boolean isMismatch(VSwitchImpl vswitch) {
        return SubDirectAccessDeviceOperStatusConstant.MISMATCH.equals(this.getOperStatus(vswitch));
    }

    public boolean isNonValidate(VSwitchImpl vswitch) {
        return SubDirectAccessDeviceOperStatusConstant.NON_VALIDATE.equals(this.getOperStatus(vswitch));
    }

    @Override
    protected ArrayList<ParameterCode> getParamsForCreation() {
        ArrayList<ParameterCode> params = new ArrayList<ParameterCode>();
        params.add(ParameterCode.SUB_DIRECT_ACCESS_DEVICE_ALIAS);
        params.add(ParameterCode.SUB_DIRECT_ACCESS_DEVICE_LENGTH);
        params.add(ParameterCode.SUB_DIRECT_ACCESS_DEVICE_END_ADDR);
        params.add(ParameterCode.SUB_DIRECT_ACCESS_DEVICE_DISK_ID);
        return params;
    }

    static {
        HashMap<ParameterCode, ParameterCode.Flags> parameterCodeFlagsMap = new HashMap<ParameterCode, ParameterCode.Flags>();
        parameterCodeFlagsMap.put(ParameterCode.SUB_DIRECT_ACCESS_DEVICE_ALIAS, new ParameterCode.Flags(true, false));
        parameterCodeFlagsMap.put(ParameterCode.SUB_DIRECT_ACCESS_DEVICE_END_ADDR, new ParameterCode.Flags(true, false));
        parameterCodeFlagsMap.put(ParameterCode.SUB_DIRECT_ACCESS_DEVICE_LENGTH, new ParameterCode.Flags(true, false));
        parameterCodeFlagsMap.put(ParameterCode.SUB_DIRECT_ACCESS_DEVICE_INFO, new ParameterCode.Flags(true, false));
        parameterCodeFlagsMap.put(ParameterCode.SUB_DIRECT_ACCESS_DEVICE_DISK_ID, new ParameterCode.Flags(true, false));
        parameterCodeFlagsMap.put(ParameterCode.SUB_DIRECT_ACCESS_DEVICE_OPER_STATUS, new ParameterCode.Flags(true, false));
        theParameterCodeFlagsMap = Collections.unmodifiableMap(parameterCodeFlagsMap);
        theLogger = SrLogger.getLogger();
    }
}

