/*
 * Decompiled with CFR 0.152.
 */
package com.sanrad.nms.server.logic.physstorage;

import com.sanrad.log.SrLogCategories;
import com.sanrad.log.SrLogger;
import com.sanrad.nms.server.alarm.AlarmGenerator;
import com.sanrad.nms.server.alarm.physstorage.GeneralSCSIDeviceAlarmGenerator;
import com.sanrad.nms.server.logic.AliasObjectValidator;
import com.sanrad.nms.server.logic.ClientParameterCode;
import com.sanrad.nms.server.logic.ErrorMessage;
import com.sanrad.nms.server.logic.IllegalValueException;
import com.sanrad.nms.server.logic.InvalidElementException;
import com.sanrad.nms.server.logic.SitesSynchronizeable;
import com.sanrad.nms.server.logic.cluster.ClusterImpl;
import com.sanrad.nms.server.logic.lu.LUImpl;
import com.sanrad.nms.server.logic.physstorage.GeneralSCSIDevice;
import com.sanrad.nms.server.logic.physstorage.LUIdentifierImpl;
import com.sanrad.nms.server.logic.storage.StorageImpl;
import com.sanrad.nms.server.logic.volume.VolumeImpl;
import com.sanrad.nms.server.logic.volume.VolumeNodeImpl;
import com.sanrad.nms.server.logic.vswitch.VSwitchImpl;
import com.sanrad.nms.server.mgr.ConfigElementData;
import com.sanrad.nms.server.util.ClassID;
import com.sanrad.nms.server.util.CommKeyClassId;
import com.sanrad.nms.server.util.Parameter;
import com.sanrad.nms.server.util.ParameterCode;
import com.sanrad.nms.server.util.types.ConfigElementDataList;
import com.sanrad.nms.server.util.types.SrEntityNameFormat;
import com.sanrad.nms.server.util.types.SrInteger;
import com.sanrad.nms.server.util.types.SrIpAddress;
import com.sanrad.nms.server.util.types.SrLunFormat;
import com.sanrad.nms.server.util.types.SrString;
import com.sanrad.nms.server.util.types.SrType;
import com.sanrad.nms.server.util.types.constants.PhysStorTransportTypeConstant;
import com.sanrad.nms.server.util.types.constants.PhysicalStorageComAdminStatusConstant;
import com.sanrad.nms.server.util.types.constants.PhysicalStorageComOperStatusConstant;
import com.sanrad.nms.server.util.types.constants.PhysicalStorageDriveTypeConstant;
import com.sanrad.nms.server.util.types.constants.PhysicalStorageOperStatusConstant;
import com.sanrad.nms.server.util.types.constants.PhysicalStorageRaidLevelConstant;
import com.sanrad.nms.server.util.types.constants.PhysicalStorageTypeConstant;
import com.sanrad.nms.server.util.types.constants.SrBITSConstant;
import com.sanrad.util.Util;
import com.sanrad.util.concurrent.CompleteFuture;
import com.sanrad.util.concurrent.ErrorAssertingListener;
import com.sanrad.util.concurrent.SrFuture;
import java.math.BigInteger;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class GeneralSCSIDeviceImpl
extends VolumeNodeImpl
implements GeneralSCSIDevice,
SitesSynchronizeable {
    private static Map<ParameterCode, ParameterCode.Flags> theParameterCodeFlagsMap;
    public static final int PSCSI_PORT_INDEX_IN_OCTET_STRING = 3;
    public static final int PSCSI_BUS_INDEX_IN_OCTET_STRING = 7;
    private static final Pattern NEXSAN_IP_PATTERN;
    private static SrLogger theLogger;
    private Object entityName = null;
    private String lun = null;
    private String transportType = null;
    private String type = null;
    private String serialNumber = null;
    private List<LUIdentifierImpl> myLuIdentifier = null;
    private String m_keptEntityNameForRemoval = null;
    private PhysicalStorageDriveTypeConstant myDriveType = null;

    public GeneralSCSIDeviceImpl(ClusterImpl cluster, ConfigElementData aCED) throws RemoteException, IllegalValueException, InvalidElementException {
        this(cluster, ClassID.GENERAL_SCSI_DEVICE, aCED);
    }

    protected GeneralSCSIDeviceImpl(ClusterImpl cluster, ClassID classId, ConfigElementData aCED) throws RemoteException, IllegalValueException, InvalidElementException {
        super(cluster, classId, aCED);
        this.validateAndInit(aCED, theParameterCodeFlagsMap);
    }

    @Override
    public HashMap changeParameterList(ConfigElementData aCED) throws RemoteException, IllegalValueException, InvalidElementException {
        BigInteger prevNonAllocated = this.getNonAllocatedSpace();
        HashMap changedValues = super.changeParameterList(aCED);
        BigInteger newNonAllocated = this.getNonAllocatedSpace();
        if (newNonAllocated != null && !newNonAllocated.equals(prevNonAllocated)) {
            changedValues.put(ClientParameterCode.SCSI_DEVICE_NON_ALLOCATED_SPACE, newNonAllocated);
        }
        this.toStringValue = this.getAlias();
        this.entityName = this.getEntityNameValue();
        this.lun = this.getLUN();
        this.transportType = this.getTransportType().value().toString();
        this.type = this.getType();
        this.myDriveType = this.getDriveType();
        this.serialNumber = this.getSerialNumber();
        this.myLuIdentifier = this.getLUIdentifier();
        return changedValues;
    }

    @Override
    public HashMap getClientParameterList() throws RemoteException {
        HashMap params = super.getClientParameterList();
        params.put(ClientParameterCode.SCSI_DEVICE_NON_ALLOCATED_SPACE, this.getNonAllocatedSpace());
        return params;
    }

    @Override
    protected void setVswitchesToPerformOperation(ConfigElementData element, HashMap parameterList) throws IllegalValueException {
        if (parameterList.containsKey(ClientParameterCode.PHYSICAL_STORAGE_BLINK_ACTIVE)) {
            theLogger.trace(SrLogCategories.LEGACY, "Trying to Blink ", this.getClassId(), " ", this);
            CommKeyClassId[] vSwitchCommKeyClassId = new CommKeyClassId[1];
            List<VSwitchImpl> vSwitches = this.getVSwitches();
            if (!vSwitches.isEmpty()) {
                PhysicalStorageComAdminStatusConstant newStatus = (PhysicalStorageComAdminStatusConstant)parameterList.get(ClientParameterCode.PHYSICAL_STORAGE_BLINK_ACTIVE);
                for (VSwitchImpl vSwitch : vSwitches) {
                    boolean rightVSwitch;
                    boolean isBlinking = this.isInCommandState(vSwitch, PhysicalStorageComOperStatusConstant.PHYS_STOR_COM_OPER_STAT_BLINK);
                    boolean bl = rightVSwitch = newStatus.equals(PhysicalStorageComAdminStatusConstant.PHYS_STOR_COM_OPER_STAT_BLINK) && !isBlinking || !newStatus.equals(PhysicalStorageComAdminStatusConstant.PHYS_STOR_COM_OPER_STAT_BLINK) && isBlinking;
                    if (!vSwitch.isConnected() || !rightVSwitch) continue;
                    vSwitchCommKeyClassId[0] = new CommKeyClassId(vSwitch.getCommKeys(), vSwitch.getClassId());
                    element.addParameter(new Parameter(ParameterCode.VSWITCH_ID, vSwitchCommKeyClassId));
                    return;
                }
                theLogger.trace(SrLogCategories.LEGACY, "No ", ClassID.VSWITCH, " is connected");
            } else {
                theLogger.trace(SrLogCategories.LEGACY, "change element: Could not find any ", ClassID.VSWITCH);
            }
        }
    }

    @Override
    public String getAlias() {
        return this.getAlias(null);
    }

    @Override
    public String getAlias(VSwitchImpl vSwitch) {
        return (String)this.getValueOf(vSwitch, ParameterCode.PHYSICAL_STORAGE_ALIAS, vSwitch == null);
    }

    @Override
    public String getLUN() {
        return this.getLUN(null);
    }

    public String getLUN(VSwitchImpl vSwitch) {
        SrType value = this.getSrValueOf(vSwitch, ParameterCode.PHYSICAL_STORAGE_LUN, vSwitch == null);
        if (value == null) {
            return null;
        }
        return GeneralSCSIDeviceImpl.formatSCSIDeviceLUN((SrLunFormat)value);
    }

    public static String formatSCSIDeviceLUN(SrLunFormat lunFormat) {
        return String.valueOf(lunFormat.toInt());
    }

    public static SrLunFormat parseSCSIDeviceLUN(int lun) {
        byte lunByte = lun < 128 ? (byte)lun : (byte)(lun - 256);
        return new SrLunFormat(new byte[]{0, lunByte, 0, 0, 0, 0, 0, 0});
    }

    public boolean isLeaf() {
        return true;
    }

    private boolean isInState(VSwitchImpl vSwitch, PhysicalStorageOperStatusConstant state) {
        PhysicalStorageOperStatusConstant status = this.getOperationalStatus(vSwitch);
        return status != null && status.equals(state);
    }

    private boolean isInCommandState(VSwitchImpl vSwitch, PhysicalStorageComOperStatusConstant state) {
        PhysicalStorageComOperStatusConstant status = this.getComOperationalStatus(vSwitch);
        if (status == null) {
            return false;
        }
        return status.equals(state);
    }

    @Override
    public boolean isMissing() {
        VSwitchImpl[] vSwitches = this.getConnectedVSwitches();
        for (int i = 0; i < vSwitches.length; ++i) {
            if (this.isMissing(vSwitches[i])) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean isProvisioned() {
        VSwitchImpl[] vSwitches = this.getConnectedVSwitches();
        for (int i = 0; i < vSwitches.length; ++i) {
            if (this.isProvisioned(vSwitches[i])) continue;
            return false;
        }
        return true;
    }

    public boolean isInvalid() throws RemoteException {
        VSwitchImpl[] vSwitches = this.getConnectedVSwitches();
        for (int i = 0; i < vSwitches.length; ++i) {
            if (this.isInvalid(vSwitches[i])) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean isBlinking() {
        VSwitchImpl[] vSwitches = this.getConnectedVSwitches();
        for (int i = 0; i < vSwitches.length; ++i) {
            if (!this.isBlinking(vSwitches[i])) continue;
            return true;
        }
        return false;
    }

    public boolean isEnabled() {
        VSwitchImpl[] vSwitches = this.getConnectedVSwitches();
        for (int i = 0; i < vSwitches.length; ++i) {
            if (!this.isEnabled(vSwitches[i])) continue;
            return true;
        }
        return false;
    }

    public boolean isDisabled() {
        VSwitchImpl[] vSwitches = this.getConnectedVSwitches();
        for (int i = 0; i < vSwitches.length; ++i) {
            if (!this.isDisabled(vSwitches[i])) continue;
            return true;
        }
        return false;
    }

    public boolean isMissing(VSwitchImpl vSwitch) {
        return this.isInState(vSwitch, PhysicalStorageOperStatusConstant.PHYS_STOR_OPER_STAT_MISSING);
    }

    public boolean isProvisioned(VSwitchImpl vSwitch) {
        return this.isInState(vSwitch, PhysicalStorageOperStatusConstant.PHYS_STOR_OPER_STAT_PROVISIONED);
    }

    public boolean isInvalid(VSwitchImpl vSwitch) {
        return this.isInState(vSwitch, PhysicalStorageOperStatusConstant.PHYS_STOR_OPER_STAT_INVALID);
    }

    public boolean isBlinking(VSwitchImpl vSwitch) {
        return this.isInCommandState(vSwitch, PhysicalStorageComOperStatusConstant.PHYS_STOR_COM_OPER_STAT_BLINK);
    }

    public boolean isEnabled(VSwitchImpl vSwitch) {
        return this.isInState(vSwitch, PhysicalStorageOperStatusConstant.PHYS_STOR_OPER_STAT_ENABLE);
    }

    public boolean isDisabled(VSwitchImpl vSwitch) {
        return !this.isEnabled(vSwitch);
    }

    public boolean isUnknown(VSwitchImpl vSwitch) {
        return this.isInState(vSwitch, PhysicalStorageOperStatusConstant.PHYS_STOR_OPER_STAT_UNKNOWN);
    }

    public Vector<VolumeNodeImpl> getChildren() {
        return null;
    }

    @Override
    public void clear() throws RemoteException {
        if (this.myLuIdentifier != null) {
            this.myLuIdentifier.clear();
        }
        this.setParent(null, -1);
        super.clear();
    }

    public boolean isISCSITarnsportType() throws RemoteException {
        return this.getTransportTypeConstant(null).equals(PhysStorTransportTypeConstant.PHYS_STOR_TRANS_TYPE_ISCSI);
    }

    private PhysStorTransportTypeConstant getTransportTypeConstant(VSwitchImpl vSwitch) {
        return (PhysStorTransportTypeConstant)this.getSrValueOf(vSwitch, ParameterCode.PHYSICAL_STORAGE_TRANSPORT_TYPE, vSwitch == null);
    }

    public int getPSCSIPort() {
        return this.getPSCSIPort(null);
    }

    public int getPSCSIPort(VSwitchImpl vSwitch) {
        PhysStorTransportTypeConstant type;
        SrEntityNameFormat entityName = (SrEntityNameFormat)this.getSrValueOf(vSwitch, ParameterCode.PHYSICAL_STORAGE_ENTITY_NAME, vSwitch == null);
        if (entityName != null && (type = this.getTransportTypeConstant(vSwitch)).equals(PhysStorTransportTypeConstant.PHYS_STOR_TRANS_TYPE_SPI)) {
            return entityName.getByteAt(3);
        }
        return -1;
    }

    public int getPSCSIBus() {
        return this.getPSCSIBus(null);
    }

    public int getPSCSIBus(VSwitchImpl vSwitch) {
        PhysStorTransportTypeConstant type;
        SrEntityNameFormat entityName = (SrEntityNameFormat)this.getSrValueOf(vSwitch, ParameterCode.PHYSICAL_STORAGE_ENTITY_NAME, vSwitch == null);
        if (entityName != null && (type = this.getTransportTypeConstant(vSwitch)).equals(PhysStorTransportTypeConstant.PHYS_STOR_TRANS_TYPE_SPI)) {
            return entityName.getByteAt(7);
        }
        return -1;
    }

    public SrEntityNameFormat getEntityNameValue() {
        return this.getEntityNameValue(null);
    }

    public SrEntityNameFormat getEntityNameValue(VSwitchImpl vSwitch) {
        return (SrEntityNameFormat)this.getSrValueOf(vSwitch, ParameterCode.PHYSICAL_STORAGE_ENTITY_NAME, vSwitch == null);
    }

    @Override
    public String getEntityName() {
        return this.getEntityName(null);
    }

    public String getEntityName(VSwitchImpl vSwitch) {
        SrEntityNameFormat entityFormat = (SrEntityNameFormat)this.getSrValueOf(vSwitch, ParameterCode.PHYSICAL_STORAGE_ENTITY_NAME, vSwitch == null);
        if (entityFormat == null) {
            return null;
        }
        String entityName = null;
        PhysStorTransportTypeConstant type = this.getTransportTypeConstant(vSwitch);
        if (type.equals(PhysStorTransportTypeConstant.PHYS_STOR_TRANS_TYPE_FCP)) {
            entityName = entityFormat.toHexStringFormat();
        } else if (type.equals(PhysStorTransportTypeConstant.PHYS_STOR_TRANS_TYPE_ISCSI)) {
            entityName = new String((byte[])entityFormat.value());
        } else if (type.equals(PhysStorTransportTypeConstant.PHYS_STOR_TRANS_TYPE_SPI)) {
            int port = this.getPSCSIPort(vSwitch);
            int bus = this.getPSCSIBus(vSwitch);
            entityName = GeneralSCSIDeviceImpl.getPSCSIEntityName(port, bus);
        }
        return entityName;
    }

    public static String getPSCSIEntityName(int port, int bus) {
        return new StringBuffer().append("Port ").append(port).append(" Bus ").append(bus).toString();
    }

    @Override
    public String getInfo() throws RemoteException {
        return this.getInfo(null);
    }

    public String getInfo(VSwitchImpl vSwitch) {
        return (String)this.getValueOf(vSwitch, ParameterCode.PHYSICAL_STORAGE_INFO, vSwitch == null);
    }

    @Override
    public String getVendor() throws RemoteException {
        return this.getVendor(null);
    }

    public String getVendor(VSwitchImpl vSwitch) {
        return (String)this.getValueOf(vSwitch, ParameterCode.PHYSICAL_STORAGE_VENDOR_NAME, vSwitch == null);
    }

    @Override
    public PhysStorTransportTypeConstant getTransportType() {
        return this.getTransportType(null);
    }

    public PhysStorTransportTypeConstant getTransportType(VSwitchImpl vSwitch) {
        return (PhysStorTransportTypeConstant)this.getSrValueOf(vSwitch, ParameterCode.PHYSICAL_STORAGE_TRANSPORT_TYPE, vSwitch == null);
    }

    @Override
    public String getType() {
        return this.getType(null);
    }

    public String getType(VSwitchImpl vSwitch) {
        return this.getSrValueOf(vSwitch, ParameterCode.PHYSICAL_STORAGE_TYPE, vSwitch == null).toString();
    }

    @Override
    public PhysicalStorageDriveTypeConstant getDriveType() {
        return this.getDriveType(null);
    }

    public PhysicalStorageDriveTypeConstant getDriveType(VSwitchImpl vSwitch) {
        return (PhysicalStorageDriveTypeConstant)this.getSrValueOf(vSwitch, ParameterCode.PHYSICAL_STORAGE_DRIVE_TYPE, vSwitch == null);
    }

    public PhysicalStorageTypeConstant getTypeConstant() {
        return this.getTypeConstant(null);
    }

    public PhysicalStorageTypeConstant getTypeConstant(VSwitchImpl vSwitch) {
        return (PhysicalStorageTypeConstant)this.getSrValueOf(vSwitch, ParameterCode.PHYSICAL_STORAGE_TYPE, vSwitch == null);
    }

    @Override
    public int getChildrenOfVirtualVolumeTypeCount() {
        return 0;
    }

    private PhysicalStorageOperStatusConstant getOperationalStatus(VSwitchImpl vSwitch) {
        return (PhysicalStorageOperStatusConstant)this.getSrValueOf(vSwitch, ParameterCode.PHYSICAL_STORAGE_OPERATIONAL_STATUS, vSwitch == null);
    }

    private PhysicalStorageComOperStatusConstant getComOperationalStatus(VSwitchImpl vSwitch) {
        return (PhysicalStorageComOperStatusConstant)this.getSrValueOf(vSwitch, ParameterCode.PHYSICAL_STORAGE_COM_OPER_STATUS, vSwitch == null);
    }

    @Override
    public boolean isOneOfTheVolumesInHierarchyNeedSync() throws RemoteException {
        return this.isNeedSync();
    }

    @Override
    protected String canBeDeleted() {
        VolumeImpl volume;
        VSwitchImpl[] vSwitches = this.getConnectedVSwitches();
        if (vSwitches != null && vSwitches.length > 0) {
            VSwitchImpl vswitch1 = vSwitches[0];
            boolean isMissingInVSwitch1 = this.isMissing(vswitch1);
            boolean isInvalidInVSwitch1 = this.isInvalid(vswitch1);
            boolean isConfiguredInVSwitch1 = this.isProvisioned(vswitch1);
            if (vSwitches.length > 1) {
                VSwitchImpl vswitch2 = vSwitches[1];
                boolean isMissingInVSwitch2 = this.isMissing(vswitch2);
                boolean isInvalidInVSwitch2 = this.isInvalid(vswitch2);
                boolean isConfiguredInVSwitch2 = this.isProvisioned(vswitch2);
                if (!(isMissingInVSwitch1 && isMissingInVSwitch2 || isInvalidInVSwitch1 && isInvalidInVSwitch2 || isConfiguredInVSwitch1 && isConfiguredInVSwitch2 || isMissingInVSwitch1 && isInvalidInVSwitch2 || isMissingInVSwitch1 && isConfiguredInVSwitch2 || isInvalidInVSwitch1 && isMissingInVSwitch2 || isInvalidInVSwitch1 && isConfiguredInVSwitch2 || isConfiguredInVSwitch1 && isMissingInVSwitch2 || isConfiguredInVSwitch1 && isInvalidInVSwitch2)) {
                    return "You cannot remove " + this.getClassId() + " " + this.getAlias() + ", because it is not missing or invalid or provisioned. " + "Storage discovery may resolve this issue.";
                }
            } else if (!(isMissingInVSwitch1 || isInvalidInVSwitch1 || isConfiguredInVSwitch1)) {
                return "You cannot remove " + this.getClassId() + " " + this.getAlias() + ", because it is not missing or invalid or provisioned. " + "Storage discovery may resolve this issue.";
            }
        }
        if ((volume = this.getParentVolume()) != null) {
            return "You cannot remove " + this.getClassId() + " " + this.getAlias() + ", because it belongs to " + volume.getClassId() + " " + volume.getAlias();
        }
        return super.canBeDeleted();
    }

    @Override
    public boolean equals(Object obj) {
        if (super.equals(obj)) {
            return true;
        }
        if (obj instanceof GeneralSCSIDevice) {
            return this.compareWith((GeneralSCSIDeviceImpl)obj);
        }
        return false;
    }

    protected boolean compareWith(GeneralSCSIDeviceImpl device) {
        boolean result;
        if (device == null) {
            return false;
        }
        List<VSwitchImpl> connVSwitchesTemp = this.getConnectedVSwitchesAsList();
        connVSwitchesTemp.retainAll(device.getConnectedVSwitchesAsList());
        if (connVSwitchesTemp.isEmpty()) {
            return false;
        }
        if (!this.isProvisioned() && !device.isProvisioned()) {
            if (this.supportsNewSCSIVersionCompare() && device.supportsNewSCSIVersionCompare()) {
                result = this.newSCSIVersionCompare(device);
            } else {
                if (this.supportsNewSCSIVersionCompare() || device.supportsNewSCSIVersionCompare()) {
                    return false;
                }
                result = this.oldSCSIVersionCompare(device);
            }
        } else {
            result = this.oldSCSIVersionCompare(device);
        }
        if (!result) {
            return false;
        }
        if (this.getSerialNumber() != null && !this.getSerialNumber().equals("") && !this.getSerialNumber().equals(device.getSerialNumber())) {
            if ((device.getSerialNumber() == null || device.getSerialNumber().equals("")) && device.isProvisioned()) {
                return this.compareNoAffectOnVirtualizationWith(device);
            }
            return false;
        }
        return this.compareNoAffectOnVirtualizationWith(device);
    }

    protected boolean compareNoAffectOnVirtualizationWith(GeneralSCSIDeviceImpl device) {
        return this.type.equals(device.type);
    }

    protected boolean isLUIdentifierListEquals(GeneralSCSIDeviceImpl device) {
        if (this.getLUIdentifiersCount() == device.getLUIdentifiersCount()) {
            for (int i = 0; i < this.getLUIdentifiersCount(); ++i) {
                LUIdentifierImpl deviceLUId;
                LUIdentifierImpl luId = this.myLuIdentifier.get(i);
                if (luId.equals(deviceLUId = device.myLuIdentifier.get(i))) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    protected boolean supportsNewSCSIVersionCompare() {
        return this.hasSerialNumber() && this.hasLUIdentifier();
    }

    protected boolean newSCSIVersionCompare(GeneralSCSIDeviceImpl device) {
        return this.serialNumber.equals(device.serialNumber) && this.isLUIdentifierListEquals(device);
    }

    protected boolean oldSCSIVersionCompare(GeneralSCSIDeviceImpl device) {
        return device.entityName.equals(this.entityName) && device.lun.equals(this.lun) && device.transportType.equals(this.transportType);
    }

    protected boolean hasSerialNumber() {
        return this.serialNumber != null && this.serialNumber.length() > 0;
    }

    protected boolean hasLUIdentifier() {
        return this.myLuIdentifier != null && !this.myLuIdentifier.isEmpty();
    }

    @Override
    public int getBlockSize(VSwitchImpl vSwitch) {
        return 0;
    }

    @Override
    public double getBlockNum(VSwitchImpl vSwitch) {
        return 0.0;
    }

    @Override
    public BigInteger getNumberOfBlocks(VSwitchImpl vswitch) {
        return BigInteger.ZERO;
    }

    @Override
    protected int synchronizeMe() throws RemoteException, IllegalValueException {
        if (this.canBeSynchronized() != null) {
            return 2;
        }
        StorageImpl storage = this.cluster.getStorage();
        if (!this.isInSynchronizingMode()) {
            ErrorAssertingListener.listenTo(storage.createGeneralPhysStorageDevice(this.getTypeConstant(), this.getAlias(), (SrEntityNameFormat)this.getSrValueOf(ParameterCode.PHYSICAL_STORAGE_ENTITY_NAME), Integer.parseInt(this.getLUN()), this.getTransportType(), this.getSerialNumber(), this.cluster.getOtherVSwitches(this.getVSwitches())));
            this.setSynchronizingMode(true);
        }
        return 2;
    }

    @Override
    protected String canBeSynchronized() throws RemoteException {
        if (!this.isProvisioned()) {
            return this.getClassId() + " " + this + " cannot be synchronized";
        }
        return null;
    }

    @Override
    protected String isValid(HashMap parameterList) {
        Object blinkParam;
        String info;
        String alias = (String)parameterList.get(ClientParameterCode.PHYSICAL_STORAGE_DEVICE_ALIAS);
        if (alias != null) {
            int maxLength = AliasObjectValidator.ALIAS_MAX_LENGTH;
            if (alias.length() > maxLength) {
                return "Alias cannot exceed " + maxLength + " characters. Please select a different alias";
            }
            if (alias.equals("")) {
                alias = "$dad$" + System.currentTimeMillis();
            }
            if (this.cluster.getStoragePool().isSCSIDeviceAliasExist(alias)) {
                return ErrorMessage.ALIAS_ALREADY_IN_USE.getMessage(alias);
            }
            parameterList.put(ClientParameterCode.PHYSICAL_STORAGE_DEVICE_ALIAS, new SrString(alias));
        }
        if ((info = (String)parameterList.get(ClientParameterCode.PHYSICAL_STORAGE_DEVICE_INFO)) != null) {
            parameterList.put(ClientParameterCode.PHYSICAL_STORAGE_DEVICE_INFO, new SrString(info));
        }
        if ((blinkParam = parameterList.get(ClientParameterCode.PHYSICAL_STORAGE_BLINK_ACTIVE)) != null) {
            Boolean blink = (Boolean)blinkParam;
            if (this.isMissing()) {
                String[] msg = new String[]{this.getClassId().toString(), this.toString()};
                return ErrorMessage.BLINK_MISSING_STORAGE.getMessage(msg);
            }
            if (blink.booleanValue()) {
                if (this.isBlinking()) {
                    return this.getClassId() + " " + this + " is already blinking";
                }
                Integer duration = (Integer)parameterList.get(ClientParameterCode.PHYSICAL_STORAGE_BLINK_DURATION);
                parameterList.put(ClientParameterCode.PHYSICAL_STORAGE_BLINK_ACTIVE, PhysicalStorageComAdminStatusConstant.PHYS_STOR_COM_OPER_STAT_BLINK);
                parameterList.put(ClientParameterCode.PHYSICAL_STORAGE_BLINK_DURATION, new SrInteger(duration));
            } else {
                if (!this.isBlinking()) {
                    return this.getClassId() + " " + this + " is not blinking";
                }
                parameterList.put(ClientParameterCode.PHYSICAL_STORAGE_BLINK_ACTIVE, PhysicalStorageComAdminStatusConstant.PHYS_STOR_COM_OPER_STAT_ABORT);
            }
        }
        return null;
    }

    @Override
    public void registerToPropagatedStateChange() {
        this.cluster.addPropagationStateDependentObjectAndListener(this);
    }

    @Override
    public AlarmGenerator getAlarmGenerator() {
        return GeneralSCSIDeviceAlarmGenerator.getInstance();
    }

    @Override
    public String getGroup() throws RemoteException {
        return "";
    }

    @Override
    public BigInteger getTotalSpace() {
        return BigInteger.ZERO;
    }

    @Override
    public BigInteger getNonAllocatedSpace() throws RemoteException {
        return this.getTotalSpace();
    }

    @Override
    public BigInteger getEndAddress() throws RemoteException {
        return this.getTotalSpace();
    }

    @Override
    public BigInteger getAccessibleSpace() {
        return this.getTotalSpace();
    }

    @Override
    public BigInteger getAllocatedSpace() throws RemoteException {
        if (this.getParentVolume() == null && this.getParentLU() == null) {
            return BigInteger.ZERO;
        }
        return this.getTotalSpace();
    }

    @Override
    public String getSerialNumber() {
        return this.getSerialNumber(null);
    }

    public String getSerialNumber(VSwitchImpl vSwitch) {
        return (String)this.getValueOf(vSwitch, ParameterCode.PHYSICAL_STORAGE_SERIAL_NUMBER, vSwitch == null);
    }

    @Override
    public String getProductID() {
        return this.getProductID(null);
    }

    public String getProductID(VSwitchImpl vSwitch) {
        return (String)this.getValueOf(vSwitch, ParameterCode.PHYSICAL_STORAGE_PRODUCT_ID, vSwitch == null);
    }

    @Override
    public String getRevisionLevel() {
        return this.getRevisionLevel(null);
    }

    public String getRevisionLevel(VSwitchImpl vSwitch) {
        return (String)this.getValueOf(vSwitch, ParameterCode.PHYSICAL_STORAGE_REVISION_LEVEL, vSwitch == null);
    }

    @Override
    public Integer getSCSIVersion() {
        return this.getSCSIVersion(null);
    }

    public Integer getSCSIVersion(VSwitchImpl vSwitch) {
        return (Integer)this.getValueOf(vSwitch, ParameterCode.PHYSICAL_STORAGE_SCSI_VER, vSwitch == null);
    }

    public List<LUIdentifierImpl> getLUIdentifier() {
        return this.getLUIdentifier(null);
    }

    public List<LUIdentifierImpl> getLUIdentifier(VSwitchImpl vSwitch) {
        CommKeyClassId[] luIdCommKeyClassId = (CommKeyClassId[])this.getSrArrayValueOf(vSwitch, ParameterCode.PHYSICAL_STORAGE_LU_IDENTIFIER, vSwitch == null);
        if (luIdCommKeyClassId != null) {
            ArrayList<LUIdentifierImpl> luIds = new ArrayList<LUIdentifierImpl>();
            for (int i = 0; i < luIdCommKeyClassId.length; ++i) {
                LUIdentifierImpl luId = (LUIdentifierImpl)this.cluster.getCommKeyRefMap().getRefByCommKeyClassID(luIdCommKeyClassId[i]);
                if (luId != null) {
                    luIds.add(luId);
                    continue;
                }
                theLogger.warn(SrLogCategories.LEGACY, "LUIdentifier is null for CommKeyClassId ", luIdCommKeyClassId[i], " in cluster ", this.cluster, " ", ClassID.VSWITCH, " ", vSwitch);
            }
            return luIds;
        }
        return null;
    }

    protected int getLUIdentifiersCount() {
        return this.myLuIdentifier == null ? 0 : this.myLuIdentifier.size();
    }

    @Override
    public boolean isInternal(VSwitchImpl vSwitch) {
        return this.getParentLU(vSwitch) == null && this.getParentVolume(vSwitch) == null;
    }

    @Override
    public SrFuture<Void> synchronizeDiscoveryElementOnRemoteCluster(ClusterImpl remoteCluster) throws RemoteException {
        return new CompleteFuture<Void>("GeneralSCSIDeviceImpl.synchronizeDiscoveryElementOnRemoteCluster");
    }

    @Override
    public SrFuture<Void> synchronizeNewElementOnRemoteCluster(ClusterImpl remoteCluster) throws RemoteException {
        return new CompleteFuture<Void>("GeneralSCSIDeviceImpl.synchronizeNewElementOnRemoteCluster");
    }

    @Override
    public void synchronizeChangeElementOnRemoteCluster(ClusterImpl remoteCluster, HashMap changedValues) throws RemoteException {
    }

    @Override
    public SrFuture<Void> synchronizePreRemoveElementOnRemoteCluster(ClusterImpl remoteCluster) throws RemoteException {
        this.m_keptEntityNameForRemoval = this.getEntityName();
        return new CompleteFuture<Void>("GeneralSCSIDeviceImpl.synchronizePreRemoveElementOnRemoteCluster");
    }

    @Override
    public void synchronizePostRemoveElementOnRemoteCluster(ClusterImpl remoteCluster) throws RemoteException {
    }

    @Override
    public ConfigElementDataList buildCedListForRemoveVolumeTree(Vector subdisks, ConfigElementDataList elementList) throws RemoteException {
        if (this.isProvisioned()) {
            ConfigElementData element = new ConfigElementData(this.getCommKeyClassId());
            this.getCluster().prepareVSwitchIDs(element, "prepare element for remove volume tree", this.getConnectedVSwitchesAsList());
            elementList.add(element);
        }
        return elementList;
    }

    public boolean isDeviceSuitableForLocalCopy(HashSet set, VolumeNodeImpl volume, ClusterImpl remoteCluster) throws IllegalValueException {
        return false;
    }

    @Override
    public VSwitchImpl getDominantVswitch() {
        VSwitchImpl[] vswitches = this.getConnectedVSwitches();
        LUImpl lu = this.getParentLU();
        if (lu == null) {
            for (int i = 0; i < vswitches.length; ++i) {
                PhysicalStorageOperStatusConstant state = (PhysicalStorageOperStatusConstant)this.getSrValueOf(vswitches[i], ParameterCode.PHYSICAL_STORAGE_OPERATIONAL_STATUS);
                if (!PhysicalStorageOperStatusConstant.PHYS_STOR_OPER_STAT_ENABLE.equals(state) || !vswitches[i].isConnected()) continue;
                return vswitches[i];
            }
        }
        return super.getDominantVswitch();
    }

    public BigInteger getRaidCreationTime() {
        return (BigInteger)this.getValueOf(null, ParameterCode.PHYSICAL_STORAGE_RAID_CREATION_TIME, true);
    }

    public String getRaidFirmwareRevision() {
        return (String)this.getValueOf(null, ParameterCode.PHYSICAL_STORAGE_RAID_FIRMWARE_REV, true);
    }

    public PhysicalStorageRaidLevelConstant getRaidLevel() {
        return (PhysicalStorageRaidLevelConstant)this.getSrValueOf(null, ParameterCode.PHYSICAL_STORAGE_RAID_LEVEL, true);
    }

    public String getRaidSysModelName() {
        return (String)this.getValueOf(null, ParameterCode.PHYSICAL_STORAGE_RAID_MODEL_NAME, true);
    }

    public SrBITSConstant getRaidStatus() {
        return (SrBITSConstant)this.getSrValueOf(ParameterCode.PHYSICAL_STORAGE_RAID_STATUS);
    }

    public String getRaidSysName() {
        return (String)this.getValueOf(null, ParameterCode.PHYSICAL_STORAGE_RAID_SYSTEM_NAME, true);
    }

    public SrIpAddress getRaidUrl1() {
        return this.getRaidUrl(ParameterCode.PHYSICAL_STORAGE_RAID_CONTROLLER_URL1);
    }

    public SrIpAddress getRaidUrl2() {
        return this.getRaidUrl(ParameterCode.PHYSICAL_STORAGE_RAID_CONTROLLER_URL2);
    }

    private SrIpAddress getRaidUrl(ParameterCode aCode) {
        Util.validateInputNotNull(aCode, "ParameterCode");
        String ip = (String)this.getValueOf(aCode);
        if (ip == null || ip.isEmpty()) {
            return null;
        }
        Matcher matcher = NEXSAN_IP_PATTERN.matcher(ip);
        if (matcher.matches()) {
            return new SrIpAddress(matcher.group(1));
        }
        return new SrIpAddress(ip);
    }

    @Override
    protected ArrayList<ParameterCode> getParamsForCreation() {
        return new ArrayList<ParameterCode>();
    }

    public static void main(String[] args) {
        String ip = "http://10.123.12.234";
        Pattern p = Pattern.compile("^http://((\\d{1,3}\\.){3}\\d{1,3})$");
        Matcher matcher = p.matcher(ip);
        System.out.println(matcher.matches());
    }

    static {
        HashMap<ParameterCode, ParameterCode.Flags> parameterCodeFlagsMap = new HashMap<ParameterCode, ParameterCode.Flags>();
        parameterCodeFlagsMap.put(ParameterCode.PHYSICAL_STORAGE_ALIAS, new ParameterCode.Flags(true, false));
        parameterCodeFlagsMap.put(ParameterCode.PHYSICAL_STORAGE_ENTITY_NAME, new ParameterCode.Flags(true, false));
        parameterCodeFlagsMap.put(ParameterCode.PHYSICAL_STORAGE_LUN, new ParameterCode.Flags(true, false));
        parameterCodeFlagsMap.put(ParameterCode.PHYSICAL_STORAGE_INFO, new ParameterCode.Flags(true, false));
        parameterCodeFlagsMap.put(ParameterCode.PHYSICAL_STORAGE_VENDOR_NAME, new ParameterCode.Flags(true, false));
        parameterCodeFlagsMap.put(ParameterCode.PHYSICAL_STORAGE_OPERATIONAL_STATUS, new ParameterCode.Flags(true, false));
        parameterCodeFlagsMap.put(ParameterCode.PHYSICAL_STORAGE_TRANSPORT_TYPE, new ParameterCode.Flags(true, false));
        parameterCodeFlagsMap.put(ParameterCode.PHYSICAL_STORAGE_TYPE, new ParameterCode.Flags(true, false));
        parameterCodeFlagsMap.put(ParameterCode.PHYSICAL_STORAGE_COM_ADMIN_STATUS, new ParameterCode.Flags(true, false));
        parameterCodeFlagsMap.put(ParameterCode.PHYSICAL_STORAGE_COM_OPER_STATUS, new ParameterCode.Flags(true, false));
        parameterCodeFlagsMap.put(ParameterCode.PHYSICAL_STORAGE_COM_DURATION, new ParameterCode.Flags(true, false));
        parameterCodeFlagsMap.put(ParameterCode.PHYSICAL_STORAGE_SERIAL_NUMBER, new ParameterCode.Flags(true, false));
        parameterCodeFlagsMap.put(ParameterCode.PHYSICAL_STORAGE_PRODUCT_ID, new ParameterCode.Flags(true, false));
        parameterCodeFlagsMap.put(ParameterCode.PHYSICAL_STORAGE_REVISION_LEVEL, new ParameterCode.Flags(true, false));
        parameterCodeFlagsMap.put(ParameterCode.PHYSICAL_STORAGE_SCSI_VER, new ParameterCode.Flags(true, false));
        parameterCodeFlagsMap.put(ParameterCode.PHYSICAL_STORAGE_LU_IDENTIFIER, new ParameterCode.Flags(true, false));
        parameterCodeFlagsMap.put(ParameterCode.PHYSICAL_STORAGE_DRIVE_TYPE, new ParameterCode.Flags(true, false));
        parameterCodeFlagsMap.put(ParameterCode.PHYSICAL_STORAGE_RAID_LEVEL, new ParameterCode.Flags(true, false));
        parameterCodeFlagsMap.put(ParameterCode.PHYSICAL_STORAGE_RAID_STATUS, new ParameterCode.Flags(true, false));
        parameterCodeFlagsMap.put(ParameterCode.PHYSICAL_STORAGE_RAID_SYSTEM_NAME, new ParameterCode.Flags(true, false));
        parameterCodeFlagsMap.put(ParameterCode.PHYSICAL_STORAGE_RAID_MODEL_NAME, new ParameterCode.Flags(true, false));
        parameterCodeFlagsMap.put(ParameterCode.PHYSICAL_STORAGE_RAID_FIRMWARE_REV, new ParameterCode.Flags(true, false));
        parameterCodeFlagsMap.put(ParameterCode.PHYSICAL_STORAGE_RAID_CREATION_TIME, new ParameterCode.Flags(true, false));
        parameterCodeFlagsMap.put(ParameterCode.PHYSICAL_STORAGE_RAID_CONTROLLER_URL1, new ParameterCode.Flags(true, false));
        parameterCodeFlagsMap.put(ParameterCode.PHYSICAL_STORAGE_RAID_CONTROLLER_URL2, new ParameterCode.Flags(true, false));
        theParameterCodeFlagsMap = Collections.unmodifiableMap(parameterCodeFlagsMap);
        NEXSAN_IP_PATTERN = Pattern.compile("^http://((\\d{1,3}\\.){3}\\d{1,3})$");
        theLogger = SrLogger.getLogger();
    }
}

