/*
 * Decompiled with CFR 0.152.
 */
package com.sanrad.nms.server.logic.lu;

import com.sanrad.nms.server.alarm.AlarmGenerator;
import com.sanrad.nms.server.logic.ElementEventImpl;
import com.sanrad.nms.server.logic.IllegalValueException;
import com.sanrad.nms.server.logic.InvalidElementException;
import com.sanrad.nms.server.logic.LogicMgrAOImpl;
import com.sanrad.nms.server.logic.SynchronizeableImpl;
import com.sanrad.nms.server.logic.cluster.ClusterImpl;
import com.sanrad.nms.server.logic.lu.LUImpl;
import com.sanrad.nms.server.logic.lu.SCSILun;
import com.sanrad.nms.server.logic.vswitch.VSwitchImpl;
import com.sanrad.nms.server.mgr.ConfigElementData;
import com.sanrad.nms.server.util.ClassID;
import com.sanrad.nms.server.util.CommKey;
import com.sanrad.nms.server.util.CommKeyClassId;
import com.sanrad.nms.server.util.CommKeyUtil;
import com.sanrad.nms.server.util.ParameterCode;
import com.sanrad.nms.server.util.types.SrScsiLUNFormat;
import com.sanrad.nms.server.util.types.SrString;
import com.sanrad.nms.server.util.types.constants.SCSILunStateConstant;
import com.sanrad.nms.server.util.types.constants.SCSILunStatusConstant;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Vector;

public class SCSILunImpl
extends SynchronizeableImpl
implements SCSILun {
    private static Map<ParameterCode, ParameterCode.Flags> theParameterCodeFlagsMap;
    private LUImpl lu;
    private CommKey[] scsiTargetKeys = null;

    public SCSILunImpl(ClusterImpl cluster, LUImpl lu, ConfigElementData aCED) throws RemoteException, IllegalValueException, InvalidElementException {
        super(cluster, ClassID.SCSI_LUN, aCED);
        this.validateAndInit(aCED, theParameterCodeFlagsMap);
        this.lu = lu;
    }

    @Override
    protected String canBeDeleted() {
        return null;
    }

    @Override
    protected String isValid(HashMap parameterList) {
        return null;
    }

    @Override
    public void registerToPropagatedStateChange() {
    }

    @Override
    public AlarmGenerator getAlarmGenerator() {
        return null;
    }

    public Integer getLUN() throws RemoteException {
        return this.getLUN(null);
    }

    public Integer getLUN(VSwitchImpl vSwitch) {
        SrScsiLUNFormat lun = (SrScsiLUNFormat)this.getSrValueOf(vSwitch, ParameterCode.SCSI_LUN_LU_NUMBER, vSwitch == null);
        return lun != null ? lun.toInt() : null;
    }

    public String getRevisionID() throws RemoteException {
        return this.getRevisionID(null);
    }

    public String getRevisionID(VSwitchImpl vSwitch) {
        SrString rev = (SrString)this.getSrValueOf(vSwitch, ParameterCode.SCSI_LUN_REVISION_ID, vSwitch == null);
        return rev != null ? rev.toString() : null;
    }

    public SCSILunStateConstant getState() {
        return this.getState(null);
    }

    public SCSILunStateConstant getState(VSwitchImpl vSwitch) {
        SCSILunStateConstant state = (SCSILunStateConstant)this.getSrValueOf(vSwitch, ParameterCode.SCSI_LUN_STATE, vSwitch == null);
        return state;
    }

    public SCSILunStatusConstant getStatus() {
        return this.getStatus(null);
    }

    public SCSILunStatusConstant getStatus(VSwitchImpl vSwitch) {
        SCSILunStatusConstant status = (SCSILunStatusConstant)this.getSrValueOf(vSwitch, ParameterCode.SCSI_LUN_STATUS, vSwitch == null);
        return status;
    }

    @Override
    public HashMap changeParameterList(ConfigElementData aCED) throws RemoteException, IllegalValueException, InvalidElementException {
        this.setSCSITargetCommKeyClassID((CommKeyClassId)aCED.getValue(ParameterCode.SCSI_DEVICE_ID));
        HashMap changedValues = super.changeParameterList(aCED);
        if (this.cluster.isDiscoverCompleted()) {
            ElementEventImpl elementEvent = new ElementEventImpl((Object)this.lu, this.lu);
            Object vSwitchObj = aCED.getValue(ParameterCode.VSWITCH_ID);
            CommKeyClassId vswitchID = vSwitchObj instanceof CommKeyClassId ? (CommKeyClassId)vSwitchObj : ((CommKeyClassId[])vSwitchObj)[0];
            VSwitchImpl vSwitch = (VSwitchImpl)this.getCommKeyRefMap().getRefByCommKeyClassID(vswitchID);
            if (vSwitch != null) {
                elementEvent.setVSwitchIp(vSwitch.getMgmIPAddr());
            }
            elementEvent.setParameterList(aCED.getParametersList());
            LogicMgrAOImpl.getInstance().__elementChanged(elementEvent);
        }
        this.toStringValue = this.getLUN().toString();
        return changedValues;
    }

    private void setSCSITargetCommKeyClassID(CommKeyClassId scsiTarget) {
        this.scsiTargetKeys = this.scsiTargetKeys == null ? scsiTarget.getCommKeys() : CommKeyUtil.mergerCommKeyLists(this.scsiTargetKeys, scsiTarget.getCommKeys());
    }

    public CommKey[] removeFromVSwitch(VSwitchImpl vSwitch) throws RemoteException {
        Vector<CommKey> commKeysVec = new Vector<CommKey>(Arrays.asList(this.scsiTargetKeys));
        CommKeyUtil.removeSpecificCommKeys(commKeysVec, vSwitch.getCommKeys());
        return super.removeFromVSwitch(vSwitch);
    }

    public CommKeyClassId getSCSITargetID() {
        return new CommKeyClassId(this.scsiTargetKeys, ClassID.SCSI_TARGET);
    }

    @Override
    protected int synchronizeMe() throws RemoteException, IllegalValueException {
        return 0;
    }

    @Override
    public String getAlias() {
        return null;
    }

    @Override
    public String getAlias(VSwitchImpl inSwitch) {
        return null;
    }

    @Override
    protected ArrayList<ParameterCode> getParamsForCreation() {
        return new ArrayList<ParameterCode>();
    }

    static {
        HashMap<ParameterCode, ParameterCode.Flags> parameterCodeFlagsMap = new HashMap<ParameterCode, ParameterCode.Flags>();
        parameterCodeFlagsMap.put(ParameterCode.SCSI_LUN_LU_NUMBER, new ParameterCode.Flags(true, false));
        parameterCodeFlagsMap.put(ParameterCode.SCSI_LUN_REVISION_ID, new ParameterCode.Flags(true, false));
        parameterCodeFlagsMap.put(ParameterCode.SCSI_LUN_STATE, new ParameterCode.Flags(true, false));
        parameterCodeFlagsMap.put(ParameterCode.SCSI_LUN_STATUS, new ParameterCode.Flags(true, false));
        theParameterCodeFlagsMap = Collections.unmodifiableMap(parameterCodeFlagsMap);
    }
}

