/*
 * Decompiled with CFR 0.152.
 */
package com.sanrad.nms.server.logic.lu;

import com.sanrad.log.SrLogger;
import com.sanrad.nms.server.logic.ErrorMessage;
import com.sanrad.nms.server.logic.cluster.ClusterImpl;
import com.sanrad.nms.server.logic.lu.LUValidator;
import com.sanrad.nms.server.logic.target.Target;
import com.sanrad.nms.server.logic.target.TargetImpl;
import com.sanrad.nms.server.logic.volume.VolumeNodeImpl;
import com.sanrad.nms.server.logic.vswitch.VSwitchImpl;
import java.rmi.RemoteException;
import java.util.List;

public class LUSyncValidator
extends LUValidator {
    private List<VSwitchImpl> vSwitches;
    private static SrLogger theLogger = SrLogger.getLogger();

    public LUSyncValidator(ClusterImpl cluster, int luNumber, VolumeNodeImpl volume, Target target, List<VSwitchImpl> vSwitchToSet) throws RemoteException {
        super(cluster, luNumber, volume, target);
        this.vSwitches = vSwitchToSet;
    }

    @Override
    public boolean isValid() throws RemoteException {
        if (!super.isValid()) {
            return false;
        }
        if (this.isLuNumberExist(this.target)) {
            String[] msgParts = new String[]{Integer.toString(this.luNumber), this.target.getAlias()};
            this.setErrorMsg(ErrorMessage.LUN_ALREADY_IN_USE.getMessage(msgParts));
            return false;
        }
        return true;
    }

    private boolean isLuNumberExist(TargetImpl tgt) {
        for (VSwitchImpl vs : this.vSwitches) {
            if (!tgt.isLUNumberExist(vs, this.luNumber)) continue;
            return true;
        }
        return false;
    }
}

