/*
 * Decompiled with CFR 0.152.
 */
package com.sanrad.nms.server.logic.iscsi;

import com.sanrad.nms.server.logic.ClientParameterCode;
import com.sanrad.nms.server.logic.IllegalValueException;
import com.sanrad.nms.server.logic.InvalidElementException;
import com.sanrad.nms.server.logic.cluster.ClusterImpl;
import com.sanrad.nms.server.logic.iscsi.ISCSISession;
import com.sanrad.nms.server.logic.iscsi.ISCSISessionImpl;
import com.sanrad.nms.server.logic.iscsi.ISCSISessionStatistics;
import com.sanrad.nms.server.logic.statistics.StatisticsImpl;
import com.sanrad.nms.server.logic.vswitch.VSwitch;
import com.sanrad.nms.server.mgr.ConfigElementData;
import com.sanrad.nms.server.mgr.polling.PollingGroupType;
import com.sanrad.nms.server.util.ClassID;
import com.sanrad.nms.server.util.CommKeyClassId;
import com.sanrad.nms.server.util.ParameterCode;
import com.sanrad.nms.server.util.types.constants.SessionDirectionConstant;
import com.sanrad.nms.server.util.types.constants.SessionTypeConstant;
import java.math.BigInteger;
import java.rmi.RemoteException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public class ISCSISessionStatisticsImpl
extends StatisticsImpl
implements ISCSISessionStatistics {
    private static Map<ParameterCode, ParameterCode.Flags> theParameterCodeFlagsMap;
    private static HashMap<ParameterCode, ClientParameterCode> s_parametersToCalculateMap;

    public ISCSISessionStatisticsImpl(ClusterImpl cluster, ConfigElementData aCED) throws RemoteException, IllegalValueException, InvalidElementException {
        super(cluster, ClassID.ISCSI_SESSION_STATISTICS, aCED, s_parametersToCalculateMap);
        this.validateAndInit(aCED, theParameterCodeFlagsMap);
    }

    @Override
    protected PollingGroupType getGroupType() {
        return PollingGroupType.ISCSI_SESSIONS_STATISTICS_GROUP_TYPE;
    }

    private ISCSISessionImpl getSessionShowImpl() throws RemoteException {
        CommKeyClassId sessionCommKeyClassId = (CommKeyClassId)this.getSrValueOf(ParameterCode.ISCSI_SESSION_ID);
        if (sessionCommKeyClassId != null) {
            ISCSISessionImpl sessionImpl = (ISCSISessionImpl)this.cluster.getCommKeyRefMap().getRefByCommKeyClassID(sessionCommKeyClassId);
            return sessionImpl;
        }
        return null;
    }

    @Override
    public VSwitch getVSwitchStub() throws RemoteException {
        return this.getParentVSwitch();
    }

    @Override
    public BigInteger getCmdPDUs() throws RemoteException {
        return (BigInteger)this.getValueOf(this.getParentVSwitch(), ParameterCode.ISCSI_SESSION_CMD_PDUS);
    }

    @Override
    public BigInteger getRspPDUs() throws RemoteException {
        return (BigInteger)this.getValueOf(this.getParentVSwitch(), ParameterCode.ISCSI_SESSION_RSP_PDUS);
    }

    @Override
    public BigInteger getTxBytes() throws RemoteException {
        return (BigInteger)this.getValueOf(this.getParentVSwitch(), ParameterCode.ISCSI_SESSION_TX_DATA_OCTETS);
    }

    @Override
    public BigInteger getRxBytes() throws RemoteException {
        return (BigInteger)this.getValueOf(this.getParentVSwitch(), ParameterCode.ISCSI_SESSION_RX_DATA_OCTETS);
    }

    @Override
    public BigInteger getDigestsErr() throws RemoteException {
        return (BigInteger)this.getValueOf(this.getParentVSwitch(), ParameterCode.ISCSI_SESSION_DIGEST_ERRORS);
    }

    @Override
    public BigInteger getTimeoutErr() throws RemoteException {
        return (BigInteger)this.getValueOf(this.getParentVSwitch(), ParameterCode.ISCSI_SESSION_TIMEOUT_ERRORS);
    }

    @Override
    public ISCSISession getSessionStub() throws RemoteException {
        return this.getSessionShowImpl();
    }

    @Override
    public HashMap changeParameterList(ConfigElementData aCED) throws RemoteException, IllegalValueException, InvalidElementException {
        HashMap changedValues = super.changeParameterList(aCED);
        StringBuffer sb = new StringBuffer("PolicyTableEntry");
        sb.append(this.getValueOf(ParameterCode.POLICY_PARAM_ID));
        this.toStringValue = sb.toString();
        return changedValues;
    }

    @Override
    public String toString() {
        try {
            ISCSISessionImpl session = this.getSessionShowImpl();
            if (session != null) {
                StringBuffer sb = new StringBuffer(session.isInBound() ? SessionDirectionConstant.IN_BOUND.toString() : SessionDirectionConstant.OUT_BOUND.toString());
                sb.append(" ");
                sb.append(session.isDiscovery() ? SessionTypeConstant.DISCOVER.toString() : SessionTypeConstant.NORMAL.toString());
                sb.append(" ");
                sb.append(ClassID.ISCSI_SESSION_STATISTICS.toString());
                return sb.toString();
            }
        }
        catch (RemoteException e) {
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        return ClassID.ISCSI_SESSION_STATISTICS.toString();
    }

    static {
        HashMap<ParameterCode, ParameterCode.Flags> parameterCodeFlagsMap = new HashMap<ParameterCode, ParameterCode.Flags>();
        parameterCodeFlagsMap.put(ParameterCode.ISCSI_SESSION_ID, new ParameterCode.Flags(true, false));
        parameterCodeFlagsMap.put(ParameterCode.ISCSI_SESSION_CMD_PDUS, new ParameterCode.Flags(true, false));
        parameterCodeFlagsMap.put(ParameterCode.ISCSI_SESSION_RSP_PDUS, new ParameterCode.Flags(true, false));
        parameterCodeFlagsMap.put(ParameterCode.ISCSI_SESSION_TX_DATA_OCTETS, new ParameterCode.Flags(true, false));
        parameterCodeFlagsMap.put(ParameterCode.ISCSI_SESSION_RX_DATA_OCTETS, new ParameterCode.Flags(true, false));
        parameterCodeFlagsMap.put(ParameterCode.ISCSI_SESSION_DIGEST_ERRORS, new ParameterCode.Flags(true, false));
        parameterCodeFlagsMap.put(ParameterCode.ISCSI_SESSION_TIMEOUT_ERRORS, new ParameterCode.Flags(true, false));
        theParameterCodeFlagsMap = Collections.unmodifiableMap(parameterCodeFlagsMap);
        s_parametersToCalculateMap = new HashMap();
        s_parametersToCalculateMap.put(ParameterCode.ISCSI_SESSION_CMD_PDUS, ClientParameterCode.ISCSI_SESSION_STATISTICS_CMD_PDUS_PER_SEC);
        s_parametersToCalculateMap.put(ParameterCode.ISCSI_SESSION_RSP_PDUS, ClientParameterCode.ISCSI_SESSION_STATISTICS_RSP_PDUS_PER_SEC);
    }
}

