/*
 * Decompiled with CFR 0.152.
 */
package com.sanrad.nms.server.logic.iscsi;

import com.sanrad.log.SrLogCategories;
import com.sanrad.log.SrLogger;
import com.sanrad.nms.server.logic.IllegalValueException;
import com.sanrad.nms.server.logic.InvalidElementException;
import com.sanrad.nms.server.logic.cluster.ClusterImpl;
import com.sanrad.nms.server.logic.initiator.ISCSIInitiator;
import com.sanrad.nms.server.logic.initiator.ISCSIInitiatorImpl;
import com.sanrad.nms.server.logic.initiator.ISCSIRemoteInitiatorImpl;
import com.sanrad.nms.server.logic.iscsi.ISCSIConnection;
import com.sanrad.nms.server.logic.iscsi.ISCSIConnectionImpl;
import com.sanrad.nms.server.logic.iscsi.ISCSISession;
import com.sanrad.nms.server.logic.target.ISCSIRemoteTargetImpl;
import com.sanrad.nms.server.logic.target.ISCSITargetImpl;
import com.sanrad.nms.server.logic.vswitch.TableRowImpl;
import com.sanrad.nms.server.logic.vswitch.VSwitchImpl;
import com.sanrad.nms.server.mgr.ConfigElementData;
import com.sanrad.nms.server.util.ClassID;
import com.sanrad.nms.server.util.ParameterCode;
import com.sanrad.nms.server.util.types.SrGauge;
import com.sanrad.nms.server.util.types.SrISCSISessionISID;
import com.sanrad.nms.server.util.types.SrIpAddress;
import com.sanrad.nms.server.util.types.constants.SessionConnectionStatusConstant;
import com.sanrad.nms.server.util.types.constants.SessionDirectionConstant;
import com.sanrad.nms.server.util.types.constants.SessionTypeConstant;
import java.math.BigInteger;
import java.rmi.RemoteException;
import java.util.Arrays;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.Vector;

public class ISCSISessionImpl
extends TableRowImpl
implements ISCSISession {
    private static Map<ParameterCode, ParameterCode.Flags> theParameterCodeFlagsMap;
    private String m_initiatorName;
    private String m_targetName;
    private Vector<ISCSIConnectionImpl> myConnections = new Vector();
    private String m_identityAlias;
    private static SrLogger theLogger;
    private ISCSIRemoteInitiatorImpl m_sessionRemoteInitiator;
    private ISCSITargetImpl m_sessionLocalTarget;
    private ISCSIInitiatorImpl m_sessionLocalInitiator;
    private ISCSIRemoteTargetImpl m_sessionRemoteTarget;

    public ISCSISessionImpl(ClusterImpl cluster, ClassID classId, ConfigElementData aCED) throws RemoteException, IllegalValueException, InvalidElementException {
        super(cluster, classId, aCED);
        this.validateAndInit(aCED, theParameterCodeFlagsMap);
    }

    @Override
    public HashMap changeParameterList(ConfigElementData aCED) throws RemoteException, IllegalValueException, InvalidElementException {
        HashMap changedValues = super.changeParameterList(aCED);
        this.m_initiatorName = this.getInitiatorName();
        this.m_targetName = this.getTargetName();
        this.toStringValue = this.toString();
        return changedValues;
    }

    @Override
    public String toString() {
        try {
            StringBuffer sb = new StringBuffer(this.isInBound() ? SessionDirectionConstant.IN_BOUND.toString() : SessionDirectionConstant.OUT_BOUND.toString());
            sb.append(" ");
            sb.append(this.isDiscovery() ? SessionTypeConstant.DISCOVER.toString() : SessionTypeConstant.NORMAL.toString());
            sb.append(" ");
            sb.append(ClassID.ISCSI_SESSION.toString());
            return sb.toString();
        }
        catch (RemoteException re) {
            theLogger.logAndAssert(SrLogCategories.EXCEPTION, re, "got a remote exception in the server.");
            return super.toString();
        }
    }

    @Override
    public void clear() throws RemoteException {
        if (this.myConnections != null) {
            this.myConnections.clear();
        }
        this.setInitiatorName(null);
        this.setTargetName(null);
        this.setIdentityAlias(null);
        this.setSessionRemoteInitiator(null);
        this.setSessionLocalTarget(null);
        this.setSessionLocalInitiator(null);
        this.setSessionRemoteTarget(null);
        super.clear();
    }

    public void setInitiatorName(String name) {
        this.m_initiatorName = name;
    }

    public void setTargetName(String name) {
        this.m_targetName = name;
    }

    public void setIdentityAlias(String identityAlias) {
        this.m_identityAlias = identityAlias;
    }

    @Override
    public String getIdentityAlias() {
        return this.m_identityAlias;
    }

    public void setSessionRemoteInitiator(ISCSIRemoteInitiatorImpl remoteInitiator) {
        this.m_sessionRemoteInitiator = remoteInitiator;
    }

    public void setSessionLocalTarget(ISCSITargetImpl localTarget) {
        this.m_sessionLocalTarget = localTarget;
    }

    public void setSessionLocalInitiator(ISCSIInitiatorImpl localInitiator) {
        this.m_sessionLocalInitiator = localInitiator;
    }

    public void setSessionRemoteTarget(ISCSIRemoteTargetImpl remoteTarget) {
        this.m_sessionRemoteTarget = remoteTarget;
    }

    public boolean isConnectionExist(HashMap parameterList) {
        SrIpAddress connectionLocalIP = (SrIpAddress)parameterList.get(ParameterCode.ISCSI_CONNECTION_LOCAL_ADDRESS);
        SrGauge connectionLocalPort = (SrGauge)parameterList.get(ParameterCode.ISCSI_CONNECTION_LOCAL_PORT);
        SrIpAddress connectionRemoteIP = (SrIpAddress)parameterList.get(ParameterCode.ISCSI_CONNECTION_REMOTE_ADDRESS);
        SrGauge connectionRemotePort = (SrGauge)parameterList.get(ParameterCode.ISCSI_CONNECTION_REMOTE_PORT);
        Enumeration<ISCSIConnectionImpl> iter = this.myConnections.elements();
        while (iter.hasMoreElements()) {
            ISCSIConnectionImpl iscsiConnection = iter.nextElement();
            String localIP = iscsiConnection.getInitiatorIP();
            BigInteger localPort = iscsiConnection.getInitiatorPort();
            String remoteIP = iscsiConnection.getTargetIP();
            BigInteger remotePort = iscsiConnection.getTargetPort();
            if (!localIP.equals(connectionLocalIP.toDisplayString()) || !localPort.equals(connectionLocalPort.value()) || !remoteIP.equals(connectionRemoteIP.toDisplayString()) || !remotePort.equals(connectionRemotePort.value())) continue;
            return true;
        }
        return false;
    }

    public void addConnection(ISCSIConnectionImpl connection) {
        this.myConnections.addElement(connection);
    }

    public void removeConnection(ISCSIConnectionImpl connection) {
        this.myConnections.remove(connection);
    }

    public void removeAllConnections() {
        this.myConnections.clear();
    }

    public VSwitchImpl getSessionVswitchParent() {
        return this.getParentVSwitch();
    }

    @Override
    public Vector<ISCSIConnectionImpl> getConnections() {
        return this.myConnections;
    }

    @Override
    public SessionDirectionConstant getDirection() {
        return (SessionDirectionConstant)this.getSrValueOf(this.getParentVSwitch(), ParameterCode.ISCSI_SESSION_DIRECTION);
    }

    public boolean isInBound() {
        return SessionDirectionConstant.IN_BOUND.equals(this.getDirection());
    }

    @Override
    public String getInitiatorAlias() {
        return (String)this.getValueOf(this.getParentVSwitch(), ParameterCode.ISCSI_SESSION_INITIATOR_ALIAS);
    }

    @Override
    public String getInitiatorName() {
        return (String)this.getValueOf(this.getParentVSwitch(), ParameterCode.ISCSI_SESSION_INITIATOR_NAME);
    }

    @Override
    public String getISID() {
        SrISCSISessionISID val = (SrISCSISessionISID)this.getSrValueOf(this.getParentVSwitch(), ParameterCode.ISCSI_SESSION_ISID);
        return val.toString();
    }

    @Override
    public String getTargetAlias() {
        return (String)this.getValueOf(this.getParentVSwitch(), ParameterCode.ISCSI_SESSION_TARGET_ALIAS);
    }

    @Override
    public String getTargetName() {
        return (String)this.getValueOf(this.getParentVSwitch(), ParameterCode.ISCSI_SESSION_TARGET_NAME);
    }

    @Override
    public Integer getTSIH() throws RemoteException {
        return (Integer)this.getValueOf(this.getParentVSwitch(), ParameterCode.ISCSI_SESSION_TSIH);
    }

    @Override
    public SessionTypeConstant getType() throws RemoteException {
        return (SessionTypeConstant)this.getSrValueOf(this.getParentVSwitch(), ParameterCode.ISCSI_SESSION_TYPE);
    }

    public boolean isDiscovery() throws RemoteException {
        return SessionTypeConstant.DISCOVER.equals(this.getType());
    }

    @Override
    protected String canBeDeleted() {
        return null;
    }

    @Override
    protected String isValid(HashMap parameterList) {
        return null;
    }

    @Override
    public ISCSITargetImpl getLocalTarget() {
        return this.m_sessionLocalTarget;
    }

    @Override
    public ISCSIRemoteInitiatorImpl getRemoteInitiator() {
        return this.m_sessionRemoteInitiator;
    }

    @Override
    public ISCSIInitiatorImpl getLocalInitiator() {
        return this.m_sessionLocalInitiator;
    }

    @Override
    public ISCSIRemoteTargetImpl getRemoteTarget() {
        return this.m_sessionRemoteTarget;
    }

    @Override
    public SessionConnectionStatusConstant getConnectionStatus() {
        return (SessionConnectionStatusConstant)this.getValueOf(this.getParentVSwitch(), ParameterCode.ISCSI_SESSION_CONNECTION_STATUS);
    }

    @Override
    public String getConnectionFailureReason() {
        return (String)this.getValueOf(this.getParentVSwitch(), ParameterCode.ISCSI_SESSION_CONNECTION_FAILURE_REASON);
    }

    public boolean addToInitiatorAndTarget() throws RemoteException {
        if (this.isInBound()) {
            Vector<ISCSIRemoteInitiatorImpl> remoteInitiators = this.getParentVSwitch().getRemoteInitiators();
            if (this.isDiscovery()) {
                return this.updateRemoteInitiatorWithDiscoverySession(remoteInitiators);
            }
            Vector<ISCSITargetImpl> targets = this.getCluster().getTargetListMgr().getAll();
            return this.updateRemoteInitiatorAndLocalTargetWithNormalSession(remoteInitiators, targets);
        }
        if (this.isDiscovery()) {
            return this.updateLocalInitiatorWithDiscoverySession();
        }
        return this.updateLocalInitiatorAndRemoteTargetWithNormalSession();
    }

    public void removeFromAll() throws RemoteException {
        if (this.isInBound()) {
            if (this.m_sessionRemoteInitiator != null) {
                this.m_sessionRemoteInitiator.removeInitiatorSession(this);
            }
            if (!this.isDiscovery() && this.m_sessionLocalTarget != null) {
                this.m_sessionLocalTarget.removeSession(this);
            }
        } else {
            if (this.m_sessionLocalInitiator != null) {
                this.m_sessionLocalInitiator.removeSession(this);
            }
            if (!this.isDiscovery() && this.m_sessionRemoteTarget != null) {
                this.m_sessionRemoteTarget.removeSession(this);
            }
        }
        for (int i = 0; i < this.myConnections.size(); ++i) {
            ISCSIConnection connection = this.myConnections.elementAt(i);
            ((ISCSIConnectionImpl)connection).setSessionParent(null);
        }
    }

    private boolean updateRemoteInitiatorAndLocalTargetWithNormalSession(Vector remoteInitiators, Vector targets) throws RemoteException {
        boolean found = false;
        for (int index1 = 0; index1 < remoteInitiators.size(); ++index1) {
            ISCSIRemoteInitiatorImpl remoteInitiator = (ISCSIRemoteInitiatorImpl)remoteInitiators.elementAt(index1);
            if (remoteInitiator.getInitiatorName() == null) {
                theLogger.warn(SrLogCategories.LEGACY, "ISCSIRemoteInitiator without a name value. remoteInitiator: ", remoteInitiator);
                theLogger.info(SrLogCategories.SYSTEM, "Calling 'continue' instead of 'break', this is the correct implementation but might cause a problem, since used to 'break' here.");
                continue;
            }
            if (!remoteInitiator.getInitiatorName().equals(this.m_initiatorName)) continue;
            for (int index2 = 0; index2 < targets.size(); ++index2) {
                ISCSITargetImpl target = (ISCSITargetImpl)targets.elementAt(index2);
                if (!target.getName().equals(this.m_targetName) || !target.initiatorKnownByTarget(remoteInitiator)) continue;
                remoteInitiator.addInitiatorSession(this);
                target.addSession(this);
                this.setSessionLocalTarget(target);
                this.setSessionRemoteInitiator(remoteInitiator);
                return true;
            }
        }
        theLogger.warn(SrLogCategories.LEGACY, "Couldn't update the remote initialor and local target. remoteInitiators: ", remoteInitiators, "; targets: ", targets);
        return false;
    }

    private boolean updateLocalInitiatorAndRemoteTargetWithNormalSession() throws RemoteException {
        ISCSIRemoteTargetImpl remoteTarget = this.getCluster().getRemoteTargetListMgr().getRemoteTargetByName(this.getTargetName());
        if (remoteTarget == null) {
            theLogger.warn(SrLogCategories.LEGACY, "Couldn't find the remote target by name (", this.getTargetName(), ") in the cluster's (", this.getCluster(), ") remote target manager list: ", Arrays.toString(this.getCluster().getRemoteTargetListMgr().getAll()));
            return false;
        }
        Object[] localInitiators = this.getParentVSwitch().getISCSIInitiators();
        theLogger.logAndAssert(SrLogCategories.ERROR, localInitiators.length == 1, new Object[]{"The assumption is that there is only one local initiator."});
        ISCSIInitiatorImpl initiator = (ISCSIInitiatorImpl)localInitiators[0];
        if (initiator == null) {
            theLogger.error(SrLogCategories.LEGACY, "The local initiator returned from the VS is null. localInitialotrs: ", Arrays.toString(localInitiators));
            return false;
        }
        this.setSessionRemoteTarget(remoteTarget);
        remoteTarget.addSession(this);
        this.setSessionLocalInitiator(initiator);
        initiator.addSession(this);
        return true;
    }

    private boolean updateLocalInitiatorWithDiscoverySession() throws RemoteException {
        ISCSIInitiator[] localInitiators = this.getParentVSwitch().getISCSIInitiators();
        ISCSIInitiatorImpl initiator = (ISCSIInitiatorImpl)localInitiators[0];
        this.setSessionLocalInitiator(initiator);
        initiator.addSession(this);
        return true;
    }

    private boolean updateRemoteInitiatorWithDiscoverySession(Vector remoteInitiators) throws RemoteException {
        for (int index1 = 0; index1 < remoteInitiators.size(); ++index1) {
            ISCSIRemoteInitiatorImpl remoteInitiator = (ISCSIRemoteInitiatorImpl)remoteInitiators.elementAt(index1);
            if (!remoteInitiator.getInitiatorName().equals(this.m_initiatorName)) continue;
            remoteInitiator.addInitiatorSession(this);
            this.setSessionRemoteInitiator(remoteInitiator);
            return true;
        }
        theLogger.warn(SrLogCategories.ERROR, "Session's remote initiator element wasn't found in the passed in remote initiators collection. initiatorName: " + this.m_initiatorName + "; Collection: " + remoteInitiators);
        return false;
    }

    static {
        HashMap<ParameterCode, ParameterCode.Flags> parameterCodeFlagsMap = new HashMap<ParameterCode, ParameterCode.Flags>();
        parameterCodeFlagsMap.put(ParameterCode.ISCSI_SESSION_DIRECTION, new ParameterCode.Flags(true, false));
        parameterCodeFlagsMap.put(ParameterCode.ISCSI_SESSION_INITIATOR_ALIAS, new ParameterCode.Flags(true, false));
        parameterCodeFlagsMap.put(ParameterCode.ISCSI_SESSION_INITIATOR_NAME, new ParameterCode.Flags(true, false));
        parameterCodeFlagsMap.put(ParameterCode.ISCSI_SESSION_ISID, new ParameterCode.Flags(true, false));
        parameterCodeFlagsMap.put(ParameterCode.ISCSI_SESSION_TARGET_ALIAS, new ParameterCode.Flags(true, false));
        parameterCodeFlagsMap.put(ParameterCode.ISCSI_SESSION_TARGET_NAME, new ParameterCode.Flags(true, false));
        parameterCodeFlagsMap.put(ParameterCode.ISCSI_SESSION_TSIH, new ParameterCode.Flags(true, false));
        parameterCodeFlagsMap.put(ParameterCode.ISCSI_SESSION_TYPE, new ParameterCode.Flags(true, false));
        parameterCodeFlagsMap.put(ParameterCode.ISCSI_SESSION_CONNECTION_STATUS, new ParameterCode.Flags(true, false));
        parameterCodeFlagsMap.put(ParameterCode.ISCSI_SESSION_CONNECTION_FAILURE_REASON, new ParameterCode.Flags(true, false));
        theParameterCodeFlagsMap = Collections.unmodifiableMap(parameterCodeFlagsMap);
        theLogger = SrLogger.getLogger();
    }
}

